/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.annotation.NonNull;
import android.net.wifi.WifiSsid;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.Set;

public class WifiSsidPolicy
implements Parcelable {
    public static final int WIFI_SSID_POLICY_TYPE_ALLOWLIST = 0;
    public static final int WIFI_SSID_POLICY_TYPE_DENYLIST = 1;
    private int mPolicyType;
    private ArraySet<WifiSsid> mSsids;
    @NonNull
    public static final Parcelable.Creator<WifiSsidPolicy> CREATOR = new Parcelable.Creator<WifiSsidPolicy>(){

        @Override
        public WifiSsidPolicy createFromParcel(Parcel source) {
            return new WifiSsidPolicy(source);
        }

        public WifiSsidPolicy[] newArray(int size) {
            return new WifiSsidPolicy[size];
        }
    };

    public WifiSsidPolicy(int policyType, @NonNull Set<WifiSsid> ssids) {
        if (ssids.isEmpty()) {
            throw new IllegalArgumentException("SSID list cannot be empty");
        }
        if (policyType != 0 && policyType != 1) {
            throw new IllegalArgumentException("Invalid policy type");
        }
        this.mPolicyType = policyType;
        this.mSsids = new ArraySet<WifiSsid>(ssids);
    }

    private WifiSsidPolicy(Parcel in) {
        this.mPolicyType = in.readInt();
        this.mSsids = in.readArraySet(null);
    }

    @NonNull
    public Set<WifiSsid> getSsids() {
        return this.mSsids;
    }

    public int getPolicyType() {
        return this.mPolicyType;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mPolicyType);
        dest.writeArraySet(this.mSsids);
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof WifiSsidPolicy)) {
            return false;
        }
        WifiSsidPolicy that = (WifiSsidPolicy)thatObject;
        return this.mPolicyType == that.mPolicyType && Objects.equals(this.mSsids, that.mSsids);
    }

    public int hashCode() {
        return Objects.hash(this.mPolicyType, this.mSsids);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiSsidPolicyType {
    }
}

