/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.admin.EnforcingAdmin;
import android.app.admin.PolicyValue;
import android.app.admin.ResolutionMechanism;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.LinkedHashMap;
import java.util.Objects;

@SystemApi
public class PolicyState<V>
implements Parcelable {
    private final LinkedHashMap<EnforcingAdmin, PolicyValue<V>> mPoliciesSetByAdmins = new LinkedHashMap();
    private PolicyValue<V> mCurrentResolvedPolicy;
    private ResolutionMechanism<V> mResolutionMechanism;
    @NonNull
    public static final Parcelable.Creator<PolicyState<?>> CREATOR = new Parcelable.Creator<PolicyState<?>>(){

        @Override
        public PolicyState<?> createFromParcel(Parcel source) {
            return new PolicyState(source);
        }

        public PolicyState<?>[] newArray(int size) {
            return new PolicyState[size];
        }
    };

    public PolicyState(@NonNull LinkedHashMap<EnforcingAdmin, PolicyValue<V>> policiesSetByAdmins, PolicyValue<V> currentEnforcedPolicy, @NonNull ResolutionMechanism<V> resolutionMechanism) {
        Objects.requireNonNull(policiesSetByAdmins);
        Objects.requireNonNull(resolutionMechanism);
        this.mPoliciesSetByAdmins.putAll(policiesSetByAdmins);
        this.mCurrentResolvedPolicy = currentEnforcedPolicy;
        this.mResolutionMechanism = resolutionMechanism;
    }

    private PolicyState(Parcel source) {
        int size = source.readInt();
        for (int i = 0; i < size; ++i) {
            EnforcingAdmin admin = (EnforcingAdmin)source.readParcelable(EnforcingAdmin.class.getClassLoader());
            PolicyValue policyValue = (PolicyValue)source.readParcelable(PolicyValue.class.getClassLoader());
            this.mPoliciesSetByAdmins.put(admin, policyValue);
        }
        this.mCurrentResolvedPolicy = (PolicyValue)source.readParcelable(PolicyValue.class.getClassLoader());
        this.mResolutionMechanism = (ResolutionMechanism)source.readParcelable(ResolutionMechanism.class.getClassLoader());
    }

    @NonNull
    public LinkedHashMap<EnforcingAdmin, V> getPoliciesSetByAdmins() {
        LinkedHashMap<EnforcingAdmin, V> policies = new LinkedHashMap<EnforcingAdmin, V>();
        for (EnforcingAdmin admin : this.mPoliciesSetByAdmins.keySet()) {
            policies.put(admin, this.mPoliciesSetByAdmins.get(admin).getValue());
        }
        return policies;
    }

    @Nullable
    public V getCurrentResolvedPolicy() {
        return this.mCurrentResolvedPolicy == null ? null : (V)this.mCurrentResolvedPolicy.getValue();
    }

    @NonNull
    public ResolutionMechanism<V> getResolutionMechanism() {
        return this.mResolutionMechanism;
    }

    public String toString() {
        return "PolicyState { mPoliciesSetByAdmins= " + this.mPoliciesSetByAdmins + ", mCurrentResolvedPolicy= " + this.mCurrentResolvedPolicy + ", mResolutionMechanism= " + this.mResolutionMechanism + " }";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mPoliciesSetByAdmins.size());
        for (EnforcingAdmin admin : this.mPoliciesSetByAdmins.keySet()) {
            dest.writeParcelable(admin, flags);
            dest.writeParcelable(this.mPoliciesSetByAdmins.get(admin), flags);
        }
        dest.writeParcelable(this.mCurrentResolvedPolicy, flags);
        dest.writeParcelable(this.mResolutionMechanism, flags);
    }
}

