/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.admin.ParcelableResource;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class DevicePolicyStringResource
implements Parcelable {
    @NonNull
    private final String mStringId;
    private final int mResourceIdInCallingPackage;
    @NonNull
    private ParcelableResource mResource;
    @NonNull
    public static final Parcelable.Creator<DevicePolicyStringResource> CREATOR = new Parcelable.Creator<DevicePolicyStringResource>(){

        @Override
        public DevicePolicyStringResource createFromParcel(Parcel in) {
            String stringId = in.readString();
            int resourceIdInCallingPackage = in.readInt();
            ParcelableResource resource = in.readTypedObject(ParcelableResource.CREATOR);
            return new DevicePolicyStringResource(stringId, resourceIdInCallingPackage, resource);
        }

        public DevicePolicyStringResource[] newArray(int size) {
            return new DevicePolicyStringResource[size];
        }
    };

    public DevicePolicyStringResource(@NonNull Context context, @NonNull String stringId, int resourceIdInCallingPackage) {
        this(stringId, resourceIdInCallingPackage, new ParcelableResource(context, resourceIdInCallingPackage, 2));
    }

    private DevicePolicyStringResource(@NonNull String stringId, int resourceIdInCallingPackage, @NonNull ParcelableResource resource) {
        Objects.requireNonNull(stringId, "stringId must be provided.");
        Objects.requireNonNull(resource, "ParcelableResource must be provided.");
        this.mStringId = stringId;
        this.mResourceIdInCallingPackage = resourceIdInCallingPackage;
        this.mResource = resource;
    }

    @NonNull
    public String getStringId() {
        return this.mStringId;
    }

    public int getResourceIdInCallingPackage() {
        return this.mResourceIdInCallingPackage;
    }

    @NonNull
    public ParcelableResource getResource() {
        return this.mResource;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DevicePolicyStringResource other = (DevicePolicyStringResource)o;
        return this.mStringId == other.mStringId && this.mResourceIdInCallingPackage == other.mResourceIdInCallingPackage && this.mResource.equals(other.mResource);
    }

    public int hashCode() {
        return Objects.hash(this.mStringId, this.mResourceIdInCallingPackage, this.mResource);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mStringId);
        dest.writeInt(this.mResourceIdInCallingPackage);
        dest.writeTypedObject(this.mResource, flags);
    }
}

