/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class StatsQuery {
    public static final int DIALECT_UNKNOWN = 0;
    public static final int DIALECT_SQLITE = 1;
    private final int sqlDialect;
    private final String rawSql;
    private final int minClientSqlVersion;
    private final byte[] policyConfig;

    private StatsQuery(int sqlDialect, @NonNull String rawSql, int minClientSqlVersion, @Nullable byte[] policyConfig) {
        this.sqlDialect = sqlDialect;
        this.rawSql = rawSql;
        this.minClientSqlVersion = minClientSqlVersion;
        this.policyConfig = policyConfig;
    }

    public int getSqlDialect() {
        return this.sqlDialect;
    }

    @NonNull
    public String getRawSql() {
        return this.rawSql;
    }

    public int getMinSqlClientVersion() {
        return this.minClientSqlVersion;
    }

    @Nullable
    public byte[] getPolicyConfig() {
        return this.policyConfig;
    }

    public static class Builder {
        private int sqlDialect;
        private String rawSql;
        private int minSqlClientVersion;
        private byte[] policyConfig;

        public Builder(@NonNull String rawSql) {
            if (rawSql == null) {
                throw new IllegalArgumentException("rawSql must not be null");
            }
            this.rawSql = rawSql;
            this.sqlDialect = 1;
            this.minSqlClientVersion = 1;
            this.policyConfig = null;
        }

        @NonNull
        public Builder setSqlDialect(int sqlDialect) {
            this.sqlDialect = sqlDialect;
            return this;
        }

        @NonNull
        public Builder setMinSqlClientVersion(int minSqlClientVersion) {
            if (minSqlClientVersion < 0) {
                throw new IllegalArgumentException("minSqlClientVersion must be a positive integer");
            }
            this.minSqlClientVersion = minSqlClientVersion;
            return this;
        }

        @NonNull
        public Builder setPolicyConfig(@NonNull byte[] policyConfig) {
            this.policyConfig = policyConfig;
            return this;
        }

        @NonNull
        public StatsQuery build() {
            return new StatsQuery(this.sqlDialect, this.rawSql, this.minSqlClientVersion, this.policyConfig);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface SqlDialect {
    }
}

