/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.app.Application;
import android.app.ContextImpl;
import android.app.IActivityManager;
import android.app.LoadedApk;
import android.app.Notification;
import android.app.StackTrace;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentCallbacks2;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.Trace;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.view.contentcapture.ContentCaptureManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.hidden_from_bootclasspath.android.app.Flags;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class Service
extends ContextWrapper
implements ComponentCallbacks2,
ContentCaptureManager.ContentCaptureClient {
    private static final String TAG = "Service";
    @Deprecated
    public static final int STOP_FOREGROUND_LEGACY = 0;
    public static final int STOP_FOREGROUND_REMOVE = 1;
    public static final int STOP_FOREGROUND_DETACH = 2;
    public static final int START_CONTINUATION_MASK = 15;
    public static final int START_STICKY_COMPATIBILITY = 0;
    public static final int START_STICKY = 1;
    public static final int START_NOT_STICKY = 2;
    public static final int START_REDELIVER_INTENT = 3;
    public static final int START_TASK_REMOVED_COMPLETE = 1000;
    public static final int START_FLAG_REDELIVERY = 1;
    public static final int START_FLAG_RETRY = 2;
    @UnsupportedAppUsage
    private ActivityThread mThread = null;
    @UnsupportedAppUsage
    private String mClassName = null;
    @UnsupportedAppUsage
    private IBinder mToken = null;
    @UnsupportedAppUsage
    private Application mApplication = null;
    @UnsupportedAppUsage
    private IActivityManager mActivityManager = null;
    @UnsupportedAppUsage
    private boolean mStartCompatibility = false;
    @GuardedBy(value={"mForegroundServiceTraceTitleLock"})
    @Nullable
    private String mForegroundServiceTraceTitle = null;
    private final Object mForegroundServiceTraceTitleLock = new Object();
    private static final String TRACE_TRACK_NAME_FOREGROUND_SERVICE = "FGS";
    @GuardedBy(value={"sStartForegroundServiceStackTraces"})
    private static final ArrayMap<String, StackTrace> sStartForegroundServiceStackTraces = new ArrayMap();

    public Service() {
        super(null);
    }

    public Application getApplication() {
        return this.mApplication;
    }

    public void onCreate() {
    }

    @Deprecated
    public void onStart(Intent intent, int startId) {
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.onStart(intent, startId);
        return this.mStartCompatibility ? 0 : 1;
    }

    public void onDestroy() {
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
    }

    @Override
    public void onLowMemory() {
    }

    @Override
    public void onTrimMemory(int level) {
    }

    @Nullable
    public abstract IBinder onBind(Intent var1);

    public boolean onUnbind(Intent intent) {
        return false;
    }

    public void onRebind(Intent intent) {
    }

    public void onTaskRemoved(Intent rootIntent) {
    }

    public void stopSelf() {
        this.stopSelf(-1);
    }

    public void stopSelf(int startId) {
        if (this.mActivityManager == null) {
            return;
        }
        try {
            this.mActivityManager.stopServiceToken(new ComponentName((Context)this, this.mClassName), this.mToken, startId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean stopSelfResult(int startId) {
        if (this.mActivityManager == null) {
            return false;
        }
        try {
            return this.mActivityManager.stopServiceToken(new ComponentName((Context)this, this.mClassName), this.mToken, startId);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    public void setForeground(boolean isForeground) {
        Log.w(TAG, "setForeground: ignoring old API call on " + this.getClass().getName());
    }

    public void startForeground(int id2, Notification notification) {
        try {
            ComponentName comp = new ComponentName((Context)this, this.mClassName);
            this.mActivityManager.setServiceForeground(comp, this.mToken, id2, notification, 0, -1);
            this.clearStartForegroundServiceStackTrace();
            this.logForegroundServiceStart(comp, -1);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void startForeground(int id2, @NonNull Notification notification, @RequiresPermission int foregroundServiceType) {
        try {
            ComponentName comp = new ComponentName((Context)this, this.mClassName);
            this.mActivityManager.setServiceForeground(comp, this.mToken, id2, notification, 0, foregroundServiceType);
            this.clearStartForegroundServiceStackTrace();
            this.logForegroundServiceStart(comp, foregroundServiceType);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Deprecated
    public void stopForeground(boolean removeNotification) {
        this.stopForeground(removeNotification ? 1 : 0);
    }

    public void stopForeground(int notificationBehavior) {
        try {
            this.mActivityManager.setServiceForeground(new ComponentName((Context)this, this.mClassName), this.mToken, 0, null, notificationBehavior, 0);
            this.logForegroundServiceStopIfNecessary();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getForegroundServiceType() {
        int ret = 0;
        try {
            ret = this.mActivityManager.getForegroundServiceType(new ComponentName((Context)this, this.mClassName), this.mToken);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return ret;
    }

    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.println("nothing to dump");
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(newBase);
        if (newBase != null) {
            newBase.setContentCaptureOptions(this.getContentCaptureOptions());
        }
    }

    @UnsupportedAppUsage
    public void attach(Context context, ActivityThread thread, String className, IBinder token, Application application, Object activityManager) {
        this.attachBaseContext(context);
        this.mThread = thread;
        this.mClassName = className;
        this.mToken = token;
        this.mApplication = application;
        this.mActivityManager = (IActivityManager)activityManager;
        this.mStartCompatibility = this.getApplicationInfo().targetSdkVersion < 5;
        this.setContentCaptureOptions(application.getContentCaptureOptions());
    }

    public Context createServiceBaseContext(ActivityThread mainThread, LoadedApk packageInfo) {
        return ContextImpl.createAppContext(mainThread, packageInfo);
    }

    public void detachAndCleanUp() {
        this.mToken = null;
        this.logForegroundServiceStopIfNecessary();
    }

    String getClassName() {
        return this.mClassName;
    }

    @Override
    public ContentCaptureManager.ContentCaptureClient getContentCaptureClient() {
        return this;
    }

    @Override
    public ComponentName contentCaptureClientGetComponentName() {
        return new ComponentName((Context)this, this.mClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logForegroundServiceStart(ComponentName comp, int foregroundServiceType) {
        Object object = this.mForegroundServiceTraceTitleLock;
        synchronized (object) {
            if (this.mForegroundServiceTraceTitle == null) {
                this.mForegroundServiceTraceTitle = TextUtils.formatSimple("comp=%s type=%s", comp.toShortString(), Integer.toHexString(foregroundServiceType));
                Trace.asyncTraceForTrackBegin(64L, TRACE_TRACK_NAME_FOREGROUND_SERVICE, this.mForegroundServiceTraceTitle, System.identityHashCode(this));
            } else {
                Trace.instantForTrack(64L, TRACE_TRACK_NAME_FOREGROUND_SERVICE, this.mForegroundServiceTraceTitle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logForegroundServiceStopIfNecessary() {
        Object object = this.mForegroundServiceTraceTitleLock;
        synchronized (object) {
            if (this.mForegroundServiceTraceTitle != null) {
                Trace.asyncTraceForTrackEnd(64L, TRACE_TRACK_NAME_FOREGROUND_SERVICE, System.identityHashCode(this));
                this.mForegroundServiceTraceTitle = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStartForegroundServiceStackTrace(@NonNull String className, @NonNull StackTrace stacktrace) {
        ArrayMap<String, StackTrace> arrayMap = sStartForegroundServiceStackTraces;
        synchronized (arrayMap) {
            sStartForegroundServiceStackTraces.put(className, stacktrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearStartForegroundServiceStackTrace() {
        ArrayMap<String, StackTrace> arrayMap = sStartForegroundServiceStackTraces;
        synchronized (arrayMap) {
            sStartForegroundServiceStackTraces.remove(this.getClassName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StackTrace getStartForegroundServiceStackTrace(@NonNull String className) {
        ArrayMap<String, StackTrace> arrayMap = sStartForegroundServiceStackTraces;
        synchronized (arrayMap) {
            return sStartForegroundServiceStackTraces.get(className);
        }
    }

    public void callOnTimeout(int startId) {
        if (this.mToken == null) {
            Log.w(TAG, "Service already destroyed, skipping onTimeout()");
            return;
        }
        try {
            if (!this.mActivityManager.shouldServiceTimeOut(new ComponentName((Context)this, this.mClassName), this.mToken)) {
                Log.w(TAG, "Service no longer relevant, skipping onTimeout()");
                return;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.onTimeout(startId);
        if (Flags.introduceNewServiceOntimeoutCallback()) {
            this.onTimeout(startId, 2048);
        }
    }

    public void onTimeout(int startId) {
    }

    public void callOnTimeLimitExceeded(int startId, int fgsType) {
        if (this.mToken == null) {
            Log.w(TAG, "Service already destroyed, skipping onTimeLimitExceeded()");
            return;
        }
        try {
            if (!this.mActivityManager.hasServiceTimeLimitExceeded(new ComponentName((Context)this, this.mClassName), this.mToken)) {
                Log.w(TAG, "Service no longer relevant, skipping onTimeLimitExceeded()");
                return;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (Flags.introduceNewServiceOntimeoutCallback()) {
            this.onTimeout(startId, fgsType);
        }
    }

    @FlaggedApi(value="android.app.introduce_new_service_ontimeout_callback")
    public void onTimeout(int startId, int fgsType) {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StartArgFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StartResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StopForegroundSelector {
    }
}

