/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.Application;
import android.app.ApplicationPackageManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.ApplicationInfo;
import android.content.res.ApkAssets;
import android.content.res.AssetManager;
import android.content.res.CompatResources;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.ResourcesImpl;
import android.content.res.ResourcesKey;
import android.content.res.loader.ResourcesLoader;
import android.hardware.display.DisplayManagerGlobal;
import android.os.IBinder;
import android.os.Process;
import android.os.Trace;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.ravenwood.annotation.RavenwoodThrow;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.util.IndentingPrintWriter;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.DisplayInfo;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.content.res.Flags;
import com.android.internal.util.ArrayUtils;
import com.android.tools.layoutlib.java.Reference_Delegate;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Function;

@RavenwoodKeepWholeClass
public class ResourcesManager {
    static final String TAG = "ResourcesManager";
    private static final boolean DEBUG = false;
    public static final String RESOURCE_CACHE_DIR = "/data/resource-cache/";
    private static volatile ResourcesManager sResourcesManager;
    private final Object mLock = new Object();
    private CompatibilityInfo mResCompatibilityInfo;
    @UnsupportedAppUsage
    private final Configuration mResConfiguration = new Configuration();
    private int mResDisplayId = 0;
    private ArrayList<Pair<String[], ApplicationInfo>> mPendingAppInfoUpdates;
    @UnsupportedAppUsage
    private final ArrayMap<ResourcesKey, WeakReference<ResourcesImpl>> mResourceImpls = new ArrayMap();
    @UnsupportedAppUsage
    private final ArrayList<WeakReference<Resources>> mResourceReferences = new ArrayList();
    private final ReferenceQueue<Resources> mResourcesReferencesQueue = new ReferenceQueue();
    private final ArrayList<WeakReference<Resources>> mAllResourceReferences = new ArrayList();
    private final ReferenceQueue<Resources> mAllResourceReferencesQueue = new ReferenceQueue();
    private final ArrayMap<String, SharedLibraryAssets> mSharedLibAssetsMap = new ArrayMap();
    private final ArrayMap<ApkKey, WeakReference<ApkAssets>> mCachedApkAssets = new ArrayMap();
    @UnsupportedAppUsage
    private final WeakHashMap<IBinder, ActivityResources> mActivityResourceReferences = new WeakHashMap();
    private final UpdateHandler mUpdateCallbacks = new UpdateHandler();
    private final ArraySet<String> mApplicationOwnedApks = new ArraySet();

    @VisibleForTesting
    public ArrayMap<String, SharedLibraryAssets> getRegisteredResourcePaths() {
        return this.mSharedLibAssetsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RavenwoodThrow(reason="registerResourcePaths is unsupported")
    public void registerResourcePaths(@NonNull String uniqueId, @NonNull ApplicationInfo appInfo) {
        Application application = ActivityThread.currentActivityThread().getApplication();
        ApplicationInfo currentAppInfo = application != null ? application.getApplicationInfo() : null;
        SharedLibraryAssets sharedLibAssets = new SharedLibraryAssets(appInfo, currentAppInfo);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSharedLibAssetsMap.containsKey(uniqueId)) {
                Slog.v(TAG, "Package resources' paths for uniqueId: " + uniqueId + " has already been registered, this is a no-op.");
                return;
            }
            this.mSharedLibAssetsMap.put(uniqueId, sharedLibAssets);
            this.appendLibAssetsLocked(sharedLibAssets);
            Slog.v(TAG, "The following library key has been added: " + sharedLibAssets.getResourcesKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Pair<AssetManager, Integer> updateResourceImplAssetsWithRegisteredLibs(@NonNull AssetManager assets, boolean reuseAssets) {
        PathCollector collector;
        int size;
        Object object = this.mLock;
        synchronized (object) {
            size = this.mSharedLibAssetsMap.size();
            if (size == 0 || assets == AssetManager.getSystem()) {
                return new Pair<AssetManager, Integer>(assets, size);
            }
            collector = new PathCollector(this.resourcesKeyFromAssets(assets));
            for (int i = 0; i < size; ++i) {
                ResourcesKey libraryKey = this.mSharedLibAssetsMap.valueAt(i).getResourcesKey();
                collector.appendKey(libraryKey);
            }
        }
        if (!collector.isSameAsOriginal()) {
            assets.addApkKeys(ResourcesManager.extractApkKeys(collector.collectedKey()), reuseAssets);
        }
        return new Pair<AssetManager, Integer>(assets, size);
    }

    @UnsupportedAppUsage
    public ResourcesManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @VisibleForTesting
    public static ResourcesManager setInstance(ResourcesManager resourcesManager) {
        Class<ResourcesManager> clazz = ResourcesManager.class;
        synchronized (ResourcesManager.class) {
            ResourcesManager oldResourceManager = sResourcesManager;
            sResourcesManager = resourcesManager;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return oldResourceManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @UnsupportedAppUsage
    public static ResourcesManager getInstance() {
        ResourcesManager rm = sResourcesManager;
        if (rm != null) return rm;
        Class<ResourcesManager> clazz = ResourcesManager.class;
        synchronized (ResourcesManager.class) {
            rm = sResourcesManager;
            if (rm != null) return rm;
            sResourcesManager = rm = new ResourcesManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return rm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidatePath(String path) {
        ArrayList<ResourcesImpl> implsToFlush = new ArrayList<ResourcesImpl>();
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mResourceImpls.size() - 1; i >= 0; --i) {
                ResourcesImpl resImpl;
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                if (!key.isPathReferenced(path) || (resImpl = (ResourcesImpl)this.mResourceImpls.removeAt(i).get()) == null) continue;
                implsToFlush.add(resImpl);
            }
        }
        for (int i = 0; i < implsToFlush.size(); ++i) {
            ((ResourcesImpl)implsToFlush.get(i)).flushLayoutCache();
        }
        ArrayList<ApkAssets> assetsToClose = new ArrayList<ApkAssets>();
        ArrayMap<ApkKey, WeakReference<ApkAssets>> i = this.mCachedApkAssets;
        synchronized (i) {
            for (int i2 = this.mCachedApkAssets.size() - 1; i2 >= 0; --i2) {
                ApkAssets apkAssets;
                ApkKey key = this.mCachedApkAssets.keyAt(i2);
                if (!key.path.equals(path)) continue;
                WeakReference<ApkAssets> apkAssetsRef = this.mCachedApkAssets.removeAt(i2);
                ApkAssets apkAssets2 = apkAssets = apkAssetsRef != null ? (ApkAssets)apkAssetsRef.get() : null;
                if (apkAssets == null) continue;
                assetsToClose.add(apkAssets);
            }
        }
        for (int i3 = 0; i3 < assetsToClose.size(); ++i3) {
            ((ApkAssets)assetsToClose.get(i3)).close();
        }
        Log.i(TAG, "Invalidated " + implsToFlush.size() + " asset managers that referenced " + path);
    }

    public Configuration getConfiguration() {
        return this.mResConfiguration;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public DisplayMetrics getDisplayMetrics() {
        return this.getDisplayMetrics(this.mResDisplayId, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS);
    }

    @VisibleForTesting
    @NonNull
    public DisplayMetrics getDisplayMetrics(int displayId, DisplayAdjustments da) {
        DisplayInfo displayInfo;
        DisplayManagerGlobal displayManagerGlobal = DisplayManagerGlobal.getInstance();
        DisplayMetrics dm = new DisplayMetrics();
        DisplayInfo displayInfo2 = displayInfo = displayManagerGlobal != null ? displayManagerGlobal.getDisplayInfo(displayId) : null;
        if (displayInfo != null) {
            Configuration dajConfig = da.getConfiguration();
            displayInfo.getAppMetrics(dm, da.getCompatibilityInfo(), this.mResDisplayId == displayId && Configuration.EMPTY.equals(dajConfig) ? this.mResConfiguration : dajConfig);
        } else {
            dm.setToDefaults();
        }
        return dm;
    }

    private DisplayMetrics getDisplayMetrics(Configuration config) {
        DisplayInfo displayInfo;
        DisplayManagerGlobal displayManagerGlobal = DisplayManagerGlobal.getInstance();
        DisplayMetrics dm = new DisplayMetrics();
        DisplayInfo displayInfo2 = displayInfo = displayManagerGlobal != null ? displayManagerGlobal.getDisplayInfo(this.mResDisplayId) : null;
        if (displayInfo != null) {
            displayInfo.getAppMetrics(dm, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS.getCompatibilityInfo(), config);
        } else {
            dm.setToDefaults();
        }
        return dm;
    }

    private static void applyDisplayMetricsToConfiguration(@NonNull DisplayMetrics dm, @NonNull Configuration config) {
        config.touchscreen = 1;
        config.densityDpi = dm.densityDpi;
        config.screenWidthDp = (int)((float)dm.widthPixels / dm.density + 0.5f);
        config.screenHeightDp = (int)((float)dm.heightPixels / dm.density + 0.5f);
        int sl = Configuration.resetScreenLayout(config.screenLayout);
        if (dm.widthPixels > dm.heightPixels) {
            config.orientation = 2;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenWidthDp, config.screenHeightDp);
        } else {
            config.orientation = 1;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenHeightDp, config.screenWidthDp);
        }
        config.smallestScreenWidthDp = Math.min(config.screenWidthDp, config.screenHeightDp);
        config.compatScreenWidthDp = config.screenWidthDp;
        config.compatScreenHeightDp = config.screenHeightDp;
        config.compatSmallestScreenWidthDp = config.smallestScreenWidthDp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyCompatConfiguration(int displayDensity, @NonNull Configuration compatConfiguration) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mResCompatibilityInfo != null && !this.mResCompatibilityInfo.supportsScreen()) {
                this.mResCompatibilityInfo.applyToConfiguration(displayDensity, compatConfiguration);
                return true;
            }
            return false;
        }
    }

    public Display getAdjustedDisplay(int displayId, Resources resources) {
        DisplayManagerGlobal dm = DisplayManagerGlobal.getInstance();
        if (dm == null) {
            return null;
        }
        return dm.getCompatibleDisplay(displayId, resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeApplicationPaths(@NonNull String sourceDir, @Nullable String[] splitDirs) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mApplicationOwnedApks.isEmpty()) {
                this.addApplicationPathsLocked(sourceDir, splitDirs);
            }
        }
    }

    private void addApplicationPathsLocked(@NonNull String sourceDir, @Nullable String[] splitDirs) {
        this.mApplicationOwnedApks.add(sourceDir);
        if (splitDirs != null) {
            this.mApplicationOwnedApks.addAll(Arrays.asList(splitDirs));
        }
    }

    private static String overlayPathToIdmapPath(String path) {
        return RESOURCE_CACHE_DIR + path.substring(1).replace('/', '@') + "@idmap";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ApkAssets loadApkAssets(@NonNull ApkKey key) throws IOException {
        ApkAssets apkAssets;
        WeakReference<ApkAssets> apkAssetsRef;
        ArrayMap<ApkKey, WeakReference<ApkAssets>> arrayMap = this.mCachedApkAssets;
        synchronized (arrayMap) {
            apkAssetsRef = this.mCachedApkAssets.get(key);
        }
        if (apkAssetsRef != null && (apkAssets = (ApkAssets)apkAssetsRef.get()) != null && apkAssets.isUpToDate()) {
            return apkAssets;
        }
        int flags = 0;
        if (key.sharedLib) {
            flags |= 2;
        }
        if (this.mApplicationOwnedApks.contains(key.path)) {
            flags |= 0x10;
        }
        apkAssets = key.overlay ? ApkAssets.loadOverlayFromPath(ResourcesManager.overlayPathToIdmapPath(key.path), flags) : ApkAssets.loadFromPath(key.path, flags);
        ArrayMap<ApkKey, WeakReference<ApkAssets>> arrayMap2 = this.mCachedApkAssets;
        synchronized (arrayMap2) {
            this.mCachedApkAssets.put(key, new WeakReference<ApkAssets>(apkAssets));
        }
        return apkAssets;
    }

    @NonNull
    private static ArrayList<ApkKey> extractApkKeys(@NonNull ResourcesKey key) {
        ArrayList<ApkKey> apkKeys = new ArrayList<ApkKey>();
        if (key.mResDir != null) {
            apkKeys.add(new ApkKey(key.mResDir, false, false));
        }
        if (key.mSplitResDirs != null) {
            for (String splitResDir : key.mSplitResDirs) {
                apkKeys.add(new ApkKey(splitResDir, false, false));
            }
        }
        if (key.mLibDirs != null) {
            for (String libDir : key.mLibDirs) {
                if (!libDir.endsWith(".apk")) continue;
                apkKeys.add(new ApkKey(libDir, true, false));
            }
        }
        if (key.mOverlayPaths != null) {
            for (String idmapPath : key.mOverlayPaths) {
                apkKeys.add(new ApkKey(idmapPath, false, true));
            }
        }
        return apkKeys;
    }

    private ResourcesKey resourcesKeyFromAssets(@NonNull AssetManager assets) {
        ArrayList<String> libs = new ArrayList<String>();
        ArrayList<String> overlays = new ArrayList<String>();
        for (ApkAssets asset : assets.getApkAssets()) {
            if (asset.isSystem() || asset.isForLoader()) continue;
            if (asset.isOverlay()) {
                overlays.add(asset.getAssetPath());
                continue;
            }
            if (!asset.isSharedLib()) continue;
            libs.add(asset.getAssetPath());
        }
        return new ResourcesKey(null, null, overlays.toArray(new String[0]), libs.toArray(new String[0]), 0, null, null);
    }

    @VisibleForTesting
    @UnsupportedAppUsage
    @Nullable
    protected AssetManager createAssetManager(@NonNull ResourcesKey key) {
        return this.createAssetManager(key, null);
    }

    @VisibleForTesting
    @UnsupportedAppUsage
    @Nullable
    protected AssetManager createAssetManager(@NonNull ResourcesKey key, @Nullable ApkAssetsSupplier apkSupplier) {
        AssetManager.Builder builder = new AssetManager.Builder().setNoInit();
        ArrayList<ApkKey> apkKeys = ResourcesManager.extractApkKeys(key);
        int n = apkKeys.size();
        for (int i = 0; i < n; ++i) {
            ApkKey apkKey = apkKeys.get(i);
            try {
                builder.addApkAssets(apkSupplier != null ? apkSupplier.load(apkKey) : this.loadApkAssets(apkKey));
                continue;
            }
            catch (IOException e) {
                if (apkKey.overlay) {
                    Log.w(TAG, String.format("failed to add overlay path '%s'", apkKey.path), e);
                    continue;
                }
                if (apkKey.sharedLib) {
                    Log.w(TAG, String.format("asset path '%s' does not exist or contains no resources", apkKey.path), e);
                    continue;
                }
                Log.e(TAG, String.format("failed to add asset path '%s'", apkKey.path), e);
                return null;
            }
        }
        if (key.mLoaders != null) {
            for (ResourcesLoader loader : key.mLoaders) {
                builder.addLoader(loader);
            }
        }
        return builder.build();
    }

    private static <T> int countLiveReferences(Collection<WeakReference<T>> collection) {
        int count = 0;
        for (WeakReference<T> ref : collection) {
            Object value = ref != null ? ref.get() : null;
            if (value == null) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String prefix, PrintWriter printWriter) {
        int liveAssets;
        int resImpls;
        int references;
        Object object = this.mLock;
        synchronized (object) {
            int refs = ResourcesManager.countLiveReferences(this.mResourceReferences);
            for (ActivityResources activityResources : this.mActivityResourceReferences.values()) {
                refs += activityResources.countLiveReferences();
            }
            references = refs;
            resImpls = ResourcesManager.countLiveReferences(this.mResourceImpls.values());
        }
        ArrayMap<ApkKey, WeakReference<ApkAssets>> refs = this.mCachedApkAssets;
        synchronized (refs) {
            liveAssets = ResourcesManager.countLiveReferences(this.mCachedApkAssets.values());
        }
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)printWriter, "  ");
        for (int i = 0; i < prefix.length() / 2; ++i) {
            pw.increaseIndent();
        }
        pw.println("ResourcesManager:");
        pw.increaseIndent();
        pw.print("total apks: ");
        pw.println(liveAssets);
        pw.print("resources: ");
        pw.println(references);
        pw.print("resource impls: ");
        pw.println(resImpls);
    }

    private Configuration generateConfig(@NonNull ResourcesKey key) {
        Configuration config;
        boolean hasOverrideConfig = key.hasOverrideConfiguration();
        if (hasOverrideConfig) {
            config = new Configuration(this.getConfiguration());
            config.updateFrom(key.mOverrideConfiguration);
        } else {
            config = this.getConfiguration();
        }
        return config;
    }

    private int generateDisplayId(@NonNull ResourcesKey key) {
        return key.mDisplayId != -1 ? key.mDisplayId : this.mResDisplayId;
    }

    @Nullable
    private ResourcesImpl createResourcesImpl(@NonNull ResourcesKey key, @Nullable ApkAssetsSupplier apkSupplier) {
        AssetManager assets = this.createAssetManager(key, apkSupplier);
        if (assets == null) {
            return null;
        }
        DisplayAdjustments daj = new DisplayAdjustments(key.mOverrideConfiguration);
        daj.setCompatibilityInfo(key.mCompatInfo);
        Configuration config = this.generateConfig(key);
        DisplayMetrics displayMetrics = this.getDisplayMetrics(this.generateDisplayId(key), daj);
        ResourcesImpl impl = new ResourcesImpl(assets, displayMetrics, config, daj, true);
        return impl;
    }

    @Nullable
    private ResourcesImpl findResourcesImplForKeyLocked(@NonNull ResourcesKey key) {
        ResourcesImpl impl;
        WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.get(key);
        ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
        if (impl != null && impl.getAssets().isUpToDate()) {
            return impl;
        }
        return null;
    }

    @Nullable
    private ResourcesImpl findOrCreateResourcesImplForKeyLocked(@NonNull ResourcesKey key) {
        return this.findOrCreateResourcesImplForKeyLocked(key, null);
    }

    @Nullable
    private ResourcesImpl findOrCreateResourcesImplForKeyLocked(@NonNull ResourcesKey key, @Nullable ApkAssetsSupplier apkSupplier) {
        ResourcesImpl impl = this.findResourcesImplForKeyLocked(key);
        if ((impl == null || impl.getAppliedSharedLibsHash() != this.mSharedLibAssetsMap.size()) && (impl = this.createResourcesImpl(key, apkSupplier)) != null) {
            this.mResourceImpls.put(key, new WeakReference<ResourcesImpl>(impl));
        }
        return impl;
    }

    @Nullable
    private ResourcesKey findKeyForResourceImplLocked(@NonNull ResourcesImpl resourceImpl) {
        int refCount = this.mResourceImpls.size();
        for (int i = 0; i < refCount; ++i) {
            WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
            if (weakImplRef == null || !Reference_Delegate.refersTo(weakImplRef, resourceImpl)) continue;
            return this.mResourceImpls.keyAt(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameResourcesOverrideConfig(@Nullable IBinder activityToken, @Nullable Configuration overrideConfig) {
        Object object = this.mLock;
        synchronized (object) {
            ActivityResources activityResources;
            ActivityResources activityResources2 = activityResources = activityToken != null ? this.mActivityResourceReferences.get(activityToken) : null;
            if (activityResources == null) {
                return overrideConfig == null;
            }
            return Objects.equals(activityResources.overrideConfig, overrideConfig) || overrideConfig != null && activityResources.overrideConfig != null && 0 == overrideConfig.diffPublicOnly(activityResources.overrideConfig);
        }
    }

    private ActivityResources getOrCreateActivityResourcesStructLocked(@NonNull IBinder activityToken) {
        ActivityResources activityResources = this.mActivityResourceReferences.get(activityToken);
        if (activityResources == null) {
            activityResources = new ActivityResources();
            this.mActivityResourceReferences.put(activityToken, activityResources);
        }
        return activityResources;
    }

    @Nullable
    private Resources findResourcesForActivityLocked(@NonNull IBinder targetActivityToken, @NonNull ResourcesKey targetKey, @NonNull ClassLoader targetClassLoader) {
        ActivityResources activityResources = this.getOrCreateActivityResourcesStructLocked(targetActivityToken);
        int size = activityResources.activityResources.size();
        for (int index = 0; index < size; ++index) {
            ResourcesKey key;
            ActivityResource activityResource = activityResources.activityResources.get(index);
            Resources resources = (Resources)activityResource.resources.get();
            ResourcesKey resourcesKey = key = resources == null ? null : this.findKeyForResourceImplLocked(resources.getImpl());
            if (key == null || !Objects.equals(resources.getClassLoader(), targetClassLoader) || !Objects.equals(key, targetKey)) continue;
            return resources;
        }
        return null;
    }

    @NonNull
    private Resources createResourcesForActivityLocked(@NonNull IBinder activityToken, @NonNull Configuration initialOverrideConfig, @Nullable Integer overrideDisplayId, @NonNull ClassLoader classLoader, @NonNull ResourcesImpl impl, @NonNull CompatibilityInfo compatInfo) {
        ActivityResources activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
        ResourcesManager.cleanupReferences(activityResources.activityResources, activityResources.activityResourcesQueue, r -> r.resources);
        Resources resources = compatInfo.needsCompatResources() ? new CompatResources(classLoader) : new Resources(classLoader);
        resources.setImpl(impl);
        resources.setCallbacks(this.mUpdateCallbacks);
        ActivityResource activityResource = new ActivityResource();
        activityResource.resources = new WeakReference<Resources>(resources, activityResources.activityResourcesQueue);
        activityResource.overrideConfig.setTo(initialOverrideConfig);
        activityResource.overrideDisplayId = overrideDisplayId;
        activityResources.activityResources.add(activityResource);
        return resources;
    }

    @NonNull
    private Resources createResourcesLocked(@NonNull ClassLoader classLoader, @NonNull ResourcesImpl impl, @NonNull CompatibilityInfo compatInfo) {
        ResourcesManager.cleanupReferences(this.mResourceReferences, this.mResourcesReferencesQueue);
        Resources resources = compatInfo.needsCompatResources() ? new CompatResources(classLoader) : new Resources(classLoader);
        resources.setImpl(impl);
        resources.setCallbacks(this.mUpdateCallbacks);
        this.mResourceReferences.add(new WeakReference<Resources>(resources, this.mResourcesReferencesQueue));
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Resources createBaseTokenResources(@NonNull IBinder token, @Nullable String resDir, @Nullable String[] splitResDirs, @Nullable String[] legacyOverlayDirs, @Nullable String[] overlayPaths, @Nullable String[] libDirs, int displayId, @Nullable Configuration overrideConfig, @NonNull CompatibilityInfo compatInfo, @Nullable ClassLoader classLoader, @Nullable List<ResourcesLoader> loaders) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#createBaseActivityResources");
            ResourcesKey key = new ResourcesKey(resDir, splitResDirs, ResourcesManager.combinedOverlayPaths(legacyOverlayDirs, overlayPaths), libDirs, displayId, overrideConfig, compatInfo, loaders == null ? null : loaders.toArray(new ResourcesLoader[0]));
            classLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
            Object object = this.mLock;
            synchronized (object) {
                this.getOrCreateActivityResourcesStructLocked(token);
            }
            this.updateResourcesForActivity(token, overrideConfig, displayId);
            object = this.mLock;
            synchronized (object) {
                Resources resources = this.findResourcesForActivityLocked(token, key, classLoader);
                if (resources != null) {
                    Resources resources2 = resources;
                    return resources2;
                }
            }
            object = this.createResourcesForActivity(token, key, Configuration.EMPTY, null, classLoader, null);
            return object;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebaseKeyForActivity(IBinder activityToken, ResourcesKey key, boolean overridesActivityDisplay) {
        Object object = this.mLock;
        synchronized (object) {
            Configuration config;
            ActivityResources activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
            if (key.mDisplayId == -1) {
                key.mDisplayId = activityResources.overrideDisplayId;
            }
            if (key.hasOverrideConfiguration()) {
                config = new Configuration(activityResources.overrideConfig);
                config.updateFrom(key.mOverrideConfiguration);
            } else {
                config = activityResources.overrideConfig;
            }
            if (overridesActivityDisplay && key.mOverrideConfiguration.windowConfiguration.getAppBounds() == null) {
                if (!key.hasOverrideConfiguration()) {
                    config = new Configuration(config);
                }
                config.windowConfiguration.setAppBounds(null);
            }
            key.mOverrideConfiguration.setTo(config);
        }
    }

    private void rebaseKeyForDisplay(ResourcesKey key, int overrideDisplay) {
        Configuration temp = new Configuration();
        DisplayAdjustments daj = new DisplayAdjustments(key.mOverrideConfiguration);
        daj.setCompatibilityInfo(key.mCompatInfo);
        DisplayMetrics dm = this.getDisplayMetrics(overrideDisplay, daj);
        ResourcesManager.applyDisplayMetricsToConfiguration(dm, temp);
        if (key.hasOverrideConfiguration()) {
            temp.updateFrom(key.mOverrideConfiguration);
        }
        key.mOverrideConfiguration.setTo(temp);
    }

    private static <T> void cleanupReferences(ArrayList<WeakReference<T>> references, ReferenceQueue<T> referenceQueue) {
        ResourcesManager.cleanupReferences(references, referenceQueue, Function.identity());
    }

    private static <C, T> void cleanupReferences(ArrayList<C> referenceContainers, ReferenceQueue<T> referenceQueue, Function<C, WeakReference<T>> unwrappingFunction) {
        Reference<T> enqueuedRef = referenceQueue.poll();
        if (enqueuedRef == null) {
            return;
        }
        HashSet deadReferences = new HashSet();
        while (enqueuedRef != null) {
            deadReferences.add(enqueuedRef);
            enqueuedRef = referenceQueue.poll();
        }
        ArrayUtils.unstableRemoveIf(referenceContainers, refContainer -> {
            WeakReference ref = (WeakReference)unwrappingFunction.apply(refContainer);
            return ref == null || deadReferences.contains(ref);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private ApkAssetsSupplier createApkAssetsSupplierNotLocked(@NonNull ResourcesKey key) {
        Trace.traceBegin(8192L, "ResourcesManager#createApkAssetsSupplierNotLocked");
        try {
            ApkAssetsSupplier supplier = new ApkAssetsSupplier();
            ArrayList<ApkKey> apkKeys = ResourcesManager.extractApkKeys(key);
            int n = apkKeys.size();
            for (int i = 0; i < n; ++i) {
                ApkKey apkKey = apkKeys.get(i);
                try {
                    supplier.load(apkKey);
                    continue;
                }
                catch (IOException e) {
                    Log.w(TAG, String.format("failed to preload asset path '%s'", apkKey.path), e);
                }
            }
            ApkAssetsSupplier apkAssetsSupplier = supplier;
            return apkAssetsSupplier;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Resources createResources(@NonNull ResourcesKey key, @NonNull ClassLoader classLoader, @Nullable ApkAssetsSupplier apkSupplier) {
        Object object = this.mLock;
        synchronized (object) {
            ResourcesImpl resourcesImpl = this.findOrCreateResourcesImplForKeyLocked(key, apkSupplier);
            if (resourcesImpl == null) {
                return null;
            }
            return this.createResourcesLocked(classLoader, resourcesImpl, key.mCompatInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Resources createResourcesForActivity(@NonNull IBinder activityToken, @NonNull ResourcesKey key, @NonNull Configuration initialOverrideConfig, @Nullable Integer overrideDisplayId, @NonNull ClassLoader classLoader, @Nullable ApkAssetsSupplier apkSupplier) {
        Object object = this.mLock;
        synchronized (object) {
            ResourcesImpl resourcesImpl = this.findOrCreateResourcesImplForKeyLocked(key, apkSupplier);
            if (resourcesImpl == null) {
                return null;
            }
            return this.createResourcesForActivityLocked(activityToken, initialOverrideConfig, overrideDisplayId, classLoader, resourcesImpl, key.mCompatInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Resources getResources(@Nullable IBinder activityToken, @Nullable String resDir, @Nullable String[] splitResDirs, @Nullable String[] legacyOverlayDirs, @Nullable String[] overlayPaths, @Nullable String[] libDirs, @Nullable Integer overrideDisplayId, @Nullable Configuration overrideConfig, @NonNull CompatibilityInfo compatInfo, @Nullable ClassLoader classLoader, @Nullable List<ResourcesLoader> loaders) {
        try {
            Resources resources;
            Trace.traceBegin(8192L, "ResourcesManager#getResources");
            ResourcesKey key = new ResourcesKey(resDir, splitResDirs, ResourcesManager.combinedOverlayPaths(legacyOverlayDirs, overlayPaths), libDirs, overrideDisplayId != null ? overrideDisplayId : -1, overrideConfig, compatInfo, loaders == null ? null : loaders.toArray(new ResourcesLoader[0]));
            classLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
            ApkAssetsSupplier assetsSupplier = this.createApkAssetsSupplierNotLocked(key);
            if (overrideDisplayId != null) {
                this.rebaseKeyForDisplay(key, overrideDisplayId);
            }
            if (activityToken != null) {
                Configuration initialOverrideConfig = new Configuration(key.mOverrideConfiguration);
                this.rebaseKeyForActivity(activityToken, key, overrideDisplayId != null);
                resources = this.createResourcesForActivity(activityToken, key, initialOverrideConfig, overrideDisplayId, classLoader, assetsSupplier);
            } else {
                resources = this.createResources(key, classLoader, assetsSupplier);
            }
            Resources resources2 = resources;
            return resources2;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResourcesForActivity(@NonNull IBinder activityToken, @Nullable Configuration overrideConfig, int displayId) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#updateResourcesForActivity");
            if (displayId == -1) {
                throw new IllegalArgumentException("displayId can not be INVALID_DISPLAY");
            }
            Object object = this.mLock;
            synchronized (object) {
                ActivityResources activityResources;
                block13: {
                    boolean movedToDifferentDisplay;
                    activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
                    boolean bl = movedToDifferentDisplay = activityResources.overrideDisplayId != displayId;
                    if (!Objects.equals(activityResources.overrideConfig, overrideConfig) || movedToDifferentDisplay) break block13;
                    return;
                }
                Configuration oldConfig = new Configuration(activityResources.overrideConfig);
                if (overrideConfig != null) {
                    activityResources.overrideConfig.setTo(overrideConfig);
                } else {
                    activityResources.overrideConfig.unset();
                }
                activityResources.overrideDisplayId = displayId;
                this.applyAllPendingAppInfoUpdates();
                int refCount = activityResources.activityResources.size();
                for (int i = 0; i < refCount; ++i) {
                    ResourcesImpl resourcesImpl;
                    ResourcesKey newKey;
                    ActivityResource activityResource = activityResources.activityResources.get(i);
                    Resources resources = (Resources)activityResource.resources.get();
                    if (resources == null || (newKey = this.rebaseActivityOverrideConfig(activityResource, overrideConfig, displayId)) == null || (resourcesImpl = this.findOrCreateResourcesImplForKeyLocked(newKey)) == null) continue;
                    if (resourcesImpl != resources.getImpl()) {
                        resources.setImpl(resourcesImpl);
                        continue;
                    }
                    if (!Flags.ignoreNonPublicConfigDiffForResourcesKey()) continue;
                    Configuration resConfig = resourcesImpl.getConfiguration();
                    resConfig.windowConfiguration.updateFrom(newKey.mOverrideConfiguration.windowConfiguration);
                    if (newKey.mOverrideConfiguration.seq == 0) continue;
                    resConfig.seq = newKey.mOverrideConfiguration.seq;
                }
            }
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    @Nullable
    private ResourcesKey rebaseActivityOverrideConfig(@NonNull ActivityResource activityResource, @Nullable Configuration newOverrideConfig, int displayId) {
        boolean hasOverrideConfig;
        Integer overrideDisplayId;
        Resources resources = (Resources)activityResource.resources.get();
        if (resources == null) {
            return null;
        }
        ResourcesKey oldKey = this.findKeyForResourceImplLocked(resources.getImpl());
        if (oldKey == null) {
            Slog.e(TAG, "can't find ResourcesKey for resources impl=" + resources.getImpl());
            return null;
        }
        Configuration rebasedOverrideConfig = new Configuration();
        if (newOverrideConfig != null) {
            rebasedOverrideConfig.setTo(newOverrideConfig);
        }
        if ((overrideDisplayId = activityResource.overrideDisplayId) != null) {
            DisplayAdjustments displayAdjustments = new DisplayAdjustments(rebasedOverrideConfig);
            displayAdjustments.getConfiguration().setTo(activityResource.overrideConfig);
            displayAdjustments.setCompatibilityInfo(oldKey.mCompatInfo);
            DisplayMetrics dm = this.getDisplayMetrics(overrideDisplayId, displayAdjustments);
            ResourcesManager.applyDisplayMetricsToConfiguration(dm, rebasedOverrideConfig);
        }
        boolean bl = hasOverrideConfig = !activityResource.overrideConfig.equals(Configuration.EMPTY);
        if (hasOverrideConfig) {
            rebasedOverrideConfig.updateFrom(activityResource.overrideConfig);
        }
        if (activityResource.overrideDisplayId != null && activityResource.overrideConfig.windowConfiguration.getAppBounds() == null) {
            rebasedOverrideConfig.windowConfiguration.setAppBounds(null);
        }
        displayId = overrideDisplayId != null ? overrideDisplayId : displayId;
        ResourcesKey newKey = new ResourcesKey(oldKey.mResDir, oldKey.mSplitResDirs, oldKey.mOverlayPaths, oldKey.mLibDirs, displayId, rebasedOverrideConfig, oldKey.mCompatInfo, oldKey.mLoaders);
        return newKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RavenwoodThrow(reason="AppInfo update not supported")
    public void appendPendingAppInfoUpdate(@NonNull String[] oldSourceDirs, @NonNull ApplicationInfo appInfo) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPendingAppInfoUpdates == null) {
                this.mPendingAppInfoUpdates = new ArrayList();
            }
            for (int i = this.mPendingAppInfoUpdates.size() - 1; i >= 0; --i) {
                if (!ArrayUtils.containsAll(oldSourceDirs, (String[])this.mPendingAppInfoUpdates.get((int)i).first)) continue;
                this.mPendingAppInfoUpdates.remove(i);
            }
            this.mPendingAppInfoUpdates.add(new Pair<String[], ApplicationInfo>(oldSourceDirs, appInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RavenwoodReplace(reason="AppInfo update not supported")
    public void applyAllPendingAppInfoUpdates() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPendingAppInfoUpdates != null) {
                int n = this.mPendingAppInfoUpdates.size();
                for (int i = 0; i < n; ++i) {
                    Pair<String[], ApplicationInfo> appInfo = this.mPendingAppInfoUpdates.get(i);
                    this.applyNewResourceDirsLocked((String[])appInfo.first, (ApplicationInfo)appInfo.second);
                }
                this.mPendingAppInfoUpdates = null;
            }
        }
    }

    private void applyAllPendingAppInfoUpdates$ravenwood() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean applyConfigurationToResources(@NonNull Configuration config, @Nullable CompatibilityInfo compat) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                Trace.traceBegin(8192L, "ResourcesManager#applyConfigurationToResources");
                if (!this.mResConfiguration.isOtherSeqNewer(config) && compat == null) {
                    boolean bl = false;
                    return bl;
                }
                int changes = this.mResConfiguration.updateFrom(config);
                if (!(compat == null || this.mResCompatibilityInfo != null && this.mResCompatibilityInfo.equals(compat))) {
                    changes |= compat.getCompatibilityChangesForConfig(this.mResCompatibilityInfo);
                    this.mResCompatibilityInfo = compat;
                }
                if ((changes & Integer.MIN_VALUE) != 0) {
                    this.applyAllPendingAppInfoUpdates();
                }
                DisplayMetrics displayMetrics = this.getDisplayMetrics(config);
                Resources.updateSystemConfiguration(config, displayMetrics, compat);
                ApplicationPackageManager.configurationChanged();
                Configuration tmpConfig = new Configuration();
                for (int i = this.mResourceImpls.size() - 1; i >= 0; --i) {
                    ResourcesImpl r;
                    ResourcesKey key = this.mResourceImpls.keyAt(i);
                    WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
                    ResourcesImpl resourcesImpl = r = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
                    if (r != null) {
                        this.applyConfigurationToResourcesLocked(config, compat, tmpConfig, key, r);
                        continue;
                    }
                    this.mResourceImpls.removeAt(i);
                }
                boolean bl = changes != 0;
                return bl;
            }
            finally {
                Trace.traceEnd(8192L);
            }
        }
    }

    private void applyConfigurationToResourcesLocked(@NonNull Configuration config, @Nullable CompatibilityInfo compat, Configuration tmpConfig, ResourcesKey key, ResourcesImpl resourcesImpl) {
        tmpConfig.setTo(config);
        if (key.hasOverrideConfiguration()) {
            tmpConfig.updateFrom(key.mOverrideConfiguration);
        }
        DisplayAdjustments daj = resourcesImpl.getDisplayAdjustments();
        if (compat != null) {
            daj = new DisplayAdjustments(daj);
            daj.setCompatibilityInfo(compat);
        }
        daj.setConfiguration(tmpConfig);
        DisplayMetrics dm = this.getDisplayMetrics(this.generateDisplayId(key), daj);
        resourcesImpl.updateConfiguration(tmpConfig, dm, compat);
    }

    @UnsupportedAppUsage
    public void appendLibAssetForMainAssetPath(String assetPath, String libAsset) {
        this.appendLibAssetsForMainAssetPath(assetPath, new String[]{libAsset});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendLibAssetsForMainAssetPath(String assetPath, String[] libAssets) {
        Object object = this.mLock;
        synchronized (object) {
            ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys = new ArrayMap<ResourcesImpl, ResourcesKey>();
            int implCount = this.mResourceImpls.size();
            for (int i = 0; i < implCount; ++i) {
                ResourcesImpl impl;
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
                ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
                if (impl == null || !Objects.equals(key.mResDir, assetPath)) continue;
                Object[] newLibAssets = key.mLibDirs;
                for (String libAsset : libAssets) {
                    newLibAssets = ArrayUtils.appendElement(String.class, newLibAssets, libAsset);
                }
                if (Arrays.equals(newLibAssets, key.mLibDirs)) continue;
                updatedResourceKeys.put(impl, new ResourcesKey(key.mResDir, key.mSplitResDirs, key.mOverlayPaths, (String[])newLibAssets, key.mDisplayId, key.mOverrideConfiguration, key.mCompatInfo, key.mLoaders));
            }
            this.redirectResourcesToNewImplLocked(updatedResourceKeys);
        }
    }

    @Nullable
    private ResourcesKey createNewResourceKeyIfNeeded(@NonNull ResourcesKey original, @NonNull ResourcesKey library) {
        PathCollector collector = new PathCollector(original);
        collector.appendKey(library);
        return collector.isSameAsOriginal() ? null : collector.collectedKey();
    }

    private void appendLibAssetsLocked(@NonNull SharedLibraryAssets libAssets) {
        ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys = new ArrayMap<ResourcesImpl, ResourcesKey>();
        int implCount = this.mResourceImpls.size();
        for (int i = 0; i < implCount; ++i) {
            ResourcesImpl impl;
            ResourcesKey key = this.mResourceImpls.keyAt(i);
            WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
            ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
            if (impl == null) {
                Slog.w(TAG, "Found a null ResourcesImpl, skipped.");
                continue;
            }
            ResourcesKey newKey = this.createNewResourceKeyIfNeeded(key, libAssets.getResourcesKey());
            if (newKey == null) continue;
            updatedResourceKeys.put(impl, newKey);
        }
        this.redirectAllResourcesToNewImplLocked(updatedResourceKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyNewResourceDirsLocked(@Nullable String[] oldSourceDirs, @NonNull ApplicationInfo appInfo) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#applyNewResourceDirsLocked");
            String baseCodePath = appInfo.getBaseCodePath();
            int myUid = Process.myUid();
            String[] newSplitDirs = appInfo.uid == myUid ? appInfo.splitSourceDirs : appInfo.splitPublicSourceDirs;
            String[] copiedSplitDirs = ArrayUtils.cloneOrNull(newSplitDirs);
            String[] copiedResourceDirs = ResourcesManager.combinedOverlayPaths(appInfo.resourceDirs, appInfo.overlayPaths);
            if (appInfo.uid == myUid) {
                this.addApplicationPathsLocked(baseCodePath, copiedSplitDirs);
            }
            ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys = new ArrayMap<ResourcesImpl, ResourcesKey>();
            int implCount = this.mResourceImpls.size();
            for (int i = 0; i < implCount; ++i) {
                ResourcesImpl impl;
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
                ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
                if (impl == null || key.mResDir != null && !key.mResDir.equals(baseCodePath) && !ArrayUtils.contains(oldSourceDirs, key.mResDir)) continue;
                updatedResourceKeys.put(impl, new ResourcesKey(baseCodePath, copiedSplitDirs, copiedResourceDirs, key.mLibDirs, key.mDisplayId, key.mOverrideConfiguration, key.mCompatInfo, key.mLoaders));
            }
            this.redirectResourcesToNewImplLocked(updatedResourceKeys);
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    @Nullable
    private static String[] combinedOverlayPaths(@Nullable String[] resourceDirs, @Nullable String[] overlayPaths) {
        if (resourceDirs == null) {
            return ArrayUtils.cloneOrNull(overlayPaths);
        }
        if (overlayPaths == null) {
            return ArrayUtils.cloneOrNull(resourceDirs);
        }
        ArrayList<String> paths = new ArrayList<String>(overlayPaths.length + resourceDirs.length);
        for (String path : overlayPaths) {
            paths.add(path);
        }
        for (String path : resourceDirs) {
            if (paths.contains(path)) continue;
            paths.add(path);
        }
        return paths.toArray(new String[0]);
    }

    private void redirectResourcesToNewImplLocked(@NonNull ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys) {
        if (updatedResourceKeys.isEmpty()) {
            return;
        }
        int resourcesCount = this.mResourceReferences.size();
        for (int i = 0; i < resourcesCount; ++i) {
            ResourcesKey key;
            Resources r;
            WeakReference<Resources> ref = this.mResourceReferences.get(i);
            Resources resources = r = ref != null ? (Resources)ref.get() : null;
            if (r == null || (key = updatedResourceKeys.get(r.getImpl())) == null) continue;
            ResourcesImpl impl = this.findOrCreateResourcesImplForKeyLocked(key);
            if (impl == null) {
                throw new Resources.NotFoundException("failed to redirect ResourcesImpl");
            }
            r.setImpl(impl);
        }
        for (ActivityResources activityResources : this.mActivityResourceReferences.values()) {
            int resCount = activityResources.activityResources.size();
            for (int i = 0; i < resCount; ++i) {
                ResourcesKey key;
                Resources r;
                ActivityResource activityResource = activityResources.activityResources.get(i);
                Resources resources = r = activityResource != null ? (Resources)activityResource.resources.get() : null;
                if (r == null || (key = updatedResourceKeys.get(r.getImpl())) == null) continue;
                ResourcesImpl impl = this.findOrCreateResourcesImplForKeyLocked(key);
                if (impl == null) {
                    throw new Resources.NotFoundException("failed to redirect ResourcesImpl");
                }
                r.setImpl(impl);
            }
        }
    }

    private void redirectAllResourcesToNewImplLocked(@NonNull ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys) {
        ResourcesManager.cleanupReferences(this.mAllResourceReferences, this.mAllResourceReferencesQueue);
        int resourcesCount = this.mAllResourceReferences.size();
        for (int i = 0; i < resourcesCount; ++i) {
            AssetManager oldAssets;
            Resources r;
            WeakReference<Resources> ref = this.mAllResourceReferences.get(i);
            Resources resources = r = ref != null ? (Resources)ref.get() : null;
            if (r == null) continue;
            ResourcesKey key = updatedResourceKeys.get(r.getImpl());
            if (key != null) {
                ResourcesImpl impl = this.findOrCreateResourcesImplForKeyLocked(key);
                if (impl != null) {
                    r.setImpl(impl);
                    continue;
                }
                Slog.w(TAG, "failed to redirect ResourcesImpl, left untouched, for a key " + key);
                continue;
            }
            ResourcesImpl oldImpl = r.getImpl();
            if (oldImpl == null || (oldAssets = oldImpl.getAssets()) == AssetManager.getSystem()) continue;
            if (oldAssets.isUpToDate()) {
                ResourcesImpl newImpl = new ResourcesImpl(oldImpl);
                r.setImpl(newImpl);
                continue;
            }
            Slog.w(TAG, "Skip appending shared library asset paths for the Resources as its assets are not up to date.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAllResourcesReference(@NonNull Resources resources) {
        Object object = this.mLock;
        synchronized (object) {
            ResourcesManager.cleanupReferences(this.mAllResourceReferences, this.mAllResourceReferencesQueue);
            this.mAllResourceReferences.add(new WeakReference<Resources>(resources, this.mAllResourceReferencesQueue));
        }
    }

    @VisibleForTesting
    public static class SharedLibraryAssets {
        private final ResourcesKey mResourcesKey;

        private SharedLibraryAssets(@NonNull ApplicationInfo appInfo, @Nullable ApplicationInfo baseAppInfo) {
            PathCollector collector = new PathCollector(null);
            if (baseAppInfo != null && !baseAppInfo.sourceDir.equals(appInfo.sourceDir)) {
                collector.libsSet.add(baseAppInfo.sourceDir);
                if (baseAppInfo.splitSourceDirs != null) {
                    collector.libsSet.addAll(Arrays.asList(baseAppInfo.splitSourceDirs));
                }
                if (baseAppInfo.resourceDirs != null) {
                    collector.overlaysSet.addAll(Arrays.asList(baseAppInfo.resourceDirs));
                }
                if (baseAppInfo.overlayPaths != null) {
                    collector.overlaysSet.addAll(Arrays.asList(baseAppInfo.overlayPaths));
                }
            }
            PathCollector.appendNewPath(appInfo.sourceDir, collector.libsSet, collector.orderedLibs);
            PathCollector.appendAllNewPaths(appInfo.splitSourceDirs, collector.libsSet, collector.orderedLibs);
            PathCollector.appendAllNewPaths(appInfo.sharedLibraryFiles, collector.libsSet, collector.orderedLibs);
            PathCollector.appendAllNewPaths(appInfo.resourceDirs, collector.overlaysSet, collector.orderedOverlays);
            PathCollector.appendAllNewPaths(appInfo.overlayPaths, collector.overlaysSet, collector.orderedOverlays);
            this.mResourcesKey = collector.collectedKey();
        }

        @NonNull
        public ResourcesKey getResourcesKey() {
            return this.mResourcesKey;
        }
    }

    private static class PathCollector {
        public final ResourcesKey originalKey;
        public final ArrayList<String> orderedLibs = new ArrayList();
        public final ArraySet<String> libsSet = new ArraySet();
        public final ArrayList<String> orderedOverlays = new ArrayList();
        public final ArraySet<String> overlaysSet = new ArraySet();

        static void appendNewPath(@NonNull String path, @NonNull ArraySet<String> uniquePaths, @NonNull ArrayList<String> orderedPaths) {
            if (uniquePaths.add(path)) {
                orderedPaths.add(path);
            }
        }

        static void appendAllNewPaths(@Nullable String[] paths, @NonNull ArraySet<String> uniquePaths, @NonNull ArrayList<String> orderedPaths) {
            if (paths == null) {
                return;
            }
            int size = paths.length;
            for (int i = 0; i < size; ++i) {
                PathCollector.appendNewPath(paths[i], uniquePaths, orderedPaths);
            }
        }

        PathCollector(@Nullable ResourcesKey original) {
            this.originalKey = original;
            if (this.originalKey != null) {
                this.appendKey(this.originalKey);
            }
        }

        public void appendKey(@NonNull ResourcesKey key) {
            PathCollector.appendAllNewPaths(key.mLibDirs, this.libsSet, this.orderedLibs);
            PathCollector.appendAllNewPaths(key.mOverlayPaths, this.overlaysSet, this.orderedOverlays);
        }

        boolean isSameAsOriginal() {
            if (this.originalKey == null) {
                return this.orderedLibs.isEmpty() && this.orderedOverlays.isEmpty();
            }
            return (this.originalKey.mLibDirs == null && this.orderedLibs.isEmpty() || this.originalKey.mLibDirs != null && this.originalKey.mLibDirs.length == this.orderedLibs.size()) && (this.originalKey.mOverlayPaths == null && this.orderedOverlays.isEmpty() || this.originalKey.mOverlayPaths != null && this.originalKey.mOverlayPaths.length == this.orderedOverlays.size());
        }

        @NonNull
        ResourcesKey collectedKey() {
            return new ResourcesKey(this.originalKey == null ? null : this.originalKey.mResDir, this.originalKey == null ? null : this.originalKey.mSplitResDirs, this.orderedOverlays.toArray(new String[0]), this.orderedLibs.toArray(new String[0]), this.originalKey == null ? 0 : this.originalKey.mDisplayId, this.originalKey == null ? null : this.originalKey.mOverrideConfiguration, this.originalKey == null ? null : this.originalKey.mCompatInfo, this.originalKey == null ? null : this.originalKey.mLoaders);
        }
    }

    private class UpdateHandler
    implements Resources.UpdateCallbacks {
        private UpdateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @RavenwoodThrow(blockedBy={ResourcesLoader.class})
        public void onLoadersChanged(@NonNull Resources resources, @NonNull List<ResourcesLoader> newLoader) {
            Object object = ResourcesManager.this.mLock;
            synchronized (object) {
                ResourcesKey oldKey = ResourcesManager.this.findKeyForResourceImplLocked(resources.getImpl());
                if (oldKey == null) {
                    throw new IllegalArgumentException("Cannot modify resource loaders of ResourcesImpl not registered with ResourcesManager");
                }
                ResourcesKey newKey = new ResourcesKey(oldKey.mResDir, oldKey.mSplitResDirs, oldKey.mOverlayPaths, oldKey.mLibDirs, oldKey.mDisplayId, oldKey.mOverrideConfiguration, oldKey.mCompatInfo, newLoader.toArray(new ResourcesLoader[0]));
                ResourcesImpl impl = ResourcesManager.this.findOrCreateResourcesImplForKeyLocked(newKey);
                resources.setImpl(impl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @RavenwoodThrow(blockedBy={ResourcesLoader.class})
        public void onLoaderUpdated(@NonNull ResourcesLoader loader) {
            Object object = ResourcesManager.this.mLock;
            synchronized (object) {
                ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceImplKeys = new ArrayMap<ResourcesImpl, ResourcesKey>();
                for (int i = ResourcesManager.this.mResourceImpls.size() - 1; i >= 0; --i) {
                    ResourcesKey key = ResourcesManager.this.mResourceImpls.keyAt(i);
                    WeakReference<ResourcesImpl> impl = ResourcesManager.this.mResourceImpls.valueAt(i);
                    if (impl == null || Reference_Delegate.refersTo(impl, null) || !ArrayUtils.contains(key.mLoaders, loader)) continue;
                    ResourcesManager.this.mResourceImpls.remove(key);
                    updatedResourceImplKeys.put((ResourcesImpl)impl.get(), key);
                }
                ResourcesManager.this.redirectResourcesToNewImplLocked(updatedResourceImplKeys);
            }
        }
    }

    public static class ApkKey {
        public final String path;
        public final boolean sharedLib;
        public final boolean overlay;

        public ApkKey(String path, boolean sharedLib, boolean overlay) {
            this.path = path;
            this.sharedLib = sharedLib;
            this.overlay = overlay;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.path.hashCode();
            result = 31 * result + Boolean.hashCode(this.sharedLib);
            result = 31 * result + Boolean.hashCode(this.overlay);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof ApkKey)) {
                return false;
            }
            ApkKey other = (ApkKey)obj;
            return this.path.equals(other.path) && this.sharedLib == other.sharedLib && this.overlay == other.overlay;
        }

        public String toString() {
            return "ApkKey[" + (this.sharedLib ? "lib" : "app") + (this.overlay ? ", overlay" : "") + ": " + this.path + "]";
        }
    }

    @VisibleForTesting
    protected class ApkAssetsSupplier {
        final ArrayMap<ApkKey, ApkAssets> mLocalCache = new ArrayMap();

        protected ApkAssetsSupplier() {
        }

        ApkAssets load(ApkKey apkKey) throws IOException {
            ApkAssets apkAssets = this.mLocalCache.get(apkKey);
            if (apkAssets == null) {
                apkAssets = ResourcesManager.this.loadApkAssets(apkKey);
                this.mLocalCache.put(apkKey, apkAssets);
            }
            return apkAssets;
        }
    }

    private static class ActivityResources {
        public final Configuration overrideConfig = new Configuration();
        public int overrideDisplayId;
        public final ArrayList<ActivityResource> activityResources = new ArrayList();
        public final ReferenceQueue<Resources> activityResourcesQueue = new ReferenceQueue();

        @UnsupportedAppUsage
        private ActivityResources() {
        }

        public int countLiveReferences() {
            int count = 0;
            for (int i = 0; i < this.activityResources.size(); ++i) {
                WeakReference<Resources> resources = this.activityResources.get((int)i).resources;
                if (resources == null || resources.get() == null) continue;
                ++count;
            }
            return count;
        }
    }

    private static class ActivityResource {
        public final Configuration overrideConfig = new Configuration();
        @Nullable
        public Integer overrideDisplayId;
        @Nullable
        public WeakReference<Resources> resources;

        private ActivityResource() {
        }
    }
}

