/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.AutomaticZenRule;
import android.app.ICallNotificationEventCallback;
import android.app.INotificationManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.Person;
import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IpcDataCache;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.UserHandle;
import android.service.notification.Condition;
import android.service.notification.RateEstimator;
import android.service.notification.StatusBarNotification;
import android.service.notification.ZenDeviceEffects;
import android.service.notification.ZenModeConfig;
import android.service.notification.ZenPolicy;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.LruCache;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.service.notification.Flags;
import com.android.internal.notification.NotificationChannelGroupsHelper;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Duration;
import java.time.Instant;
import java.time.InstantSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

public class NotificationManager {
    private static String TAG = "NotificationManager";
    private static boolean localLOGV = false;
    public static final String ACTION_APP_BLOCK_STATE_CHANGED = "android.app.action.APP_BLOCK_STATE_CHANGED";
    public static final String ACTION_NOTIFICATION_CHANNEL_BLOCK_STATE_CHANGED = "android.app.action.NOTIFICATION_CHANNEL_BLOCK_STATE_CHANGED";
    @SystemApi
    @RequiresPermission(value="android.permission.STATUS_BAR_SERVICE")
    public static final String ACTION_TOGGLE_NOTIFICATION_HANDLER_PANEL = "android.app.action.TOGGLE_NOTIFICATION_HANDLER_PANEL";
    @SystemApi
    @RequiresPermission(value="android.permission.STATUS_BAR_SERVICE")
    public static final String ACTION_OPEN_NOTIFICATION_HANDLER_PANEL = "android.app.action.OPEN_NOTIFICATION_HANDLER_PANEL";
    @SystemApi
    @RequiresPermission(value="android.permission.STATUS_BAR_SERVICE")
    public static final String ACTION_CLOSE_NOTIFICATION_HANDLER_PANEL = "android.app.action.CLOSE_NOTIFICATION_HANDLER_PANEL";
    public static final String EXTRA_NOTIFICATION_CHANNEL_ID = "android.app.extra.NOTIFICATION_CHANNEL_ID";
    public static final String EXTRA_NOTIFICATION_CHANNEL_GROUP_ID = "android.app.extra.NOTIFICATION_CHANNEL_GROUP_ID";
    public static final String EXTRA_BLOCKED_STATE = "android.app.extra.BLOCKED_STATE";
    public static final String ACTION_NOTIFICATION_CHANNEL_GROUP_BLOCK_STATE_CHANGED = "android.app.action.NOTIFICATION_CHANNEL_GROUP_BLOCK_STATE_CHANGED";
    public static final String ACTION_AUTOMATIC_ZEN_RULE_STATUS_CHANGED = "android.app.action.AUTOMATIC_ZEN_RULE_STATUS_CHANGED";
    public static final String ACTION_ZEN_CONFIGURATION_CHANGED_INTERNAL = "android.app.action.ZEN_CONFIGURATION_CHANGED_INTERNAL";
    public static final String EXTRA_AUTOMATIC_ZEN_RULE_STATUS = "android.app.extra.AUTOMATIC_ZEN_RULE_STATUS";
    public static final String EXTRA_AUTOMATIC_ZEN_RULE_ID = "android.app.extra.AUTOMATIC_ZEN_RULE_ID";
    public static final int AUTOMATIC_RULE_STATUS_UNKNOWN = -1;
    public static final int AUTOMATIC_RULE_STATUS_ENABLED = 1;
    public static final int AUTOMATIC_RULE_STATUS_DISABLED = 2;
    public static final int AUTOMATIC_RULE_STATUS_REMOVED = 3;
    public static final int AUTOMATIC_RULE_STATUS_ACTIVATED = 4;
    public static final int AUTOMATIC_RULE_STATUS_DEACTIVATED = 5;
    public static final String ACTION_EFFECTS_SUPPRESSOR_CHANGED = "android.os.action.ACTION_EFFECTS_SUPPRESSOR_CHANGED";
    public static final String ACTION_NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED = "android.app.action.NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED";
    public static final String ACTION_NOTIFICATION_POLICY_CHANGED = "android.app.action.NOTIFICATION_POLICY_CHANGED";
    public static final String ACTION_CONSOLIDATED_NOTIFICATION_POLICY_CHANGED = "android.app.action.CONSOLIDATED_NOTIFICATION_POLICY_CHANGED";
    public static final String EXTRA_NOTIFICATION_POLICY = "android.app.extra.NOTIFICATION_POLICY";
    public static final String ACTION_INTERRUPTION_FILTER_CHANGED = "android.app.action.INTERRUPTION_FILTER_CHANGED";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String ACTION_NOTIFICATION_LISTENER_ENABLED_CHANGED = "android.app.action.NOTIFICATION_LISTENER_ENABLED_CHANGED";
    public static final String ACTION_INTERRUPTION_FILTER_CHANGED_INTERNAL = "android.app.action.INTERRUPTION_FILTER_CHANGED_INTERNAL";
    public static final int INTERRUPTION_FILTER_ALL = 1;
    public static final int INTERRUPTION_FILTER_PRIORITY = 2;
    public static final int INTERRUPTION_FILTER_NONE = 3;
    public static final int INTERRUPTION_FILTER_ALARMS = 4;
    public static final int INTERRUPTION_FILTER_UNKNOWN = 0;
    public static final String ACTION_AUTOMATIC_ZEN_RULE = "android.app.action.AUTOMATIC_ZEN_RULE";
    public static final String EXTRA_AUTOMATIC_RULE_ID = "android.app.extra.AUTOMATIC_RULE_ID";
    public static final String META_DATA_AUTOMATIC_RULE_TYPE = "android.service.zen.automatic.ruleType";
    public static final String META_DATA_RULE_INSTANCE_LIMIT = "android.service.zen.automatic.ruleInstanceLimit";
    public static final int VISIBILITY_NO_OVERRIDE = -1000;
    public static final int IMPORTANCE_UNSPECIFIED = -1000;
    public static final int IMPORTANCE_NONE = 0;
    public static final int IMPORTANCE_MIN = 1;
    public static final int IMPORTANCE_LOW = 2;
    public static final int IMPORTANCE_DEFAULT = 3;
    public static final int IMPORTANCE_HIGH = 4;
    public static final int IMPORTANCE_MAX = 5;
    public static final int BUBBLE_PREFERENCE_NONE = 0;
    public static final int BUBBLE_PREFERENCE_ALL = 1;
    public static final int BUBBLE_PREFERENCE_SELECTED = 2;
    public static int MAX_SERVICE_COMPONENT_NAME_LENGTH = 500;
    private static final float MAX_NOTIFICATION_UPDATE_RATE = 5.0f;
    private static final float MAX_NOTIFICATION_UNNECESSARY_CANCEL_RATE = 5.0f;
    private static final int KNOWN_STATUS_ENQUEUED = 1;
    private static final int KNOWN_STATUS_CANCELLED = 2;
    private final Context mContext;
    private final Map<CallNotificationEventListener, CallNotificationEventCallbackStub> mCallNotificationEventCallbacks = new HashMap<CallNotificationEventListener, CallNotificationEventCallbackStub>();
    private final InstantSource mClock;
    private final RateLimiter mUpdateRateLimiter = new RateLimiter("notify (update)", "notifications.value_client_throttled_notify_update", 5.0f);
    private final RateLimiter mUnnecessaryCancelRateLimiter = new RateLimiter("cancel (dupe)", "notifications.value_client_throttled_cancel_duplicate", 5.0f);
    private final LruCache<NotificationKey, Integer> mKnownNotifications = new LruCache(100);
    private final Object mThrottleLock = new Object();
    @UnsupportedAppUsage
    private static INotificationManager sService;
    private static final String NOTIFICATION_CHANNELS_CACHE_API = "getNotificationChannels";
    private static final int NOTIFICATION_CHANNELS_CACHE_SIZE = 10;
    private static final String NOTIFICATION_CHANNEL_GROUPS_CACHE_API = "getNotificationChannelGroups";
    private static final int NOTIFICATION_CHANNEL_GROUPS_CACHE_SIZE = 10;
    private final IpcDataCache.QueryHandler<NotificationChannelQuery, List<NotificationChannel>> mNotificationChannelListQueryHandler = new IpcDataCache.QueryHandler<NotificationChannelQuery, List<NotificationChannel>>(){

        @Override
        public List<NotificationChannel> apply(NotificationChannelQuery query) {
            INotificationManager service = NotificationManager.this.service();
            try {
                return service.getNotificationChannels(query.callingPkg, query.targetPkg, query.userId).getList();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @Override
        public boolean shouldBypassCache(@NonNull NotificationChannelQuery query) {
            if (!com.android.internal.hidden_from_bootclasspath.android.app.Flags.nmBinderPerfCacheChannels()) {
                Log.wtf(TAG, "shouldBypassCache called when nm_binder_perf_cache_channels off");
                return true;
            }
            return false;
        }
    };
    private final IpcDataCache<NotificationChannelQuery, List<NotificationChannel>> mNotificationChannelListCache = new IpcDataCache<NotificationChannelQuery, List<NotificationChannel>>(10, "system_server", "getNotificationChannels", "getNotificationChannels", this.mNotificationChannelListQueryHandler);
    private final IpcDataCache.QueryHandler<String, Map<String, NotificationChannelGroup>> mNotificationChannelGroupsQueryHandler = new IpcDataCache.QueryHandler<String, Map<String, NotificationChannelGroup>>(){

        @Override
        public Map<String, NotificationChannelGroup> apply(String pkg) {
            INotificationManager service = NotificationManager.this.service();
            ArrayMap<String, NotificationChannelGroup> groups = new ArrayMap<String, NotificationChannelGroup>();
            try {
                ParceledListSlice parceledList = service.getNotificationChannelGroupsWithoutChannels(pkg);
                if (parceledList != null) {
                    for (NotificationChannelGroup group : parceledList.getList()) {
                        groups.put(group.getId(), group);
                    }
                }
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            return groups;
        }

        @Override
        public boolean shouldBypassCache(@NonNull String query) {
            if (!com.android.internal.hidden_from_bootclasspath.android.app.Flags.nmBinderPerfCacheChannels()) {
                Log.wtf(TAG, "shouldBypassCache called when nm_binder_perf_cache_channels off");
                return true;
            }
            return false;
        }
    };
    private final IpcDataCache<String, Map<String, NotificationChannelGroup>> mNotificationChannelGroupsCache = new IpcDataCache<String, Map<String, NotificationChannelGroup>>(10, "system_server", "getNotificationChannelGroups", "getNotificationChannelGroups", this.mNotificationChannelGroupsQueryHandler);
    public static final long SET_LISTENER_ACCESS_GRANTED_IS_USER_AWARE = 302563478L;

    @UnsupportedAppUsage
    public static INotificationManager getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("notification");
        sService = INotificationManager.Stub.asInterface(b);
        return sService;
    }

    protected INotificationManager service() {
        return NotificationManager.getService();
    }

    public NotificationManager(Context context) {
        this(context, SystemClock.elapsedRealtimeClock());
    }

    @UnsupportedAppUsage
    public NotificationManager(Context context, InstantSource clock) {
        this.mContext = context;
        this.mClock = clock;
    }

    @UnsupportedAppUsage
    public static NotificationManager from(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }

    public void notify(int id2, Notification notification) {
        this.notify(null, id2, notification);
    }

    public void notify(String tag, int id2, Notification notification) {
        this.notifyAsUser(tag, id2, notification, this.mContext.getUser());
    }

    public void notifyAsPackage(@NonNull String targetPackage, @Nullable String tag, int id2, @NonNull Notification notification) {
        INotificationManager service = this.service();
        String sender = this.mContext.getPackageName();
        if (this.discardNotify(this.mContext.getUser(), targetPackage, tag, id2, notification)) {
            return;
        }
        try {
            if (localLOGV) {
                Log.v(TAG, sender + ": notify(" + id2 + ", " + notification + ")");
            }
            service.enqueueNotificationWithTag(targetPackage, sender, tag, id2, this.fixNotification(notification), this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void notifyAsUser(@Nullable String tag, int id2, Notification notification, UserHandle user) {
        INotificationManager service = this.service();
        String pkg = this.mContext.getPackageName();
        if (this.discardNotify(user, pkg, tag, id2, notification)) {
            return;
        }
        try {
            if (localLOGV) {
                Log.v(TAG, pkg + ": notify(" + id2 + ", " + notification + ")");
            }
            service.enqueueNotificationWithTag(pkg, this.mContext.getOpPackageName(), tag, id2, this.fixNotification(notification), user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean discardNotify(UserHandle user, String pkg, @Nullable String tag, int id2, Notification notification) {
        if (Flags.notificationClassification() && NotificationChannel.SYSTEM_RESERVED_IDS.contains(notification.getChannelId())) {
            return true;
        }
        if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.nmBinderPerfThrottleNotify()) {
            NotificationKey key = new NotificationKey(user, pkg, tag, id2);
            Object object = this.mThrottleLock;
            synchronized (object) {
                Integer status = this.mKnownNotifications.get(key);
                if (status != null && status == 1 && !notification.hasCompletedProgress()) {
                    if (this.mUpdateRateLimiter.eventExceedsRate()) {
                        this.mUpdateRateLimiter.recordRejected(key);
                        return true;
                    }
                    this.mUpdateRateLimiter.recordAccepted();
                }
                this.mKnownNotifications.put(key, 1);
            }
        }
        return false;
    }

    private Notification fixNotification(Notification notification) {
        String pkg = this.mContext.getPackageName();
        Notification.addFieldsFromContext(this.mContext, notification);
        if (notification.sound != null) {
            notification.sound = notification.sound.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                notification.sound.checkFileUriExposed("Notification.sound");
            }
        }
        this.fixLegacySmallIcon(notification, pkg);
        if (this.mContext.getApplicationInfo().targetSdkVersion > 22 && notification.getSmallIcon() == null) {
            throw new IllegalArgumentException("Invalid notification (no valid small icon): " + notification);
        }
        notification.reduceImageSizes(this.mContext);
        return Notification.Builder.maybeCloneStrippedForDelivery(notification);
    }

    private void fixLegacySmallIcon(Notification n, String pkg) {
        if (n.getSmallIcon() == null && n.icon != 0) {
            n.setSmallIcon(Icon.createWithResource(pkg, n.icon));
        }
    }

    public void cancel(int id2) {
        this.cancel(null, id2);
    }

    public void cancel(@Nullable String tag, int id2) {
        this.cancelAsUser(tag, id2, this.mContext.getUser());
    }

    public void cancelAsPackage(@NonNull String targetPackage, @Nullable String tag, int id2) {
        if (this.discardCancel(this.mContext.getUser(), targetPackage, tag, id2)) {
            return;
        }
        INotificationManager service = this.service();
        try {
            service.cancelNotificationWithTag(targetPackage, this.mContext.getOpPackageName(), tag, id2, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void cancelAsUser(@Nullable String tag, int id2, UserHandle user) {
        String pkg = this.mContext.getPackageName();
        if (this.discardCancel(user, pkg, tag, id2)) {
            return;
        }
        INotificationManager service = this.service();
        if (localLOGV) {
            Log.v(TAG, pkg + ": cancel(" + id2 + ")");
        }
        try {
            service.cancelNotificationWithTag(pkg, this.mContext.getOpPackageName(), tag, id2, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean discardCancel(UserHandle user, String pkg, @Nullable String tag, int id2) {
        if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.nmBinderPerfThrottleNotify()) {
            NotificationKey key = new NotificationKey(user, pkg, tag, id2);
            Object object = this.mThrottleLock;
            synchronized (object) {
                Integer status = this.mKnownNotifications.get(key);
                if (status != null && status == 2) {
                    if (this.mUnnecessaryCancelRateLimiter.eventExceedsRate()) {
                        this.mUnnecessaryCancelRateLimiter.recordRejected(key);
                        return true;
                    }
                    this.mUnnecessaryCancelRateLimiter.recordAccepted();
                }
                this.mKnownNotifications.put(key, 2);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        String pkg = this.mContext.getPackageName();
        UserHandle user = this.mContext.getUser();
        if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.nmBinderPerfThrottleNotify()) {
            Object object = this.mThrottleLock;
            synchronized (object) {
                for (NotificationKey key : this.mKnownNotifications.snapshot().keySet()) {
                    if (!key.pkg.equals(pkg) || !key.user.equals(user)) continue;
                    this.mKnownNotifications.put(key, 2);
                }
            }
        }
        INotificationManager service = this.service();
        if (localLOGV) {
            Log.v(TAG, pkg + ": cancelAll()");
        }
        try {
            service.cancelAllNotifications(pkg, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setNotificationDelegate(@Nullable String delegate) {
        INotificationManager service = this.service();
        String pkg = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, pkg + ": setNotificationDelegate()");
        }
        try {
            service.setNotificationDelegate(pkg, delegate);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public String getNotificationDelegate() {
        INotificationManager service = this.service();
        String pkg = this.mContext.getPackageName();
        try {
            return service.getNotificationDelegate(pkg);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean canNotifyAsPackage(@NonNull String pkg) {
        INotificationManager service = this.service();
        try {
            return service.canNotifyAsPackage(this.mContext.getPackageName(), pkg, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean canUseFullScreenIntent() {
        INotificationManager service = this.service();
        try {
            return service.canUseFullScreenIntent(this.mContext.getAttributionSource());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.app.api_rich_ongoing")
    public boolean canPostPromotedNotifications() {
        INotificationManager service = this.service();
        try {
            return service.canBePromoted(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.app.api_rich_ongoing")
    public void setCanPostPromotedNotifications(@NonNull String pkg, int uid, boolean allowed) {
        INotificationManager service = this.service();
        try {
            service.setCanBePromoted(pkg, uid, allowed, true);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void createNotificationChannelGroup(@NonNull NotificationChannelGroup group) {
        this.createNotificationChannelGroups(Arrays.asList(group));
    }

    public void createNotificationChannelGroups(@NonNull List<NotificationChannelGroup> groups) {
        INotificationManager service = this.service();
        try {
            service.createNotificationChannelGroups(this.mContext.getPackageName(), new ParceledListSlice<NotificationChannelGroup>(groups));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void createNotificationChannel(@NonNull NotificationChannel channel) {
        this.createNotificationChannels(Arrays.asList(channel));
    }

    public void createNotificationChannels(@NonNull List<NotificationChannel> channels) {
        INotificationManager service = this.service();
        try {
            service.createNotificationChannels(this.mContext.getPackageName(), new ParceledListSlice<NotificationChannel>(channels));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public NotificationChannel getNotificationChannel(String channelId) {
        if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.nmBinderPerfCacheChannels()) {
            return NotificationManager.getChannelFromList(channelId, this.mNotificationChannelListCache.query(new NotificationChannelQuery(this.mContext.getOpPackageName(), this.mContext.getPackageName(), this.mContext.getUserId())));
        }
        INotificationManager service = this.service();
        try {
            return service.getNotificationChannel(this.mContext.getOpPackageName(), this.mContext.getUserId(), this.mContext.getPackageName(), channelId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public NotificationChannel getNotificationChannel(@NonNull String channelId, @NonNull String conversationId) {
        if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.nmBinderPerfCacheChannels()) {
            return NotificationManager.getConversationChannelFromList(channelId, conversationId, this.mNotificationChannelListCache.query(new NotificationChannelQuery(this.mContext.getOpPackageName(), this.mContext.getPackageName(), this.mContext.getUserId())));
        }
        INotificationManager service = this.service();
        try {
            return service.getConversationNotificationChannel(this.mContext.getOpPackageName(), this.mContext.getUserId(), this.mContext.getPackageName(), channelId, true, conversationId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<NotificationChannel> getNotificationChannels() {
        if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.nmBinderPerfCacheChannels()) {
            List<NotificationChannel> channelList = this.mNotificationChannelListCache.query(new NotificationChannelQuery(this.mContext.getOpPackageName(), this.mContext.getPackageName(), this.mContext.getUserId()));
            ArrayList<NotificationChannel> out = new ArrayList<NotificationChannel>();
            if (channelList != null) {
                for (NotificationChannel c : channelList) {
                    out.add(c.copy());
                }
            }
            return out;
        }
        INotificationManager service = this.service();
        try {
            return service.getNotificationChannels(this.mContext.getOpPackageName(), this.mContext.getPackageName(), this.mContext.getUserId()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static NotificationChannel getChannelFromList(String channelId, List<NotificationChannel> channels) {
        if (channels == null) {
            return null;
        }
        if (channelId == null) {
            channelId = "miscellaneous";
        }
        for (NotificationChannel channel : channels) {
            if (!channelId.equals(channel.getId())) continue;
            return channel.copy();
        }
        return null;
    }

    private static NotificationChannel getConversationChannelFromList(String channelId, String conversationId, List<NotificationChannel> channels) {
        if (channels == null) {
            return null;
        }
        if (channelId == null) {
            channelId = "miscellaneous";
        }
        if (conversationId == null) {
            return NotificationManager.getChannelFromList(channelId, channels);
        }
        NotificationChannel parent = null;
        for (NotificationChannel channel : channels) {
            if (conversationId.equals(channel.getConversationId()) && channelId.equals(channel.getParentChannelId())) {
                return channel.copy();
            }
            if (!channelId.equals(channel.getId())) continue;
            parent = channel;
        }
        return parent != null ? parent.copy() : null;
    }

    public void deleteNotificationChannel(String channelId) {
        if (Flags.notificationClassification() && NotificationChannel.SYSTEM_RESERVED_IDS.contains(channelId)) {
            return;
        }
        INotificationManager service = this.service();
        try {
            service.deleteNotificationChannel(this.mContext.getPackageName(), channelId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public NotificationChannelGroup getNotificationChannelGroup(String channelGroupId) {
        if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.nmBinderPerfCacheChannels()) {
            Map<String, NotificationChannelGroup> groupHeaders;
            String pkgName = this.mContext.getPackageName();
            List<NotificationChannel> channelList = this.mNotificationChannelListCache.query(new NotificationChannelQuery(pkgName, pkgName, this.mContext.getUserId()));
            NotificationChannelGroup ncg = NotificationChannelGroupsHelper.getGroupWithChannels(channelGroupId, channelList, groupHeaders = this.mNotificationChannelGroupsCache.query(pkgName), false);
            return ncg != null ? ncg.clone() : null;
        }
        INotificationManager service = this.service();
        try {
            return service.getNotificationChannelGroup(this.mContext.getPackageName(), channelGroupId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<NotificationChannelGroup> getNotificationChannelGroups() {
        if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.nmBinderPerfCacheChannels()) {
            String pkgName = this.mContext.getPackageName();
            List<NotificationChannel> channelList = this.mNotificationChannelListCache.query(new NotificationChannelQuery(pkgName, pkgName, this.mContext.getUserId()));
            Map<String, NotificationChannelGroup> groupHeaders = this.mNotificationChannelGroupsCache.query(pkgName);
            List<NotificationChannelGroup> populatedGroupList = NotificationChannelGroupsHelper.getGroupsWithChannels(channelList, groupHeaders, NotificationChannelGroupsHelper.Params.forAllGroups());
            ArrayList<NotificationChannelGroup> out = new ArrayList<NotificationChannelGroup>();
            for (NotificationChannelGroup g : populatedGroupList) {
                out.add(g.clone());
            }
            return out;
        }
        INotificationManager service = this.service();
        try {
            ParceledListSlice parceledList = service.getNotificationChannelGroups(this.mContext.getPackageName());
            if (parceledList != null) {
                return parceledList.getList();
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return new ArrayList<NotificationChannelGroup>();
    }

    public void deleteNotificationChannelGroup(String groupId) {
        INotificationManager service = this.service();
        try {
            service.deleteNotificationChannelGroup(this.mContext.getPackageName(), groupId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void updateNotificationChannel(@NonNull String pkg, int uid, @NonNull NotificationChannel channel) {
        INotificationManager service = this.service();
        try {
            service.updateNotificationChannelForPackage(pkg, uid, channel);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void invalidateNotificationChannelCache() {
        if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.nmBinderPerfCacheChannels()) {
            IpcDataCache.invalidateCache("system_server", NOTIFICATION_CHANNELS_CACHE_API);
        } else {
            Log.wtf(TAG, "invalidateNotificationChannelCache called without flag");
        }
    }

    public static void invalidateNotificationChannelGroupCache() {
        if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.nmBinderPerfCacheChannels()) {
            IpcDataCache.invalidateCache("system_server", NOTIFICATION_CHANNEL_GROUPS_CACHE_API);
        } else {
            Log.wtf(TAG, "invalidateNotificationChannelGroupCache called without flag");
        }
    }

    @VisibleForTesting
    public void setChannelCachesToTestMode() {
        this.mNotificationChannelListCache.testPropertyName();
        this.mNotificationChannelGroupsCache.testPropertyName();
    }

    public ComponentName getEffectsSuppressor() {
        INotificationManager service = this.service();
        try {
            return service.getEffectsSuppressor();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean matchesCallFilter(Bundle extras) {
        INotificationManager service = this.service();
        try {
            return service.matchesCallFilter(extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void cleanUpCallersAfter(long timeThreshold) {
        INotificationManager service = this.service();
        try {
            service.cleanUpCallersAfter(timeThreshold);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isSystemConditionProviderEnabled(String path) {
        INotificationManager service = this.service();
        try {
            return service.isSystemConditionProviderEnabled(path);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void setZenMode(int mode, Uri conditionId, String reason) {
        this.setZenMode(mode, conditionId, reason, false);
    }

    public void setZenMode(int mode, Uri conditionId, String reason, boolean fromUser) {
        INotificationManager service = this.service();
        try {
            service.setZenMode(mode, conditionId, reason, fromUser);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getZenMode() {
        INotificationManager service = this.service();
        try {
            return service.getZenMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public ZenModeConfig getZenModeConfig() {
        INotificationManager service = this.service();
        try {
            return service.getZenModeConfig();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public Policy getConsolidatedNotificationPolicy() {
        INotificationManager service = this.service();
        try {
            return service.getConsolidatedNotificationPolicy();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getRuleInstanceCount(ComponentName owner) {
        INotificationManager service = this.service();
        try {
            return service.getRuleInstanceCount(owner);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean areAutomaticZenRulesUserManaged() {
        PackageManager pm = this.mContext.getPackageManager();
        return !pm.hasSystemFeature("android.hardware.type.watch") && !pm.hasSystemFeature("android.hardware.type.automotive") && !pm.hasSystemFeature("android.software.leanback");
    }

    public Map<String, AutomaticZenRule> getAutomaticZenRules() {
        INotificationManager service = this.service();
        try {
            HashMap<String, AutomaticZenRule> result = new HashMap<String, AutomaticZenRule>();
            ParceledListSlice parceledRules = service.getAutomaticZenRules();
            if (parceledRules != null) {
                for (AutomaticZenRule.AzrWithId rule : parceledRules.getList()) {
                    result.put(rule.mId, rule.mRule);
                }
            }
            return result;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public AutomaticZenRule getAutomaticZenRule(String id2) {
        INotificationManager service = this.service();
        try {
            return service.getAutomaticZenRule(id2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String addAutomaticZenRule(AutomaticZenRule automaticZenRule) {
        return this.addAutomaticZenRule(automaticZenRule, false);
    }

    @NonNull
    public String addAutomaticZenRule(@NonNull AutomaticZenRule automaticZenRule, boolean fromUser) {
        INotificationManager service = this.service();
        try {
            return service.addAutomaticZenRule(automaticZenRule, this.mContext.getPackageName(), fromUser);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean updateAutomaticZenRule(String id2, AutomaticZenRule automaticZenRule) {
        return this.updateAutomaticZenRule(id2, automaticZenRule, false);
    }

    public boolean updateAutomaticZenRule(@NonNull String id2, @NonNull AutomaticZenRule automaticZenRule, boolean fromUser) {
        INotificationManager service = this.service();
        try {
            return service.updateAutomaticZenRule(id2, automaticZenRule, fromUser);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getAutomaticZenRuleState(@NonNull String id2) {
        INotificationManager service = this.service();
        try {
            return service.getAutomaticZenRuleState(id2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setAutomaticZenRuleState(@NonNull String id2, @NonNull Condition condition) {
        INotificationManager service = this.service();
        try {
            service.setAutomaticZenRuleState(id2, condition);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean removeAutomaticZenRule(String id2) {
        return this.removeAutomaticZenRule(id2, false);
    }

    public boolean removeAutomaticZenRule(@NonNull String id2, boolean fromUser) {
        INotificationManager service = this.service();
        try {
            return service.removeAutomaticZenRule(id2, fromUser);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean removeAutomaticZenRules(String packageName) {
        return this.removeAutomaticZenRules(packageName, false);
    }

    public boolean removeAutomaticZenRules(String packageName, boolean fromUser) {
        INotificationManager service = this.service();
        try {
            return service.removeAutomaticZenRules(packageName, fromUser);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getImportance() {
        INotificationManager service = this.service();
        try {
            return service.getPackageImportance(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean areNotificationsEnabled() {
        if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.nmBinderPerfPermissionCheck()) {
            return this.mContext.checkSelfPermission("android.permission.POST_NOTIFICATIONS") == 0;
        }
        INotificationManager service = this.service();
        try {
            return service.areNotificationsEnabled(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean areBubblesAllowed() {
        INotificationManager service = this.service();
        try {
            return service.areBubblesAllowed(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean areBubblesEnabled() {
        INotificationManager service = this.service();
        try {
            return service.areBubblesEnabled(this.mContext.getUser());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getBubblePreference() {
        INotificationManager service = this.service();
        try {
            return service.getBubblePreferenceForPackage(this.mContext.getPackageName(), Binder.getCallingUid());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void silenceNotificationSound() {
        INotificationManager service = this.service();
        try {
            service.silenceNotificationSound();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean areNotificationsPaused() {
        INotificationManager service = this.service();
        try {
            return service.isPackagePaused(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isNotificationPolicyAccessGranted() {
        INotificationManager service = this.service();
        try {
            return service.isNotificationPolicyAccessGranted(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isNotificationListenerAccessGranted(ComponentName listener) {
        INotificationManager service = this.service();
        try {
            return service.isNotificationListenerAccessGranted(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public boolean isNotificationAssistantAccessGranted(@NonNull ComponentName assistant) {
        INotificationManager service = this.service();
        try {
            return service.isNotificationAssistantAccessGranted(assistant);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean shouldHideSilentStatusBarIcons() {
        INotificationManager service = this.service();
        try {
            return service.shouldHideSilentStatusIcons(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    public List<String> getAllowedAssistantAdjustments() {
        INotificationManager service = this.service();
        try {
            return service.getAllowedAssistantAdjustments(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.service.notification.notification_classification")
    public void allowAssistantAdjustment(@NonNull String capability) {
        INotificationManager service = this.service();
        try {
            service.allowAssistantAdjustment(this.mContext.getUserId(), capability);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.service.notification.notification_classification")
    public void disallowAssistantAdjustment(@NonNull String capability) {
        INotificationManager service = this.service();
        try {
            service.disallowAssistantAdjustment(this.mContext.getUserId(), capability);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isNotificationPolicyAccessGrantedForPackage(@NonNull String pkg) {
        INotificationManager service = this.service();
        try {
            return service.isNotificationPolicyAccessGrantedForPackage(pkg);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.service.notification.notification_classification")
    public void setAssistantAdjustmentKeyTypeState(int type, boolean enabled) {
        this.setAssistantClassificationTypeState(type, enabled);
    }

    @FlaggedApi(value="android.service.notification.notification_classification")
    public void setAssistantClassificationTypeState(int type, boolean enabled) {
        INotificationManager service = this.service();
        try {
            service.setAssistantClassificationTypeState(type, enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<String> getEnabledNotificationListenerPackages() {
        INotificationManager service = this.service();
        try {
            return service.getEnabledNotificationListenerPackages();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Policy getNotificationPolicy() {
        INotificationManager service = this.service();
        try {
            return service.getNotificationPolicy(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setNotificationPolicy(@NonNull Policy policy) {
        this.setNotificationPolicy(policy, false);
    }

    public void setNotificationPolicy(@NonNull Policy policy, boolean fromUser) {
        NotificationManager.checkRequired("policy", policy);
        INotificationManager service = this.service();
        try {
            service.setNotificationPolicy(this.mContext.getOpPackageName(), policy, fromUser);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setNotificationPolicyAccessGranted(String pkg, boolean granted) {
        INotificationManager service = this.service();
        try {
            service.setNotificationPolicyAccessGranted(pkg, granted);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setNotificationListenerAccessGranted(@NonNull ComponentName listener, boolean granted) {
        this.setNotificationListenerAccessGranted(listener, granted, true);
    }

    @NonNull
    public ZenPolicy getDefaultZenPolicy() {
        INotificationManager service = this.service();
        try {
            return service.getDefaultZenPolicy();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setManualZenRuleDeviceEffects(@NonNull ZenDeviceEffects effects) {
        INotificationManager service = this.service();
        try {
            service.setManualZenRuleDeviceEffects(effects);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_NOTIFICATION_LISTENERS")
    public void setNotificationListenerAccessGranted(@NonNull ComponentName listener, boolean granted, boolean userSet) {
        INotificationManager service = this.service();
        try {
            if (CompatChanges.isChangeEnabled(302563478L)) {
                service.setNotificationListenerAccessGrantedForUser(listener, this.mContext.getUserId(), granted, userSet);
            } else {
                service.setNotificationListenerAccessGranted(listener, granted, userSet);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setNotificationListenerAccessGrantedForUser(ComponentName listener, int userId, boolean granted) {
        INotificationManager service = this.service();
        try {
            service.setNotificationListenerAccessGrantedForUser(listener, userId, granted, true);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void setNotificationAssistantAccessGranted(@Nullable ComponentName assistant, boolean granted) {
        INotificationManager service = this.service();
        try {
            service.setNotificationAssistantAccessGranted(assistant, granted);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_NOTIFICATION_LISTENERS")
    @NonNull
    public List<ComponentName> getEnabledNotificationListeners() {
        return this.getEnabledNotificationListeners(this.mContext.getUserId());
    }

    public List<ComponentName> getEnabledNotificationListeners(int userId) {
        INotificationManager service = this.service();
        try {
            return service.getEnabledNotificationListeners(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Nullable
    public ComponentName getAllowedNotificationAssistant() {
        INotificationManager service = this.service();
        try {
            return service.getAllowedNotificationAssistant();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @SuppressLint(value={"UserHandle"})
    public boolean hasEnabledNotificationListener(@NonNull String packageName, @NonNull UserHandle userHandle) {
        INotificationManager service = this.service();
        try {
            return service.hasEnabledNotificationListener(packageName, userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static void checkRequired(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " is required");
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_TOAST_RATE_LIMITING")
    public void setToastRateLimitingEnabled(boolean enable) {
        INotificationManager service = this.service();
        try {
            service.setToastRateLimitingEnabled(enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public StatusBarNotification[] getActiveNotifications() {
        INotificationManager service = this.service();
        String pkg = this.mContext.getPackageName();
        try {
            ParceledListSlice parceledList = service.getAppActiveNotifications(pkg, this.mContext.getUserId());
            if (parceledList != null) {
                List list = parceledList.getList();
                return list.toArray(new StatusBarNotification[list.size()]);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return new StatusBarNotification[0];
    }

    public int getCurrentInterruptionFilter() {
        INotificationManager service = this.service();
        try {
            return NotificationManager.zenModeToInterruptionFilter(service.getZenMode());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setInterruptionFilter(int interruptionFilter) {
        this.setInterruptionFilter(interruptionFilter, false);
    }

    public void setInterruptionFilter(int interruptionFilter, boolean fromUser) {
        INotificationManager service = this.service();
        try {
            service.setInterruptionFilter(this.mContext.getOpPackageName(), interruptionFilter, fromUser);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean matchesCallFilter(@NonNull Uri uri) {
        Bundle extras = new Bundle();
        ArrayList<Person> pList = new ArrayList<Person>();
        pList.add(new Person.Builder().setUri(uri.toString()).build());
        extras.putParcelableArrayList("android.people.list", pList);
        return this.matchesCallFilter(extras);
    }

    public static int zenModeToInterruptionFilter(int zen) {
        switch (zen) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    public static int zenModeFromInterruptionFilter(int interruptionFilter, int defValue) {
        switch (interruptionFilter) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.ACCESS_NOTIFICATIONS"})
    @FlaggedApi(value="android.service.notification.callstyle_callback_api")
    @SuppressLint(value={"UserHandle"})
    public void registerCallNotificationEventListener(@NonNull String packageName, @NonNull UserHandle userHandle, @NonNull Executor executor, @NonNull CallNotificationEventListener listener) {
        NotificationManager.checkRequired("packageName", packageName);
        NotificationManager.checkRequired("userHandle", userHandle);
        NotificationManager.checkRequired("executor", executor);
        NotificationManager.checkRequired("listener", listener);
        INotificationManager service = this.service();
        try {
            Map<CallNotificationEventListener, CallNotificationEventCallbackStub> map = this.mCallNotificationEventCallbacks;
            synchronized (map) {
                CallNotificationEventCallbackStub callbackStub = new CallNotificationEventCallbackStub(packageName, userHandle, executor, listener);
                this.mCallNotificationEventCallbacks.put(listener, callbackStub);
                service.registerCallNotificationEventListener(packageName, userHandle, callbackStub);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @FlaggedApi(value="android.service.notification.callstyle_callback_api")
    @RequiresPermission(allOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.ACCESS_NOTIFICATIONS"})
    public void unregisterCallNotificationEventListener(@NonNull CallNotificationEventListener listener) {
        NotificationManager.checkRequired("listener", listener);
        INotificationManager service = this.service();
        try {
            Map<CallNotificationEventListener, CallNotificationEventCallbackStub> map = this.mCallNotificationEventCallbacks;
            synchronized (map) {
                CallNotificationEventCallbackStub callbackStub = this.mCallNotificationEventCallbacks.remove(listener);
                if (callbackStub != null) {
                    service.unregisterCallNotificationEventListener(callbackStub.mPackageName, callbackStub.mUserHandle, callbackStub);
                }
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.service.notification.notification_classification")
    @NonNull
    public Set<String> getUnsupportedAdjustmentTypes() {
        INotificationManager service = this.service();
        try {
            return new HashSet<String>(service.getUnsupportedAdjustmentTypes());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private class RateLimiter {
        private static final Duration RATE_LIMITER_LOG_INTERVAL = Duration.ofSeconds(1L);
        private final RateEstimator mInputRateEstimator = new RateEstimator();
        private final RateEstimator mOutputRateEstimator = new RateEstimator();
        private final String mName;
        private final String mCounterName;
        private final float mLimitRate;
        private Instant mLogSilencedUntil;

        private RateLimiter(String name, String counterName, float limitRate) {
            this.mName = name;
            this.mCounterName = counterName;
            this.mLimitRate = limitRate;
        }

        boolean eventExceedsRate() {
            long nowMillis = NotificationManager.this.mClock.millis();
            this.mInputRateEstimator.update(nowMillis);
            return this.mOutputRateEstimator.getRate(nowMillis) > this.mLimitRate;
        }

        void recordAccepted() {
            this.mOutputRateEstimator.update(NotificationManager.this.mClock.millis());
        }

        void recordRejected(NotificationKey key) {
            Instant now = NotificationManager.this.mClock.instant();
            if (this.mLogSilencedUntil != null && now.isBefore(this.mLogSilencedUntil)) {
                return;
            }
            if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.nmBinderPerfLogNmThrottling()) {
                try {
                    NotificationManager.this.service().incrementCounter(this.mCounterName);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Ignoring error while trying to log " + this.mCounterName, e);
                }
            }
            long nowMillis = now.toEpochMilli();
            Slog.w(TAG, TextUtils.formatSimple("Shedding %s of %s, rate limit (%s) exceeded: input %s, output would be %s", this.mName, key, Float.valueOf(this.mLimitRate), Float.valueOf(this.mInputRateEstimator.getRate(nowMillis)), Float.valueOf(this.mOutputRateEstimator.getRate(nowMillis))));
            this.mLogSilencedUntil = now.plus(RATE_LIMITER_LOG_INTERVAL);
        }
    }

    private static class NotificationKey
    extends Record {
        @NonNull
        private final UserHandle user;
        @NonNull
        private final String pkg;
        @Nullable
        private final String tag;
        private final int id;

        private NotificationKey(@NonNull UserHandle user, @NonNull String pkg, @Nullable String tag, int id2) {
            this.user = user;
            this.pkg = pkg;
            this.tag = tag;
            this.id = id2;
        }

        @Override
        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NotificationKey.class, "user;pkg;tag;id", "user", "pkg", "tag", "id"}, this);
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NotificationKey.class, "user;pkg;tag;id", "user", "pkg", "tag", "id"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NotificationKey.class, "user;pkg;tag;id", "user", "pkg", "tag", "id"}, this, o);
        }

        @NonNull
        public UserHandle user() {
            return this.user;
        }

        @NonNull
        public String pkg() {
            return this.pkg;
        }

        @Nullable
        public String tag() {
            return this.tag;
        }

        public int id() {
            return this.id;
        }
    }

    private static class NotificationChannelQuery
    extends Record {
        private final String callingPkg;
        private final String targetPkg;
        private final int userId;

        private NotificationChannelQuery(String callingPkg, String targetPkg, int userId) {
            this.callingPkg = callingPkg;
            this.targetPkg = targetPkg;
            this.userId = userId;
        }

        @Override
        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NotificationChannelQuery.class, "callingPkg;targetPkg;userId", "callingPkg", "targetPkg", "userId"}, this);
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NotificationChannelQuery.class, "callingPkg;targetPkg;userId", "callingPkg", "targetPkg", "userId"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NotificationChannelQuery.class, "callingPkg;targetPkg;userId", "callingPkg", "targetPkg", "userId"}, this, o);
        }

        public String callingPkg() {
            return this.callingPkg;
        }

        public String targetPkg() {
            return this.targetPkg;
        }

        public int userId() {
            return this.userId;
        }
    }

    public static class Policy
    implements Parcelable {
        public static final int PRIORITY_CATEGORY_REMINDERS = 1;
        public static final int PRIORITY_CATEGORY_EVENTS = 2;
        public static final int PRIORITY_CATEGORY_MESSAGES = 4;
        public static final int PRIORITY_CATEGORY_CALLS = 8;
        public static final int PRIORITY_CATEGORY_REPEAT_CALLERS = 16;
        public static final int PRIORITY_CATEGORY_ALARMS = 32;
        public static final int PRIORITY_CATEGORY_MEDIA = 64;
        public static final int PRIORITY_CATEGORY_SYSTEM = 128;
        public static final int PRIORITY_CATEGORY_CONVERSATIONS = 256;
        public static final int[] ALL_PRIORITY_CATEGORIES = new int[]{32, 64, 128, 1, 2, 4, 8, 16, 256};
        public static final int PRIORITY_SENDERS_ANY = 0;
        public static final int PRIORITY_SENDERS_CONTACTS = 1;
        public static final int PRIORITY_SENDERS_STARRED = 2;
        public static final int CONVERSATION_SENDERS_ANYONE = 1;
        public static final int CONVERSATION_SENDERS_IMPORTANT = 2;
        public static final int CONVERSATION_SENDERS_NONE = 3;
        public final int priorityCategories;
        public final int priorityCallSenders;
        public final int priorityMessageSenders;
        public final int priorityConversationSenders;
        public static final int CONVERSATION_SENDERS_UNSET = -1;
        public static final int SUPPRESSED_EFFECTS_UNSET = -1;
        @Deprecated
        public static final int SUPPRESSED_EFFECT_SCREEN_OFF = 1;
        @Deprecated
        public static final int SUPPRESSED_EFFECT_SCREEN_ON = 2;
        public static final int SUPPRESSED_EFFECT_FULL_SCREEN_INTENT = 4;
        public static final int SUPPRESSED_EFFECT_LIGHTS = 8;
        public static final int SUPPRESSED_EFFECT_PEEK = 16;
        public static final int SUPPRESSED_EFFECT_STATUS_BAR = 32;
        public static final int SUPPRESSED_EFFECT_BADGE = 64;
        public static final int SUPPRESSED_EFFECT_AMBIENT = 128;
        public static final int SUPPRESSED_EFFECT_NOTIFICATION_LIST = 256;
        private static final int[] ALL_SUPPRESSED_EFFECTS = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256};
        public final int suppressedVisualEffects;
        public static final int STATE_HAS_PRIORITY_CHANNELS = 1;
        public static final int STATE_PRIORITY_CHANNELS_BLOCKED = 2;
        public static final int STATE_UNSET = -1;
        public final int state;
        @NonNull
        public static final Parcelable.Creator<Policy> CREATOR = new Parcelable.Creator<Policy>(){

            @Override
            public Policy createFromParcel(Parcel in) {
                return new Policy(in);
            }

            public Policy[] newArray(int size) {
                return new Policy[size];
            }
        };

        public Policy(int priorityCategories, int priorityCallSenders, int priorityMessageSenders) {
            this(priorityCategories, priorityCallSenders, priorityMessageSenders, -1, -1, -1);
        }

        public Policy(int priorityCategories, int priorityCallSenders, int priorityMessageSenders, int suppressedVisualEffects) {
            this(priorityCategories, priorityCallSenders, priorityMessageSenders, suppressedVisualEffects, -1, -1);
        }

        public Policy(int priorityCategories, int priorityCallSenders, int priorityMessageSenders, int suppressedVisualEffects, int priorityConversationSenders) {
            this(priorityCategories, priorityCallSenders, priorityMessageSenders, suppressedVisualEffects, -1, priorityConversationSenders);
        }

        public Policy(int priorityCategories, int priorityCallSenders, int priorityMessageSenders, int suppressedVisualEffects, int state, int priorityConversationSenders) {
            this.priorityCategories = priorityCategories;
            this.priorityCallSenders = priorityCallSenders;
            this.priorityMessageSenders = priorityMessageSenders;
            this.suppressedVisualEffects = suppressedVisualEffects;
            this.state = state;
            this.priorityConversationSenders = priorityConversationSenders;
        }

        public Policy(Parcel source) {
            this(source.readInt(), source.readInt(), source.readInt(), source.readInt(), source.readInt(), source.readInt());
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.priorityCategories);
            dest.writeInt(this.priorityCallSenders);
            dest.writeInt(this.priorityMessageSenders);
            dest.writeInt(this.suppressedVisualEffects);
            dest.writeInt(this.state);
            dest.writeInt(this.priorityConversationSenders);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public int hashCode() {
            return Objects.hash(this.priorityCategories, this.priorityCallSenders, this.priorityMessageSenders, this.suppressedVisualEffects, this.state, this.priorityConversationSenders);
        }

        public boolean equals(@Nullable Object o) {
            if (!(o instanceof Policy)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Policy other = (Policy)o;
            return other.priorityCategories == this.priorityCategories && other.priorityCallSenders == this.priorityCallSenders && other.priorityMessageSenders == this.priorityMessageSenders && this.suppressedVisualEffectsEqual(this.suppressedVisualEffects, other.suppressedVisualEffects) && other.state == this.state && other.priorityConversationSenders == this.priorityConversationSenders;
        }

        private boolean suppressedVisualEffectsEqual(int suppressedEffects, int otherSuppressedVisualEffects) {
            int otherWithoutOldEffects;
            int thisWithoutOldEffects;
            int currSuppressedEffects;
            if (suppressedEffects == otherSuppressedVisualEffects) {
                return true;
            }
            if ((suppressedEffects & 2) != 0) {
                suppressedEffects |= 0x10;
            }
            if ((suppressedEffects & 1) != 0) {
                suppressedEffects |= 4;
                suppressedEffects |= 8;
                suppressedEffects |= 0x80;
            }
            if ((otherSuppressedVisualEffects & 2) != 0) {
                otherSuppressedVisualEffects |= 0x10;
            }
            if ((otherSuppressedVisualEffects & 1) != 0) {
                otherSuppressedVisualEffects |= 4;
                otherSuppressedVisualEffects |= 8;
                otherSuppressedVisualEffects |= 0x80;
            }
            if ((suppressedEffects & 2) != (otherSuppressedVisualEffects & 2)) {
                int n = currSuppressedEffects = (suppressedEffects & 2) != 0 ? otherSuppressedVisualEffects : suppressedEffects;
                if ((currSuppressedEffects & 0x10) == 0) {
                    return false;
                }
            }
            if ((suppressedEffects & 1) != (otherSuppressedVisualEffects & 1)) {
                int n = currSuppressedEffects = (suppressedEffects & 1) != 0 ? otherSuppressedVisualEffects : suppressedEffects;
                if ((currSuppressedEffects & 4) == 0 || (currSuppressedEffects & 8) == 0 || (currSuppressedEffects & 0x80) == 0) {
                    return false;
                }
            }
            return (thisWithoutOldEffects = suppressedEffects & 0xFFFFFFFD & 0xFFFFFFFE) == (otherWithoutOldEffects = otherSuppressedVisualEffects & 0xFFFFFFFD & 0xFFFFFFFE);
        }

        public String toString() {
            return "NotificationManager.Policy[" + "priorityCategories=" + Policy.priorityCategoriesToString(this.priorityCategories) + ",priorityCallSenders=" + Policy.prioritySendersToString(this.priorityCallSenders) + ",priorityMessageSenders=" + Policy.prioritySendersToString(this.priorityMessageSenders) + ",priorityConvSenders=" + Policy.conversationSendersToString(this.priorityConversationSenders) + ",suppressedVisualEffects=" + Policy.suppressedEffectsToString(this.suppressedVisualEffects) + ",hasPriorityChannels=" + (this.state == -1 ? "unset" : ((this.state & 1) != 0 ? "true" : "false")) + ",allowPriorityChannels=" + (this.state == -1 ? "unset" : (this.allowPriorityChannels() ? "true" : "false")) + "]";
        }

        public void dumpDebug(ProtoOutputStream proto, long fieldId) {
            long pToken = proto.start(fieldId);
            Policy.bitwiseToProtoEnum(proto, 2259152797697L, this.priorityCategories);
            proto.write(1159641169922L, this.priorityCallSenders);
            proto.write(1159641169923L, this.priorityMessageSenders);
            Policy.bitwiseToProtoEnum(proto, 2259152797700L, this.suppressedVisualEffects);
            proto.end(pToken);
        }

        private static void bitwiseToProtoEnum(ProtoOutputStream proto, long fieldId, int data) {
            int i = 1;
            while (data > 0) {
                if ((data & 1) == 1) {
                    proto.write(fieldId, i);
                }
                ++i;
                data >>>= 1;
            }
        }

        public static int getAllSuppressedVisualEffects() {
            int effects = 0;
            for (int i = 0; i < ALL_SUPPRESSED_EFFECTS.length; ++i) {
                effects |= ALL_SUPPRESSED_EFFECTS[i];
            }
            return effects;
        }

        public static boolean areAllVisualEffectsSuppressed(int effects) {
            for (int i = 0; i < ALL_SUPPRESSED_EFFECTS.length; ++i) {
                int effect = ALL_SUPPRESSED_EFFECTS[i];
                if ((effects & effect) != 0) continue;
                return false;
            }
            return true;
        }

        private static int toggleEffects(int currentEffects, int[] effects, boolean suppress) {
            for (int i = 0; i < effects.length; ++i) {
                int effect = effects[i];
                if (suppress) {
                    currentEffects |= effect;
                    continue;
                }
                currentEffects &= ~effect;
            }
            return currentEffects;
        }

        public static String suppressedEffectsToString(int effects) {
            if (effects <= 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ALL_SUPPRESSED_EFFECTS.length; ++i) {
                int effect = ALL_SUPPRESSED_EFFECTS[i];
                if ((effects & effect) != 0) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(Policy.effectToString(effect));
                }
                effects &= ~effect;
            }
            if (effects != 0) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("UNKNOWN_").append(effects);
            }
            return sb.toString();
        }

        public static String priorityCategoriesToString(int priorityCategories) {
            if (priorityCategories == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ALL_PRIORITY_CATEGORIES.length; ++i) {
                int priorityCategory = ALL_PRIORITY_CATEGORIES[i];
                if ((priorityCategories & priorityCategory) != 0) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(Policy.priorityCategoryToString(priorityCategory));
                }
                priorityCategories &= ~priorityCategory;
            }
            if (priorityCategories != 0) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("PRIORITY_CATEGORY_UNKNOWN_").append(priorityCategories);
            }
            return sb.toString();
        }

        private static String effectToString(int effect) {
            switch (effect) {
                case 4: {
                    return "SUPPRESSED_EFFECT_FULL_SCREEN_INTENT";
                }
                case 8: {
                    return "SUPPRESSED_EFFECT_LIGHTS";
                }
                case 16: {
                    return "SUPPRESSED_EFFECT_PEEK";
                }
                case 32: {
                    return "SUPPRESSED_EFFECT_STATUS_BAR";
                }
                case 64: {
                    return "SUPPRESSED_EFFECT_BADGE";
                }
                case 128: {
                    return "SUPPRESSED_EFFECT_AMBIENT";
                }
                case 256: {
                    return "SUPPRESSED_EFFECT_NOTIFICATION_LIST";
                }
                case 1: {
                    return "SUPPRESSED_EFFECT_SCREEN_OFF";
                }
                case 2: {
                    return "SUPPRESSED_EFFECT_SCREEN_ON";
                }
                case -1: {
                    return "SUPPRESSED_EFFECTS_UNSET";
                }
            }
            return "UNKNOWN_" + effect;
        }

        private static String priorityCategoryToString(int priorityCategory) {
            switch (priorityCategory) {
                case 1: {
                    return "PRIORITY_CATEGORY_REMINDERS";
                }
                case 2: {
                    return "PRIORITY_CATEGORY_EVENTS";
                }
                case 4: {
                    return "PRIORITY_CATEGORY_MESSAGES";
                }
                case 8: {
                    return "PRIORITY_CATEGORY_CALLS";
                }
                case 16: {
                    return "PRIORITY_CATEGORY_REPEAT_CALLERS";
                }
                case 32: {
                    return "PRIORITY_CATEGORY_ALARMS";
                }
                case 64: {
                    return "PRIORITY_CATEGORY_MEDIA";
                }
                case 128: {
                    return "PRIORITY_CATEGORY_SYSTEM";
                }
                case 256: {
                    return "PRIORITY_CATEGORY_CONVERSATIONS";
                }
            }
            return "PRIORITY_CATEGORY_UNKNOWN_" + priorityCategory;
        }

        public static String prioritySendersToString(int prioritySenders) {
            switch (prioritySenders) {
                case 0: {
                    return "PRIORITY_SENDERS_ANY";
                }
                case 1: {
                    return "PRIORITY_SENDERS_CONTACTS";
                }
                case 2: {
                    return "PRIORITY_SENDERS_STARRED";
                }
            }
            return "PRIORITY_SENDERS_UNKNOWN_" + prioritySenders;
        }

        @NonNull
        public static String conversationSendersToString(int priorityConversationSenders) {
            switch (priorityConversationSenders) {
                case 1: {
                    return "anyone";
                }
                case 2: {
                    return "important";
                }
                case 3: {
                    return "none";
                }
                case -1: {
                    return "unset";
                }
            }
            return "invalidConversationType{" + priorityConversationSenders + "}";
        }

        public boolean allowAlarms() {
            return (this.priorityCategories & 0x20) != 0;
        }

        public boolean allowMedia() {
            return (this.priorityCategories & 0x40) != 0;
        }

        public boolean allowSystem() {
            return (this.priorityCategories & 0x80) != 0;
        }

        public boolean allowRepeatCallers() {
            return (this.priorityCategories & 0x10) != 0;
        }

        public boolean allowCalls() {
            return (this.priorityCategories & 8) != 0;
        }

        public boolean allowConversations() {
            return (this.priorityCategories & 0x100) != 0;
        }

        public boolean allowMessages() {
            return (this.priorityCategories & 4) != 0;
        }

        public boolean allowEvents() {
            return (this.priorityCategories & 2) != 0;
        }

        public boolean allowReminders() {
            return (this.priorityCategories & 1) != 0;
        }

        public int allowCallsFrom() {
            return this.priorityCallSenders;
        }

        public int allowMessagesFrom() {
            return this.priorityMessageSenders;
        }

        public int allowConversationsFrom() {
            return this.priorityConversationSenders;
        }

        public boolean showFullScreenIntents() {
            return (this.suppressedVisualEffects & 4) == 0;
        }

        public boolean showLights() {
            return (this.suppressedVisualEffects & 8) == 0;
        }

        public boolean showPeeking() {
            return (this.suppressedVisualEffects & 0x10) == 0;
        }

        public boolean showStatusBarIcons() {
            return (this.suppressedVisualEffects & 0x20) == 0;
        }

        public boolean showAmbient() {
            return (this.suppressedVisualEffects & 0x80) == 0;
        }

        public boolean showBadges() {
            return (this.suppressedVisualEffects & 0x40) == 0;
        }

        public boolean showInNotificationList() {
            return (this.suppressedVisualEffects & 0x100) == 0;
        }

        public boolean allowPriorityChannels() {
            if (this.state == -1) {
                return true;
            }
            return (this.state & 2) == 0;
        }

        public boolean hasPriorityChannels() {
            return (this.state & 1) != 0;
        }

        public static int policyState(boolean hasPriorityChannels, boolean allowPriorityChannels) {
            int state = 0;
            if (hasPriorityChannels) {
                state |= 1;
            }
            if (!allowPriorityChannels) {
                state |= 2;
            }
            return state;
        }

        public Policy copy() {
            Parcel parcel = Parcel.obtain();
            try {
                this.writeToParcel(parcel, 0);
                parcel.setDataPosition(0);
                Policy policy = new Policy(parcel);
                return policy;
            }
            finally {
                parcel.recycle();
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ConversationSenders {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface PrioritySenders {
        }
    }

    private static class CallNotificationEventCallbackStub
    extends ICallNotificationEventCallback.Stub {
        final String mPackageName;
        final UserHandle mUserHandle;
        final Executor mExecutor;
        final CallNotificationEventListener mListener;

        CallNotificationEventCallbackStub(@NonNull String packageName, @NonNull UserHandle userHandle, @NonNull Executor executor, @NonNull CallNotificationEventListener listener) {
            this.mPackageName = packageName;
            this.mUserHandle = userHandle;
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        @FlaggedApi(value="android.service.notification.callstyle_callback_api")
        public void onCallNotificationPosted(String packageName, UserHandle userHandle) {
            this.mExecutor.execute(() -> this.mListener.onCallNotificationPosted(packageName, userHandle));
        }

        @Override
        @FlaggedApi(value="android.service.notification.callstyle_callback_api")
        public void onCallNotificationRemoved(String packageName, UserHandle userHandle) {
            this.mExecutor.execute(() -> this.mListener.onCallNotificationRemoved(packageName, userHandle));
        }
    }

    @SystemApi
    @FlaggedApi(value="android.service.notification.callstyle_callback_api")
    public static interface CallNotificationEventListener {
        @FlaggedApi(value="android.service.notification.callstyle_callback_api")
        public void onCallNotificationPosted(@NonNull String var1, @NonNull UserHandle var2);

        @FlaggedApi(value="android.service.notification.callstyle_callback_api")
        public void onCallNotificationRemoved(@NonNull String var1, @NonNull UserHandle var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BubblePreference {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Importance {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InterruptionFilter {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AutomaticZenRuleStatus {
    }
}

