/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.ILocaleManager;
import android.app.LocaleConfig;
import android.content.Context;
import android.content.res.Configuration;
import android.os.LocaleList;
import android.os.RemoteException;

public class LocaleManager {
    private static final String TAG = "LocaleManager";
    private Context mContext;
    private ILocaleManager mService;

    public LocaleManager(Context context, ILocaleManager service) {
        this.mContext = context;
        this.mService = service;
    }

    public void setApplicationLocales(@NonNull LocaleList locales) {
        this.setApplicationLocales(this.mContext.getPackageName(), locales, false);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CHANGE_CONFIGURATION")
    public void setApplicationLocales(@NonNull String appPackageName, @NonNull LocaleList locales) {
        this.setApplicationLocales(appPackageName, locales, true);
    }

    private void setApplicationLocales(@NonNull String appPackageName, @NonNull LocaleList locales, boolean fromDelegate) {
        try {
            this.mService.setApplicationLocales(appPackageName, this.mContext.getUserId(), locales, fromDelegate);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public LocaleList getApplicationLocales() {
        return this.getApplicationLocales(this.mContext.getPackageName());
    }

    @RequiresPermission(value="android.permission.READ_APP_SPECIFIC_LOCALES", conditional=true)
    @NonNull
    public LocaleList getApplicationLocales(@NonNull String appPackageName) {
        try {
            return this.mService.getApplicationLocales(appPackageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public LocaleList getSystemLocales() {
        try {
            return this.mService.getSystemLocales();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setSystemLocales(@NonNull LocaleList locales) {
        try {
            Configuration conf = new Configuration();
            conf.setLocales(locales);
            ActivityManager.getService().updatePersistentConfiguration(conf);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setOverrideLocaleConfig(@Nullable LocaleConfig localeConfig) {
        try {
            this.mService.setOverrideLocaleConfig(this.mContext.getPackageName(), this.mContext.getUserId(), localeConfig);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public LocaleConfig getOverrideLocaleConfig() {
        try {
            return this.mService.getOverrideLocaleConfig(this.mContext.getPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

