/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.app.ActivityClient;
import android.app.ActivityManager;
import android.app.IActivityManager;
import android.app.INotificationManager;
import android.app.RemoteLockscreenValidationResult;
import android.app.RemoteLockscreenValidationSession;
import android.app.admin.PasswordMetrics;
import android.app.trust.ITrustManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.persistentdata.IPersistentDataBlockService;
import android.util.ArrayMap;
import android.util.Log;
import android.view.IOnKeyguardExitResult;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.app.Flags;
import com.android.internal.policy.IDeviceLockedStateListener;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.policy.IKeyguardLockedStateListener;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.widget.IWeakEscrowTokenActivatedListener;
import com.android.internal.widget.IWeakEscrowTokenRemovedListener;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.LockPatternView;
import com.android.internal.widget.LockscreenCredential;
import com.android.internal.widget.PasswordValidationError;
import com.android.internal.widget.VerifyCredentialResponse;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class KeyguardManager {
    private static final String TAG = "KeyguardManager";
    private final Context mContext;
    private final LockPatternUtils mLockPatternUtils;
    private final IWindowManager mWM;
    private final IActivityManager mAm;
    private final ITrustManager mTrustManager;
    private final INotificationManager mNotificationManager;
    private final ArrayMap<WeakEscrowTokenRemovedListener, IWeakEscrowTokenRemovedListener> mListeners = new ArrayMap();
    public static final String ACTION_CONFIRM_DEVICE_CREDENTIAL = "android.app.action.CONFIRM_DEVICE_CREDENTIAL";
    public static final String ACTION_CONFIRM_DEVICE_CREDENTIAL_WITH_USER = "android.app.action.CONFIRM_DEVICE_CREDENTIAL_WITH_USER";
    public static final String ACTION_CONFIRM_FRP_CREDENTIAL = "android.app.action.CONFIRM_FRP_CREDENTIAL";
    public static final String ACTION_CONFIRM_REMOTE_DEVICE_CREDENTIAL = "android.app.action.CONFIRM_REMOTE_DEVICE_CREDENTIAL";
    public static final String ACTION_PREPARE_REPAIR_MODE_DEVICE_CREDENTIAL = "android.app.action.PREPARE_REPAIR_MODE_DEVICE_CREDENTIAL";
    public static final String ACTION_CONFIRM_REPAIR_MODE_DEVICE_CREDENTIAL = "android.app.action.CONFIRM_REPAIR_MODE_DEVICE_CREDENTIAL";
    public static final String EXTRA_TITLE = "android.app.extra.TITLE";
    public static final String EXTRA_DESCRIPTION = "android.app.extra.DESCRIPTION";
    public static final String EXTRA_ALTERNATE_BUTTON_LABEL = "android.app.extra.ALTERNATE_BUTTON_LABEL";
    public static final String EXTRA_CHECKBOX_LABEL = "android.app.extra.CHECKBOX_LABEL";
    public static final String EXTRA_REMOTE_LOCKSCREEN_VALIDATION_SESSION = "android.app.extra.REMOTE_LOCKSCREEN_VALIDATION_SESSION";
    public static final String EXTRA_FORCE_TASK_OVERLAY = "android.app.KeyguardManager.FORCE_TASK_OVERLAY";
    public static final int RESULT_ALTERNATE = 1;
    public static final String EXTRA_DISALLOW_BIOMETRICS_IF_POLICY_EXISTS = "check_dpm";
    public static final String LOCK_ON_USER_SWITCH_CALLBACK = "onSwitchCallback";
    @SystemApi
    public static final int PASSWORD = 0;
    @SystemApi
    public static final int PIN = 1;
    @SystemApi
    public static final int PATTERN = 2;
    private final IKeyguardLockedStateListener mIKeyguardLockedStateListener = new IKeyguardLockedStateListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onKeyguardLockedStateChanged(boolean isKeyguardLocked) {
            ArrayMap<KeyguardLockedStateListener, Executor> arrayMap = KeyguardManager.this.mKeyguardLockedStateListeners;
            synchronized (arrayMap) {
                KeyguardManager.this.mKeyguardLockedStateListeners.forEach((listener, executor) -> executor.execute(() -> listener.onKeyguardLockedStateChanged(isKeyguardLocked)));
            }
        }
    };
    @GuardedBy(value={"itself"})
    private final ArrayMap<KeyguardLockedStateListener, Executor> mKeyguardLockedStateListeners = new ArrayMap();
    private final IDeviceLockedStateListener mIDeviceLockedStateListener = new IDeviceLockedStateListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeviceLockedStateChanged(boolean isDeviceLocked) {
            if (!Flags.deviceUnlockListener()) {
                return;
            }
            ArrayMap<DeviceLockedStateListener, Executor> arrayMap = KeyguardManager.this.mDeviceLockedStateListeners;
            synchronized (arrayMap) {
                KeyguardManager.this.mDeviceLockedStateListeners.forEach((listener, executor) -> executor.execute(() -> listener.onDeviceLockedStateChanged(isDeviceLocked)));
            }
        }
    };
    @GuardedBy(value={"itself"})
    private final ArrayMap<DeviceLockedStateListener, Executor> mDeviceLockedStateListeners = new ArrayMap();

    @Deprecated
    public Intent createConfirmDeviceCredentialIntent(CharSequence title, CharSequence description) {
        if (!this.isDeviceSecure()) {
            return null;
        }
        Intent intent = new Intent(ACTION_CONFIRM_DEVICE_CREDENTIAL);
        intent.putExtra(EXTRA_TITLE, title);
        intent.putExtra(EXTRA_DESCRIPTION, description);
        intent.setPackage(this.getSettingsPackageForIntent(intent));
        return intent;
    }

    public Intent createConfirmDeviceCredentialIntent(CharSequence title, CharSequence description, int userId) {
        if (!this.isDeviceSecure(userId)) {
            return null;
        }
        Intent intent = new Intent(ACTION_CONFIRM_DEVICE_CREDENTIAL_WITH_USER);
        intent.putExtra(EXTRA_TITLE, title);
        intent.putExtra(EXTRA_DESCRIPTION, description);
        intent.putExtra("android.intent.extra.USER_ID", userId);
        intent.setPackage(this.getSettingsPackageForIntent(intent));
        return intent;
    }

    public Intent createConfirmDeviceCredentialIntent(CharSequence title, CharSequence description, int userId, boolean disallowBiometricsIfPolicyExists) {
        Intent intent = this.createConfirmDeviceCredentialIntent(title, description, userId);
        if (intent != null) {
            intent.putExtra(EXTRA_DISALLOW_BIOMETRICS_IF_POLICY_EXISTS, disallowBiometricsIfPolicyExists);
        }
        return intent;
    }

    @SystemApi
    public Intent createConfirmFactoryResetCredentialIntent(CharSequence title, CharSequence description, CharSequence alternateButtonLabel) {
        if (!LockPatternUtils.frpCredentialEnabled(this.mContext)) {
            Log.w(TAG, "Factory reset credentials not supported.");
            throw new UnsupportedOperationException("not supported on this device");
        }
        if (Settings.Global.getInt(this.mContext.getContentResolver(), "device_provisioned", 0) != 0) {
            Log.e(TAG, "Factory reset credential cannot be verified after provisioning.");
            throw new IllegalStateException("must not be provisioned yet");
        }
        try {
            IPersistentDataBlockService pdb = IPersistentDataBlockService.Stub.asInterface(ServiceManager.getService("persistent_data_block"));
            if (pdb == null) {
                Log.e(TAG, "No persistent data block service");
                throw new UnsupportedOperationException("not supported on this device");
            }
            if (!pdb.hasFrpCredentialHandle()) {
                Log.i(TAG, "The persistent data block does not have a factory reset credential.");
                return null;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        Intent intent = new Intent(ACTION_CONFIRM_FRP_CREDENTIAL);
        intent.putExtra(EXTRA_TITLE, title);
        intent.putExtra(EXTRA_DESCRIPTION, description);
        intent.putExtra(EXTRA_ALTERNATE_BUTTON_LABEL, alternateButtonLabel);
        intent.setPackage(this.getSettingsPackageForIntent(intent));
        return intent;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CHECK_REMOTE_LOCKSCREEN")
    @NonNull
    public Intent createConfirmDeviceCredentialForRemoteValidationIntent(@NonNull RemoteLockscreenValidationSession session, @NonNull ComponentName remoteLockscreenValidationServiceComponent, @Nullable CharSequence title, @Nullable CharSequence description, @Nullable CharSequence checkboxLabel, @Nullable CharSequence alternateButtonLabel) {
        Intent intent = new Intent(ACTION_CONFIRM_REMOTE_DEVICE_CREDENTIAL).putExtra(EXTRA_REMOTE_LOCKSCREEN_VALIDATION_SESSION, session).putExtra("android.intent.extra.COMPONENT_NAME", remoteLockscreenValidationServiceComponent).putExtra(EXTRA_TITLE, title).putExtra(EXTRA_DESCRIPTION, description).putExtra(EXTRA_CHECKBOX_LABEL, checkboxLabel).putExtra(EXTRA_ALTERNATE_BUTTON_LABEL, alternateButtonLabel);
        intent.setPackage(this.getSettingsPackageForIntent(intent));
        return intent;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONTROL_KEYGUARD_SECURE_NOTIFICATIONS")
    public void setPrivateNotificationsAllowed(boolean allow) {
        try {
            this.mNotificationManager.setPrivateNotificationsAllowed(allow);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CONTROL_KEYGUARD_SECURE_NOTIFICATIONS")
    public boolean getPrivateNotificationsAllowed() {
        try {
            return this.mNotificationManager.getPrivateNotificationsAllowed();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private String getSettingsPackageForIntent(Intent intent) {
        int i = 0;
        List<ResolveInfo> resolveInfos = this.mContext.getPackageManager().queryIntentActivities(intent, 0x100000);
        if (i < resolveInfos.size()) {
            return resolveInfos.get((int)i).activityInfo.packageName;
        }
        return "com.android.settings";
    }

    KeyguardManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mLockPatternUtils = new LockPatternUtils(context);
        this.mWM = WindowManagerGlobal.getWindowManagerService();
        this.mAm = ActivityManager.getService();
        this.mTrustManager = ITrustManager.Stub.asInterface(ServiceManager.getServiceOrThrow("trust"));
        this.mNotificationManager = INotificationManager.Stub.asInterface(ServiceManager.getServiceOrThrow("notification"));
    }

    @Deprecated
    public KeyguardLock newKeyguardLock(String tag) {
        return new KeyguardLock(tag);
    }

    public boolean isKeyguardLocked() {
        try {
            return this.mWM.isKeyguardLocked();
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public boolean isKeyguardSecure() {
        try {
            return this.mWM.isKeyguardSecure(this.mContext.getUserId());
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public boolean inKeyguardRestrictedInputMode() {
        return this.isKeyguardLocked();
    }

    public boolean isDeviceLocked() {
        return this.isDeviceLocked(this.mContext.getUserId(), this.mContext.getDeviceId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public boolean isDeviceLocked(int userId) {
        return this.isDeviceLocked(userId, this.mContext.getDeviceId());
    }

    public boolean isDeviceLocked(int userId, int deviceId) {
        try {
            return this.mTrustManager.isDeviceLocked(userId, deviceId);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean isDeviceSecure() {
        return this.isDeviceSecure(this.mContext.getUserId(), this.mContext.getDeviceId());
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isDeviceSecure(int userId) {
        return this.isDeviceSecure(userId, this.mContext.getDeviceId());
    }

    public boolean isDeviceSecure(int userId, int deviceId) {
        try {
            return this.mTrustManager.isDeviceSecure(userId, deviceId);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void requestDismissKeyguard(@NonNull Activity activity, @Nullable KeyguardDismissCallback callback) {
        this.requestDismissKeyguard(activity, null, callback);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SHOW_KEYGUARD_MESSAGE")
    public void requestDismissKeyguard(final @NonNull Activity activity, @Nullable CharSequence message, final @Nullable KeyguardDismissCallback callback) {
        ActivityClient.getInstance().dismissKeyguard(activity.getActivityToken(), new IKeyguardDismissCallback.Stub(this){

            @Override
            public void onDismissError() throws RemoteException {
                if (callback != null && !activity.isDestroyed()) {
                    activity.mHandler.post(callback::onDismissError);
                }
            }

            @Override
            public void onDismissSucceeded() throws RemoteException {
                if (callback != null && !activity.isDestroyed()) {
                    activity.mHandler.post(callback::onDismissSucceeded);
                }
            }

            @Override
            public void onDismissCancelled() throws RemoteException {
                if (callback != null && !activity.isDestroyed()) {
                    activity.mHandler.post(callback::onDismissCancelled);
                }
            }
        }, message);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.DISABLE_KEYGUARD")
    public void exitKeyguardSecurely(final OnKeyguardExitResult callback) {
        try {
            this.mWM.exitKeyguardSecurely(new IOnKeyguardExitResult.Stub(this){

                @Override
                public void onKeyguardExitResult(boolean success) throws RemoteException {
                    if (callback != null) {
                        callback.onKeyguardExitResult(success);
                    }
                }
            });
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    public boolean checkInitialLockMethodUsage() {
        if (!this.hasPermission("android.permission.SET_INITIAL_LOCK")) {
            throw new SecurityException("Requires SET_INITIAL_LOCK permission.");
        }
        return true;
    }

    private boolean hasPermission(String permission2) {
        return 0 == this.mContext.checkCallingOrSelfPermission(permission2);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SET_INITIAL_LOCK")
    public boolean isValidLockPasswordComplexity(int lockType, @NonNull byte[] password, int complexity) {
        if (!this.checkInitialLockMethodUsage()) {
            return false;
        }
        Objects.requireNonNull(password, "Password cannot be null.");
        complexity = PasswordMetrics.sanitizeComplexityLevel(complexity);
        PasswordMetrics adminMetrics = this.mLockPatternUtils.getRequestedPasswordMetrics(this.mContext.getUserId());
        try (LockscreenCredential credential = this.createLockscreenCredential(lockType, password);){
            boolean bl = PasswordMetrics.validateCredential(adminMetrics, complexity, credential).size() == 0;
            return bl;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.SET_INITIAL_LOCK")
    public int getMinLockLength(boolean isPin, int complexity) {
        if (!this.checkInitialLockMethodUsage()) {
            return -1;
        }
        complexity = PasswordMetrics.sanitizeComplexityLevel(complexity);
        PasswordMetrics adminMetrics = this.mLockPatternUtils.getRequestedPasswordMetrics(this.mContext.getUserId());
        PasswordMetrics minMetrics = PasswordMetrics.applyComplexity(adminMetrics, isPin, complexity);
        return minMetrics.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.SET_INITIAL_LOCK")
    public boolean setLock(int lockType, @NonNull byte[] password, int complexity) {
        boolean success;
        if (!this.checkInitialLockMethodUsage()) {
            return false;
        }
        int userId = this.mContext.getUserId();
        if (this.isDeviceSecure(userId)) {
            Log.e(TAG, "Password already set, rejecting call to setLock");
            return false;
        }
        if (!this.isValidLockPasswordComplexity(lockType, password, complexity)) {
            Log.e(TAG, "Password is not valid, rejecting call to setLock");
            return false;
        }
        try (LockscreenCredential credential = this.createLockscreenCredential(lockType, password);){
            success = this.mLockPatternUtils.setLockCredential(credential, LockscreenCredential.createNone(), userId);
        }
        catch (Exception e) {
            Log.e(TAG, "Save lock exception", e);
            success = false;
        }
        finally {
            ArrayUtils.zeroize(password);
        }
        return success;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_WEAK_ESCROW_TOKEN")
    public long addWeakEscrowToken(@NonNull byte[] token, @NonNull UserHandle user, final @NonNull Executor executor, final @NonNull WeakEscrowTokenActivatedListener listener) {
        Objects.requireNonNull(token, "Token cannot be null.");
        Objects.requireNonNull(user, "User cannot be null.");
        Objects.requireNonNull(executor, "Executor cannot be null.");
        Objects.requireNonNull(listener, "Listener cannot be null.");
        int userId = user.getIdentifier();
        IWeakEscrowTokenActivatedListener.Stub internalListener = new IWeakEscrowTokenActivatedListener.Stub(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWeakEscrowTokenActivated(long handle, int userId) {
                UserHandle user = UserHandle.of(userId);
                long restoreToken = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener.onWeakEscrowTokenActivated(handle, user));
                }
                finally {
                    Binder.restoreCallingIdentity(restoreToken);
                }
                Log.i(KeyguardManager.TAG, "Weak escrow token activated.");
            }
        };
        return this.mLockPatternUtils.addWeakEscrowToken(token, userId, internalListener);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_WEAK_ESCROW_TOKEN")
    public boolean removeWeakEscrowToken(long handle, @NonNull UserHandle user) {
        Objects.requireNonNull(user, "User cannot be null.");
        return this.mLockPatternUtils.removeWeakEscrowToken(handle, user.getIdentifier());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_WEAK_ESCROW_TOKEN")
    public boolean isWeakEscrowTokenActive(long handle, @NonNull UserHandle user) {
        Objects.requireNonNull(user, "User cannot be null.");
        return this.mLockPatternUtils.isWeakEscrowTokenActive(handle, user.getIdentifier());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_WEAK_ESCROW_TOKEN")
    public boolean isWeakEscrowTokenValid(long handle, @NonNull byte[] token, @NonNull UserHandle user) {
        Objects.requireNonNull(token, "Token cannot be null.");
        Objects.requireNonNull(user, "User cannot be null.");
        return this.mLockPatternUtils.isWeakEscrowTokenValid(handle, token, user.getIdentifier());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_WEAK_ESCROW_TOKEN")
    public boolean registerWeakEscrowTokenRemovedListener(final @NonNull Executor executor, final @NonNull WeakEscrowTokenRemovedListener listener) {
        Objects.requireNonNull(listener, "Listener cannot be null.");
        Objects.requireNonNull(executor, "Executor cannot be null.");
        Preconditions.checkArgument(!this.mListeners.containsKey(listener), "Listener already registered: %s", listener);
        IWeakEscrowTokenRemovedListener.Stub internalListener = new IWeakEscrowTokenRemovedListener.Stub(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onWeakEscrowTokenRemoved(long handle, int userId) {
                UserHandle user = UserHandle.of(userId);
                long token = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener.onWeakEscrowTokenRemoved(handle, user));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        };
        if (this.mLockPatternUtils.registerWeakEscrowTokenRemovedListener(internalListener)) {
            this.mListeners.put(listener, internalListener);
            return true;
        }
        Log.e(TAG, "Listener failed to register");
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_WEAK_ESCROW_TOKEN")
    public boolean unregisterWeakEscrowTokenRemovedListener(@NonNull WeakEscrowTokenRemovedListener listener) {
        Objects.requireNonNull(listener, "Listener cannot be null.");
        IWeakEscrowTokenRemovedListener internalListener = this.mListeners.get(listener);
        Preconditions.checkArgument(internalListener != null, "Listener was not registered");
        if (this.mLockPatternUtils.unregisterWeakEscrowTokenRemovedListener(internalListener)) {
            this.mListeners.remove(listener);
            return true;
        }
        Log.e(TAG, "Listener failed to unregister.");
        return false;
    }

    @RequiresPermission(anyOf={"android.permission.SET_AND_VERIFY_LOCKSCREEN_CREDENTIALS", "android.permission.ACCESS_KEYGUARD_SECURE_STORAGE"})
    public boolean setLock(int newLockType, @Nullable byte[] newPassword, int currentLockType, @Nullable byte[] currentPassword) {
        int userId = this.mContext.getUserId();
        try (LockscreenCredential currentCredential = this.createLockscreenCredential(currentLockType, currentPassword);){
            LockscreenCredential newCredential;
            block16: {
                newCredential = this.createLockscreenCredential(newLockType, newPassword);
                try {
                    PasswordMetrics adminMetrics = this.mLockPatternUtils.getRequestedPasswordMetrics(this.mContext.getUserId());
                    List<PasswordValidationError> errors = PasswordMetrics.validateCredential(adminMetrics, 0, newCredential);
                    if (errors.isEmpty()) break block16;
                    Log.e(TAG, "New credential is not valid: " + errors.get(0));
                    boolean bl = false;
                    if (newCredential != null) {
                        newCredential.close();
                    }
                    return bl;
                }
                catch (Throwable throwable) {
                    if (newCredential != null) {
                        try {
                            newCredential.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            boolean bl = this.mLockPatternUtils.setLockCredential(newCredential, currentCredential, userId);
            if (newCredential != null) {
                newCredential.close();
            }
            return bl;
        }
    }

    @RequiresPermission(anyOf={"android.permission.SET_AND_VERIFY_LOCKSCREEN_CREDENTIALS", "android.permission.ACCESS_KEYGUARD_SECURE_STORAGE"})
    public boolean checkLock(int lockType, @Nullable byte[] password) {
        try (LockscreenCredential credential = this.createLockscreenCredential(lockType, password);){
            VerifyCredentialResponse response = this.mLockPatternUtils.verifyCredential(credential, this.mContext.getUserId(), 0);
            if (response == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = response.getResponseCode() == 0;
            return bl;
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CHECK_REMOTE_LOCKSCREEN")
    @NonNull
    public RemoteLockscreenValidationSession startRemoteLockscreenValidation() {
        return this.mLockPatternUtils.startRemoteLockscreenValidation();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.CHECK_REMOTE_LOCKSCREEN")
    @NonNull
    public RemoteLockscreenValidationResult validateRemoteLockscreen(@NonNull byte[] encryptedCredential) {
        return this.mLockPatternUtils.validateRemoteLockscreen(encryptedCredential);
    }

    private LockscreenCredential createLockscreenCredential(int lockType, @Nullable byte[] password) {
        if (password == null) {
            return LockscreenCredential.createNone();
        }
        switch (lockType) {
            case 0: {
                String passwordStr = new String(password, Charset.forName("UTF-8"));
                return LockscreenCredential.createPassword(passwordStr);
            }
            case 1: {
                String pinStr = new String(password);
                return LockscreenCredential.createPin(pinStr);
            }
            case 2: {
                List<LockPatternView.Cell> pattern = LockPatternUtils.byteArrayToPattern(password);
                return LockscreenCredential.createPattern(pattern);
            }
        }
        throw new IllegalArgumentException("Unknown lock type " + lockType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.SUBSCRIBE_TO_KEYGUARD_LOCKED_STATE")
    public void addKeyguardLockedStateListener(@NonNull Executor executor, @NonNull KeyguardLockedStateListener listener) {
        ArrayMap<KeyguardLockedStateListener, Executor> arrayMap = this.mKeyguardLockedStateListeners;
        synchronized (arrayMap) {
            this.mKeyguardLockedStateListeners.put(listener, executor);
            if (this.mKeyguardLockedStateListeners.size() > 1) {
                return;
            }
            try {
                this.mWM.addKeyguardLockedStateListener(this.mIKeyguardLockedStateListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.SUBSCRIBE_TO_KEYGUARD_LOCKED_STATE")
    public void removeKeyguardLockedStateListener(@NonNull KeyguardLockedStateListener listener) {
        ArrayMap<KeyguardLockedStateListener, Executor> arrayMap = this.mKeyguardLockedStateListeners;
        synchronized (arrayMap) {
            this.mKeyguardLockedStateListeners.remove(listener);
            if (!this.mKeyguardLockedStateListeners.isEmpty()) {
                return;
            }
            try {
                this.mWM.removeKeyguardLockedStateListener(this.mIKeyguardLockedStateListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.SUBSCRIBE_TO_KEYGUARD_LOCKED_STATE")
    @FlaggedApi(value="android.app.device_unlock_listener")
    public void addDeviceLockedStateListener(@NonNull Executor executor, @NonNull DeviceLockedStateListener listener) {
        if (!Flags.deviceUnlockListener()) {
            return;
        }
        ArrayMap<DeviceLockedStateListener, Executor> arrayMap = this.mDeviceLockedStateListeners;
        synchronized (arrayMap) {
            this.mDeviceLockedStateListeners.put(listener, executor);
            if (this.mDeviceLockedStateListeners.size() > 1) {
                return;
            }
            try {
                this.mTrustManager.registerDeviceLockedStateListener(this.mIDeviceLockedStateListener, this.mContext.getDeviceId());
            }
            catch (RemoteException re) {
                Log.d(TAG, "TrustManager service died", re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.SUBSCRIBE_TO_KEYGUARD_LOCKED_STATE")
    @FlaggedApi(value="android.app.device_unlock_listener")
    public void removeDeviceLockedStateListener(@NonNull DeviceLockedStateListener listener) {
        if (!Flags.deviceUnlockListener()) {
            return;
        }
        ArrayMap<DeviceLockedStateListener, Executor> arrayMap = this.mDeviceLockedStateListeners;
        synchronized (arrayMap) {
            this.mDeviceLockedStateListeners.remove(listener);
            if (!this.mDeviceLockedStateListeners.isEmpty()) {
                return;
            }
            try {
                this.mTrustManager.unregisterDeviceLockedStateListener(this.mIDeviceLockedStateListener);
            }
            catch (RemoteException re) {
                Log.d(TAG, "TrustManager service died", re);
            }
        }
    }

    @Deprecated
    public class KeyguardLock {
        private final IBinder mToken = new Binder();
        private final String mTag;

        KeyguardLock(String tag) {
            this.mTag = tag;
        }

        @RequiresPermission(value="android.permission.DISABLE_KEYGUARD")
        public void disableKeyguard() {
            try {
                KeyguardManager.this.mWM.disableKeyguard(this.mToken, this.mTag, KeyguardManager.this.mContext.getUserId());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @RequiresPermission(value="android.permission.DISABLE_KEYGUARD")
        public void reenableKeyguard() {
            try {
                KeyguardManager.this.mWM.reenableKeyguard(this.mToken, KeyguardManager.this.mContext.getUserId());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public static abstract class KeyguardDismissCallback {
        public void onDismissError() {
        }

        public void onDismissSucceeded() {
        }

        public void onDismissCancelled() {
        }
    }

    @Deprecated
    public static interface OnKeyguardExitResult {
        public void onKeyguardExitResult(boolean var1);
    }

    @SystemApi
    public static interface WeakEscrowTokenActivatedListener {
        public void onWeakEscrowTokenActivated(long var1, @NonNull UserHandle var3);
    }

    @SystemApi
    public static interface WeakEscrowTokenRemovedListener {
        public void onWeakEscrowTokenRemoved(long var1, @NonNull UserHandle var3);
    }

    @FunctionalInterface
    @FlaggedApi(value="android.app.device_unlock_listener")
    public static interface DeviceLockedStateListener {
        public void onDeviceLockedStateChanged(boolean var1);
    }

    @FunctionalInterface
    public static interface KeyguardLockedStateListener {
        public void onKeyguardLockedStateChanged(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface LockTypes {
    }
}

