/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.content.pm.IBackgroundInstallControlService;
import android.content.pm.PackageInfo;
import android.os.RemoteException;
import android.os.ServiceManager;
import java.util.List;

@SystemApi(client=SystemApi.Client.PRIVILEGED_APPS)
@FlaggedApi(value="android.app.bic_client")
public class BackgroundInstallControlManager {
    private static final String TAG = "BackgroundInstallControlManager";
    private static IBackgroundInstallControlService sService;
    private final Context mContext;

    BackgroundInstallControlManager(Context context) {
        this.mContext = context;
    }

    private static IBackgroundInstallControlService getService() {
        if (sService == null) {
            sService = IBackgroundInstallControlService.Stub.asInterface(ServiceManager.getService("background_install_control"));
        }
        return sService;
    }

    @SystemApi
    @FlaggedApi(value="android.app.bic_client")
    @RequiresPermission(value="android.permission.GET_BACKGROUND_INSTALLED_PACKAGES")
    @NonNull
    public List<PackageInfo> getBackgroundInstalledPackages(long flags) {
        try {
            return BackgroundInstallControlManager.getService().getBackgroundInstalledPackages(flags, this.mContext.getUserId()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

