/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.ContextImpl;
import android.app.LocaleConfig;
import android.app.PropertyInvalidatedCache;
import android.app.admin.DevicePolicyManager;
import android.app.role.RoleManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApkChecksum;
import android.content.pm.ApplicationInfo;
import android.content.pm.ArchivedPackageInfo;
import android.content.pm.ArchivedPackageParcel;
import android.content.pm.ChangedPackages;
import android.content.pm.ComponentInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IDexModuleRegisterCallback;
import android.content.pm.IOnChecksumsReadyListener;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageManager;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstallSourceInfo;
import android.content.pm.InstantAppInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.IntentFilterVerificationInfo;
import android.content.pm.KeySet;
import android.content.pm.ModuleInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.SharedLibraryInfo;
import android.content.pm.SuspendDialogInfo;
import android.content.pm.SystemFeaturesCache;
import android.content.pm.VerifierDeviceIdentity;
import android.content.pm.VersionedPackage;
import android.content.pm.dex.ArtManager;
import android.content.res.ApkAssets;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.ParcelableException;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.StrictMode;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManager;
import android.os.storage.VolumeInfo;
import android.permission.PermissionControllerManager;
import android.permission.PermissionManager;
import android.provider.Settings;
import android.ravenwood.annotation.RavenwoodKeepPartialClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.LauncherIcons;
import android.util.Log;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.content.pm.Flags;
import com.android.internal.os.SomeArgs;
import com.android.internal.pm.RoSystemFeatures;
import com.android.internal.util.UserIcons;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.ref.WeakReference;
import java.lang.runtime.ObjectMethods;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParserException;

@RavenwoodKeepPartialClass
public class ApplicationPackageManager
extends PackageManager {
    private static final String TAG = "ApplicationPackageManager";
    private static final boolean DEBUG_ICONS = false;
    private static final int DEFAULT_EPHEMERAL_COOKIE_MAX_SIZE_BYTES = 16384;
    private static final int sDefaultFlags = 1024;
    private static final int DEFAULT_CHECKSUMS = 127;
    public static final String APP_PERMISSION_BUTTON_ALLOW_ALWAYS = "app_permission_button_allow_always";
    public static final String PERMISSION_CONTROLLER_RESOURCE_PACKAGE = "com.android.permissioncontroller";
    private volatile UserManager mUserManager;
    private volatile PermissionManager mPermissionManager;
    private volatile PackageInstaller mInstaller;
    private volatile ArtManager mArtManager;
    private volatile DevicePolicyManager mDevicePolicyManager;
    private volatile String mPermissionsControllerPackageName;
    @GuardedBy(value={"mDelegates"})
    private final ArrayList<MoveCallbackDelegate> mDelegates = new ArrayList();
    @NonNull
    @GuardedBy(value={"mPackageMonitorCallbacks"})
    private final ArraySet<IRemoteCallback> mPackageMonitorCallbacks = new ArraySet();
    private final boolean mUseSystemFeaturesCache;
    private static final String HAS_SYSTEM_FEATURE_API = "has_system_feature";
    private static final PropertyInvalidatedCache<HasSystemFeatureQuery, Boolean> mHasSystemFeatureCache = new PropertyInvalidatedCache<HasSystemFeatureQuery, Boolean>(new PropertyInvalidatedCache.Args("system_server").api("has_system_feature").maxEntries(SDK_FEATURE_COUNT).isolateUids(false), "has_system_feature", null){

        @Override
        public Boolean recompute(HasSystemFeatureQuery query) {
            try {
                ActivityThread.currentActivityThread();
                return ActivityThread.getPackageManager().hasSystemFeature(query.name, query.version);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    };
    private static final String CACHE_KEY_PACKAGES_FOR_UID_API = "get_packages_for_uid";
    @VisibleForTesting
    public static final PropertyInvalidatedCache<Integer, GetPackagesForUidResult> sGetPackagesForUidCache = new PropertyInvalidatedCache<Integer, GetPackagesForUidResult>(new PropertyInvalidatedCache.Args("system_server").maxEntries(1024).api("get_packages_for_uid").cacheNulls(true), "get_packages_for_uid", null){

        @Override
        public GetPackagesForUidResult recompute(Integer uid) {
            try {
                ActivityThread.currentActivityThread();
                return new GetPackagesForUidResult(ActivityThread.getPackageManager().getPackagesForUid(uid));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @Override
        public String queryToString(Integer uid) {
            return String.format("uid=%d", (int)uid);
        }
    };
    volatile int mCachedSafeMode = -1;
    private final ContextImpl mContext;
    @UnsupportedAppUsage
    private final IPackageManager mPM;
    private volatile boolean mUserUnlocked = false;
    private static final Object sSync = new Object();
    private static ArrayMap<ResourceName, WeakReference<Drawable.ConstantState>> sIconCache = new ArrayMap();
    private static ArrayMap<ResourceName, WeakReference<CharSequence>> sStringCache = new ArrayMap();

    UserManager getUserManager() {
        if (this.mUserManager == null) {
            this.mUserManager = UserManager.get(this.mContext);
        }
        return this.mUserManager;
    }

    DevicePolicyManager getDevicePolicyManager() {
        if (this.mDevicePolicyManager == null) {
            this.mDevicePolicyManager = this.mContext.getSystemService(DevicePolicyManager.class);
        }
        return this.mDevicePolicyManager;
    }

    private PermissionManager getPermissionManager() {
        if (this.mPermissionManager == null) {
            this.mPermissionManager = this.mContext.getSystemService(PermissionManager.class);
        }
        return this.mPermissionManager;
    }

    @Override
    public int getUserId() {
        return this.mContext.getUserId();
    }

    @Override
    public PackageInfo getPackageInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return this.getPackageInfo(packageName, PackageManager.PackageInfoFlags.of(flags));
    }

    @Override
    public PackageInfo getPackageInfo(String packageName, PackageManager.PackageInfoFlags flags) throws PackageManager.NameNotFoundException {
        return this.getPackageInfoAsUser(packageName, flags, this.getUserId());
    }

    @Override
    public PackageInfo getPackageInfo(VersionedPackage versionedPackage, int flags) throws PackageManager.NameNotFoundException {
        return this.getPackageInfo(versionedPackage, PackageManager.PackageInfoFlags.of(flags));
    }

    @Override
    public PackageInfo getPackageInfo(VersionedPackage versionedPackage, PackageManager.PackageInfoFlags flags) throws PackageManager.NameNotFoundException {
        int userId = this.getUserId();
        try {
            PackageInfo pi = this.mPM.getPackageInfoVersioned(versionedPackage, this.updateFlagsForPackage(flags.getValue(), userId), userId);
            if (pi != null) {
                return pi;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(versionedPackage.toString());
    }

    @Override
    public PackageInfo getPackageInfoAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        return this.getPackageInfoAsUser(packageName, PackageManager.PackageInfoFlags.of(flags), userId);
    }

    @Override
    public PackageInfo getPackageInfoAsUser(String packageName, PackageManager.PackageInfoFlags flags, int userId) throws PackageManager.NameNotFoundException {
        PackageInfo pi = ApplicationPackageManager.getPackageInfoAsUserCached(packageName, this.updateFlagsForPackage(flags.getValue(), userId), userId);
        if (pi == null) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        return pi;
    }

    @Override
    public String[] currentToCanonicalPackageNames(String[] names) {
        try {
            return this.mPM.currentToCanonicalPackageNames(names);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public String[] canonicalToCurrentPackageNames(String[] names) {
        try {
            return this.mPM.canonicalToCurrentPackageNames(names);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public Intent getLaunchIntentForPackage(String packageName) {
        return this.getLaunchIntentForPackage(packageName, false);
    }

    @Override
    @Nullable
    public Intent getLaunchIntentForPackage(@NonNull String packageName, boolean includeDirectBootUnaware) {
        PackageManager.ResolveInfoFlags queryFlags = PackageManager.ResolveInfoFlags.of(includeDirectBootUnaware ? 786432L : 0L);
        Intent intentToResolve = new Intent("android.intent.action.MAIN");
        intentToResolve.addCategory("android.intent.category.INFO");
        intentToResolve.setPackage(packageName);
        List<ResolveInfo> ris = this.queryIntentActivities(intentToResolve, queryFlags);
        if (ris == null || ris.size() <= 0) {
            intentToResolve.removeCategory("android.intent.category.INFO");
            intentToResolve.addCategory("android.intent.category.LAUNCHER");
            intentToResolve.setPackage(packageName);
            ris = this.queryIntentActivities(intentToResolve, queryFlags);
        }
        if (ris == null || ris.size() <= 0) {
            return null;
        }
        Intent intent = new Intent(intentToResolve);
        intent.setFlags(0x10000000);
        intent.setClassName(ris.get((int)0).activityInfo.packageName, ris.get((int)0).activityInfo.name);
        return intent;
    }

    @Override
    public Intent getLeanbackLaunchIntentForPackage(String packageName) {
        return this.getLaunchIntentForPackageAndCategory(packageName, "android.intent.category.LEANBACK_LAUNCHER");
    }

    @Override
    public Intent getCarLaunchIntentForPackage(String packageName) {
        return this.getLaunchIntentForPackageAndCategory(packageName, "android.intent.category.CAR_LAUNCHER");
    }

    private Intent getLaunchIntentForPackageAndCategory(String packageName, String category) {
        Intent intentToResolve = new Intent("android.intent.action.MAIN");
        intentToResolve.addCategory(category);
        intentToResolve.setPackage(packageName);
        List<ResolveInfo> ris = this.queryIntentActivities(intentToResolve, 0);
        if (ris == null || ris.size() <= 0) {
            return null;
        }
        Intent intent = new Intent(intentToResolve);
        intent.setFlags(0x10000000);
        intent.setClassName(ris.get((int)0).activityInfo.packageName, ris.get((int)0).activityInfo.name);
        return intent;
    }

    @Override
    @NonNull
    public IntentSender getLaunchIntentSenderForPackage(@NonNull String packageName) {
        try {
            return this.mPM.getLaunchIntentSenderForPackage(packageName, this.mContext.getPackageName(), this.mContext.getAttributionTag(), this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public int[] getPackageGids(String packageName) throws PackageManager.NameNotFoundException {
        return this.getPackageGids(packageName, 0);
    }

    @Override
    public int[] getPackageGids(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return this.getPackageGids(packageName, PackageManager.PackageInfoFlags.of(flags));
    }

    @Override
    public int[] getPackageGids(String packageName, PackageManager.PackageInfoFlags flags) throws PackageManager.NameNotFoundException {
        int userId = this.getUserId();
        try {
            int[] gids = this.mPM.getPackageGids(packageName, this.updateFlagsForPackage(flags.getValue(), userId), userId);
            if (gids != null) {
                return gids;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    @Override
    public int getPackageUid(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return this.getPackageUid(packageName, PackageManager.PackageInfoFlags.of(flags));
    }

    @Override
    public int getPackageUid(String packageName, PackageManager.PackageInfoFlags flags) throws PackageManager.NameNotFoundException {
        return this.getPackageUidAsUser(packageName, flags, this.getUserId());
    }

    @Override
    public int getPackageUidAsUser(String packageName, int userId) throws PackageManager.NameNotFoundException {
        return this.getPackageUidAsUser(packageName, 0, userId);
    }

    @Override
    public int getPackageUidAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        return this.getPackageUidAsUser(packageName, PackageManager.PackageInfoFlags.of(flags), userId);
    }

    @Override
    public int getPackageUidAsUser(String packageName, PackageManager.PackageInfoFlags flags, int userId) throws PackageManager.NameNotFoundException {
        try {
            int uid = this.mPM.getPackageUid(packageName, this.updateFlagsForPackage(flags.getValue(), userId), userId);
            if (uid >= 0) {
                return uid;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    @Override
    public List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
        return this.getPermissionManager().getAllPermissionGroups(flags);
    }

    @Override
    public PermissionGroupInfo getPermissionGroupInfo(String groupName, int flags) throws PackageManager.NameNotFoundException {
        PermissionGroupInfo permissionGroupInfo = this.getPermissionManager().getPermissionGroupInfo(groupName, flags);
        if (permissionGroupInfo == null) {
            throw new PackageManager.NameNotFoundException(groupName);
        }
        return permissionGroupInfo;
    }

    @Override
    public PermissionInfo getPermissionInfo(String permName, int flags) throws PackageManager.NameNotFoundException {
        PermissionInfo permissionInfo = this.getPermissionManager().getPermissionInfo(permName, flags);
        if (permissionInfo == null) {
            throw new PackageManager.NameNotFoundException(permName);
        }
        return permissionInfo;
    }

    @Override
    public List<PermissionInfo> queryPermissionsByGroup(String groupName, int flags) throws PackageManager.NameNotFoundException {
        List<PermissionInfo> permissionInfos = this.getPermissionManager().queryPermissionsByGroup(groupName, flags);
        if (permissionInfos == null) {
            throw new PackageManager.NameNotFoundException(groupName);
        }
        return permissionInfos;
    }

    @Override
    public void getPlatformPermissionsForGroup(@NonNull String permissionGroupName, @NonNull Executor executor, @NonNull Consumer<List<String>> callback) {
        PermissionControllerManager permissionControllerManager = this.mContext.getSystemService(PermissionControllerManager.class);
        permissionControllerManager.getPlatformPermissionsForGroup(permissionGroupName, executor, callback);
    }

    @Override
    public void getGroupOfPlatformPermission(@NonNull String permissionName, @NonNull Executor executor, @NonNull Consumer<String> callback) {
        PermissionControllerManager permissionControllerManager = this.mContext.getSystemService(PermissionControllerManager.class);
        permissionControllerManager.getGroupOfPlatformPermission(permissionName, executor, callback);
    }

    @Override
    public boolean arePermissionsIndividuallyControlled() {
        return this.mContext.getResources().getBoolean(17891861);
    }

    @Override
    public boolean isWirelessConsentModeEnabled() {
        return this.mContext.getResources().getBoolean(17892036);
    }

    @Override
    public ApplicationInfo getApplicationInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return this.getApplicationInfo(packageName, PackageManager.ApplicationInfoFlags.of(flags));
    }

    @Override
    public ApplicationInfo getApplicationInfo(String packageName, PackageManager.ApplicationInfoFlags flags) throws PackageManager.NameNotFoundException {
        return this.getApplicationInfoAsUser(packageName, flags, this.getUserId());
    }

    @Override
    public ApplicationInfo getApplicationInfoAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        return this.getApplicationInfoAsUser(packageName, PackageManager.ApplicationInfoFlags.of(flags), userId);
    }

    @Override
    public ApplicationInfo getApplicationInfoAsUser(String packageName, PackageManager.ApplicationInfoFlags flags, int userId) throws PackageManager.NameNotFoundException {
        ApplicationInfo ai = ApplicationPackageManager.getApplicationInfoAsUserCached(packageName, this.updateFlagsForApplication(flags.getValue(), userId), userId);
        if (ai == null) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        return ApplicationPackageManager.maybeAdjustApplicationInfo(ai);
    }

    private static ApplicationInfo maybeAdjustApplicationInfo(ApplicationInfo info) {
        if (info.primaryCpuAbi != null && info.secondaryCpuAbi != null) {
            String runtimeIsa = VMRuntime.getRuntime().vmInstructionSet();
            String secondaryIsa = VMRuntime.getInstructionSet(info.secondaryCpuAbi);
            String secondaryDexCodeIsa = SystemProperties.get("ro.dalvik.vm.isa." + secondaryIsa);
            String string2 = secondaryIsa = secondaryDexCodeIsa.isEmpty() ? secondaryIsa : secondaryDexCodeIsa;
            if (runtimeIsa.equals(secondaryIsa)) {
                ApplicationInfo modified = new ApplicationInfo(info);
                modified.nativeLibraryDir = info.secondaryNativeLibraryDir;
                return modified;
            }
        }
        return info;
    }

    @Override
    public int getTargetSdkVersion(@NonNull String packageName) throws PackageManager.NameNotFoundException {
        try {
            int version = this.mPM.getTargetSdkVersion(packageName);
            if (version != -1) {
                return version;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    @Override
    public ActivityInfo getActivityInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        return this.getActivityInfo(className, PackageManager.ComponentInfoFlags.of(flags));
    }

    @Override
    public ActivityInfo getActivityInfo(ComponentName className, PackageManager.ComponentInfoFlags flags) throws PackageManager.NameNotFoundException {
        int userId = this.getUserId();
        try {
            ActivityInfo ai = this.mPM.getActivityInfo(className, this.updateFlagsForComponent(flags.getValue(), userId, null), userId);
            if (ai != null) {
                return ai;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(className.toString());
    }

    @Override
    public ActivityInfo getReceiverInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        return this.getReceiverInfo(className, PackageManager.ComponentInfoFlags.of(flags));
    }

    @Override
    public ActivityInfo getReceiverInfo(ComponentName className, PackageManager.ComponentInfoFlags flags) throws PackageManager.NameNotFoundException {
        int userId = this.getUserId();
        try {
            ActivityInfo ai = this.mPM.getReceiverInfo(className, this.updateFlagsForComponent(flags.getValue(), userId, null), userId);
            if (ai != null) {
                return ai;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(className.toString());
    }

    @Override
    public ServiceInfo getServiceInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        return this.getServiceInfo(className, PackageManager.ComponentInfoFlags.of(flags));
    }

    @Override
    public ServiceInfo getServiceInfo(ComponentName className, PackageManager.ComponentInfoFlags flags) throws PackageManager.NameNotFoundException {
        int userId = this.getUserId();
        try {
            ServiceInfo si = this.mPM.getServiceInfo(className, this.updateFlagsForComponent(flags.getValue(), userId, null), userId);
            if (si != null) {
                return si;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(className.toString());
    }

    @Override
    public ProviderInfo getProviderInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        return this.getProviderInfo(className, PackageManager.ComponentInfoFlags.of(flags));
    }

    @Override
    public ProviderInfo getProviderInfo(ComponentName className, PackageManager.ComponentInfoFlags flags) throws PackageManager.NameNotFoundException {
        int userId = this.getUserId();
        try {
            ProviderInfo pi = this.mPM.getProviderInfo(className, this.updateFlagsForComponent(flags.getValue(), userId, null), userId);
            if (pi != null) {
                return pi;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(className.toString());
    }

    @Override
    public String[] getSystemSharedLibraryNames() {
        try {
            return this.mPM.getSystemSharedLibraryNames();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @NonNull
    public List<SharedLibraryInfo> getSharedLibraries(int flags) {
        return this.getSharedLibraries(PackageManager.PackageInfoFlags.of(flags));
    }

    @Override
    @NonNull
    public List<SharedLibraryInfo> getSharedLibraries(PackageManager.PackageInfoFlags flags) {
        return this.getSharedLibrariesAsUser(flags, this.getUserId());
    }

    @Override
    @NonNull
    public List<SharedLibraryInfo> getSharedLibrariesAsUser(int flags, int userId) {
        return this.getSharedLibrariesAsUser(PackageManager.PackageInfoFlags.of(flags), userId);
    }

    @Override
    @NonNull
    public List<SharedLibraryInfo> getSharedLibrariesAsUser(PackageManager.PackageInfoFlags flags, int userId) {
        try {
            ParceledListSlice sharedLibs = this.mPM.getSharedLibraries(this.mContext.getOpPackageName(), flags.getValue(), userId);
            if (sharedLibs == null) {
                return Collections.emptyList();
            }
            return sharedLibs.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @NonNull
    public List<SharedLibraryInfo> getDeclaredSharedLibraries(@NonNull String packageName, int flags) {
        return this.getDeclaredSharedLibraries(packageName, PackageManager.PackageInfoFlags.of(flags));
    }

    @Override
    @NonNull
    public List<SharedLibraryInfo> getDeclaredSharedLibraries(@NonNull String packageName, PackageManager.PackageInfoFlags flags) {
        try {
            ParceledListSlice sharedLibraries = this.mPM.getDeclaredSharedLibraries(packageName, flags.getValue(), this.mContext.getUserId());
            return sharedLibraries != null ? sharedLibraries.getList() : Collections.emptyList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @NonNull
    public String getServicesSystemSharedLibraryPackageName() {
        try {
            return this.mPM.getServicesSystemSharedLibraryPackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @NonNull
    public String getSharedSystemSharedLibraryPackageName() {
        try {
            return this.mPM.getSharedSystemSharedLibraryPackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public ChangedPackages getChangedPackages(int sequenceNumber) {
        try {
            return this.mPM.getChangedPackages(sequenceNumber, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public FeatureInfo[] getSystemAvailableFeatures() {
        try {
            ParceledListSlice parceledList = this.mPM.getSystemAvailableFeatures();
            if (parceledList == null) {
                return new FeatureInfo[0];
            }
            List list = parceledList.getList();
            FeatureInfo[] res = new FeatureInfo[list.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = (FeatureInfo)list.get(i);
            }
            return res;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean hasSystemFeature(String name) {
        return this.hasSystemFeature(name, 0);
    }

    @Override
    public boolean hasSystemFeature(String name, int version) {
        Boolean maybeHasSystemFeature = RoSystemFeatures.maybeHasFeature(name, version);
        if (maybeHasSystemFeature != null) {
            return maybeHasSystemFeature;
        }
        if (this.mUseSystemFeaturesCache && (maybeHasSystemFeature = SystemFeaturesCache.getInstance().maybeHasFeature(name, version)) != null) {
            return maybeHasSystemFeature;
        }
        return mHasSystemFeatureCache.query(new HasSystemFeatureQuery(name, version));
    }

    public static void invalidateHasSystemFeatureCache() {
        mHasSystemFeatureCache.invalidateCache();
    }

    @Override
    public int checkPermission(String permName, String pkgName) {
        return this.getPermissionManager().checkPackageNamePermission(permName, pkgName, this.mContext.getDeviceId(), this.getUserId());
    }

    @Override
    public boolean isPermissionRevokedByPolicy(String permName, String pkgName) {
        return this.getPermissionManager().isPermissionRevokedByPolicy(pkgName, permName);
    }

    @Override
    public String getPermissionControllerPackageName() {
        if (this.mPermissionsControllerPackageName == null) {
            try {
                this.mPermissionsControllerPackageName = this.mPM.getPermissionControllerPackageName();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return this.mPermissionsControllerPackageName;
    }

    @Override
    public String getSdkSandboxPackageName() {
        try {
            return this.mPM.getSdkSandboxPackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean addPermission(PermissionInfo info) {
        return this.getPermissionManager().addPermission(info, false);
    }

    @Override
    public boolean addPermissionAsync(PermissionInfo info) {
        return this.getPermissionManager().addPermission(info, true);
    }

    @Override
    public void removePermission(String name) {
        this.getPermissionManager().removePermission(name);
    }

    @Override
    public void grantRuntimePermission(String packageName, String permissionName, UserHandle user) {
        this.getPermissionManager().grantRuntimePermission(packageName, permissionName, user);
    }

    @Override
    public void revokeRuntimePermission(String packageName, String permName, UserHandle user) {
        this.revokeRuntimePermission(packageName, permName, user, null);
    }

    @Override
    public void revokeRuntimePermission(String packageName, String permName, UserHandle user, String reason) {
        this.getPermissionManager().revokeRuntimePermission(packageName, permName, user, reason);
    }

    @Override
    public int getPermissionFlags(String permName, String packageName, UserHandle user) {
        return this.getPermissionManager().getPermissionFlags(packageName, permName, user);
    }

    @Override
    public void updatePermissionFlags(String permName, String packageName, int flagMask, int flagValues, UserHandle user) {
        this.getPermissionManager().updatePermissionFlags(packageName, permName, flagMask, flagValues, user);
    }

    @Override
    @NonNull
    public Set<String> getWhitelistedRestrictedPermissions(@NonNull String packageName, int flags) {
        return this.getPermissionManager().getAllowlistedRestrictedPermissions(packageName, flags);
    }

    @Override
    public boolean addWhitelistedRestrictedPermission(@NonNull String packageName, @NonNull String permName, int flags) {
        return this.getPermissionManager().addAllowlistedRestrictedPermission(packageName, permName, flags);
    }

    @Override
    public boolean setAutoRevokeWhitelisted(@NonNull String packageName, boolean whitelisted) {
        return this.getPermissionManager().setAutoRevokeExempted(packageName, whitelisted);
    }

    @Override
    public boolean isAutoRevokeWhitelisted(@NonNull String packageName) {
        return this.getPermissionManager().isAutoRevokeExempted(packageName);
    }

    @Override
    public boolean removeWhitelistedRestrictedPermission(@NonNull String packageName, @NonNull String permName, int flags) {
        return this.getPermissionManager().removeAllowlistedRestrictedPermission(packageName, permName, flags);
    }

    @Override
    @UnsupportedAppUsage
    public boolean shouldShowRequestPermissionRationale(String permName) {
        return this.getPermissionManager().shouldShowRequestPermissionRationale(permName);
    }

    @Override
    public Intent buildRequestPermissionsIntent(@NonNull String[] permissions) {
        Intent intent = super.buildRequestPermissionsIntent(permissions);
        intent.putExtra("android.content.pm.extra.REQUEST_PERMISSIONS_DEVICE_ID", this.mContext.getDeviceId());
        return intent;
    }

    @Override
    public CharSequence getBackgroundPermissionOptionLabel() {
        try {
            String permissionController = this.getPermissionControllerPackageName();
            Context context = this.mContext.createPackageContext(permissionController, 0);
            int textId = context.getResources().getIdentifier(APP_PERMISSION_BUTTON_ALLOW_ALWAYS, "string", PERMISSION_CONTROLLER_RESOURCE_PACKAGE);
            if (textId != 0) {
                return context.getText(textId);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Permission controller not found.", e);
        }
        return "";
    }

    @Override
    public int checkSignatures(String pkg1, String pkg2) {
        try {
            return this.mPM.checkSignatures(pkg1, pkg2, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public int checkSignatures(int uid1, int uid2) {
        try {
            return this.mPM.checkUidSignatures(uid1, uid2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean hasSigningCertificate(String packageName, byte[] certificate, int type) {
        try {
            return this.mPM.hasSigningCertificate(packageName, certificate, type);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean hasSigningCertificate(int uid, byte[] certificate, int type) {
        try {
            return this.mPM.hasUidSigningCertificate(uid, certificate, type);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void setPageSizeAppCompatFlagsSettingsOverride(String packageName, boolean enabled) {
        try {
            this.mPM.setPageSizeAppCompatFlagsSettingsOverride(packageName, enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean isPageSizeCompatEnabled(String packageName) {
        try {
            return this.mPM.isPageSizeCompatEnabled(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public String getPageSizeCompatWarningMessage(String packageName) {
        try {
            return this.mPM.getPageSizeCompatWarningMessage(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static List<byte[]> encodeCertificates(List<Certificate> certs) throws CertificateEncodingException {
        if (certs == null) {
            return null;
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>(certs.size());
        for (Certificate cert : certs) {
            if (!(cert instanceof X509Certificate)) {
                throw new CertificateEncodingException("Only X509 certificates supported.");
            }
            result.add(cert.getEncoded());
        }
        return result;
    }

    @Override
    public void requestChecksums(@NonNull String packageName, boolean includeSplits, int required, @NonNull List<Certificate> trustedInstallers, final @NonNull PackageManager.OnChecksumsReadyListener onChecksumsReadyListener) throws CertificateEncodingException, PackageManager.NameNotFoundException {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(onChecksumsReadyListener);
        Objects.requireNonNull(trustedInstallers);
        if (trustedInstallers == TRUST_ALL) {
            trustedInstallers = null;
        } else if (trustedInstallers == TRUST_NONE) {
            trustedInstallers = Collections.emptyList();
        } else if (trustedInstallers.isEmpty()) {
            throw new IllegalArgumentException("trustedInstallers has to be one of TRUST_ALL/TRUST_NONE or a non-empty list of certificates.");
        }
        try {
            IOnChecksumsReadyListener.Stub onChecksumsReadyListenerDelegate = new IOnChecksumsReadyListener.Stub(this){

                @Override
                public void onChecksumsReady(List<ApkChecksum> checksums) throws RemoteException {
                    onChecksumsReadyListener.onChecksumsReady(checksums);
                }
            };
            this.mPM.requestPackageChecksums(packageName, includeSplits, 127, required, ApplicationPackageManager.encodeCertificates(trustedInstallers), onChecksumsReadyListenerDelegate, this.getUserId());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(PackageManager.NameNotFoundException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public String[] getPackagesForUid(int uid) {
        return sGetPackagesForUidCache.query(uid).value();
    }

    public static void disableGetPackagesForUidCache() {
        sGetPackagesForUidCache.disableLocal();
    }

    public static void invalidateGetPackagesForUidCache() {
        sGetPackagesForUidCache.invalidateCache();
    }

    @Override
    public String getNameForUid(int uid) {
        try {
            return this.mPM.getNameForUid(uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public String[] getNamesForUids(int[] uids) {
        try {
            return this.mPM.getNamesForUids(uids);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public int getUidForSharedUser(String sharedUserName) throws PackageManager.NameNotFoundException {
        try {
            int uid = this.mPM.getUidForSharedUser(sharedUserName);
            if (uid != -1) {
                return uid;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException("No shared userid for user:" + sharedUserName);
    }

    @Override
    public List<ModuleInfo> getInstalledModules(int flags) {
        try {
            return this.mPM.getInstalledModules(flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public ModuleInfo getModuleInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        try {
            ModuleInfo mi = this.mPM.getModuleInfo(packageName, flags);
            if (mi != null) {
                return mi;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException("No module info for package: " + packageName);
    }

    @Override
    public List<PackageInfo> getInstalledPackages(int flags) {
        return this.getInstalledPackages(PackageManager.PackageInfoFlags.of(flags));
    }

    @Override
    public List<PackageInfo> getInstalledPackages(PackageManager.PackageInfoFlags flags) {
        return this.getInstalledPackagesAsUser(flags, this.getUserId());
    }

    @Override
    public List<PackageInfo> getInstalledPackagesAsUser(int flags, int userId) {
        return this.getInstalledPackagesAsUser(PackageManager.PackageInfoFlags.of(flags), userId);
    }

    @Override
    public List<PackageInfo> getInstalledPackagesAsUser(PackageManager.PackageInfoFlags flags, int userId) {
        try {
            ParceledListSlice parceledList = this.mPM.getInstalledPackages(this.updateFlagsForPackage(flags.getValue(), userId), userId);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @NonNull
    public PersistableBundle getAppMetadata(@NonNull String packageName) throws PackageManager.NameNotFoundException {
        PersistableBundle appMetadata = null;
        ParcelFileDescriptor pfd = null;
        try {
            pfd = this.mPM.getAppMetadataFd(packageName, this.getUserId());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(PackageManager.NameNotFoundException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (pfd != null) {
            try (ParcelFileDescriptor.AutoCloseInputStream inputStream = new ParcelFileDescriptor.AutoCloseInputStream(pfd);){
                appMetadata = PersistableBundle.readFromStream(inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return appMetadata != null ? appMetadata : new PersistableBundle();
    }

    @Override
    public int getAppMetadataSource(@NonNull String packageName) throws PackageManager.NameNotFoundException {
        Objects.requireNonNull(packageName, "packageName cannot be null");
        int source = 0;
        try {
            source = this.mPM.getAppMetadataSource(packageName, this.getUserId());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(PackageManager.NameNotFoundException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return source;
    }

    @Override
    public List<PackageInfo> getPackagesHoldingPermissions(String[] permissions, int flags) {
        return this.getPackagesHoldingPermissions(permissions, PackageManager.PackageInfoFlags.of(flags));
    }

    @Override
    public List<PackageInfo> getPackagesHoldingPermissions(String[] permissions, PackageManager.PackageInfoFlags flags) {
        int userId = this.getUserId();
        try {
            ParceledListSlice parceledList = this.mPM.getPackagesHoldingPermissions(permissions, this.updateFlagsForPackage(flags.getValue(), userId), userId);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public List<ApplicationInfo> getInstalledApplications(int flags) {
        return this.getInstalledApplicationsAsUser(flags, this.getUserId());
    }

    @Override
    public List<ApplicationInfo> getInstalledApplications(PackageManager.ApplicationInfoFlags flags) {
        return this.getInstalledApplicationsAsUser(flags, this.getUserId());
    }

    @Override
    public List<ApplicationInfo> getInstalledApplicationsAsUser(int flags, int userId) {
        return this.getInstalledApplicationsAsUser(PackageManager.ApplicationInfoFlags.of(flags), userId);
    }

    @Override
    public List<ApplicationInfo> getInstalledApplicationsAsUser(PackageManager.ApplicationInfoFlags flags, int userId) {
        try {
            ParceledListSlice parceledList = this.mPM.getInstalledApplications(this.updateFlagsForApplication(flags.getValue(), userId), userId);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public List<InstantAppInfo> getInstantApps() {
        try {
            ParceledListSlice slice = this.mPM.getInstantApps(this.getUserId());
            if (slice != null) {
                return slice.getList();
            }
            return Collections.emptyList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public Drawable getInstantAppIcon(String packageName) {
        try {
            Bitmap bitmap = this.mPM.getInstantAppIcon(packageName, this.getUserId());
            if (bitmap != null) {
                return new BitmapDrawable(null, bitmap);
            }
            return null;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean isInstantApp() {
        return this.isInstantApp(this.mContext.getPackageName());
    }

    @Override
    public boolean isInstantApp(String packageName) {
        try {
            return this.mPM.isInstantApp(packageName, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public int getInstantAppCookieMaxBytes() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "ephemeral_cookie_max_size_bytes", 16384);
    }

    @Override
    public int getInstantAppCookieMaxSize() {
        return this.getInstantAppCookieMaxBytes();
    }

    @Override
    @NonNull
    public byte[] getInstantAppCookie() {
        try {
            byte[] cookie = this.mPM.getInstantAppCookie(this.mContext.getPackageName(), this.getUserId());
            if (cookie != null) {
                return cookie;
            }
            return EmptyArray.BYTE;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void clearInstantAppCookie() {
        this.updateInstantAppCookie(null);
    }

    @Override
    public void updateInstantAppCookie(@NonNull byte[] cookie) {
        if (cookie != null && cookie.length > this.getInstantAppCookieMaxBytes()) {
            throw new IllegalArgumentException("instant cookie longer than " + this.getInstantAppCookieMaxBytes());
        }
        try {
            this.mPM.setInstantAppCookie(this.mContext.getPackageName(), cookie, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean setInstantAppCookie(@NonNull byte[] cookie) {
        try {
            return this.mPM.setInstantAppCookie(this.mContext.getPackageName(), cookie, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public ResolveInfo resolveActivity(Intent intent, int flags) {
        return this.resolveActivity(intent, PackageManager.ResolveInfoFlags.of(flags));
    }

    @Override
    public ResolveInfo resolveActivity(Intent intent, PackageManager.ResolveInfoFlags flags) {
        return this.resolveActivityAsUser(intent, null, flags, this.getUserId());
    }

    @Override
    public ResolveInfo resolveActivityAsUser(Intent intent, int flags, int userId) {
        return this.resolveActivityAsUser(intent, null, PackageManager.ResolveInfoFlags.of(flags), userId);
    }

    @Override
    public ResolveInfo resolveActivityAsUser(Intent intent, PackageManager.ResolveInfoFlags flags, int userId) {
        return this.resolveActivityAsUser(intent, null, flags, userId);
    }

    @Override
    public ResolveInfo resolveActivityAsUser(Intent intent, String resolvedType, int flags, int userId) {
        return this.resolveActivityAsUser(intent, resolvedType, PackageManager.ResolveInfoFlags.of(flags), userId);
    }

    @Override
    public ResolveInfo resolveActivityAsUser(Intent intent, String resolvedType, PackageManager.ResolveInfoFlags flags, int userId) {
        try {
            return this.mPM.resolveIntent(intent, resolvedType == null ? intent.resolveTypeIfNeeded(this.mContext.getContentResolver()) : resolvedType, this.updateFlagsForComponent(flags.getValue(), userId, intent), userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
        return this.queryIntentActivities(intent, PackageManager.ResolveInfoFlags.of(flags));
    }

    @Override
    public List<ResolveInfo> queryIntentActivities(Intent intent, PackageManager.ResolveInfoFlags flags) {
        return this.queryIntentActivitiesAsUser(intent, flags, this.getUserId());
    }

    @Override
    public List<ResolveInfo> queryIntentActivitiesAsUser(Intent intent, int flags, int userId) {
        return this.queryIntentActivitiesAsUser(intent, PackageManager.ResolveInfoFlags.of(flags), userId);
    }

    @Override
    public List<ResolveInfo> queryIntentActivitiesAsUser(Intent intent, PackageManager.ResolveInfoFlags flags, int userId) {
        try {
            ParceledListSlice parceledList = this.mPM.queryIntentActivities(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), this.updateFlagsForComponent(flags.getValue(), userId, intent), userId);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, Intent intent, int flags) {
        return this.queryIntentActivityOptions(caller, specifics == null ? null : new ArrayList<Intent>(Arrays.asList(specifics)), intent, PackageManager.ResolveInfoFlags.of(flags));
    }

    @Override
    public List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, List<Intent> specifics, Intent intent, PackageManager.ResolveInfoFlags flags) {
        int userId = this.getUserId();
        ContentResolver resolver = this.mContext.getContentResolver();
        String[] specificTypes = null;
        if (specifics != null) {
            int numSpecifics = specifics.size();
            for (int i = 0; i < numSpecifics; ++i) {
                String t;
                Intent sp = specifics.get(i);
                if (sp == null || (t = sp.resolveTypeIfNeeded(resolver)) == null) continue;
                if (specificTypes == null) {
                    specificTypes = new String[numSpecifics];
                }
                specificTypes[i] = t;
            }
        }
        try {
            ParceledListSlice parceledList = this.mPM.queryIntentActivityOptions(caller, specifics == null ? null : specifics.toArray(new Intent[0]), specificTypes, intent, intent.resolveTypeIfNeeded(resolver), this.updateFlagsForComponent(flags.getValue(), userId, intent), userId);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public List<ResolveInfo> queryBroadcastReceiversAsUser(Intent intent, int flags, int userId) {
        return this.queryBroadcastReceiversAsUser(intent, PackageManager.ResolveInfoFlags.of(flags), userId);
    }

    @Override
    public List<ResolveInfo> queryBroadcastReceiversAsUser(Intent intent, PackageManager.ResolveInfoFlags flags, int userId) {
        try {
            ParceledListSlice parceledList = this.mPM.queryIntentReceivers(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), this.updateFlagsForComponent(flags.getValue(), userId, intent), userId);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags) {
        return this.queryBroadcastReceivers(intent, PackageManager.ResolveInfoFlags.of(flags));
    }

    @Override
    public List<ResolveInfo> queryBroadcastReceivers(Intent intent, PackageManager.ResolveInfoFlags flags) {
        return this.queryBroadcastReceiversAsUser(intent, flags, this.getUserId());
    }

    @Override
    public ResolveInfo resolveServiceAsUser(Intent intent, int flags, int userId) {
        return this.resolveServiceAsUser(intent, PackageManager.ResolveInfoFlags.of(flags), userId);
    }

    @Override
    public ResolveInfo resolveServiceAsUser(Intent intent, PackageManager.ResolveInfoFlags flags, int userId) {
        try {
            return this.mPM.resolveService(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), this.updateFlagsForComponent(flags.getValue(), userId, intent), userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public ResolveInfo resolveService(Intent intent, int flags) {
        return this.resolveService(intent, PackageManager.ResolveInfoFlags.of(flags));
    }

    @Override
    public ResolveInfo resolveService(Intent intent, PackageManager.ResolveInfoFlags flags) {
        return this.resolveServiceAsUser(intent, flags, this.getUserId());
    }

    @Override
    public List<ResolveInfo> queryIntentServicesAsUser(Intent intent, int flags, int userId) {
        return this.queryIntentServicesAsUser(intent, PackageManager.ResolveInfoFlags.of(flags), userId);
    }

    @Override
    public List<ResolveInfo> queryIntentServicesAsUser(Intent intent, PackageManager.ResolveInfoFlags flags, int userId) {
        try {
            ParceledListSlice parceledList = this.mPM.queryIntentServices(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), this.updateFlagsForComponent(flags.getValue(), userId, intent), userId);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public List<ResolveInfo> queryIntentServices(Intent intent, int flags) {
        return this.queryIntentServices(intent, PackageManager.ResolveInfoFlags.of(flags));
    }

    @Override
    public List<ResolveInfo> queryIntentServices(Intent intent, PackageManager.ResolveInfoFlags flags) {
        return this.queryIntentServicesAsUser(intent, flags, this.getUserId());
    }

    @Override
    public List<ResolveInfo> queryIntentContentProvidersAsUser(Intent intent, int flags, int userId) {
        return this.queryIntentContentProvidersAsUser(intent, PackageManager.ResolveInfoFlags.of(flags), userId);
    }

    @Override
    public List<ResolveInfo> queryIntentContentProvidersAsUser(Intent intent, PackageManager.ResolveInfoFlags flags, int userId) {
        try {
            ParceledListSlice parceledList = this.mPM.queryIntentContentProviders(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), this.updateFlagsForComponent(flags.getValue(), userId, intent), userId);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public List<ResolveInfo> queryIntentContentProviders(Intent intent, int flags) {
        return this.queryIntentContentProviders(intent, PackageManager.ResolveInfoFlags.of(flags));
    }

    @Override
    public List<ResolveInfo> queryIntentContentProviders(Intent intent, PackageManager.ResolveInfoFlags flags) {
        return this.queryIntentContentProvidersAsUser(intent, flags, this.getUserId());
    }

    @Override
    public ProviderInfo resolveContentProvider(String name, int flags) {
        return this.resolveContentProvider(name, PackageManager.ComponentInfoFlags.of(flags));
    }

    @Override
    public ProviderInfo resolveContentProvider(String name, PackageManager.ComponentInfoFlags flags) {
        return this.resolveContentProviderAsUser(name, flags, this.getUserId());
    }

    @Override
    public ProviderInfo resolveContentProviderAsUser(String name, int flags, int userId) {
        return this.resolveContentProviderAsUser(name, PackageManager.ComponentInfoFlags.of(flags), userId);
    }

    @Override
    public ProviderInfo resolveContentProviderAsUser(String name, PackageManager.ComponentInfoFlags flags, int userId) {
        try {
            return this.mPM.resolveContentProvider(name, this.updateFlagsForComponent(flags.getValue(), userId, null), userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public ProviderInfo resolveContentProviderForUid(@NonNull String authority, PackageManager.ComponentInfoFlags flags, int callingUid) {
        try {
            return this.mPM.resolveContentProviderForUid(authority, this.updateFlagsForComponent(flags.getValue(), this.getUserId(), null), this.getUserId(), callingUid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public List<ProviderInfo> queryContentProviders(String processName, int uid, int flags) {
        return this.queryContentProviders(processName, uid, PackageManager.ComponentInfoFlags.of(flags));
    }

    @Override
    public List<ProviderInfo> queryContentProviders(String processName, int uid, PackageManager.ComponentInfoFlags flags) {
        return this.queryContentProviders(processName, uid, flags, null);
    }

    @Override
    public List<ProviderInfo> queryContentProviders(String processName, int uid, int flags, String metaDataKey) {
        return this.queryContentProviders(processName, uid, PackageManager.ComponentInfoFlags.of(flags), metaDataKey);
    }

    @Override
    public List<ProviderInfo> queryContentProviders(String processName, int uid, PackageManager.ComponentInfoFlags flags, String metaDataKey) {
        try {
            ParceledListSlice slice = this.mPM.queryContentProviders(processName, uid, this.updateFlagsForComponent(flags.getValue(), UserHandle.getUserId(uid), null), metaDataKey);
            return slice != null ? slice.getList() : Collections.emptyList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public InstrumentationInfo getInstrumentationInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        try {
            InstrumentationInfo ii = this.mPM.getInstrumentationInfoAsUser(className, flags, this.getUserId());
            if (ii != null) {
                return ii;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException(className.toString());
    }

    @Override
    public List<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
        try {
            ParceledListSlice parceledList = this.mPM.queryInstrumentationAsUser(targetPackage, flags, this.getUserId());
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @Nullable
    public Drawable getDrawable(String packageName, int resId, @Nullable ApplicationInfo appInfo) {
        ResourceName name = new ResourceName(packageName, resId);
        Drawable cachedIcon = this.getCachedIcon(name);
        if (cachedIcon != null) {
            return cachedIcon;
        }
        if (appInfo == null) {
            try {
                appInfo = this.getApplicationInfo(packageName, 1024);
            }
            catch (PackageManager.NameNotFoundException e) {
                return null;
            }
        }
        if (resId != 0) {
            try {
                Resources r = this.getResourcesForApplication(appInfo);
                Drawable dr = r.getDrawable(resId, null);
                if (dr != null) {
                    this.putCachedIcon(name, dr);
                }
                return dr;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w("PackageManager", "Failure retrieving resources for " + appInfo.packageName);
            }
            catch (Resources.NotFoundException e) {
                Log.w("PackageManager", "Failure retrieving resources for " + appInfo.packageName + ": " + e.getMessage());
            }
            catch (Exception e) {
                Log.w("PackageManager", "Failure retrieving icon 0x" + Integer.toHexString(resId) + " in package " + packageName, e);
            }
        }
        return null;
    }

    @Override
    public Drawable getActivityIcon(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return this.getActivityInfo(activityName, 1024).loadIcon(this);
    }

    @Override
    public Drawable getActivityIcon(Intent intent) throws PackageManager.NameNotFoundException {
        if (intent.getComponent() != null) {
            return this.getActivityIcon(intent.getComponent());
        }
        ResolveInfo info = this.resolveActivity(intent, 65536);
        if (info != null) {
            return info.activityInfo.loadIcon(this);
        }
        throw new PackageManager.NameNotFoundException(intent.toUri(0));
    }

    @Override
    public Drawable getDefaultActivityIcon() {
        return this.mContext.getDrawable(17301651);
    }

    @Override
    public Drawable getApplicationIcon(ApplicationInfo info) {
        return info.loadIcon(this);
    }

    @Override
    public Drawable getApplicationIcon(String packageName) throws PackageManager.NameNotFoundException {
        return this.getApplicationIcon(this.getApplicationInfo(packageName, 1024));
    }

    @Override
    public Drawable getActivityBanner(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return this.getActivityInfo(activityName, 1024).loadBanner(this);
    }

    @Override
    public Drawable getActivityBanner(Intent intent) throws PackageManager.NameNotFoundException {
        if (intent.getComponent() != null) {
            return this.getActivityBanner(intent.getComponent());
        }
        ResolveInfo info = this.resolveActivity(intent, 65536);
        if (info != null) {
            return info.activityInfo.loadBanner(this);
        }
        throw new PackageManager.NameNotFoundException(intent.toUri(0));
    }

    @Override
    public Drawable getApplicationBanner(ApplicationInfo info) {
        return info.loadBanner(this);
    }

    @Override
    public Drawable getApplicationBanner(String packageName) throws PackageManager.NameNotFoundException {
        return this.getApplicationBanner(this.getApplicationInfo(packageName, 1024));
    }

    @Override
    public Drawable getActivityLogo(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return this.getActivityInfo(activityName, 1024).loadLogo(this);
    }

    @Override
    public Drawable getActivityLogo(Intent intent) throws PackageManager.NameNotFoundException {
        if (intent.getComponent() != null) {
            return this.getActivityLogo(intent.getComponent());
        }
        ResolveInfo info = this.resolveActivity(intent, 65536);
        if (info != null) {
            return info.activityInfo.loadLogo(this);
        }
        throw new PackageManager.NameNotFoundException(intent.toUri(0));
    }

    @Override
    public Drawable getApplicationLogo(ApplicationInfo info) {
        return info.loadLogo(this);
    }

    @Override
    public Drawable getApplicationLogo(String packageName) throws PackageManager.NameNotFoundException {
        return this.getApplicationLogo(this.getApplicationInfo(packageName, 1024));
    }

    @Override
    public Drawable getUserBadgedIcon(Drawable icon, UserHandle user) {
        if (!this.hasUserBadge(user.getIdentifier())) {
            return icon;
        }
        Drawable badgeForeground = this.getDevicePolicyManager().getResources().getDrawable(this.getUpdatableUserIconBadgeId(user), "SOLID_COLORED", () -> this.getDefaultUserIconBadge(user));
        Drawable badge = new LauncherIcons(this.mContext).getBadgeDrawable(badgeForeground, this.getUserBadgeColor(user, false));
        return this.getBadgedDrawable(icon, badge, null, true);
    }

    private String getUpdatableUserIconBadgeId(UserHandle user) {
        return this.getUserManager().isManagedProfile(user.getIdentifier()) ? "WORK_PROFILE_ICON_BADGE" : "UNDEFINED";
    }

    private Drawable getDefaultUserIconBadge(UserHandle user) {
        return this.mContext.getDrawable(this.getUserManager().getUserIconBadgeResId(user.getIdentifier()));
    }

    @Override
    public Drawable getUserBadgedDrawableForDensity(Drawable drawable2, UserHandle user, Rect badgeLocation, int badgeDensity) {
        Drawable badgeDrawable = this.getUserBadgeForDensity(user, badgeDensity);
        if (badgeDrawable == null) {
            return drawable2;
        }
        return this.getBadgedDrawable(drawable2, badgeDrawable, badgeLocation, true);
    }

    private int getUserBadgeColor(UserHandle user, boolean checkTheme) {
        if (checkTheme && this.mContext.getResources().getConfiguration().isNightModeActive()) {
            return this.getUserManager().getUserBadgeDarkColor(user.getIdentifier());
        }
        return this.getUserManager().getUserBadgeColor(user.getIdentifier());
    }

    @Override
    public Drawable getUserBadgeForDensity(UserHandle user, int density) {
        Drawable badgeColor = this.getProfileIconForDensity(user, 17302547, density);
        if (badgeColor == null) {
            return null;
        }
        Drawable badgeForeground = this.getDevicePolicyManager().getResources().getDrawableForDensity(this.getUpdatableUserBadgeId(user), "SOLID_COLORED", density, () -> this.getDefaultUserBadgeForDensity(user, density));
        badgeForeground.setTint(this.getUserBadgeColor(user, false));
        LayerDrawable badge = new LayerDrawable(new Drawable[]{badgeColor, badgeForeground});
        return badge;
    }

    private String getUpdatableUserBadgeId(UserHandle user) {
        return this.getUserManager().isManagedProfile(user.getIdentifier()) ? "WORK_PROFILE_ICON" : "UNDEFINED";
    }

    private Drawable getDefaultUserBadgeForDensity(UserHandle user, int density) {
        return this.getDrawableForDensity(this.getUserManager().getUserBadgeResId(user.getIdentifier()), density);
    }

    @Override
    public Drawable getUserBadgeForDensityNoBackground(UserHandle user, int density) {
        if (!this.hasUserBadge(user.getIdentifier())) {
            return null;
        }
        Drawable badge = this.getDevicePolicyManager().getResources().getDrawableForDensity(this.getUpdatableUserBadgeId(user), "SOLID_NOT_COLORED", density, () -> this.getDefaultUserBadgeNoBackgroundForDensity(user, density));
        if (badge != null) {
            badge.setTint(this.getUserBadgeColor(user, true));
        }
        return badge;
    }

    private Drawable getDefaultUserBadgeNoBackgroundForDensity(UserHandle user, int density) {
        return this.getDrawableForDensity(this.getUserManager().getUserBadgeNoBackgroundResId(user.getIdentifier()), density);
    }

    private Drawable getDrawableForDensity(int drawableId, int density) {
        if (density <= 0) {
            density = this.mContext.getResources().getDisplayMetrics().densityDpi;
        }
        return this.mContext.getResources().getDrawableForDensity(drawableId, density);
    }

    private Drawable getProfileIconForDensity(UserHandle user, int drawableId, int density) {
        if (this.hasUserBadge(user.getIdentifier())) {
            return this.getDrawableForDensity(drawableId, density);
        }
        return null;
    }

    @Override
    public CharSequence getUserBadgedLabel(CharSequence label, UserHandle user) {
        return this.getUserManager().getBadgedLabelForUser(label, user);
    }

    @Override
    public Resources getResourcesForActivity(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return this.getResourcesForApplication(this.getActivityInfo((ComponentName)activityName, (int)1024).applicationInfo);
    }

    @Override
    public Resources getResourcesForApplication(@NonNull ApplicationInfo app) throws PackageManager.NameNotFoundException {
        return this.getResourcesForApplication(app, null);
    }

    @Override
    public Resources getResourcesForApplication(@NonNull ApplicationInfo app, @Nullable Configuration configuration) throws PackageManager.NameNotFoundException {
        if (app.packageName.equals("system")) {
            Context sysuiContext = this.mContext.mMainThread.getSystemUiContext();
            if (configuration != null) {
                sysuiContext = sysuiContext.createConfigurationContext(configuration);
            }
            return sysuiContext.getResources();
        }
        boolean sameUid = app.uid == Process.myUid();
        Resources r = this.mContext.mMainThread.getTopLevelResources(sameUid ? app.sourceDir : app.publicSourceDir, sameUid ? app.splitSourceDirs : app.splitPublicSourceDirs, app.resourceDirs, app.overlayPaths, app.sharedLibraryFiles, this.mContext.mPackageInfo, configuration);
        if (r != null) {
            if (com.android.internal.hidden_from_bootclasspath.android.content.res.Flags.defaultLocale() && r.getConfiguration().getLocales().size() > 1) {
                LocaleConfig lc = new LocaleConfig(app, r);
                r.setLocaleConfig(lc);
            }
            return r;
        }
        throw new PackageManager.NameNotFoundException("Unable to open " + app.publicSourceDir);
    }

    @Override
    public Resources getResourcesForApplication(String appPackageName) throws PackageManager.NameNotFoundException {
        return this.getResourcesForApplication(this.getApplicationInfo(appPackageName, 1024));
    }

    @Override
    public Resources getResourcesForApplicationAsUser(String appPackageName, int userId) throws PackageManager.NameNotFoundException {
        if (userId < 0) {
            throw new IllegalArgumentException("Call does not support special user #" + userId);
        }
        if ("system".equals(appPackageName)) {
            return this.mContext.mMainThread.getSystemUiContext().getResources();
        }
        try {
            ApplicationInfo ai = this.mPM.getApplicationInfo(appPackageName, 1024L, userId);
            if (ai != null) {
                return this.getResourcesForApplication(ai);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        throw new PackageManager.NameNotFoundException("Package " + appPackageName + " doesn't exist");
    }

    @Override
    public boolean isSafeMode() {
        try {
            if (this.mCachedSafeMode < 0) {
                this.mCachedSafeMode = this.mPM.isSafeMode() ? 1 : 0;
            }
            return this.mCachedSafeMode != 0;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void addOnPermissionsChangeListener(PackageManager.OnPermissionsChangedListener listener) {
        this.getPermissionManager().addOnPermissionsChangeListener(listener);
    }

    @Override
    public void removeOnPermissionsChangeListener(PackageManager.OnPermissionsChangedListener listener) {
        this.getPermissionManager().removeOnPermissionsChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @RavenwoodReplace(reason="<cinit> crashes due to unsupported class PropertyInvalidatedCache")
    static void configurationChanged() {
        Object object = sSync;
        synchronized (object) {
            sIconCache.clear();
            sStringCache.clear();
        }
    }

    private static void configurationChanged$ravenwood() {
    }

    @UnsupportedAppUsage
    protected ApplicationPackageManager(ContextImpl context, IPackageManager pm) {
        this.mContext = context;
        this.mPM = pm;
        this.mUseSystemFeaturesCache = ApplicationPackageManager.isSystemFeaturesCacheEnabledAndAvailable();
    }

    private static boolean isSystemFeaturesCacheEnabledAndAvailable() {
        if (!Flags.cacheSdkSystemFeatures()) {
            return false;
        }
        return !ActivityThread.isSystem() || SystemFeaturesCache.hasInstance();
    }

    private long updateFlagsForPackage(long flags, int userId) {
        if ((flags & 0xFL) != 0L && (flags & 0x100C0000L) == 0L) {
            this.onImplicitDirectBoot(userId);
        }
        return flags;
    }

    private long updateFlagsForApplication(long flags, int userId) {
        return this.updateFlagsForPackage(flags, userId);
    }

    private long updateFlagsForComponent(long flags, int userId, Intent intent) {
        if (intent != null && (intent.getFlags() & 0x100) != 0) {
            flags |= 0x10000000L;
        }
        if ((flags & 0x100C0000L) == 0L) {
            this.onImplicitDirectBoot(userId);
        }
        return flags;
    }

    private void onImplicitDirectBoot(int userId) {
        if (StrictMode.vmImplicitDirectBootEnabled()) {
            if (userId == UserHandle.myUserId()) {
                if (this.mUserUnlocked) {
                    return;
                }
                if (this.mContext.getSystemService(UserManager.class).isUserUnlockingOrUnlocked(userId)) {
                    this.mUserUnlocked = true;
                } else {
                    StrictMode.onImplicitDirectBoot();
                }
            } else if (!this.mContext.getSystemService(UserManager.class).isUserUnlockingOrUnlocked(userId)) {
                StrictMode.onImplicitDirectBoot();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Drawable getCachedIcon(@NonNull ResourceName name) {
        Object object = sSync;
        synchronized (object) {
            WeakReference<Drawable.ConstantState> wr = sIconCache.get(name);
            if (wr != null) {
                Drawable.ConstantState state = (Drawable.ConstantState)wr.get();
                if (state != null) {
                    return state.newDrawable();
                }
                sIconCache.remove(name);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedIcon(@NonNull ResourceName name, @NonNull Drawable dr) {
        Object object = sSync;
        synchronized (object) {
            sIconCache.put(name, new WeakReference<Drawable.ConstantState>(dr.getConstantState()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handlePackageBroadcast(int cmd, String[] pkgList, boolean hasPkgInfo) {
        boolean immediateGc = false;
        if (cmd == 1) {
            immediateGc = true;
        }
        if (pkgList != null && pkgList.length > 0) {
            boolean needCleanup = false;
            for (String ssp : pkgList) {
                Object object = sSync;
                synchronized (object) {
                    ResourceName nm;
                    int i;
                    for (i = sIconCache.size() - 1; i >= 0; --i) {
                        nm = sIconCache.keyAt(i);
                        if (!nm.packageName.equals(ssp)) continue;
                        sIconCache.removeAt(i);
                        needCleanup = true;
                    }
                    for (i = sStringCache.size() - 1; i >= 0; --i) {
                        nm = sStringCache.keyAt(i);
                        if (!nm.packageName.equals(ssp)) continue;
                        sStringCache.removeAt(i);
                        needCleanup = true;
                    }
                }
            }
            if (needCleanup || hasPkgInfo) {
                if (immediateGc) {
                    Runtime.getRuntime().gc();
                } else {
                    ActivityThread.currentActivityThread().scheduleGcIdler();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence getCachedString(ResourceName name) {
        Object object = sSync;
        synchronized (object) {
            WeakReference<CharSequence> wr = sStringCache.get(name);
            if (wr != null) {
                CharSequence cs = (CharSequence)wr.get();
                if (cs != null) {
                    return cs;
                }
                sStringCache.remove(name);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedString(ResourceName name, CharSequence cs) {
        Object object = sSync;
        synchronized (object) {
            sStringCache.put(name, new WeakReference<CharSequence>(cs));
        }
    }

    @Override
    public CharSequence getText(String packageName, int resid, ApplicationInfo appInfo) {
        ResourceName name = new ResourceName(packageName, resid);
        CharSequence text = this.getCachedString(name);
        if (text != null) {
            return text;
        }
        if (appInfo == null) {
            try {
                appInfo = this.getApplicationInfo(packageName, 1024);
            }
            catch (PackageManager.NameNotFoundException e) {
                return null;
            }
        }
        try {
            Resources r = this.getResourcesForApplication(appInfo);
            text = r.getText(resid);
            this.putCachedString(name, text);
            return text;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w("PackageManager", "Failure retrieving resources for " + appInfo.packageName);
        }
        catch (RuntimeException e) {
            Log.w("PackageManager", "Failure retrieving text 0x" + Integer.toHexString(resid) + " in package " + packageName, e);
        }
        return null;
    }

    @Override
    public XmlResourceParser getXml(String packageName, int resid, ApplicationInfo appInfo) {
        if (appInfo == null) {
            try {
                appInfo = this.getApplicationInfo(packageName, 1024);
            }
            catch (PackageManager.NameNotFoundException e) {
                return null;
            }
        }
        try {
            Resources r = this.getResourcesForApplication(appInfo);
            return r.getXml(resid);
        }
        catch (RuntimeException e) {
            Log.w("PackageManager", "Failure retrieving xml 0x" + Integer.toHexString(resid) + " in package " + packageName, e);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w("PackageManager", "Failure retrieving resources for " + appInfo.packageName);
        }
        return null;
    }

    @Override
    public CharSequence getApplicationLabel(ApplicationInfo info) {
        return info.loadLabel(this);
    }

    @Override
    public int installExistingPackage(String packageName) throws PackageManager.NameNotFoundException {
        return this.installExistingPackage(packageName, 0);
    }

    @Override
    public int installExistingPackage(String packageName, int installReason) throws PackageManager.NameNotFoundException {
        return this.installExistingPackageAsUser(packageName, installReason, this.getUserId());
    }

    @Override
    public int installExistingPackageAsUser(String packageName, int userId) throws PackageManager.NameNotFoundException {
        return this.installExistingPackageAsUser(packageName, 0, userId);
    }

    private int installExistingPackageAsUser(String packageName, int installReason, int userId) throws PackageManager.NameNotFoundException {
        try {
            int res = this.mPM.installExistingPackageAsUser(packageName, userId, 0x400000, installReason, null);
            if (res == -3) {
                throw new PackageManager.NameNotFoundException("Package " + packageName + " doesn't exist");
            }
            return res;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void verifyPendingInstall(int id2, int response) {
        try {
            this.mPM.verifyPendingInstall(id2, response);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void extendVerificationTimeout(int id2, int verificationCodeAtTimeout, long millisecondsToDelay) {
        try {
            this.mPM.extendVerificationTimeout(id2, verificationCodeAtTimeout, millisecondsToDelay);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void verifyIntentFilter(int id2, int verificationCode, List<String> failedDomains) {
        try {
            this.mPM.verifyIntentFilter(id2, verificationCode, failedDomains);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public int getIntentVerificationStatusAsUser(String packageName, int userId) {
        try {
            return this.mPM.getIntentVerificationStatus(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean updateIntentVerificationStatusAsUser(String packageName, int status, int userId) {
        try {
            return this.mPM.updateIntentVerificationStatus(packageName, status, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public List<IntentFilterVerificationInfo> getIntentFilterVerifications(String packageName) {
        try {
            ParceledListSlice parceledList = this.mPM.getIntentFilterVerifications(packageName);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public List<IntentFilter> getAllIntentFilters(String packageName) {
        try {
            ParceledListSlice parceledList = this.mPM.getAllIntentFilters(packageName);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public String getDefaultBrowserPackageNameAsUser(int userId) {
        RoleManager roleManager = this.mContext.getSystemService(RoleManager.class);
        return roleManager.getBrowserRoleHolder(userId);
    }

    @Override
    public boolean setDefaultBrowserPackageNameAsUser(String packageName, int userId) {
        RoleManager roleManager = this.mContext.getSystemService(RoleManager.class);
        return roleManager.setBrowserRoleHolder(packageName, userId);
    }

    @Override
    public void setInstallerPackageName(String targetPackage, String installerPackageName) {
        try {
            this.mPM.setInstallerPackageName(targetPackage, installerPackageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void setUpdateAvailable(String packageName, boolean updateAvailable) {
        try {
            this.mPM.setUpdateAvailable(packageName, updateAvailable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public String getInstallerPackageName(String packageName) {
        try {
            return this.mPM.getInstallerPackageName(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @NonNull
    public InstallSourceInfo getInstallSourceInfo(String packageName) throws PackageManager.NameNotFoundException {
        InstallSourceInfo installSourceInfo;
        try {
            installSourceInfo = this.mPM.getInstallSourceInfo(packageName, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (installSourceInfo == null) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        return installSourceInfo;
    }

    @Override
    public boolean isAppArchivable(String packageName) throws PackageManager.NameNotFoundException {
        try {
            Objects.requireNonNull(packageName);
            return this.mPM.isAppArchivable(packageName, new UserHandle(this.getUserId()));
        }
        catch (ParcelableException e) {
            e.maybeRethrow(PackageManager.NameNotFoundException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public int getMoveStatus(int moveId) {
        try {
            return this.mPM.getMoveStatus(moveId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMoveCallback(PackageManager.MoveCallback callback, Handler handler) {
        ArrayList<MoveCallbackDelegate> arrayList = this.mDelegates;
        synchronized (arrayList) {
            MoveCallbackDelegate delegate = new MoveCallbackDelegate(callback, handler.getLooper());
            try {
                this.mPM.registerMoveCallback(delegate);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mDelegates.add(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMoveCallback(PackageManager.MoveCallback callback) {
        ArrayList<MoveCallbackDelegate> arrayList = this.mDelegates;
        synchronized (arrayList) {
            Iterator<MoveCallbackDelegate> i = this.mDelegates.iterator();
            while (i.hasNext()) {
                MoveCallbackDelegate delegate = i.next();
                if (delegate.mCallback != callback) continue;
                try {
                    this.mPM.unregisterMoveCallback(delegate);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                i.remove();
            }
        }
    }

    @Override
    public int movePackage(String packageName, VolumeInfo vol) {
        try {
            String volumeUuid = "private".equals(vol.id) ? StorageManager.UUID_PRIVATE_INTERNAL : (vol.isPrimaryPhysical() ? "primary_physical" : Objects.requireNonNull(vol.fsUuid));
            return this.mPM.movePackage(packageName, volumeUuid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @Nullable
    public VolumeInfo getPackageCurrentVolume(ApplicationInfo app) {
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        return this.getPackageCurrentVolume(app, storage);
    }

    @VisibleForTesting
    @Nullable
    protected VolumeInfo getPackageCurrentVolume(ApplicationInfo app, StorageManager storage) {
        if (app.isInternal()) {
            return storage.findVolumeById("private");
        }
        return storage.findVolumeByUuid(app.volumeUuid);
    }

    @Override
    @NonNull
    public List<VolumeInfo> getPackageCandidateVolumes(ApplicationInfo app) {
        StorageManager storageManager = this.mContext.getSystemService(StorageManager.class);
        return this.getPackageCandidateVolumes(app, storageManager, this.mPM);
    }

    @VisibleForTesting
    @NonNull
    protected List<VolumeInfo> getPackageCandidateVolumes(ApplicationInfo app, StorageManager storageManager, IPackageManager pm) {
        VolumeInfo currentVol = this.getPackageCurrentVolume(app, storageManager);
        List<VolumeInfo> vols = storageManager.getVolumes();
        ArrayList<VolumeInfo> candidates = new ArrayList<VolumeInfo>();
        for (VolumeInfo vol : vols) {
            if (!Objects.equals(vol, currentVol) && !this.isPackageCandidateVolume(this.mContext, app, vol, pm)) continue;
            candidates.add(vol);
        }
        return candidates;
    }

    @VisibleForTesting
    protected boolean isForceAllowOnExternal(Context context) {
        return Settings.Global.getInt(context.getContentResolver(), "force_allow_on_external", 0) != 0;
    }

    @VisibleForTesting
    protected boolean isAllow3rdPartyOnInternal(Context context) {
        return context.getResources().getBoolean(0x1110016);
    }

    private boolean isPackageCandidateVolume(ContextImpl context, ApplicationInfo app, VolumeInfo vol, IPackageManager pm) {
        boolean forceAllowOnExternal = this.isForceAllowOnExternal(context);
        if ("private".equals(vol.getId())) {
            return app.isSystemApp() || this.isAllow3rdPartyOnInternal(context);
        }
        if (app.isSystemApp()) {
            return false;
        }
        if (!(forceAllowOnExternal || app.installLocation != 1 && app.installLocation != -1)) {
            return false;
        }
        if (!vol.isMountedWritable()) {
            return false;
        }
        if (vol.isPrimaryPhysical()) {
            return app.isInternal();
        }
        try {
            if (pm.isPackageDeviceAdminOnAnyUser(app.packageName)) {
                return false;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return vol.getType() == 1;
    }

    @Override
    public int movePrimaryStorage(VolumeInfo vol) {
        try {
            String volumeUuid = "private".equals(vol.id) ? StorageManager.UUID_PRIVATE_INTERNAL : (vol.isPrimaryPhysical() ? "primary_physical" : Objects.requireNonNull(vol.fsUuid));
            return this.mPM.movePrimaryStorage(volumeUuid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @Nullable
    public VolumeInfo getPrimaryStorageCurrentVolume() {
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        String volumeUuid = storage.getPrimaryStorageUuid();
        return storage.findVolumeByQualifiedUuid(volumeUuid);
    }

    @Override
    @NonNull
    public List<VolumeInfo> getPrimaryStorageCandidateVolumes() {
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        VolumeInfo currentVol = this.getPrimaryStorageCurrentVolume();
        List<VolumeInfo> vols = storage.getVolumes();
        ArrayList<VolumeInfo> candidates = new ArrayList<VolumeInfo>();
        if (Objects.equals("primary_physical", storage.getPrimaryStorageUuid()) && currentVol != null) {
            candidates.add(currentVol);
        } else {
            for (VolumeInfo vol : vols) {
                if (!Objects.equals(vol, currentVol) && !ApplicationPackageManager.isPrimaryStorageCandidateVolume(vol)) continue;
                candidates.add(vol);
            }
        }
        return candidates;
    }

    private static boolean isPrimaryStorageCandidateVolume(VolumeInfo vol) {
        if ("private".equals(vol.getId())) {
            return true;
        }
        if (!vol.isMountedWritable()) {
            return false;
        }
        return vol.getType() == 1;
    }

    @Override
    @UnsupportedAppUsage
    public void deletePackage(String packageName, IPackageDeleteObserver observer, int flags) {
        this.deletePackageAsUser(packageName, observer, flags, this.getUserId());
    }

    @Override
    public void deletePackageAsUser(String packageName, IPackageDeleteObserver observer, int flags, int userId) {
        try {
            this.mPM.deletePackageAsUser(packageName, -1, observer, userId, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void clearApplicationUserData(String packageName, IPackageDataObserver observer) {
        try {
            this.mPM.clearApplicationUserData(packageName, observer, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void deleteApplicationCacheFiles(String packageName, IPackageDataObserver observer) {
        try {
            this.mPM.deleteApplicationCacheFiles(packageName, observer);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void deleteApplicationCacheFilesAsUser(String packageName, int userId, IPackageDataObserver observer) {
        try {
            this.mPM.deleteApplicationCacheFilesAsUser(packageName, userId, observer);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void freeStorageAndNotify(String volumeUuid, long idealStorageSize, IPackageDataObserver observer) {
        try {
            this.mPM.freeStorageAndNotify(volumeUuid, idealStorageSize, 0, observer);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void freeStorage(String volumeUuid, long freeStorageSize, IntentSender pi) {
        try {
            this.mPM.freeStorage(volumeUuid, freeStorageSize, 0, pi);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public String[] setDistractingPackageRestrictions(String[] packages, int distractionFlags) {
        try {
            return this.mPM.setDistractingPackageRestrictionsAsUser(packages, distractionFlags, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public String[] setPackagesSuspended(String[] packageNames, boolean suspended, PersistableBundle appExtras, PersistableBundle launcherExtras, String dialogMessage) {
        SuspendDialogInfo dialogInfo = !TextUtils.isEmpty(dialogMessage) ? new SuspendDialogInfo.Builder().setMessage(dialogMessage).build() : null;
        return this.setPackagesSuspended(packageNames, suspended, appExtras, launcherExtras, dialogInfo, 0);
    }

    @Override
    public String[] setPackagesSuspended(String[] packageNames, boolean suspended, PersistableBundle appExtras, PersistableBundle launcherExtras, SuspendDialogInfo dialogInfo) {
        return this.setPackagesSuspended(packageNames, suspended, appExtras, launcherExtras, dialogInfo, 0);
    }

    @Override
    public String[] setPackagesSuspended(String[] packageNames, boolean suspended, PersistableBundle appExtras, PersistableBundle launcherExtras, SuspendDialogInfo dialogInfo, int flags) {
        try {
            return this.mPM.setPackagesSuspendedAsUser(packageNames, suspended, appExtras, launcherExtras, dialogInfo, flags, this.mContext.getOpPackageName(), UserHandle.myUserId(), this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public String[] getUnsuspendablePackages(String[] packageNames) {
        try {
            return this.mPM.getUnsuspendablePackagesForUser(packageNames, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public Bundle getSuspendedPackageAppExtras() {
        try {
            return this.mPM.getSuspendedPackageAppExtras(this.mContext.getOpPackageName(), this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public String getSuspendingPackage(String suspendedPackage) {
        try {
            return this.mPM.getSuspendingPackage(suspendedPackage, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean isPackageSuspendedForUser(String packageName, int userId) {
        try {
            return this.mPM.isPackageSuspendedForUser(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean isPackageSuspended(String packageName) throws PackageManager.NameNotFoundException {
        try {
            return this.isPackageSuspendedForUser(packageName, this.getUserId());
        }
        catch (IllegalArgumentException ie) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
    }

    @Override
    public boolean isPackageSuspended() {
        return this.isPackageSuspendedForUser(this.mContext.getOpPackageName(), this.getUserId());
    }

    @Override
    public boolean isPackageQuarantined(@NonNull String packageName) throws PackageManager.NameNotFoundException {
        try {
            return this.mPM.isPackageQuarantinedForUser(packageName, this.getUserId());
        }
        catch (IllegalArgumentException ie) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean isPackageStopped(@NonNull String packageName) throws PackageManager.NameNotFoundException {
        try {
            return this.mPM.isPackageStoppedForUser(packageName, this.getUserId());
        }
        catch (IllegalArgumentException ie) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void setApplicationCategoryHint(String packageName, int categoryHint) {
        try {
            this.mPM.setApplicationCategoryHint(packageName, categoryHint, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @UnsupportedAppUsage
    public void getPackageSizeInfoAsUser(String packageName, int userHandle, IPackageStatsObserver observer) {
        String msg = "Shame on you for calling the hidden API getPackageSizeInfoAsUser(). Shame!";
        if (this.mContext.getApplicationInfo().targetSdkVersion >= 26) {
            throw new UnsupportedOperationException("Shame on you for calling the hidden API getPackageSizeInfoAsUser(). Shame!");
        }
        if (observer != null) {
            Log.d(TAG, "Shame on you for calling the hidden API getPackageSizeInfoAsUser(). Shame!");
            try {
                observer.onGetStatsCompleted(null, false);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void addPackageToPreferred(String packageName) {
        Log.w(TAG, "addPackageToPreferred() is a no-op");
    }

    @Override
    public void removePackageFromPreferred(String packageName) {
        Log.w(TAG, "removePackageFromPreferred() is a no-op");
    }

    @Override
    public List<PackageInfo> getPreferredPackages(int flags) {
        Log.w(TAG, "getPreferredPackages() is a no-op");
        return Collections.emptyList();
    }

    @Override
    public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        try {
            this.mPM.addPreferredActivity(filter, match, set, activity, this.getUserId(), false);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void addPreferredActivityAsUser(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) {
        try {
            this.mPM.addPreferredActivity(filter, match, set, activity, userId, false);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        try {
            this.mPM.replacePreferredActivity(filter, match, set, activity, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void replacePreferredActivityAsUser(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) {
        try {
            this.mPM.replacePreferredActivity(filter, match, set, activity, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void clearPackagePreferredActivities(String packageName) {
        try {
            this.mPM.clearPackagePreferredActivities(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void addUniquePreferredActivity(@NonNull IntentFilter filter, int match, @Nullable ComponentName[] set, @NonNull ComponentName activity) {
        try {
            this.mPM.addPreferredActivity(filter, match, set, activity, this.getUserId(), true);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        try {
            return this.mPM.getPreferredActivities(outFilters, outActivities, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public ComponentName getHomeActivities(List<ResolveInfo> outActivities) {
        try {
            return this.mPM.getHomeActivities(outActivities);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void setSyntheticAppDetailsActivityEnabled(String packageName, boolean enabled) {
        try {
            ComponentName componentName = new ComponentName(packageName, APP_DETAILS_ACTIVITY_CLASS_NAME);
            this.mPM.setComponentEnabledSetting(componentName, enabled ? 0 : 2, 1, this.getUserId(), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean getSyntheticAppDetailsActivityEnabled(String packageName) {
        try {
            ComponentName componentName = new ComponentName(packageName, APP_DETAILS_ACTIVITY_CLASS_NAME);
            int state = this.mPM.getComponentEnabledSetting(componentName, this.getUserId());
            return state == 1 || state == 0;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void setComponentEnabledSetting(ComponentName componentName, int newState, int flags) {
        try {
            this.mPM.setComponentEnabledSetting(componentName, newState, flags, this.getUserId(), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void setComponentEnabledSettings(List<PackageManager.ComponentEnabledSetting> settings) {
        try {
            this.mPM.setComponentEnabledSettings(settings, this.getUserId(), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public int getComponentEnabledSetting(ComponentName componentName) {
        try {
            return this.mPM.getComponentEnabledSetting(componentName, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void setApplicationEnabledSetting(String packageName, int newState, int flags) {
        try {
            this.mPM.setApplicationEnabledSetting(packageName, newState, flags, this.getUserId(), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public int getApplicationEnabledSetting(String packageName) {
        try {
            return this.mPM.getApplicationEnabledSetting(packageName, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void flushPackageRestrictionsAsUser(int userId) {
        try {
            this.mPM.flushPackageRestrictionsAsUser(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean setApplicationHiddenSettingAsUser(String packageName, boolean hidden, UserHandle user) {
        try {
            return this.mPM.setApplicationHiddenSettingAsUser(packageName, hidden, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean getApplicationHiddenSettingAsUser(String packageName, UserHandle user) {
        try {
            return this.mPM.getApplicationHiddenSettingAsUser(packageName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void setSystemAppState(String packageName, int state) {
        try {
            switch (state) {
                case 0: {
                    this.mPM.setSystemAppHiddenUntilInstalled(packageName, true);
                    break;
                }
                case 1: {
                    this.mPM.setSystemAppHiddenUntilInstalled(packageName, false);
                    break;
                }
                case 2: {
                    this.mPM.setSystemAppInstallState(packageName, true, this.getUserId());
                    break;
                }
                case 3: {
                    this.mPM.setSystemAppInstallState(packageName, false, this.getUserId());
                    break;
                }
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public KeySet getKeySetByAlias(String packageName, String alias) {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(alias);
        try {
            return this.mPM.getKeySetByAlias(packageName, alias);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public KeySet getSigningKeySet(String packageName) {
        Objects.requireNonNull(packageName);
        try {
            return this.mPM.getSigningKeySet(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean isSignedBy(String packageName, KeySet ks) {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(ks);
        try {
            return this.mPM.isPackageSignedByKeySet(packageName, ks);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean isSignedByExactly(String packageName, KeySet ks) {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(ks);
        try {
            return this.mPM.isPackageSignedByKeySetExactly(packageName, ks);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public VerifierDeviceIdentity getVerifierDeviceIdentity() {
        try {
            return this.mPM.getVerifierDeviceIdentity();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean isUpgrade() {
        return this.isDeviceUpgrading();
    }

    @Override
    public boolean isDeviceUpgrading() {
        try {
            return this.mPM.isDeviceUpgrading();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public PackageInstaller getPackageInstaller() {
        if (this.mInstaller == null) {
            try {
                this.mInstaller = new PackageInstaller(this.mPM.getPackageInstaller(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), this.getUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return this.mInstaller;
    }

    @Override
    public boolean isPackageAvailable(String packageName) {
        try {
            return this.mPM.isPackageAvailable(packageName, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void addCrossProfileIntentFilter(IntentFilter filter, int sourceUserId, int targetUserId, int flags) {
        try {
            this.mPM.addCrossProfileIntentFilter(filter, this.mContext.getOpPackageName(), sourceUserId, targetUserId, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean removeCrossProfileIntentFilter(IntentFilter filter, int sourceUserId, int targetUserId, int flags) {
        try {
            return this.mPM.removeCrossProfileIntentFilter(filter, this.mContext.getOpPackageName(), sourceUserId, targetUserId, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void clearCrossProfileIntentFilters(int sourceUserId) {
        try {
            this.mPM.clearCrossProfileIntentFilters(sourceUserId, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public Drawable loadItemIcon(PackageItemInfo itemInfo, ApplicationInfo appInfo) {
        Drawable dr = this.loadUnbadgedItemIcon(itemInfo, appInfo);
        if (itemInfo.showUserIcon != -10000) {
            return dr;
        }
        return this.getUserBadgedIcon(dr, new UserHandle(this.getUserId()));
    }

    @Override
    public Drawable loadUnbadgedItemIcon(@NonNull PackageItemInfo itemInfo, @Nullable ApplicationInfo appInfo) {
        if (itemInfo.showUserIcon != -10000) {
            int targetUserId = itemInfo.showUserIcon;
            return UserIcons.getDefaultUserIcon(this.mContext.getResources(), targetUserId, false);
        }
        Drawable dr = null;
        if (itemInfo.packageName != null) {
            dr = itemInfo.isArchived ? this.getArchivedAppIcon(itemInfo.packageName) : this.getDrawable(itemInfo.packageName, itemInfo.icon, appInfo);
        }
        if (dr == null && itemInfo != appInfo && appInfo != null) {
            dr = this.loadUnbadgedItemIcon(appInfo, appInfo);
        }
        if (dr == null) {
            dr = itemInfo.loadDefaultIcon(this);
        }
        return dr;
    }

    private Drawable getBadgedDrawable(Drawable drawable2, Drawable badgeDrawable, Rect badgeLocation, boolean tryBadgeInPlace) {
        int badgedWidth = drawable2.getIntrinsicWidth();
        int badgedHeight = drawable2.getIntrinsicHeight();
        boolean canBadgeInPlace = tryBadgeInPlace && drawable2 instanceof BitmapDrawable && ((BitmapDrawable)drawable2).getBitmap().isMutable();
        Bitmap bitmap = canBadgeInPlace ? ((BitmapDrawable)drawable2).getBitmap() : Bitmap.createBitmap(badgedWidth, badgedHeight, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        if (!canBadgeInPlace) {
            drawable2.setBounds(0, 0, badgedWidth, badgedHeight);
            drawable2.draw(canvas);
        }
        if (badgeLocation != null) {
            if (badgeLocation.left < 0 || badgeLocation.top < 0 || badgeLocation.width() > badgedWidth || badgeLocation.height() > badgedHeight) {
                throw new IllegalArgumentException("Badge location " + badgeLocation + " not in badged drawable bounds " + new Rect(0, 0, badgedWidth, badgedHeight));
            }
            badgeDrawable.setBounds(0, 0, badgeLocation.width(), badgeLocation.height());
            canvas.save();
            canvas.translate(badgeLocation.left, badgeLocation.top);
            badgeDrawable.draw(canvas);
            canvas.restore();
        } else {
            badgeDrawable.setBounds(0, 0, badgedWidth, badgedHeight);
            badgeDrawable.draw(canvas);
        }
        if (!canBadgeInPlace) {
            BitmapDrawable mergedDrawable = new BitmapDrawable(this.mContext.getResources(), bitmap);
            if (drawable2 instanceof BitmapDrawable) {
                BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
                mergedDrawable.setTargetDensity(bitmapDrawable.getBitmap().getDensity());
            }
            return mergedDrawable;
        }
        return drawable2;
    }

    private boolean hasUserBadge(int userId) {
        return this.getUserManager().hasBadge(userId);
    }

    @Override
    public int getInstallReason(String packageName, UserHandle user) {
        try {
            return this.mPM.getInstallReason(packageName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public boolean canRequestPackageInstalls() {
        try {
            return this.mPM.canRequestPackageInstalls(this.mContext.getPackageName(), this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public ComponentName getInstantAppResolverSettingsComponent() {
        try {
            return this.mPM.getInstantAppResolverSettingsComponent();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public ComponentName getInstantAppInstallerComponent() {
        try {
            return this.mPM.getInstantAppInstallerComponent();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public String getInstantAppAndroidId(String packageName, UserHandle user) {
        try {
            return this.mPM.getInstantAppAndroidId(packageName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public void registerDexModule(@NonNull String dexModule, @Nullable PackageManager.DexModuleRegisterCallback callback) {
        DexModuleRegisterCallbackDelegate callbackDelegate = null;
        if (callback != null) {
            callbackDelegate = new DexModuleRegisterCallbackDelegate(callback);
        }
        boolean isSharedModule = false;
        try {
            StructStat stat = Os.stat(dexModule);
            if ((OsConstants.S_IROTH & stat.st_mode) != 0) {
                isSharedModule = true;
            }
        }
        catch (ErrnoException e) {
            if (callbackDelegate != null) {
                callback.onDexModuleRegistered(dexModule, false, "Could not get stat the module file: " + e.getMessage());
            }
            return;
        }
        try {
            this.mPM.registerDexModule(this.mContext.getPackageName(), dexModule, isSharedModule, callbackDelegate);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public CharSequence getHarmfulAppWarning(String packageName) {
        try {
            return this.mPM.getHarmfulAppWarning(packageName, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public void setHarmfulAppWarning(String packageName, CharSequence warning) {
        try {
            this.mPM.setHarmfulAppWarning(packageName, warning, this.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public ArtManager getArtManager() {
        if (this.mArtManager == null) {
            try {
                this.mArtManager = new ArtManager(this.mContext, this.mPM.getArtManager());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return this.mArtManager;
    }

    @Override
    public String getDefaultTextClassifierPackageName() {
        try {
            return this.mPM.getDefaultTextClassifierPackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public String getSystemTextClassifierPackageName() {
        try {
            return this.mPM.getSystemTextClassifierPackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public String getAttentionServicePackageName() {
        try {
            return this.mPM.getAttentionServicePackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public String getRotationResolverPackageName() {
        try {
            return this.mPM.getRotationResolverPackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public String getWellbeingPackageName() {
        try {
            return this.mPM.getWellbeingPackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public String getAppPredictionServicePackageName() {
        try {
            return this.mPM.getAppPredictionServicePackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public String getSystemCaptionsServicePackageName() {
        try {
            return this.mPM.getSystemCaptionsServicePackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public String getSetupWizardPackageName() {
        try {
            return this.mPM.getSetupWizardPackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public String getIncidentReportApproverPackageName() {
        try {
            return this.mPM.getIncidentReportApproverPackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public boolean isPackageStateProtected(String packageName, int userId) {
        try {
            return this.mPM.isPackageStateProtected(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public void sendDeviceCustomizationReadyBroadcast() {
        try {
            this.mPM.sendDeviceCustomizationReadyBroadcast();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public boolean isAutoRevokeWhitelisted() {
        try {
            return this.mPM.isAutoRevokeWhitelisted(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public void setMimeGroup(String mimeGroup, Set<String> mimeTypes) {
        try {
            this.mPM.setMimeGroup(this.mContext.getPackageName(), mimeGroup, new ArrayList<String>(mimeTypes));
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    @NonNull
    public Set<String> getMimeGroup(String group) {
        try {
            List<String> mimeGroup = this.mPM.getMimeGroup(this.mContext.getPackageName(), group);
            return new ArraySet<String>(mimeGroup);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public PackageManager.Property getProperty(String propertyName, String packageName) throws PackageManager.NameNotFoundException {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(propertyName);
        return this.getPropertyAsUser(propertyName, packageName, null, this.getUserId());
    }

    @Override
    public PackageManager.Property getProperty(String propertyName, ComponentName component) throws PackageManager.NameNotFoundException {
        Objects.requireNonNull(component);
        Objects.requireNonNull(propertyName);
        return this.getPropertyAsUser(propertyName, component.getPackageName(), component.getClassName(), this.getUserId());
    }

    @Override
    public PackageManager.Property getPropertyAsUser(@NonNull String propertyName, @NonNull String packageName, @Nullable String className, int userId) throws PackageManager.NameNotFoundException {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(propertyName);
        try {
            PackageManager.Property property = this.mPM.getPropertyAsUser(propertyName, packageName, className, userId);
            if (property == null) {
                throw new PackageManager.NameNotFoundException();
            }
            return property;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public List<PackageManager.Property> queryApplicationProperty(String propertyName) {
        Objects.requireNonNull(propertyName);
        try {
            ParceledListSlice parceledList = this.mPM.queryProperty(propertyName, 5);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public List<PackageManager.Property> queryActivityProperty(String propertyName) {
        Objects.requireNonNull(propertyName);
        try {
            ParceledListSlice parceledList = this.mPM.queryProperty(propertyName, 1);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public List<PackageManager.Property> queryProviderProperty(String propertyName) {
        Objects.requireNonNull(propertyName);
        try {
            ParceledListSlice parceledList = this.mPM.queryProperty(propertyName, 4);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public List<PackageManager.Property> queryReceiverProperty(String propertyName) {
        Objects.requireNonNull(propertyName);
        try {
            ParceledListSlice parceledList = this.mPM.queryProperty(propertyName, 2);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public List<PackageManager.Property> queryServiceProperty(String propertyName) {
        Objects.requireNonNull(propertyName);
        try {
            ParceledListSlice parceledList = this.mPM.queryProperty(propertyName, 3);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public boolean canPackageQuery(@NonNull String sourcePackageName, @NonNull String targetPackageName) throws PackageManager.NameNotFoundException {
        Objects.requireNonNull(sourcePackageName);
        Objects.requireNonNull(targetPackageName);
        return this.canPackageQuery(sourcePackageName, new String[]{targetPackageName})[0];
    }

    @Override
    @NonNull
    public boolean[] canPackageQuery(@NonNull String sourcePackageName, @NonNull String[] targetPackageNames) throws PackageManager.NameNotFoundException {
        Objects.requireNonNull(sourcePackageName);
        Objects.requireNonNull(targetPackageNames);
        try {
            return this.mPM.canPackageQuery(sourcePackageName, targetPackageNames, this.getUserId());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(PackageManager.NameNotFoundException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException re) {
            throw re.rethrowAsRuntimeException();
        }
    }

    @Override
    public void makeUidVisible(int recipientUid, int visibleUid) {
        try {
            this.mPM.makeUidVisible(recipientUid, visibleUid);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    @Nullable
    public ArchivedPackageInfo getArchivedPackage(@NonNull String packageName) {
        try {
            ArchivedPackageParcel parcel = this.mPM.getArchivedPackage(packageName, this.mContext.getUserId());
            if (parcel == null) {
                return null;
            }
            return new ArchivedPackageInfo(parcel);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public boolean canUserUninstall(String packageName, UserHandle user) {
        try {
            return this.mPM.getBlockUninstallForUser(packageName, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @Override
    public boolean shouldShowNewAppInstalledNotification() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "show_new_app_installed_notification_enabled", 0) == 1;
    }

    @Override
    public void relinquishUpdateOwnership(String targetPackage) {
        Objects.requireNonNull(targetPackage);
        try {
            this.mPM.relinquishUpdateOwnership(targetPackage);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPackageMonitorCallback(@NonNull IRemoteCallback callback, int userId) {
        Objects.requireNonNull(callback);
        try {
            this.mPM.registerPackageMonitorCallback(callback, userId);
            ArraySet<IRemoteCallback> arraySet = this.mPackageMonitorCallbacks;
            synchronized (arraySet) {
                if (this.mPackageMonitorCallbacks.contains(callback)) {
                    throw new IllegalStateException("registerPackageMonitorCallback: callback already registered: " + callback);
                }
                this.mPackageMonitorCallbacks.add(callback);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterPackageMonitorCallback(@NonNull IRemoteCallback callback) {
        Objects.requireNonNull(callback);
        try {
            this.mPM.unregisterPackageMonitorCallback(callback);
            ArraySet<IRemoteCallback> arraySet = this.mPackageMonitorCallbacks;
            synchronized (arraySet) {
                this.mPackageMonitorCallbacks.remove(callback);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    private Drawable getArchivedAppIcon(String packageName) {
        try {
            Bitmap archivedAppIcon = this.mPM.getArchivedAppIcon(packageName, new UserHandle(this.getUserId()), this.mContext.getPackageName());
            if (archivedAppIcon == null) {
                return null;
            }
            return new BitmapDrawable(null, archivedAppIcon);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to retrieve archived app icon: " + e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T parseAndroidManifest(@NonNull File apkFile, @NonNull Function<XmlResourceParser, T> parserFunction) throws IOException {
        Objects.requireNonNull(apkFile, "apkFile cannot be null");
        Objects.requireNonNull(parserFunction, "parserFunction cannot be null");
        try (XmlResourceParser xmlResourceParser = ApplicationPackageManager.getAndroidManifestParser(apkFile);){
            XmlResourceParser t = parserFunction.apply(xmlResourceParser);
            return (T)t;
        }
        catch (IOException e) {
            Log.w(TAG, "Failed to get the android manifest parser", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XmlResourceParser getAndroidManifestParser(@NonNull File apkFile) throws IOException {
        ApkAssets apkAssets = null;
        try {
            apkAssets = ApkAssets.loadFromPath(apkFile.getAbsolutePath());
            XmlResourceParser xmlResourceParser = apkAssets.openXml("AndroidManifest.xml");
            return xmlResourceParser;
        }
        finally {
            if (apkAssets != null) {
                try {
                    apkAssets.close();
                }
                catch (Throwable ignored) {
                    Log.w(TAG, "Failed to close apkAssets", ignored);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T parseAndroidManifest(@NonNull ParcelFileDescriptor apkFileDescriptor, @NonNull Function<XmlResourceParser, T> parserFunction) throws IOException {
        Objects.requireNonNull(apkFileDescriptor, "apkFileDescriptor cannot be null");
        Objects.requireNonNull(parserFunction, "parserFunction cannot be null");
        try (XmlResourceParser xmlResourceParser = ApplicationPackageManager.getAndroidManifestParser(apkFileDescriptor);){
            XmlResourceParser t = parserFunction.apply(xmlResourceParser);
            return (T)t;
        }
        catch (IOException e) {
            Log.w(TAG, "Failed to get the android manifest parser", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XmlResourceParser getAndroidManifestParser(@NonNull ParcelFileDescriptor fd) throws IOException {
        ApkAssets apkAssets = null;
        try {
            apkAssets = ApkAssets.loadFromFd(fd.getFileDescriptor(), fd.toString(), 0, null);
            XmlResourceParser xmlResourceParser = apkAssets.openXml("AndroidManifest.xml");
            return xmlResourceParser;
        }
        finally {
            if (apkAssets != null) {
                try {
                    apkAssets.close();
                }
                catch (Throwable ignored) {
                    Log.w(TAG, "Failed to close apkAssets", ignored);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TypedArray extractPackageItemInfoAttributes(PackageItemInfo info, String name, String rootTag, int[] attributes) {
        if (info == null) return null;
        if (info.metaData == null) {
            return null;
        }
        try (XmlResourceParser parser = info.loadXmlMetaData(this, name);){
            int type;
            if (parser == null) {
                Log.w(TAG, "No " + name + " metadata");
                TypedArray typedArray = null;
                return typedArray;
            }
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            if (!TextUtils.equals(parser.getName(), rootTag)) {
                Log.w(TAG, "Metadata does not start with " + name + " tag");
                TypedArray typedArray = null;
                return typedArray;
            }
            TypedArray typedArray = this.getResourcesForApplication(info.getApplicationInfo()).obtainAttributes(attrs, attributes);
            return typedArray;
        }
        catch (PackageManager.NameNotFoundException | IOException | XmlPullParserException e) {
            Log.e(TAG, "Error parsing: " + info.packageName, e);
            return null;
        }
    }

    private static class HasSystemFeatureQuery
    extends Record {
        private final String name;
        private final int version;

        private HasSystemFeatureQuery(String name, int version) {
            this.name = name;
            this.version = version;
        }

        @Override
        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{HasSystemFeatureQuery.class, "name;version", "name", "version"}, this);
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{HasSystemFeatureQuery.class, "name;version", "name", "version"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{HasSystemFeatureQuery.class, "name;version", "name", "version"}, this, o);
        }

        public String name() {
            return this.name;
        }

        public int version() {
            return this.version;
        }
    }

    private static class GetPackagesForUidResult {
        private final String[] mValue;

        GetPackagesForUidResult(String[] s) {
            this.mValue = s;
        }

        public String[] value() {
            return this.mValue;
        }

        public String toString() {
            return Arrays.toString(this.mValue);
        }

        public int hashCode() {
            return Arrays.hashCode(this.mValue);
        }

        public boolean equals(@Nullable Object o) {
            if (o instanceof GetPackagesForUidResult) {
                Object[] l;
                Object[] r = ((GetPackagesForUidResult)o).mValue;
                if (r == null != ((l = this.mValue) == null)) {
                    return false;
                }
                if (r == null) {
                    return true;
                }
                Arrays.sort(r);
                Arrays.sort(l);
                return Arrays.equals(l, r);
            }
            return false;
        }
    }

    private static class ResourceName {
        final String packageName;
        final int iconId;

        ResourceName(String _packageName, int _iconId) {
            this.packageName = _packageName;
            this.iconId = _iconId;
        }

        ResourceName(ApplicationInfo aInfo, int _iconId) {
            this(aInfo.packageName, _iconId);
        }

        ResourceName(ComponentInfo cInfo, int _iconId) {
            this(cInfo.applicationInfo.packageName, _iconId);
        }

        ResourceName(ResolveInfo rInfo, int _iconId) {
            this(rInfo.activityInfo.applicationInfo.packageName, _iconId);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceName that = (ResourceName)o;
            if (this.iconId != that.iconId) {
                return false;
            }
            return !(this.packageName == null ? that.packageName != null : !this.packageName.equals(that.packageName));
        }

        public int hashCode() {
            int result = this.packageName.hashCode();
            result = 31 * result + this.iconId;
            return result;
        }

        public String toString() {
            return "{ResourceName " + this.packageName + " / " + this.iconId + "}";
        }
    }

    private static class MoveCallbackDelegate
    extends IPackageMoveObserver.Stub
    implements Handler.Callback {
        private static final int MSG_CREATED = 1;
        private static final int MSG_STATUS_CHANGED = 2;
        final PackageManager.MoveCallback mCallback;
        final Handler mHandler;

        public MoveCallbackDelegate(PackageManager.MoveCallback callback, Looper looper) {
            this.mCallback = callback;
            this.mHandler = new Handler(looper, this);
        }

        @Override
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    this.mCallback.onCreated(args.argi1, (Bundle)args.arg2);
                    args.recycle();
                    return true;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    this.mCallback.onStatusChanged(args.argi1, args.argi2, (Long)args.arg3);
                    args.recycle();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onCreated(int moveId, Bundle extras) {
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = moveId;
            args.arg2 = extras;
            this.mHandler.obtainMessage(1, args).sendToTarget();
        }

        @Override
        public void onStatusChanged(int moveId, int status, long estMillis) {
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = moveId;
            args.argi2 = status;
            args.arg3 = estMillis;
            this.mHandler.obtainMessage(2, args).sendToTarget();
        }
    }

    private static class DexModuleRegisterCallbackDelegate
    extends IDexModuleRegisterCallback.Stub
    implements Handler.Callback {
        private static final int MSG_DEX_MODULE_REGISTERED = 1;
        private final PackageManager.DexModuleRegisterCallback callback;
        private final Handler mHandler;

        DexModuleRegisterCallbackDelegate(@NonNull PackageManager.DexModuleRegisterCallback callback) {
            this.callback = callback;
            this.mHandler = new Handler(Looper.getMainLooper(), this);
        }

        @Override
        public void onDexModuleRegistered(@NonNull String dexModulePath, boolean success, @Nullable String message) throws RemoteException {
            this.mHandler.obtainMessage(1, new DexModuleRegisterResult(dexModulePath, success, message)).sendToTarget();
        }

        @Override
        public boolean handleMessage(Message msg) {
            if (msg.what != 1) {
                return false;
            }
            DexModuleRegisterResult result = (DexModuleRegisterResult)msg.obj;
            this.callback.onDexModuleRegistered(result.dexModulePath, result.success, result.message);
            return true;
        }
    }

    private static class DexModuleRegisterResult {
        final String dexModulePath;
        final boolean success;
        final String message;

        private DexModuleRegisterResult(String dexModulePath, boolean success, String message) {
            this.dexModulePath = dexModulePath;
            this.success = success;
            this.message = message;
        }
    }
}

