/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.ondevicepersonalization;

import android.adservices.ondevicepersonalization.MeasurementWebTriggerEventParams;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.ondevicepersonalization.internal.util.AnnotationValidations;

public class MeasurementWebTriggerEventParamsParcel
implements Parcelable {
    @NonNull
    private Uri mDestinationUrl;
    @NonNull
    private String mAppPackageName;
    @NonNull
    private ComponentName mIsolatedService;
    @Nullable
    private String mCertDigest = null;
    @Nullable
    private byte[] mEventData = null;
    @NonNull
    public static final Parcelable.Creator<MeasurementWebTriggerEventParamsParcel> CREATOR = new Parcelable.Creator<MeasurementWebTriggerEventParamsParcel>(){

        public MeasurementWebTriggerEventParamsParcel[] newArray(int size) {
            return new MeasurementWebTriggerEventParamsParcel[size];
        }

        @Override
        public MeasurementWebTriggerEventParamsParcel createFromParcel(@NonNull Parcel in) {
            return new MeasurementWebTriggerEventParamsParcel(in);
        }
    };

    public MeasurementWebTriggerEventParamsParcel(@NonNull MeasurementWebTriggerEventParams params) {
        this(params.getDestinationUrl(), params.getAppPackageName(), params.getIsolatedService(), params.getCertDigest(), params.getEventData());
    }

    public MeasurementWebTriggerEventParamsParcel(@NonNull Uri destinationUrl, @NonNull String appPackageName, @NonNull ComponentName isolatedService, @Nullable String certDigest, @Nullable byte[] eventData) {
        this.mDestinationUrl = destinationUrl;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mDestinationUrl);
        this.mAppPackageName = appPackageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAppPackageName);
        this.mIsolatedService = isolatedService;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mIsolatedService);
        this.mCertDigest = certDigest;
        this.mEventData = eventData;
    }

    @NonNull
    public Uri getDestinationUrl() {
        return this.mDestinationUrl;
    }

    @NonNull
    public String getAppPackageName() {
        return this.mAppPackageName;
    }

    @NonNull
    public ComponentName getIsolatedService() {
        return this.mIsolatedService;
    }

    @Nullable
    public String getCertDigest() {
        return this.mCertDigest;
    }

    @Nullable
    public byte[] getEventData() {
        return this.mEventData;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mCertDigest != null) {
            flg = (byte)(flg | 8);
        }
        dest.writeByte(flg);
        dest.writeTypedObject(this.mDestinationUrl, flags);
        dest.writeString(this.mAppPackageName);
        dest.writeTypedObject(this.mIsolatedService, flags);
        if (this.mCertDigest != null) {
            dest.writeString(this.mCertDigest);
        }
        dest.writeByteArray(this.mEventData);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    MeasurementWebTriggerEventParamsParcel(@NonNull Parcel in) {
        byte flg = in.readByte();
        Uri destinationUrl = in.readTypedObject(Uri.CREATOR);
        String appPackageName = in.readString();
        ComponentName isolatedService = in.readTypedObject(ComponentName.CREATOR);
        String certDigest = (flg & 8) == 0 ? null : in.readString();
        byte[] eventData = in.createByteArray();
        this.mDestinationUrl = destinationUrl;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mDestinationUrl);
        this.mAppPackageName = appPackageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAppPackageName);
        this.mIsolatedService = isolatedService;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mIsolatedService);
        this.mCertDigest = certDigest;
        this.mEventData = eventData;
    }

    @Deprecated
    private void __metadata() {
    }
}

