/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.ondevicepersonalization;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.content.ComponentName;
import android.net.Uri;
import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class MeasurementWebTriggerEventParams {
    @NonNull
    private Uri mDestinationUrl;
    @NonNull
    private String mAppPackageName;
    @NonNull
    private ComponentName mIsolatedService;
    @Nullable
    private String mCertDigest = null;
    @Nullable
    private byte[] mEventData = null;

    MeasurementWebTriggerEventParams(@NonNull Uri destinationUrl, @NonNull String appPackageName, @NonNull ComponentName isolatedService, @Nullable String certDigest, @Nullable byte[] eventData) {
        this.mDestinationUrl = destinationUrl;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mDestinationUrl);
        this.mAppPackageName = appPackageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAppPackageName);
        this.mIsolatedService = isolatedService;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mIsolatedService);
        this.mCertDigest = certDigest;
        this.mEventData = eventData;
    }

    @NonNull
    public Uri getDestinationUrl() {
        return this.mDestinationUrl;
    }

    @NonNull
    public String getAppPackageName() {
        return this.mAppPackageName;
    }

    @NonNull
    public ComponentName getIsolatedService() {
        return this.mIsolatedService;
    }

    @Nullable
    public String getCertDigest() {
        return this.mCertDigest;
    }

    @Nullable
    public byte[] getEventData() {
        return this.mEventData;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasurementWebTriggerEventParams that = (MeasurementWebTriggerEventParams)o;
        return Objects.equals(this.mDestinationUrl, that.mDestinationUrl) && Objects.equals(this.mAppPackageName, that.mAppPackageName) && Objects.equals(this.mIsolatedService, that.mIsolatedService) && Objects.equals(this.mCertDigest, that.mCertDigest) && Arrays.equals(this.mEventData, that.mEventData);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mDestinationUrl);
        _hash = 31 * _hash + Objects.hashCode(this.mAppPackageName);
        _hash = 31 * _hash + Objects.hashCode(this.mIsolatedService);
        _hash = 31 * _hash + Objects.hashCode(this.mCertDigest);
        _hash = 31 * _hash + Arrays.hashCode(this.mEventData);
        return _hash;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        @NonNull
        private Uri mDestinationUrl;
        @NonNull
        private String mAppPackageName;
        @NonNull
        private ComponentName mIsolatedService;
        @Nullable
        private String mCertDigest;
        @Nullable
        private byte[] mEventData;
        private long mBuilderFieldsSet = 0L;

        public Builder(@NonNull Uri destinationUrl, @NonNull String appPackageName, @NonNull ComponentName isolatedService) {
            this.mDestinationUrl = destinationUrl;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mDestinationUrl);
            this.mAppPackageName = appPackageName;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mAppPackageName);
            this.mIsolatedService = isolatedService;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mIsolatedService);
        }

        @NonNull
        public Builder setDestinationUrl(@NonNull Uri value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mDestinationUrl = value;
            return this;
        }

        @NonNull
        public Builder setAppPackageName(@NonNull String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mAppPackageName = value;
            return this;
        }

        @NonNull
        public Builder setIsolatedService(@NonNull ComponentName value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mIsolatedService = value;
            return this;
        }

        @NonNull
        public Builder setCertDigest(@Nullable String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mCertDigest = value;
            return this;
        }

        @NonNull
        public Builder setEventData(byte ... value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mEventData = value;
            return this;
        }

        @NonNull
        public MeasurementWebTriggerEventParams build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mCertDigest = null;
            }
            if ((this.mBuilderFieldsSet & 0x10L) == 0L) {
                this.mEventData = null;
            }
            MeasurementWebTriggerEventParams o = new MeasurementWebTriggerEventParams(this.mDestinationUrl, this.mAppPackageName, this.mIsolatedService, this.mCertDigest, this.mEventData);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x20L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

