/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.ondevicepersonalization;

import android.annotation.FlaggedApi;
import android.annotation.IntRange;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.os.PersistableBundle;
import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@FlaggedApi(value="com.android.adservices.ondevicepersonalization.flags.execute_in_isolated_service_api_enabled")
public class ExecuteInIsolatedServiceRequest {
    @NonNull
    private ComponentName mService;
    @NonNull
    private PersistableBundle mAppParams;
    @NonNull
    private OutputSpec mOutputSpec;

    ExecuteInIsolatedServiceRequest(@NonNull ComponentName service, @NonNull PersistableBundle appParams, @NonNull OutputSpec outputSpec) {
        Objects.requireNonNull(service);
        Objects.requireNonNull(appParams);
        Objects.requireNonNull(outputSpec);
        this.mService = service;
        this.mAppParams = appParams;
        this.mOutputSpec = outputSpec;
    }

    @NonNull
    public ComponentName getService() {
        return this.mService;
    }

    @NonNull
    public PersistableBundle getAppParams() {
        return this.mAppParams;
    }

    @NonNull
    public OutputSpec getOutputSpec() {
        return this.mOutputSpec;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecuteInIsolatedServiceRequest that = (ExecuteInIsolatedServiceRequest)o;
        return Objects.equals(this.mService, that.mService) && Objects.equals(this.mAppParams, that.mAppParams) && Objects.equals(this.mOutputSpec, that.mOutputSpec);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mService);
        _hash = 31 * _hash + Objects.hashCode(this.mAppParams);
        _hash = 31 * _hash + Objects.hashCode(this.mOutputSpec);
        return _hash;
    }

    public static class OutputSpec {
        public static final int OUTPUT_TYPE_NULL = 0;
        public static final int OUTPUT_TYPE_BEST_VALUE = 1;
        private final int mOutputType;
        private final int mMaxIntValue;
        @NonNull
        public static final OutputSpec DEFAULT = new OutputSpec(0, -1);

        private OutputSpec(int outputType, int maxIntValue) {
            this.mMaxIntValue = maxIntValue;
            this.mOutputType = outputType;
        }

        @NonNull
        public static OutputSpec buildBestValueSpec(int maxIntValue) {
            AnnotationValidations.validate(IntRange.class, null, maxIntValue, "from", 0L);
            return new OutputSpec(1, maxIntValue);
        }

        public int getOutputType() {
            return this.mOutputType;
        }

        public int getMaxIntValue() {
            return this.mMaxIntValue;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface OutputType {
        }
    }

    public static class Builder {
        @NonNull
        private ComponentName mService;
        @NonNull
        private PersistableBundle mAppParams = PersistableBundle.EMPTY;
        @NonNull
        private OutputSpec mOutputSpec = OutputSpec.DEFAULT;

        public Builder(@NonNull ComponentName service) {
            Objects.requireNonNull(service);
            this.mService = service;
        }

        @NonNull
        public Builder setAppParams(@NonNull PersistableBundle value) {
            Objects.requireNonNull(value);
            this.mAppParams = value;
            return this;
        }

        @NonNull
        public Builder setOutputSpec(@NonNull OutputSpec value) {
            Objects.requireNonNull(value);
            this.mOutputSpec = value;
            return this;
        }

        @NonNull
        public ExecuteInIsolatedServiceRequest build() {
            return new ExecuteInIsolatedServiceRequest(this.mService, this.mAppParams, this.mOutputSpec);
        }
    }
}

