/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.customaudience;

import android.adservices.common.AdTechIdentifier;
import android.annotation.NonNull;
import android.annotation.Nullable;
import java.util.Objects;

public class LeaveCustomAudienceRequest {
    @NonNull
    private final AdTechIdentifier mBuyer;
    @NonNull
    private final String mName;

    private LeaveCustomAudienceRequest(@NonNull Builder builder) {
        this.mBuyer = builder.mBuyer;
        this.mName = builder.mName;
    }

    @NonNull
    public AdTechIdentifier getBuyer() {
        return this.mBuyer;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LeaveCustomAudienceRequest)) {
            return false;
        }
        LeaveCustomAudienceRequest that = (LeaveCustomAudienceRequest)o;
        return this.mBuyer.equals(that.mBuyer) && this.mName.equals(that.mName);
    }

    public int hashCode() {
        return Objects.hash(this.mBuyer, this.mName);
    }

    public static class Builder {
        @Nullable
        private AdTechIdentifier mBuyer;
        @Nullable
        private String mName;

        @NonNull
        public Builder setBuyer(@NonNull AdTechIdentifier buyer) {
            Objects.requireNonNull(buyer);
            this.mBuyer = buyer;
            return this;
        }

        @NonNull
        public Builder setName(@NonNull String name) {
            Objects.requireNonNull(name);
            this.mName = name;
            return this;
        }

        @NonNull
        public LeaveCustomAudienceRequest build() {
            Objects.requireNonNull(this.mBuyer);
            Objects.requireNonNull(this.mName);
            return new LeaveCustomAudienceRequest(this);
        }
    }
}

