/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.customaudience;

import android.adservices.common.AdServicesOutcomeReceiver;
import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.AdTechIdentifier;
import android.adservices.common.FledgeErrorResponse;
import android.adservices.common.SandboxedSdkContextUtils;
import android.adservices.customaudience.CustomAudience;
import android.adservices.customaudience.FetchAndJoinCustomAudienceCallback;
import android.adservices.customaudience.FetchAndJoinCustomAudienceInput;
import android.adservices.customaudience.FetchAndJoinCustomAudienceRequest;
import android.adservices.customaudience.ICustomAudienceCallback;
import android.adservices.customaudience.ICustomAudienceService;
import android.adservices.customaudience.JoinCustomAudienceRequest;
import android.adservices.customaudience.LeaveCustomAudienceRequest;
import android.adservices.customaudience.ScheduleCustomAudienceUpdateCallback;
import android.adservices.customaudience.ScheduleCustomAudienceUpdateInput;
import android.adservices.customaudience.ScheduleCustomAudienceUpdateRequest;
import android.adservices.customaudience.TestCustomAudienceManager;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.app.sdksandbox.SandboxedSdkContext;
import android.content.Context;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os._Original_Build;
import com.android.adservices.LoggerFactory;
import com.android.adservices.ServiceBinder;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(value=31)
public class CustomAudienceManager {
    private static final LoggerFactory.Logger sLogger = LoggerFactory.getFledgeLogger();
    public static final String CUSTOM_AUDIENCE_SERVICE = "custom_audience_service";
    @NonNull
    private Context mContext;
    @NonNull
    private ServiceBinder<ICustomAudienceService> mServiceBinder;

    @NonNull
    public static CustomAudienceManager get(@NonNull Context context) {
        return _Original_Build.VERSION.SDK_INT >= 33 ? context.getSystemService(CustomAudienceManager.class) : new CustomAudienceManager(context);
    }

    public CustomAudienceManager(@NonNull Context context) {
        Objects.requireNonNull(context);
        this.initialize(context);
    }

    public CustomAudienceManager initialize(@NonNull Context context) {
        Objects.requireNonNull(context);
        this.mContext = context;
        this.mServiceBinder = ServiceBinder.getServiceBinder(context, "android.adservices.customaudience.CUSTOM_AUDIENCE_SERVICE", ICustomAudienceService.Stub::asInterface);
        return this;
    }

    @NonNull
    public TestCustomAudienceManager getTestCustomAudienceManager() {
        return new TestCustomAudienceManager(this, this.getCallerPackageName());
    }

    @NonNull
    ICustomAudienceService getService() {
        ICustomAudienceService service = this.mServiceBinder.getService();
        if (service == null) {
            throw new IllegalStateException("custom audience service is not available.");
        }
        return service;
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void joinCustomAudience(@NonNull JoinCustomAudienceRequest joinCustomAudienceRequest, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(joinCustomAudienceRequest);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        CustomAudience customAudience = joinCustomAudienceRequest.getCustomAudience();
        try {
            ICustomAudienceService service = this.getService();
            service.joinCustomAudience(customAudience, this.getCallerPackageName(), new ICustomAudienceCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Internal Error!", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void fetchAndJoinCustomAudience(@NonNull FetchAndJoinCustomAudienceRequest fetchAndJoinCustomAudienceRequest, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(fetchAndJoinCustomAudienceRequest);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            ICustomAudienceService service = this.getService();
            service.fetchAndJoinCustomAudience(new FetchAndJoinCustomAudienceInput.Builder(fetchAndJoinCustomAudienceRequest.getFetchUri(), this.getCallerPackageName()).setName(fetchAndJoinCustomAudienceRequest.getName()).setActivationTime(fetchAndJoinCustomAudienceRequest.getActivationTime()).setExpirationTime(fetchAndJoinCustomAudienceRequest.getExpirationTime()).setUserBiddingSignals(fetchAndJoinCustomAudienceRequest.getUserBiddingSignals()).build(), new FetchAndJoinCustomAudienceCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Internal Error!", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void leaveCustomAudience(@NonNull LeaveCustomAudienceRequest leaveCustomAudienceRequest, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(leaveCustomAudienceRequest);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        AdTechIdentifier buyer = leaveCustomAudienceRequest.getBuyer();
        String name = leaveCustomAudienceRequest.getName();
        try {
            ICustomAudienceService service = this.getService();
            service.leaveCustomAudience(this.getCallerPackageName(), buyer, name, new ICustomAudienceCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Internal Error!", e));
        }
    }

    @FlaggedApi(value="com.android.adservices.flags.fledge_schedule_custom_audience_update_enabled")
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void scheduleCustomAudienceUpdate(@NonNull ScheduleCustomAudienceUpdateRequest request, final @NonNull Executor executor, final @NonNull AdServicesOutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            ICustomAudienceService service = this.getService();
            service.scheduleCustomAudienceUpdate(new ScheduleCustomAudienceUpdateInput.Builder(request.getUpdateUri(), this.getCallerPackageName(), request.getMinDelay(), request.getPartialCustomAudienceList()).setShouldReplacePendingUpdates(request.shouldReplacePendingUpdates()).build(), new ScheduleCustomAudienceUpdateCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Internal Error!", e));
        }
    }

    private String getCallerPackageName() {
        SandboxedSdkContext sandboxedSdkContext = SandboxedSdkContextUtils.getAsSandboxedSdkContext(this.mContext);
        return sandboxedSdkContext == null ? this.mContext.getPackageName() : sandboxedSdkContext.getClientPackageName();
    }
}

