/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseIntArray;
import com.android.internal.util.Preconditions;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
public class AdServicesUserChoicesResponse
implements Parcelable {
    private final int mStatusCode;
    private final String mErrorMessage;
    private final SparseIntArray mUserChoices;
    @NonNull
    public static final Parcelable.Creator<AdServicesUserChoicesResponse> CREATOR = new Parcelable.Creator<AdServicesUserChoicesResponse>(){

        @Override
        public AdServicesUserChoicesResponse createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new AdServicesUserChoicesResponse(in);
        }

        public AdServicesUserChoicesResponse[] newArray(int size) {
            return new AdServicesUserChoicesResponse[size];
        }
    };

    private AdServicesUserChoicesResponse(int statusCode, @Nullable String errorMessage, SparseIntArray userChoices) {
        this.mStatusCode = statusCode;
        this.mErrorMessage = errorMessage;
        this.mUserChoices = userChoices;
    }

    private AdServicesUserChoicesResponse(@NonNull Parcel in) {
        this.mStatusCode = in.readInt();
        this.mErrorMessage = in.readString();
        int userChoicesSize = in.readInt();
        this.mUserChoices = new SparseIntArray(userChoicesSize);
        for (int i = 0; i < userChoicesSize; ++i) {
            this.mUserChoices.put(in.readInt(), in.readInt());
        }
    }

    int getStatusCode() {
        return this.mStatusCode;
    }

    @NonNull
    public SparseIntArray getUserChoices() {
        return this.mUserChoices;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        Objects.requireNonNull(out);
        out.writeInt(this.mStatusCode);
        out.writeString(this.mErrorMessage);
        int size = this.mUserChoices.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeInt(this.mUserChoices.keyAt(i));
            out.writeInt(this.mUserChoices.valueAt(i));
        }
    }

    public String toString() {
        return "EnableAdServicesResponse{mStatusCode=" + this.mStatusCode + ", mErrorMessage=" + this.mErrorMessage + ", mUserChoices=" + this.mUserChoices + "'}";
    }

    public static class Builder {
        private int mStatusCode = -1;
        @Nullable
        private String mErrorMessage;
        private SparseIntArray mUserChoices;

        @NonNull
        public Builder setStatusCode(int statusCode) {
            this.mStatusCode = statusCode;
            return this;
        }

        @NonNull
        public Builder setErrorMessage(@Nullable String errorMessage) {
            this.mErrorMessage = errorMessage;
            return this;
        }

        @NonNull
        public Builder setUserChoices(@Nullable SparseIntArray userChoices) {
            this.mUserChoices = userChoices;
            return this;
        }

        @NonNull
        public AdServicesUserChoicesResponse build() {
            Preconditions.checkArgument(this.mStatusCode != -1, "Status code has not been set!");
            return new AdServicesUserChoicesResponse(this.mStatusCode, this.mErrorMessage, this.mUserChoices);
        }
    }
}

