/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.adservices.common.AdFilters;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import com.android.internal.util.Preconditions;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class AdData
implements Parcelable {
    public static final String NUM_AD_COUNTER_KEYS_EXCEEDED_FORMAT = "AdData should have no more than %d ad counter keys";
    public static final int MAX_NUM_AD_COUNTER_KEYS = 10;
    @NonNull
    private final Uri mRenderUri;
    @NonNull
    private final String mMetadata;
    @NonNull
    private final Set<Integer> mAdCounterKeys;
    @Nullable
    private final AdFilters mAdFilters;
    @Nullable
    private final String mAdRenderId;
    @NonNull
    public static final Parcelable.Creator<AdData> CREATOR = new Parcelable.Creator<AdData>(){

        @Override
        public AdData createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new AdData(in);
        }

        public AdData[] newArray(int size) {
            return new AdData[size];
        }
    };

    private AdData(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mRenderUri = builder.mRenderUri;
        this.mMetadata = builder.mMetadata;
        this.mAdCounterKeys = builder.mAdCounterKeys;
        this.mAdFilters = builder.mAdFilters;
        this.mAdRenderId = builder.mAdRenderId;
    }

    private AdData(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mRenderUri = Uri.CREATOR.createFromParcel(in);
        this.mMetadata = in.readString();
        this.mAdCounterKeys = AdServicesParcelableUtil.readNullableFromParcel(in, AdServicesParcelableUtil::readIntegerSetFromParcel);
        this.mAdFilters = AdServicesParcelableUtil.readNullableFromParcel(in, AdFilters.CREATOR::createFromParcel);
        this.mAdRenderId = in.readString();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        this.mRenderUri.writeToParcel(dest, flags);
        dest.writeString(this.mMetadata);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mAdCounterKeys, AdServicesParcelableUtil::writeIntegerSetToParcel);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mAdFilters, (targetParcel, sourceFilters) -> sourceFilters.writeToParcel(targetParcel, flags));
        dest.writeString(this.mAdRenderId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public Uri getRenderUri() {
        return this.mRenderUri;
    }

    @NonNull
    public String getMetadata() {
        return this.mMetadata;
    }

    @NonNull
    public Set<Integer> getAdCounterKeys() {
        return this.mAdCounterKeys;
    }

    @Nullable
    public AdFilters getAdFilters() {
        return this.mAdFilters;
    }

    @Nullable
    public String getAdRenderId() {
        return this.mAdRenderId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdData)) {
            return false;
        }
        AdData adData = (AdData)o;
        return ((Object)this.mRenderUri).equals(adData.mRenderUri) && this.mMetadata.equals(adData.mMetadata) && this.mAdCounterKeys.equals(adData.mAdCounterKeys) && Objects.equals(this.mAdFilters, adData.mAdFilters) && Objects.equals(this.mAdRenderId, adData.mAdRenderId);
    }

    public int hashCode() {
        return Objects.hash(this.mRenderUri, this.mMetadata, this.mAdCounterKeys, this.mAdFilters);
    }

    public String toString() {
        return "AdData{mRenderUri=" + this.mRenderUri + ", mMetadata='" + this.mMetadata + '\'' + ", mAdCounterKeys=" + this.mAdCounterKeys + ", mAdFilters=" + this.mAdFilters + ", mAdRenderId='" + this.mAdRenderId + '\'' + '}';
    }

    public static class Builder {
        @Nullable
        private Uri mRenderUri;
        @Nullable
        private String mMetadata;
        @NonNull
        private Set<Integer> mAdCounterKeys = new HashSet<Integer>();
        @Nullable
        private AdFilters mAdFilters;
        @Nullable
        private String mAdRenderId;

        @NonNull
        public Builder setRenderUri(@NonNull Uri renderUri) {
            Objects.requireNonNull(renderUri);
            this.mRenderUri = renderUri;
            return this;
        }

        @NonNull
        public Builder setMetadata(@NonNull String metadata) {
            Objects.requireNonNull(metadata);
            this.mMetadata = metadata;
            return this;
        }

        @NonNull
        public Builder setAdCounterKeys(@NonNull Set<Integer> adCounterKeys) {
            Objects.requireNonNull(adCounterKeys);
            Preconditions.checkArgument(!adCounterKeys.contains(null), "Ad counter keys must not contain null value");
            Preconditions.checkArgument(adCounterKeys.size() <= 10, AdData.NUM_AD_COUNTER_KEYS_EXCEEDED_FORMAT, 10);
            this.mAdCounterKeys = adCounterKeys;
            return this;
        }

        @NonNull
        public Builder setAdFilters(@Nullable AdFilters adFilters) {
            this.mAdFilters = adFilters;
            return this;
        }

        @NonNull
        public Builder setAdRenderId(@Nullable String adRenderId) {
            this.mAdRenderId = adRenderId;
            return this;
        }

        @NonNull
        public AdData build() {
            Objects.requireNonNull(this.mRenderUri, "The render URI has not been provided");
            Objects.requireNonNull(this.mMetadata, "The metadata has not been provided");
            return new AdData(this);
        }
    }
}

