/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class UpdateAdCounterHistogramInput
implements Parcelable {
    private static final String UNSET_CALLER_PACKAGE_NAME_MESSAGE = "Caller package name must not be null";
    private final long mAdSelectionId;
    private final int mAdEventType;
    @NonNull
    private final AdTechIdentifier mCallerAdTech;
    @NonNull
    private final String mCallerPackageName;
    @NonNull
    public static final Parcelable.Creator<UpdateAdCounterHistogramInput> CREATOR = new Parcelable.Creator<UpdateAdCounterHistogramInput>(){

        @Override
        public UpdateAdCounterHistogramInput createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new UpdateAdCounterHistogramInput(in);
        }

        public UpdateAdCounterHistogramInput[] newArray(int size) {
            return new UpdateAdCounterHistogramInput[size];
        }
    };

    private UpdateAdCounterHistogramInput(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mAdSelectionId = builder.mAdSelectionId;
        this.mAdEventType = builder.mAdEventType;
        this.mCallerAdTech = builder.mCallerAdTech;
        this.mCallerPackageName = builder.mCallerPackageName;
    }

    private UpdateAdCounterHistogramInput(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mAdSelectionId = in.readLong();
        this.mAdEventType = in.readInt();
        this.mCallerAdTech = AdTechIdentifier.CREATOR.createFromParcel(in);
        this.mCallerPackageName = in.readString();
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    public int getAdEventType() {
        return this.mAdEventType;
    }

    @NonNull
    public AdTechIdentifier getCallerAdTech() {
        return this.mCallerAdTech;
    }

    @NonNull
    public String getCallerPackageName() {
        return this.mCallerPackageName;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mAdSelectionId);
        dest.writeInt(this.mAdEventType);
        this.mCallerAdTech.writeToParcel(dest, flags);
        dest.writeString(this.mCallerPackageName);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAdCounterHistogramInput)) {
            return false;
        }
        UpdateAdCounterHistogramInput that = (UpdateAdCounterHistogramInput)o;
        return this.mAdSelectionId == that.mAdSelectionId && this.mAdEventType == that.mAdEventType && this.mCallerAdTech.equals(that.mCallerAdTech) && this.mCallerPackageName.equals(that.mCallerPackageName);
    }

    public int hashCode() {
        return Objects.hash(this.mAdSelectionId, this.mAdEventType, this.mCallerAdTech, this.mCallerPackageName);
    }

    public String toString() {
        return "UpdateAdCounterHistogramInput{mAdSelectionId=" + this.mAdSelectionId + ", mAdEventType=" + this.mAdEventType + ", mCallerAdTech=" + this.mCallerAdTech + ", mCallerPackageName='" + this.mCallerPackageName + '\'' + '}';
    }

    public static class Builder {
        private long mAdSelectionId;
        private int mAdEventType;
        @NonNull
        private AdTechIdentifier mCallerAdTech;
        @NonNull
        private String mCallerPackageName;

        public Builder(long adSelectionId, int adEventType, @NonNull AdTechIdentifier callerAdTech, @NonNull String callerPackageName) {
            Preconditions.checkArgument(adSelectionId != 0L, "Non-zero ad selection ID must be set");
            Preconditions.checkArgument(adEventType != 0, "Win event types cannot be manually updated");
            Preconditions.checkArgument(adEventType >= 0 && adEventType <= 3, "Ad event type must be one of AD_EVENT_TYPE_IMPRESSION, AD_EVENT_TYPE_VIEW, or AD_EVENT_TYPE_CLICK");
            Objects.requireNonNull(callerAdTech, "Caller ad tech must not be null");
            Objects.requireNonNull(callerPackageName, UpdateAdCounterHistogramInput.UNSET_CALLER_PACKAGE_NAME_MESSAGE);
            this.mAdSelectionId = adSelectionId;
            this.mAdEventType = adEventType;
            this.mCallerAdTech = callerAdTech;
            this.mCallerPackageName = callerPackageName;
        }

        @NonNull
        public Builder setAdSelectionId(long adSelectionId) {
            Preconditions.checkArgument(adSelectionId != 0L, "Non-zero ad selection ID must be set");
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        @NonNull
        public Builder setAdEventType(int adEventType) {
            Preconditions.checkArgument(adEventType != 0, "Win event types cannot be manually updated");
            Preconditions.checkArgument(adEventType >= 0 && adEventType <= 3, "Ad event type must be one of AD_EVENT_TYPE_IMPRESSION, AD_EVENT_TYPE_VIEW, or AD_EVENT_TYPE_CLICK");
            this.mAdEventType = adEventType;
            return this;
        }

        @NonNull
        public Builder setCallerAdTech(@NonNull AdTechIdentifier callerAdTech) {
            Objects.requireNonNull(callerAdTech, "Caller ad tech must not be null");
            this.mCallerAdTech = callerAdTech;
            return this;
        }

        @NonNull
        public Builder setCallerPackageName(@NonNull String callerPackageName) {
            Objects.requireNonNull(callerPackageName, UpdateAdCounterHistogramInput.UNSET_CALLER_PACKAGE_NAME_MESSAGE);
            this.mCallerPackageName = callerPackageName;
            return this;
        }

        @NonNull
        public UpdateAdCounterHistogramInput build() {
            return new UpdateAdCounterHistogramInput(this);
        }
    }
}

