/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.util.Preconditions;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SetAdCounterHistogramOverrideRequest {
    public static final String NULL_HISTOGRAM_TIMESTAMPS_MESSAGE = "List of histogram timestamps must not be null";
    public static final String NULL_BUYER_MESSAGE = "Buyer must not be null";
    public static final String NULL_CUSTOM_AUDIENCE_OWNER_MESSAGE = "Custom audience owner must not be null";
    public static final String NULL_CUSTOM_AUDIENCE_NAME_MESSAGE = "Custom audience name must not be null";
    private final int mAdEventType;
    private final int mAdCounterKey;
    @NonNull
    private final List<Instant> mHistogramTimestamps;
    @NonNull
    private final AdTechIdentifier mBuyer;
    @NonNull
    private final String mCustomAudienceOwner;
    @NonNull
    private final String mCustomAudienceName;

    private SetAdCounterHistogramOverrideRequest(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mAdEventType = builder.mAdEventType;
        this.mAdCounterKey = builder.mAdCounterKey;
        this.mHistogramTimestamps = builder.mHistogramTimestamps;
        this.mBuyer = builder.mBuyer;
        this.mCustomAudienceOwner = builder.mCustomAudienceOwner;
        this.mCustomAudienceName = builder.mCustomAudienceName;
    }

    public int getAdEventType() {
        return this.mAdEventType;
    }

    @NonNull
    public int getAdCounterKey() {
        return this.mAdCounterKey;
    }

    @NonNull
    public List<Instant> getHistogramTimestamps() {
        return this.mHistogramTimestamps;
    }

    @NonNull
    public AdTechIdentifier getBuyer() {
        return this.mBuyer;
    }

    @NonNull
    public String getCustomAudienceOwner() {
        return this.mCustomAudienceOwner;
    }

    @NonNull
    public String getCustomAudienceName() {
        return this.mCustomAudienceName;
    }

    public String toString() {
        return "SetAdCounterHistogramOverrideRequest{mAdEventType=" + this.mAdEventType + ", mAdCounterKey=" + this.mAdCounterKey + ", mHistogramTimestamps=" + this.mHistogramTimestamps + ", mBuyer=" + this.mBuyer + ", mCustomAudienceOwner='" + this.mCustomAudienceOwner + "', mCustomAudienceName='" + this.mCustomAudienceName + "'}";
    }

    public static class Builder {
        private int mAdEventType = -1;
        private int mAdCounterKey;
        @NonNull
        private List<Instant> mHistogramTimestamps = new ArrayList<Instant>();
        @Nullable
        private AdTechIdentifier mBuyer;
        @Nullable
        private String mCustomAudienceOwner;
        @Nullable
        private String mCustomAudienceName;

        @NonNull
        public Builder setAdEventType(int adEventType) {
            this.mAdEventType = adEventType;
            return this;
        }

        @NonNull
        public Builder setAdCounterKey(int adCounterKey) {
            this.mAdCounterKey = adCounterKey;
            return this;
        }

        @NonNull
        public Builder setHistogramTimestamps(@NonNull List<Instant> histogramTimestamps) {
            Objects.requireNonNull(histogramTimestamps, SetAdCounterHistogramOverrideRequest.NULL_HISTOGRAM_TIMESTAMPS_MESSAGE);
            this.mHistogramTimestamps = histogramTimestamps;
            return this;
        }

        @NonNull
        public Builder setBuyer(@NonNull AdTechIdentifier buyer) {
            Objects.requireNonNull(buyer, SetAdCounterHistogramOverrideRequest.NULL_BUYER_MESSAGE);
            this.mBuyer = buyer;
            return this;
        }

        @NonNull
        public Builder setCustomAudienceOwner(@NonNull String customAudienceOwner) {
            Objects.requireNonNull(customAudienceOwner, SetAdCounterHistogramOverrideRequest.NULL_CUSTOM_AUDIENCE_OWNER_MESSAGE);
            this.mCustomAudienceOwner = customAudienceOwner;
            return this;
        }

        @NonNull
        public Builder setCustomAudienceName(@NonNull String customAudienceName) {
            Objects.requireNonNull(customAudienceName, SetAdCounterHistogramOverrideRequest.NULL_CUSTOM_AUDIENCE_NAME_MESSAGE);
            this.mCustomAudienceName = customAudienceName;
            return this;
        }

        @NonNull
        public SetAdCounterHistogramOverrideRequest build() throws NullPointerException, IllegalArgumentException {
            Preconditions.checkArgument(this.mAdEventType != -1, "Ad event type must be set");
            Objects.requireNonNull(this.mBuyer, SetAdCounterHistogramOverrideRequest.NULL_BUYER_MESSAGE);
            Objects.requireNonNull(this.mCustomAudienceOwner, SetAdCounterHistogramOverrideRequest.NULL_CUSTOM_AUDIENCE_OWNER_MESSAGE);
            Objects.requireNonNull(this.mCustomAudienceName, SetAdCounterHistogramOverrideRequest.NULL_CUSTOM_AUDIENCE_NAME_MESSAGE);
            return new SetAdCounterHistogramOverrideRequest(this);
        }
    }
}

