/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.view.InputEvent;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class ReportEventRequest {
    public static final int FLAG_REPORTING_DESTINATION_SELLER = 1;
    public static final int FLAG_REPORTING_DESTINATION_BUYER = 2;
    @FlaggedApi(value="com.android.adservices.flags.fledge_enable_report_event_for_component_seller")
    public static final int FLAG_REPORTING_DESTINATION_COMPONENT_SELLER = 4;
    private static final int UNSET_REPORTING_DESTINATIONS = 0;
    private static final String UNSET_REPORTING_DESTINATIONS_MESSAGE = "Reporting destinations bitfield not set.";
    private static final String INVALID_REPORTING_DESTINATIONS_MESSAGE = "Invalid reporting destinations bitfield!";
    public static final long REPORT_EVENT_MAX_INTERACTION_DATA_SIZE_B = 65536L;
    private static final String EVENT_DATA_SIZE_MAX_EXCEEDED = "Event data should not exceed 65536 bytes";
    private final long mAdSelectionId;
    @NonNull
    private final String mEventKey;
    @Nullable
    private final InputEvent mInputEvent;
    @NonNull
    private final String mEventData;
    private final int mReportingDestinations;

    private ReportEventRequest(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        Preconditions.checkArgument(builder.mAdSelectionId != 0L, "Non-zero ad selection ID must be set");
        Preconditions.checkArgument(builder.mReportingDestinations != 0, UNSET_REPORTING_DESTINATIONS_MESSAGE);
        Preconditions.checkArgument(ReportEventRequest.isValidDestination(builder.mReportingDestinations), INVALID_REPORTING_DESTINATIONS_MESSAGE);
        Preconditions.checkArgument((long)builder.mEventData.getBytes(StandardCharsets.UTF_8).length <= 65536L, EVENT_DATA_SIZE_MAX_EXCEEDED);
        this.mAdSelectionId = builder.mAdSelectionId;
        this.mEventKey = builder.mEventKey;
        this.mInputEvent = builder.mInputEvent;
        this.mEventData = builder.mEventData;
        this.mReportingDestinations = builder.mReportingDestinations;
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    @NonNull
    public String getKey() {
        return this.mEventKey;
    }

    @Nullable
    public InputEvent getInputEvent() {
        return this.mInputEvent;
    }

    @NonNull
    public String getData() {
        return this.mEventData;
    }

    public int getReportingDestinations() {
        return this.mReportingDestinations;
    }

    private static boolean isValidDestination(int reportingDestinations) {
        return 0 < reportingDestinations && reportingDestinations <= 7;
    }

    public static class Builder {
        private long mAdSelectionId;
        @NonNull
        private String mEventKey;
        @Nullable
        private InputEvent mInputEvent;
        @NonNull
        private String mEventData;
        private int mReportingDestinations;

        public Builder(long adSelectionId, @NonNull String eventKey, @NonNull String eventData, int reportingDestinations) {
            Objects.requireNonNull(eventKey);
            Objects.requireNonNull(eventData);
            Preconditions.checkArgument(adSelectionId != 0L, "Non-zero ad selection ID must be set");
            Preconditions.checkArgument(reportingDestinations != 0, ReportEventRequest.UNSET_REPORTING_DESTINATIONS_MESSAGE);
            Preconditions.checkArgument(ReportEventRequest.isValidDestination(reportingDestinations), ReportEventRequest.INVALID_REPORTING_DESTINATIONS_MESSAGE);
            Preconditions.checkArgument((long)eventData.getBytes(StandardCharsets.UTF_8).length <= 65536L, ReportEventRequest.EVENT_DATA_SIZE_MAX_EXCEEDED);
            this.mAdSelectionId = adSelectionId;
            this.mEventKey = eventKey;
            this.mEventData = eventData;
            this.mReportingDestinations = reportingDestinations;
        }

        @NonNull
        public Builder setAdSelectionId(long adSelectionId) {
            Preconditions.checkArgument(adSelectionId != 0L, "Non-zero ad selection ID must be set");
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        @NonNull
        public Builder setKey(@NonNull String eventKey) {
            Objects.requireNonNull(eventKey);
            this.mEventKey = eventKey;
            return this;
        }

        @NonNull
        public Builder setInputEvent(@Nullable InputEvent inputEvent) {
            this.mInputEvent = inputEvent;
            return this;
        }

        @NonNull
        public Builder setData(@NonNull String eventData) {
            Objects.requireNonNull(eventData);
            this.mEventData = eventData;
            return this;
        }

        @NonNull
        public Builder setReportingDestinations(int reportingDestinations) {
            Preconditions.checkArgument(ReportEventRequest.isValidDestination(reportingDestinations), ReportEventRequest.INVALID_REPORTING_DESTINATIONS_MESSAGE);
            this.mReportingDestinations = reportingDestinations;
            return this;
        }

        @NonNull
        public ReportEventRequest build() {
            return new ReportEventRequest(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ReportingDestination {
    }
}

