/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class RemoveAdCounterHistogramOverrideRequest {
    private final int mAdEventType;
    private final int mAdCounterKey;
    @NonNull
    private final AdTechIdentifier mBuyer;

    private RemoveAdCounterHistogramOverrideRequest(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mAdEventType = builder.mAdEventType;
        this.mAdCounterKey = builder.mAdCounterKey;
        this.mBuyer = builder.mBuyer;
    }

    public int getAdEventType() {
        return this.mAdEventType;
    }

    @NonNull
    public int getAdCounterKey() {
        return this.mAdCounterKey;
    }

    @NonNull
    public AdTechIdentifier getBuyer() {
        return this.mBuyer;
    }

    public String toString() {
        return "RemoveAdCounterHistogramOverrideRequest{mAdEventType=" + this.mAdEventType + ", mAdCounterKey=" + this.mAdCounterKey + ", mBuyer=" + this.mBuyer + '}';
    }

    public static class Builder {
        private int mAdEventType = -1;
        private int mAdCounterKey;
        @Nullable
        private AdTechIdentifier mBuyer;

        @NonNull
        public Builder setAdEventType(int adEventType) {
            this.mAdEventType = adEventType;
            return this;
        }

        @NonNull
        public Builder setAdCounterKey(int adCounterKey) {
            this.mAdCounterKey = adCounterKey;
            return this;
        }

        @NonNull
        public Builder setBuyer(@NonNull AdTechIdentifier buyer) {
            Objects.requireNonNull(buyer, "Buyer must not be null");
            this.mBuyer = buyer;
            return this;
        }

        @NonNull
        public RemoveAdCounterHistogramOverrideRequest build() throws NullPointerException, IllegalArgumentException {
            Preconditions.checkArgument(this.mAdEventType != -1, "Ad event type must be set");
            Objects.requireNonNull(this.mBuyer, "Buyer must not be null");
            return new RemoveAdCounterHistogramOverrideRequest(this);
        }
    }
}

