/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;

public class PersistAdSelectionResultRequest {
    private final long mAdSelectionId;
    @Nullable
    private final AdTechIdentifier mSeller;
    @Nullable
    private final byte[] mAdSelectionResult;

    private PersistAdSelectionResultRequest(long adSelectionId, @Nullable AdTechIdentifier seller, @Nullable byte[] adSelectionResult) {
        this.mAdSelectionId = adSelectionId;
        this.mSeller = seller;
        this.mAdSelectionResult = adSelectionResult;
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    @FlaggedApi(value="com.android.adservices.flags.fledge_auction_server_get_ad_selection_data_id_enabled")
    public long getAdSelectionDataId() {
        return this.mAdSelectionId;
    }

    @Nullable
    public AdTechIdentifier getSeller() {
        return this.mSeller;
    }

    @Nullable
    public byte[] getAdSelectionResult() {
        if (Objects.isNull(this.mAdSelectionResult)) {
            return null;
        }
        return Arrays.copyOf(this.mAdSelectionResult, this.mAdSelectionResult.length);
    }

    public static class Builder {
        private long mAdSelectionId;
        @Nullable
        private AdTechIdentifier mSeller;
        @Nullable
        private byte[] mAdSelectionResult;

        @NonNull
        public Builder setAdSelectionId(long adSelectionId) {
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.adservices.flags.fledge_auction_server_get_ad_selection_data_id_enabled")
        public Builder setAdSelectionDataId(long adSelectionDataId) {
            this.mAdSelectionId = adSelectionDataId;
            return this;
        }

        @NonNull
        public Builder setSeller(@Nullable AdTechIdentifier seller) {
            this.mSeller = seller;
            return this;
        }

        @NonNull
        public Builder setAdSelectionResult(@Nullable byte[] adSelectionResult) {
            this.mAdSelectionResult = (byte[])(!Objects.isNull(adSelectionResult) ? Arrays.copyOf(adSelectionResult, adSelectionResult.length) : null);
            return this;
        }

        @NonNull
        public PersistAdSelectionResultRequest build() {
            Preconditions.checkArgument(this.mAdSelectionId != 0L, "Non-zero ad selection ID must be set");
            return new PersistAdSelectionResultRequest(this.mAdSelectionId, this.mSeller, this.mAdSelectionResult);
        }
    }
}

