/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;

public class PersistAdSelectionResultInput
implements Parcelable {
    private final long mAdSelectionId;
    @Nullable
    private final AdTechIdentifier mSeller;
    @Nullable
    private final byte[] mAdSelectionResult;
    @NonNull
    private final String mCallerPackageName;
    @NonNull
    public static final Parcelable.Creator<PersistAdSelectionResultInput> CREATOR = new Parcelable.Creator<PersistAdSelectionResultInput>(){

        @Override
        public PersistAdSelectionResultInput createFromParcel(Parcel in) {
            return new PersistAdSelectionResultInput(in);
        }

        public PersistAdSelectionResultInput[] newArray(int size) {
            return new PersistAdSelectionResultInput[size];
        }
    };

    private PersistAdSelectionResultInput(long adSelectionId, @Nullable AdTechIdentifier seller, @Nullable byte[] adSelectionResult, @NonNull String callerPackageName) {
        Objects.requireNonNull(callerPackageName);
        this.mAdSelectionId = adSelectionId;
        this.mSeller = seller;
        this.mAdSelectionResult = adSelectionResult;
        this.mCallerPackageName = callerPackageName;
    }

    private PersistAdSelectionResultInput(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mAdSelectionId = in.readLong();
        this.mSeller = AdServicesParcelableUtil.readNullableFromParcel(in, AdTechIdentifier.CREATOR::createFromParcel);
        this.mAdSelectionResult = in.createByteArray();
        this.mCallerPackageName = in.readString();
    }

    public boolean equals(Object o) {
        if (o instanceof PersistAdSelectionResultInput) {
            PersistAdSelectionResultInput obj = (PersistAdSelectionResultInput)o;
            return this.mAdSelectionId == obj.mAdSelectionId && Objects.equals(this.mSeller, obj.mSeller) && Arrays.equals(this.mAdSelectionResult, obj.mAdSelectionResult) && Objects.equals(this.mCallerPackageName, obj.mCallerPackageName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mAdSelectionId, this.mSeller, Arrays.hashCode(this.mAdSelectionResult), this.mCallerPackageName);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeLong(this.mAdSelectionId);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mSeller, (targetParcel, sourceSignals) -> sourceSignals.writeToParcel(targetParcel, flags));
        dest.writeByteArray(this.mAdSelectionResult);
        dest.writeString(this.mCallerPackageName);
    }

    public long getAdSelectionId() {
        return this.mAdSelectionId;
    }

    @Nullable
    public AdTechIdentifier getSeller() {
        return this.mSeller;
    }

    @Nullable
    public byte[] getAdSelectionResult() {
        if (Objects.isNull(this.mAdSelectionResult)) {
            return null;
        }
        return Arrays.copyOf(this.mAdSelectionResult, this.mAdSelectionResult.length);
    }

    @NonNull
    public String getCallerPackageName() {
        return this.mCallerPackageName;
    }

    public static class Builder {
        private long mAdSelectionId;
        @Nullable
        private AdTechIdentifier mSeller;
        @Nullable
        private byte[] mAdSelectionResult;
        @Nullable
        private String mCallerPackageName;

        @NonNull
        public Builder setAdSelectionId(long adSelectionId) {
            this.mAdSelectionId = adSelectionId;
            return this;
        }

        @NonNull
        public Builder setSeller(@Nullable AdTechIdentifier seller) {
            this.mSeller = seller;
            return this;
        }

        @NonNull
        public Builder setAdSelectionResult(@Nullable byte[] adSelectionResult) {
            this.mAdSelectionResult = (byte[])(!Objects.isNull(adSelectionResult) ? Arrays.copyOf(adSelectionResult, adSelectionResult.length) : null);
            return this;
        }

        @NonNull
        public Builder setCallerPackageName(@NonNull String callerPackageName) {
            Objects.requireNonNull(callerPackageName);
            this.mCallerPackageName = callerPackageName;
            return this;
        }

        @NonNull
        public PersistAdSelectionResultInput build() {
            Objects.requireNonNull(this.mCallerPackageName);
            Preconditions.checkArgument(this.mAdSelectionId != 0L, "Non-zero ad selection ID must be set");
            return new PersistAdSelectionResultInput(this.mAdSelectionId, this.mSeller, this.mAdSelectionResult, this.mCallerPackageName);
        }
    }
}

