/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.adselection.SellerConfiguration;
import android.adservices.common.AdTechIdentifier;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Uri;

public class GetAdSelectionDataRequest {
    @Nullable
    private final AdTechIdentifier mSeller;
    @Nullable
    private final Uri mCoordinatorOriginUri;
    @Nullable
    private final SellerConfiguration mSellerConfiguration;

    private GetAdSelectionDataRequest(@Nullable AdTechIdentifier seller, @Nullable Uri coordinatorOriginUri, @Nullable SellerConfiguration sellerConfiguration) {
        this.mSeller = seller;
        this.mCoordinatorOriginUri = coordinatorOriginUri;
        this.mSellerConfiguration = sellerConfiguration;
    }

    @Nullable
    public AdTechIdentifier getSeller() {
        return this.mSeller;
    }

    @Nullable
    @FlaggedApi(value="com.android.adservices.flags.fledge_server_auction_multi_cloud_enabled")
    public Uri getCoordinatorOriginUri() {
        return this.mCoordinatorOriginUri;
    }

    @FlaggedApi(value="com.android.adservices.flags.fledge_get_ad_selection_data_seller_configuration_enabled")
    @Nullable
    public SellerConfiguration getSellerConfiguration() {
        return this.mSellerConfiguration;
    }

    public static class Builder {
        @Nullable
        private AdTechIdentifier mSeller;
        @Nullable
        private Uri mCoordinatorOriginUri;
        @Nullable
        private SellerConfiguration mSellerConfiguration;

        @NonNull
        public Builder setSeller(@Nullable AdTechIdentifier seller) {
            this.mSeller = seller;
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.adservices.flags.fledge_server_auction_multi_cloud_enabled")
        public Builder setCoordinatorOriginUri(@Nullable Uri coordinatorOriginUri) {
            this.mCoordinatorOriginUri = coordinatorOriginUri;
            return this;
        }

        @NonNull
        public GetAdSelectionDataRequest build() {
            return new GetAdSelectionDataRequest(this.mSeller, this.mCoordinatorOriginUri, this.mSellerConfiguration);
        }

        @FlaggedApi(value="com.android.adservices.flags.fledge_get_ad_selection_data_seller_configuration_enabled")
        @NonNull
        public Builder setSellerConfiguration(@Nullable SellerConfiguration sellerConfiguration) {
            this.mSellerConfiguration = sellerConfiguration;
            return this;
        }
    }
}

