/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.android.tools.adtui.common.ColoredIconGeneratorKt;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.icons.RgbImageFilterSupplier;
import java.awt.Color;
import java.awt.image.RGBImageFilter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\n\u0010\u000b\u001a\u00020\t*\u00020\t\u00a8\u0006\f"}, d2={"Lcom/android/tools/adtui/common/ColoredIconGenerator;", "", "<init>", "()V", "generateWhiteIcon", "Ljavax/swing/Icon;", "icon", "generateColoredIcon", "color", "Ljava/awt/Color;", "generateDeEmphasizedIcon", "deEmphasize", "intellij.android.adt.ui"})
public final class ColoredIconGenerator {
    @NotNull
    public static final ColoredIconGenerator INSTANCE = new ColoredIconGenerator();

    private ColoredIconGenerator() {
    }

    @JvmStatic
    @NotNull
    public static final Icon generateWhiteIcon(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return INSTANCE.generateColoredIcon(icon, (Color)ColoredIconGeneratorKt.getWHITE());
    }

    @NotNull
    public final Icon generateColoredIcon(@NotNull Icon icon, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return IconLoader.createLazy((Supplier)new Supplier<Icon>(color, icon){
            private final Map<Integer, Icon> cache;
            final /* synthetic */ Color $color;
            final /* synthetic */ Icon $icon;
            {
                this.$color = $color;
                this.$icon = $icon;
                this.cache = new LinkedHashMap<K, V>();
            }

            /*
             * WARNING - void declaration
             */
            public Icon get() {
                Object object;
                void key$iv;
                void $this$getOrPut$iv;
                Map<Integer, Icon> map2 = this.cache;
                Integer n = this.$color.getRGB();
                Icon icon = this.$icon;
                Color color = this.$color;
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Icon answer$iv = IconLoader.INSTANCE.filterIcon(icon, new RgbImageFilterSupplier(color){
                        final /* synthetic */ Color $color;
                        {
                            this.$color = $color;
                        }

                        public RGBImageFilter getFilter() {
                            return new RGBImageFilter(this.$color){
                                final /* synthetic */ Color $color;
                                {
                                    this.$color = $color;
                                }

                                public int filterRGB(int x, int y, int rgb) {
                                    return (rgb | 0xFFFFFF) & this.$color.getRGB();
                                }
                            };
                        }
                    });
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                return (Icon)object;
            }
        });
    }

    @NotNull
    public final Icon generateDeEmphasizedIcon(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return IconLoader.createLazy(() -> ColoredIconGenerator.generateDeEmphasizedIcon$lambda$0(icon));
    }

    @NotNull
    public final Color deEmphasize(@NotNull Color $this$deEmphasize) {
        Intrinsics.checkNotNullParameter((Object)$this$deEmphasize, (String)"<this>");
        return new Color($this$deEmphasize.getRed(), $this$deEmphasize.getGreen(), $this$deEmphasize.getBlue(), ($this$deEmphasize.getAlpha() + 1) / 2);
    }

    private static final Icon generateDeEmphasizedIcon$lambda$0(Icon $icon) {
        return IconLoader.INSTANCE.filterIcon($icon, new RgbImageFilterSupplier(){

            public RGBImageFilter getFilter() {
                return new RGBImageFilter(){

                    public int filterRGB(int x, int y, int rgb) {
                        return ColoredIconGenerator.INSTANCE.deEmphasize(new Color(rgb, true)).getRGB();
                    }
                };
            }
        });
    }
}

