/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.tasks.taskhandlers.singleartifact.cpu;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.TaskStage;
import com.android.tools.profilers.cpu.CpuCaptureSessionArtifact;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.taskbased.home.StartTaskSelectionError;
import com.android.tools.profilers.taskbased.home.TaskSelectionVerificationUtils;
import com.android.tools.profilers.tasks.args.TaskArgs;
import com.android.tools.profilers.tasks.args.singleartifact.cpu.CpuTaskArgs;
import com.android.tools.profilers.tasks.taskhandlers.singleartifact.SingleArtifactTaskHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0014J\u0014\u0010\u0013\u001a\u00020\u00112\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0014J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014J\n\u0010\u001f\u001a\u0004\u0018\u00010\u001eH$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/profilers/tasks/taskhandlers/singleartifact/cpu/CpuTaskHandler;", "Lcom/android/tools/profilers/tasks/taskhandlers/singleartifact/SingleArtifactTaskHandler;", "Lcom/android/tools/profilers/cpu/CpuProfilerStage;", "sessionsManager", "Lcom/android/tools/profilers/sessions/SessionsManager;", "<init>", "(Lcom/android/tools/profilers/sessions/SessionsManager;)V", "setupStage", "", "startCapture", "stage", "stopCapture", "loadTask", "", "args", "Lcom/android/tools/profilers/tasks/args/TaskArgs;", "createStartTaskArgs", "Lcom/android/tools/profilers/tasks/args/singleartifact/cpu/CpuTaskArgs;", "isStartupTask", "createLoadingTaskArgs", "artifact", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "checkSupportForDeviceAndProcess", "Lcom/android/tools/profilers/taskbased/home/StartTaskSelectionError;", "device", "Lcom/android/tools/profiler/proto/Common$Device;", "process", "Lcom/android/tools/profiler/proto/Common$Process;", "isDeviceSupported", "config", "Lcom/android/tools/profilers/cpu/config/ProfilingConfiguration;", "getCpuRecordingConfig", "intellij.android.profilers"})
public abstract class CpuTaskHandler
extends SingleArtifactTaskHandler<CpuProfilerStage> {
    @NotNull
    private final SessionsManager sessionsManager;

    public CpuTaskHandler(@NotNull SessionsManager sessionsManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionsManager), (String)"sessionsManager");
        super(sessionsManager);
        this.sessionsManager = sessionsManager;
    }

    @Override
    public void setupStage() {
        StudioProfilers studioProfilers = this.sessionsManager.getStudioProfilers();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
        StudioProfilers studioProfilers2 = studioProfilers;
        CpuProfilerStage stage = new CpuProfilerStage(studioProfilers2, this::stopTask);
        ProfilingConfiguration cpuRecordingConfig = this.getCpuRecordingConfig();
        if (this.sessionsManager.isSessionAlive()) {
            if (cpuRecordingConfig != null) {
                stage.getProfilerConfigModel().setProfilingConfiguration(cpuRecordingConfig);
            } else {
                throw new IllegalStateException("The task configuration cannot be null.");
            }
        }
        studioProfilers2.setStage(stage);
        super.setStage((TaskStage)stage);
    }

    @Override
    protected void startCapture(@NotNull CpuProfilerStage stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        stage.startCpuRecording();
    }

    @Override
    protected void stopCapture(@NotNull CpuProfilerStage stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        stage.stopCpuRecording();
    }

    @Override
    public boolean loadTask(@NotNull TaskArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!(args instanceof CpuTaskArgs)) {
            this.handleError("The task arguments (TaskArgs) supplied are not of the expected type (CpuTaskArgs)");
            return false;
        }
        CpuCaptureSessionArtifact cpuTaskArtifact = ((CpuTaskArgs)args).getCpuCaptureArtifact();
        if (cpuTaskArtifact == null) {
            this.handleError("The task arguments (CpuTaskArgs) supplied do not contains a valid artifact to load");
            return false;
        }
        this.loadCapture(cpuTaskArtifact);
        return true;
    }

    @Override
    @NotNull
    protected CpuTaskArgs createStartTaskArgs(boolean isStartupTask) {
        return new CpuTaskArgs(isStartupTask, null);
    }

    @Override
    @NotNull
    protected CpuTaskArgs createLoadingTaskArgs(@NotNull SessionArtifact<?> artifact2) {
        Intrinsics.checkNotNullParameter(artifact2, (String)"artifact");
        return new CpuTaskArgs(false, (CpuCaptureSessionArtifact)artifact2);
    }

    @Override
    @Nullable
    public StartTaskSelectionError checkSupportForDeviceAndProcess(@NotNull Common.Device device, @NotNull Common.Process process) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        ProfilingConfiguration config = this.getCpuRecordingConfig();
        boolean isDeviceSupported = this.isDeviceSupported(device, config);
        if (isDeviceSupported) {
            return null;
        }
        if (config == null) {
            return new StartTaskSelectionError(StartTaskSelectionError.StartTaskSelectionErrorCode.INVALID_DEVICE, "No task configuration was found for API " + device.getFeatureLevel() + " device");
        }
        return new StartTaskSelectionError(StartTaskSelectionError.StartTaskSelectionErrorCode.TASK_FROM_NOW_USING_API_BELOW_MIN, TaskSelectionVerificationUtils.INSTANCE.getMinApiStartTaskErrorMessage(config.getRequiredDeviceLevel()));
    }

    protected boolean isDeviceSupported(@NotNull Common.Device device, @Nullable ProfilingConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        return config != null && device.getFeatureLevel() >= config.getRequiredDeviceLevel();
    }

    @Nullable
    protected abstract ProfilingConfiguration getCpuRecordingConfig();
}

