/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.tasks.taskhandlers;

import com.android.tools.profilers.leakcanary.LeakCanaryTaskHandler;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import com.android.tools.profilers.tasks.taskhandlers.ProfilerTaskHandler;
import com.android.tools.profilers.tasks.taskhandlers.singleartifact.LiveTaskHandler;
import com.android.tools.profilers.tasks.taskhandlers.singleartifact.cpu.CallstackSampleTaskHandler;
import com.android.tools.profilers.tasks.taskhandlers.singleartifact.cpu.JavaKotlinMethodRecordingTaskHandler;
import com.android.tools.profilers.tasks.taskhandlers.singleartifact.cpu.SystemTraceTaskHandler;
import com.android.tools.profilers.tasks.taskhandlers.singleartifact.memory.HeapDumpTaskHandler;
import com.android.tools.profilers.tasks.taskhandlers.singleartifact.memory.JavaKotlinAllocationsTaskHandler;
import com.android.tools.profilers.tasks.taskhandlers.singleartifact.memory.NativeAllocationsTaskHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/profilers/tasks/taskhandlers/ProfilerTaskHandlerFactory;", "", "<init>", "()V", "createTaskHandlers", "", "Lcom/android/tools/profilers/tasks/ProfilerTaskType;", "Lcom/android/tools/profilers/tasks/taskhandlers/ProfilerTaskHandler;", "sessionsManager", "Lcom/android/tools/profilers/sessions/SessionsManager;", "intellij.android.profilers"})
public final class ProfilerTaskHandlerFactory {
    @NotNull
    public static final ProfilerTaskHandlerFactory INSTANCE = new ProfilerTaskHandlerFactory();

    private ProfilerTaskHandlerFactory() {
    }

    @NotNull
    public final Map<ProfilerTaskType, ProfilerTaskHandler> createTaskHandlers(@NotNull SessionsManager sessionsManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionsManager), (String)"sessionsManager");
        Map taskHandlers = new LinkedHashMap();
        boolean isTraceboxEnabled = sessionsManager.getStudioProfilers().getIdeServices().getFeatureConfig().isTraceboxEnabled();
        taskHandlers.put(ProfilerTaskType.SYSTEM_TRACE, new SystemTraceTaskHandler(sessionsManager, isTraceboxEnabled));
        taskHandlers.put(ProfilerTaskType.CALLSTACK_SAMPLE, new CallstackSampleTaskHandler(sessionsManager));
        taskHandlers.put(ProfilerTaskType.JAVA_KOTLIN_METHOD_RECORDING, new JavaKotlinMethodRecordingTaskHandler(sessionsManager));
        taskHandlers.put(ProfilerTaskType.HEAP_DUMP, new HeapDumpTaskHandler(sessionsManager));
        taskHandlers.put(ProfilerTaskType.NATIVE_ALLOCATIONS, new NativeAllocationsTaskHandler(sessionsManager));
        taskHandlers.put(ProfilerTaskType.JAVA_KOTLIN_ALLOCATIONS, new JavaKotlinAllocationsTaskHandler(sessionsManager));
        taskHandlers.put(ProfilerTaskType.LIVE_VIEW, new LiveTaskHandler(sessionsManager));
        if (sessionsManager.getStudioProfilers().getIdeServices().getFeatureConfig().isLeakCanaryEnabled()) {
            taskHandlers.put(ProfilerTaskType.LEAKCANARY, new LeakCanaryTaskHandler(sessionsManager));
        }
        return taskHandlers;
    }
}

