/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.tasks;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.taskbased.TaskNotifications;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import com.android.tools.profilers.tasks.args.TaskArgs;
import com.android.tools.profilers.tasks.taskhandlers.ProfilerTaskHandler;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002Jd\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\r2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0007\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/profilers/tasks/ProfilerTaskLauncher;", "", "<init>", "()V", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "launchProfilerTask", "", "selectedTaskType", "Lcom/android/tools/profilers/tasks/ProfilerTaskType;", "isStartupTask", "", "taskHandlers", "", "Lcom/android/tools/profilers/tasks/taskhandlers/ProfilerTaskHandler;", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "sessionIdToSessionItems", "", "Lcom/android/tools/profilers/sessions/SessionItem;", "openTaskTab", "Ljava/util/function/BiConsumer;", "Lcom/android/tools/profilers/tasks/args/TaskArgs;", "ideProfilerServices", "Lcom/android/tools/profilers/IdeProfilerServices;", "intellij.android.profilers"})
public final class ProfilerTaskLauncher {
    @NotNull
    public static final ProfilerTaskLauncher INSTANCE = new ProfilerTaskLauncher();

    private ProfilerTaskLauncher() {
    }

    private final Logger getLogger() {
        Logger logger = Logger.getInstance(ProfilerTaskLauncher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @JvmStatic
    public static final void launchProfilerTask(@NotNull ProfilerTaskType selectedTaskType, boolean isStartupTask, @NotNull Map<ProfilerTaskType, ? extends ProfilerTaskHandler> taskHandlers, @NotNull Common.Session session, @NotNull Map<Long, SessionItem> sessionIdToSessionItems, @NotNull BiConsumer<ProfilerTaskType, TaskArgs> openTaskTab, @NotNull IdeProfilerServices ideProfilerServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)selectedTaskType), (String)"selectedTaskType");
        Intrinsics.checkNotNullParameter(taskHandlers, (String)"taskHandlers");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(sessionIdToSessionItems, (String)"sessionIdToSessionItems");
        Intrinsics.checkNotNullParameter(openTaskTab, (String)"openTaskTab");
        Intrinsics.checkNotNullParameter((Object)ideProfilerServices, (String)"ideProfilerServices");
        if (!taskHandlers.containsKey((Object)selectedTaskType)) {
            INSTANCE.getLogger().error("The task type, " + selectedTaskType.getDescription() + ", does not have a corresponding task handler.");
            return;
        }
        ProfilerTaskHandler profilerTaskHandler = taskHandlers.get((Object)selectedTaskType);
        Intrinsics.checkNotNull((Object)profilerTaskHandler);
        ProfilerTaskHandler taskHandler = profilerTaskHandler;
        try {
            TaskArgs args = taskHandler.createArgs(isStartupTask, sessionIdToSessionItems, session);
            openTaskTab.accept(selectedTaskType, args);
        }
        catch (Exception e) {
            ideProfilerServices.showNotification(TaskNotifications.INSTANCE.getLAUNCH_TASK_FAILURE());
        }
    }
}

