/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.taskbased.home;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ProcessUtils;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.taskbased.home.StartTaskSelectionError;
import com.android.tools.profilers.taskbased.home.TaskHomeTabModel;
import com.android.tools.profilers.taskbased.home.selections.deviceprocesses.ProcessListModel;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import com.android.tools.profilers.tasks.TaskSupportUtils;
import com.android.tools.profilers.tasks.taskhandlers.ProfilerTaskHandler;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J6\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\nJ(\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J4\u0010 \u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u0013J0\u0010!\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019J\"\u0010\"\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\nH\u0002J*\u0010#\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J6\u0010%\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J0\u0010&\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u00060"}, d2={"Lcom/android/tools/profilers/taskbased/home/TaskSelectionVerificationUtils;", "", "<init>", "()V", "isTaskSelectionValid", "", "taskType", "Lcom/android/tools/profilers/tasks/ProfilerTaskType;", "isProcessSelectionValid", "process", "Lcom/android/tools/profiler/proto/Common$Process;", "isProcessAlive", "isDeviceSelectionValid", "device", "Lcom/android/tools/profilers/taskbased/home/selections/deviceprocesses/ProcessListModel$ProfilerDeviceSelection;", "isDeviceSelectionOnline", "isTaskSupportedByProcess", "selectedTaskType", "taskHandlers", "", "Lcom/android/tools/profilers/tasks/taskhandlers/ProfilerTaskHandler;", "selectedDevice", "selectedProcess", "isSelectedProcessPreferred", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "isProfileablePreferredButNotPresent", "profilingProcessStartingPoint", "Lcom/android/tools/profilers/taskbased/home/TaskHomeTabModel$ProfilingProcessStartingPoint;", "isTaskStartFromProcessStartEnabled", "isTaskStartFromNowEnabled", "canTaskStartFromProcessStart", "canTaskStartFromNow", "canStartTask", "areSelectionsValid", "getStartTaskFromProcessStartError", "Lcom/android/tools/profilers/taskbased/home/StartTaskSelectionError;", "getStartTaskFromNowStartError", "getStartTaskError", "getMinApiStartTaskErrorMessage", "", "minApi", "", "STARTUP_TASK_ERRORS", "", "Lcom/android/tools/profilers/taskbased/home/StartTaskSelectionError$StartTaskSelectionErrorCode;", "getSTARTUP_TASK_ERRORS", "()Ljava/util/List;", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nTaskSelectionVerificationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskSelectionVerificationUtils.kt\ncom/android/tools/profilers/taskbased/home/TaskSelectionVerificationUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n1#2:247\n*E\n"})
public final class TaskSelectionVerificationUtils {
    @NotNull
    public static final TaskSelectionVerificationUtils INSTANCE = new TaskSelectionVerificationUtils();
    @NotNull
    private static final List<StartTaskSelectionError.StartTaskSelectionErrorCode> STARTUP_TASK_ERRORS;

    private TaskSelectionVerificationUtils() {
    }

    private final boolean isTaskSelectionValid(ProfilerTaskType taskType) {
        return taskType != ProfilerTaskType.UNSPECIFIED;
    }

    private final boolean isProcessSelectionValid(Common.Process process) {
        return !Intrinsics.areEqual((Object)process, (Object)Common.Process.getDefaultInstance());
    }

    private final boolean isProcessAlive(Common.Process process) {
        return process.getState() == Common.Process.State.ALIVE;
    }

    private final boolean isDeviceSelectionValid(ProcessListModel.ProfilerDeviceSelection device) {
        return device != null;
    }

    private final boolean isDeviceSelectionOnline(ProcessListModel.ProfilerDeviceSelection device) {
        return !Intrinsics.areEqual((Object)device.getDevice(), (Object)Common.Device.getDefaultInstance());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTaskSupportedByProcess(ProfilerTaskType selectedTaskType, Map<ProfilerTaskType, ? extends ProfilerTaskHandler> taskHandlers, ProcessListModel.ProfilerDeviceSelection selectedDevice, Common.Process selectedProcess) {
        if (!this.isTaskSelectionValid(selectedTaskType)) return false;
        if (!this.isDeviceSelectionValid(selectedDevice)) return false;
        ProcessListModel.ProfilerDeviceSelection profilerDeviceSelection = selectedDevice;
        Intrinsics.checkNotNull((Object)profilerDeviceSelection);
        if (!this.isDeviceSelectionOnline(profilerDeviceSelection)) return false;
        ProfilerTaskHandler profilerTaskHandler = taskHandlers.get((Object)selectedTaskType);
        Intrinsics.checkNotNull((Object)profilerTaskHandler);
        if (profilerTaskHandler.checkSupportForDeviceAndProcess(selectedDevice.getDevice(), selectedProcess) != null) return false;
        return true;
    }

    public final boolean isSelectedProcessPreferred(@NotNull Common.Process selectedProcess, @NotNull StudioProfilers profilers) {
        Intrinsics.checkNotNullParameter((Object)selectedProcess, (String)"selectedProcess");
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        return Intrinsics.areEqual((Object)selectedProcess.getName(), (Object)profilers.getPreferredProcessName());
    }

    public final boolean isProfileablePreferredButNotPresent(@NotNull ProfilerTaskType taskType, @NotNull Common.Process process, @NotNull TaskHomeTabModel.ProfilingProcessStartingPoint profilingProcessStartingPoint) {
        Intrinsics.checkNotNullParameter((Object)((Object)taskType), (String)"taskType");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)((Object)profilingProcessStartingPoint), (String)"profilingProcessStartingPoint");
        return taskType.getPrefersProfileable() && this.isProcessAlive(process) && !ProcessUtils.INSTANCE.isProfileable(process) && profilingProcessStartingPoint == TaskHomeTabModel.ProfilingProcessStartingPoint.NOW;
    }

    public final boolean isTaskStartFromProcessStartEnabled(@NotNull ProfilerTaskType selectedTaskType, @NotNull Common.Process selectedProcess, @NotNull StudioProfilers profilers) {
        Intrinsics.checkNotNullParameter((Object)((Object)selectedTaskType), (String)"selectedTaskType");
        Intrinsics.checkNotNullParameter((Object)selectedProcess, (String)"selectedProcess");
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        return this.isSelectedProcessPreferred(selectedProcess, profilers) && profilers.getIdeServices().isTaskSupportedOnStartup(selectedTaskType);
    }

    public final boolean isTaskStartFromNowEnabled(@NotNull Common.Process selectedProcess) {
        Intrinsics.checkNotNullParameter((Object)selectedProcess, (String)"selectedProcess");
        return this.isProcessSelectionValid(selectedProcess) && this.isProcessAlive(selectedProcess);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canTaskStartFromProcessStart(@NotNull ProfilerTaskType selectedTaskType, @Nullable ProcessListModel.ProfilerDeviceSelection selectedDevice, @NotNull Common.Process selectedProcess, @NotNull StudioProfilers profilers) {
        Intrinsics.checkNotNullParameter((Object)((Object)selectedTaskType), (String)"selectedTaskType");
        Intrinsics.checkNotNullParameter((Object)selectedProcess, (String)"selectedProcess");
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        if (!this.isTaskStartFromProcessStartEnabled(selectedTaskType, selectedProcess, profilers)) return false;
        ProcessListModel.ProfilerDeviceSelection profilerDeviceSelection = selectedDevice;
        if (profilerDeviceSelection == null) return false;
        ProcessListModel.ProfilerDeviceSelection it = profilerDeviceSelection;
        boolean bl = false;
        boolean bl2 = TaskSupportUtils.INSTANCE.doesDeviceSupportProfilingTaskFromProcessStart(selectedTaskType, it.getFeatureLevel());
        if (!bl2) return false;
        return true;
    }

    public final boolean canTaskStartFromNow(@NotNull ProfilerTaskType selectedTaskType, @Nullable ProcessListModel.ProfilerDeviceSelection selectedDevice, @NotNull Common.Process selectedProcess, @NotNull Map<ProfilerTaskType, ? extends ProfilerTaskHandler> taskHandlers) {
        Intrinsics.checkNotNullParameter((Object)((Object)selectedTaskType), (String)"selectedTaskType");
        Intrinsics.checkNotNullParameter((Object)selectedProcess, (String)"selectedProcess");
        Intrinsics.checkNotNullParameter(taskHandlers, (String)"taskHandlers");
        return this.isTaskStartFromNowEnabled(selectedProcess) && this.isTaskSupportedByProcess(selectedTaskType, taskHandlers, selectedDevice, selectedProcess);
    }

    public final boolean canStartTask(@NotNull ProfilerTaskType selectedTaskType, @Nullable ProcessListModel.ProfilerDeviceSelection selectedDevice, @NotNull Common.Process selectedProcess, @NotNull TaskHomeTabModel.ProfilingProcessStartingPoint profilingProcessStartingPoint, @NotNull StudioProfilers profilers) {
        Intrinsics.checkNotNullParameter((Object)((Object)selectedTaskType), (String)"selectedTaskType");
        Intrinsics.checkNotNullParameter((Object)selectedProcess, (String)"selectedProcess");
        Intrinsics.checkNotNullParameter((Object)((Object)profilingProcessStartingPoint), (String)"profilingProcessStartingPoint");
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        return switch (WhenMappings.$EnumSwitchMapping$0[profilingProcessStartingPoint.ordinal()]) {
            case 1 -> {
                Map<ProfilerTaskType, ProfilerTaskHandler> v0 = profilers.getTaskHandlers();
                Intrinsics.checkNotNullExpressionValue(v0, (String)"getTaskHandlers(...)");
                yield this.canTaskStartFromNow(selectedTaskType, selectedDevice, selectedProcess, v0);
            }
            case 2 -> this.canTaskStartFromProcessStart(selectedTaskType, selectedDevice, selectedProcess, profilers);
            default -> false;
        };
    }

    private final boolean areSelectionsValid(ProfilerTaskType selectedTaskType, ProcessListModel.ProfilerDeviceSelection selectedDevice, Common.Process selectedProcess) {
        return this.isDeviceSelectionValid(selectedDevice) && this.isProcessSelectionValid(selectedProcess) && this.isTaskSelectionValid(selectedTaskType);
    }

    private final StartTaskSelectionError getStartTaskFromProcessStartError(ProfilerTaskType selectedTaskType, ProcessListModel.ProfilerDeviceSelection selectedDevice, Common.Process selectedProcess, StudioProfilers profilers) {
        StartTaskSelectionError startTaskSelectionError;
        boolean bl;
        boolean bl2 = bl = !this.canTaskStartFromProcessStart(selectedTaskType, selectedDevice, selectedProcess, profilers);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = this.areSelectionsValid(selectedTaskType, selectedDevice, selectedProcess);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (!this.isSelectedProcessPreferred(selectedProcess, profilers)) {
            startTaskSelectionError = new StartTaskSelectionError(StartTaskSelectionError.StartTaskSelectionErrorCode.PREFERRED_PROCESS_NOT_SELECTED_FOR_STARTUP_TASK, null, 2, null);
        } else if (!profilers.getIdeServices().isTaskSupportedOnStartup(selectedTaskType)) {
            startTaskSelectionError = new StartTaskSelectionError(StartTaskSelectionError.StartTaskSelectionErrorCode.TASK_UNSUPPORTED_ON_STARTUP, null, 2, null);
        } else {
            ProcessListModel.ProfilerDeviceSelection profilerDeviceSelection = selectedDevice;
            Intrinsics.checkNotNull((Object)profilerDeviceSelection);
            if (!TaskSupportUtils.INSTANCE.doesDeviceSupportProfilingTaskFromProcessStart(selectedTaskType, profilerDeviceSelection.getFeatureLevel())) {
                return new StartTaskSelectionError(StartTaskSelectionError.StartTaskSelectionErrorCode.TASK_FROM_PROCESS_START_USING_API_BELOW_MIN, this.getMinApiStartTaskErrorMessage(TaskSupportUtils.INSTANCE.getProcessStartMinApi(selectedTaskType)));
            }
            startTaskSelectionError = new StartTaskSelectionError(StartTaskSelectionError.StartTaskSelectionErrorCode.GENERAL_ERROR, null, 2, null);
        }
        return startTaskSelectionError;
    }

    private final StartTaskSelectionError getStartTaskFromNowStartError(ProfilerTaskType selectedTaskType, ProcessListModel.ProfilerDeviceSelection selectedDevice, Common.Process selectedProcess, Map<ProfilerTaskType, ? extends ProfilerTaskHandler> taskHandlers) {
        boolean bl;
        boolean bl2 = bl = !this.canTaskStartFromNow(selectedTaskType, selectedDevice, selectedProcess, taskHandlers);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = this.areSelectionsValid(selectedTaskType, selectedDevice, selectedProcess);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ProcessListModel.ProfilerDeviceSelection profilerDeviceSelection = selectedDevice;
        Intrinsics.checkNotNull((Object)profilerDeviceSelection);
        if (!this.isDeviceSelectionOnline(profilerDeviceSelection)) {
            return new StartTaskSelectionError(StartTaskSelectionError.StartTaskSelectionErrorCode.DEVICE_SELECTION_IS_OFFLINE, null, 2, null);
        }
        ProfilerTaskHandler profilerTaskHandler = taskHandlers.get((Object)selectedTaskType);
        Intrinsics.checkNotNull((Object)profilerTaskHandler);
        StartTaskSelectionError supportsDeviceAndProcess = profilerTaskHandler.checkSupportForDeviceAndProcess(selectedDevice.getDevice(), selectedProcess);
        if (supportsDeviceAndProcess != null) {
            return supportsDeviceAndProcess;
        }
        if (selectedProcess.getState() == Common.Process.State.DEAD) {
            return new StartTaskSelectionError(StartTaskSelectionError.StartTaskSelectionErrorCode.TASK_FROM_NOW_USING_DEAD_PROCESS, null, 2, null);
        }
        return new StartTaskSelectionError(StartTaskSelectionError.StartTaskSelectionErrorCode.GENERAL_ERROR, null, 2, null);
    }

    @NotNull
    public final StartTaskSelectionError getStartTaskError(@NotNull ProfilerTaskType selectedTaskType, @Nullable ProcessListModel.ProfilerDeviceSelection selectedDevice, @NotNull Common.Process selectedProcess, @NotNull TaskHomeTabModel.ProfilingProcessStartingPoint profilingProcessStartingPoint, @NotNull StudioProfilers profilers) {
        StartTaskSelectionError startTaskSelectionError;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)selectedTaskType), (String)"selectedTaskType");
        Intrinsics.checkNotNullParameter((Object)selectedProcess, (String)"selectedProcess");
        Intrinsics.checkNotNullParameter((Object)((Object)profilingProcessStartingPoint), (String)"profilingProcessStartingPoint");
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        boolean bl2 = bl = !this.canStartTask(selectedTaskType, selectedDevice, selectedProcess, profilingProcessStartingPoint, profilers);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (!this.isDeviceSelectionValid(selectedDevice)) {
            startTaskSelectionError = new StartTaskSelectionError(StartTaskSelectionError.StartTaskSelectionErrorCode.INVALID_DEVICE, null, 2, null);
        } else if (!this.isProcessSelectionValid(selectedProcess)) {
            startTaskSelectionError = new StartTaskSelectionError(StartTaskSelectionError.StartTaskSelectionErrorCode.INVALID_PROCESS, null, 2, null);
        } else if (!this.isTaskSelectionValid(selectedTaskType)) {
            startTaskSelectionError = new StartTaskSelectionError(StartTaskSelectionError.StartTaskSelectionErrorCode.INVALID_TASK, null, 2, null);
        } else if (profilingProcessStartingPoint == TaskHomeTabModel.ProfilingProcessStartingPoint.PROCESS_START) {
            startTaskSelectionError = this.getStartTaskFromProcessStartError(selectedTaskType, selectedDevice, selectedProcess, profilers);
        } else if (profilingProcessStartingPoint == TaskHomeTabModel.ProfilingProcessStartingPoint.NOW) {
            Map<ProfilerTaskType, ProfilerTaskHandler> map = profilers.getTaskHandlers();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getTaskHandlers(...)");
            startTaskSelectionError = this.getStartTaskFromNowStartError(selectedTaskType, selectedDevice, selectedProcess, map);
        } else {
            startTaskSelectionError = profilingProcessStartingPoint == TaskHomeTabModel.ProfilingProcessStartingPoint.UNSPECIFIED ? new StartTaskSelectionError(StartTaskSelectionError.StartTaskSelectionErrorCode.NO_STARTING_POINT_SELECTED, null, 2, null) : new StartTaskSelectionError(StartTaskSelectionError.StartTaskSelectionErrorCode.GENERAL_ERROR, null, 2, null);
        }
        return startTaskSelectionError;
    }

    @NotNull
    public final String getMinApiStartTaskErrorMessage(int minApi) {
        return "Selected task requires API " + minApi + " or higher";
    }

    @NotNull
    public final List<StartTaskSelectionError.StartTaskSelectionErrorCode> getSTARTUP_TASK_ERRORS() {
        return STARTUP_TASK_ERRORS;
    }

    static {
        StartTaskSelectionError.StartTaskSelectionErrorCode[] startTaskSelectionErrorCodeArray = new StartTaskSelectionError.StartTaskSelectionErrorCode[]{StartTaskSelectionError.StartTaskSelectionErrorCode.PREFERRED_PROCESS_NOT_SELECTED_FOR_STARTUP_TASK, StartTaskSelectionError.StartTaskSelectionErrorCode.TASK_UNSUPPORTED_ON_STARTUP, StartTaskSelectionError.StartTaskSelectionErrorCode.TASK_FROM_PROCESS_START_USING_API_BELOW_MIN};
        STARTUP_TASK_ERRORS = CollectionsKt.listOf((Object[])startTaskSelectionErrorCodeArray);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TaskHomeTabModel.ProfilingProcessStartingPoint.values().length];
            try {
                nArray[TaskHomeTabModel.ProfilingProcessStartingPoint.NOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskHomeTabModel.ProfilingProcessStartingPoint.PROCESS_START.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

