/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.instancefilters;

import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/profilers/memory/adapters/instancefilters/ActivityFragmentLeakInstanceFilter;", "Lcom/android/tools/profilers/memory/adapters/instancefilters/CaptureObjectInstanceFilter;", "classDatabase", "Lcom/android/tools/profilers/memory/adapters/ClassDb;", "<init>", "(Lcom/android/tools/profilers/memory/adapters/ClassDb;)V", "Companion", "intellij.android.profilers"})
public final class ActivityFragmentLeakInstanceFilter
extends CaptureObjectInstanceFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ACTIVTY_CLASS_NAME = "android.app.Activity";
    @NotNull
    public static final String NATIVE_FRAGMENT_CLASS_NAME = "android.app.Fragment";
    @NotNull
    public static final String SUPPORT_FRAGMENT_CLASS_NAME = "android.support.v4.app.Fragment";
    @NotNull
    public static final String ANDROIDX_FRAGMENT_CLASS_NAME = "androidx.fragment.app.Fragment";
    @NotNull
    public static final String FINISHED_FIELD_NAME = "mFinished";
    @NotNull
    public static final String DESTROYED_FIELD_NAME = "mDestroyed";
    @NotNull
    public static final String FRAGFMENT_MANAGER_FIELD_NAME = "mFragmentManager";
    @NotNull
    private static final String[] FRAGMENT_CLASS_NAMES;

    public ActivityFragmentLeakInstanceFilter(@NotNull ClassDb classDatabase) {
        Intrinsics.checkNotNullParameter((Object)classDatabase, (String)"classDatabase");
        super("activity/fragment leaks", "Show Activities and Fragments that are potentially causing memory leaks.", "Activity/Fragment leaks may include false positives.", "https://developer.android.com/r/studio-ui/profiler-memory-leak-detection", (Function1<? super InstanceObject, Boolean>)ActivityFragmentLeakInstanceFilter.Companion.makeLeakTest(classDatabase));
    }

    static {
        String[] stringArray = new String[]{NATIVE_FRAGMENT_CLASS_NAME, SUPPORT_FRAGMENT_CLASS_NAME, ANDROIDX_FRAGMENT_CLASS_NAME};
        FRAGMENT_CLASS_NAMES = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J:\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00182\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00190\u00172\u0014\u0010\"\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00190\u0017H\u0002R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u0016\u0010\u0007\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\u0016\u0010\t\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0003R\u0016\u0010\u000b\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003R\u0016\u0010\r\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u0003R\u0016\u0010\u000f\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\u0003R\u0016\u0010\u0011\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0003R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006#\u00b2\u0006\u0018\u0010$\u001a\u0010\u0012\f\u0012\n '*\u0004\u0018\u00010&0&0%X\u008a\u0084\u0002\u00b2\u0006\u0018\u0010(\u001a\u0010\u0012\f\u0012\n '*\u0004\u0018\u00010&0&0%X\u008a\u0084\u0002"}, d2={"Lcom/android/tools/profilers/memory/adapters/instancefilters/ActivityFragmentLeakInstanceFilter$Companion;", "", "<init>", "()V", "ACTIVTY_CLASS_NAME", "", "getACTIVTY_CLASS_NAME$annotations", "NATIVE_FRAGMENT_CLASS_NAME", "getNATIVE_FRAGMENT_CLASS_NAME$annotations", "SUPPORT_FRAGMENT_CLASS_NAME", "getSUPPORT_FRAGMENT_CLASS_NAME$annotations", "ANDROIDX_FRAGMENT_CLASS_NAME", "getANDROIDX_FRAGMENT_CLASS_NAME$annotations", "FINISHED_FIELD_NAME", "getFINISHED_FIELD_NAME$annotations", "DESTROYED_FIELD_NAME", "getDESTROYED_FIELD_NAME$annotations", "FRAGFMENT_MANAGER_FIELD_NAME", "getFRAGFMENT_MANAGER_FIELD_NAME$annotations", "FRAGMENT_CLASS_NAMES", "", "[Ljava/lang/String;", "makeLeakTest", "Lkotlin/Function1;", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "", "classDatabase", "Lcom/android/tools/profilers/memory/adapters/ClassDb;", "isPotentialActivityLeak", "instance", "isPotentialFragmentLeak", "isValidDepthWithAnyField", "inst", "onName", "onVal", "intellij.android.profilers", "allActivitySubclasses", "Ljava/util/HashSet;", "Lcom/android/tools/profilers/memory/adapters/ClassDb$ClassEntry;", "kotlin.jvm.PlatformType", "allFragmentSubclasses"})
    @SourceDebugExtension(value={"SMAP\nActivityFragmentLeakInstanceFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActivityFragmentLeakInstanceFilter.kt\ncom/android/tools/profilers/memory/adapters/instancefilters/ActivityFragmentLeakInstanceFilter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,110:1\n1761#2,3:111\n1460#2,5:114\n1460#2,5:125\n10135#3:119\n10557#3,5:120\n*S KotlinDebug\n*F\n+ 1 ActivityFragmentLeakInstanceFilter.kt\ncom/android/tools/profilers/memory/adapters/instancefilters/ActivityFragmentLeakInstanceFilter$Companion\n*L\n107#1:111,3\n68#1:114,5\n73#1:125,5\n72#1:119\n72#1:120,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getACTIVTY_CLASS_NAME$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getNATIVE_FRAGMENT_CLASS_NAME$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getSUPPORT_FRAGMENT_CLASS_NAME$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getANDROIDX_FRAGMENT_CLASS_NAME$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getFINISHED_FIELD_NAME$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getDESTROYED_FIELD_NAME$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getFRAGFMENT_MANAGER_FIELD_NAME$annotations() {
        }

        private final Function1<InstanceObject, Boolean> makeLeakTest(ClassDb classDatabase) {
            Lazy allActivitySubclasses$delegate = LazyKt.lazy(() -> Companion.makeLeakTest$lambda$1(classDatabase));
            Lazy allFragmentSubclasses$delegate = LazyKt.lazy(() -> Companion.makeLeakTest$lambda$5(classDatabase));
            return arg_0 -> Companion.makeLeakTest$lambda$7(allActivitySubclasses$delegate, allFragmentSubclasses$delegate, arg_0);
        }

        private final boolean isPotentialActivityLeak(InstanceObject instance) {
            return this.isValidDepthWithAnyField(instance, (Function1<? super String, Boolean>)((Function1)Companion::isPotentialActivityLeak$lambda$8), (Function1<Object, Boolean>)((Function1)Companion::isPotentialActivityLeak$lambda$9));
        }

        private final boolean isPotentialFragmentLeak(InstanceObject instance) {
            return this.isValidDepthWithAnyField(instance, (Function1<? super String, Boolean>)((Function1)Companion::isPotentialFragmentLeak$lambda$10), (Function1<Object, Boolean>)((Function1)Companion::isPotentialFragmentLeak$lambda$11));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isValidDepthWithAnyField(InstanceObject inst, Function1<? super String, Boolean> onName, Function1<Object, Boolean> onVal) {
            boolean bl;
            int depth = inst.getDepth();
            if (depth == 0) return false;
            if (depth == Integer.MAX_VALUE) return false;
            List<FieldObject> list = inst.getFields();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getFields(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                FieldObject it = (FieldObject)element$iv;
                boolean bl2 = false;
                String string = it.getFieldName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFieldName(...)");
                if (((Boolean)onName.invoke((Object)string)).booleanValue() && ((Boolean)onVal.invoke(it.getValue())).booleanValue()) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private static final HashSet makeLeakTest$lambda$1(ClassDb $classDatabase) {
            void var2_2;
            void $this$flatMapTo$iv;
            Set<ClassDb.ClassEntry> set = $classDatabase.getEntriesByName(ActivityFragmentLeakInstanceFilter.ACTIVTY_CLASS_NAME);
            Intrinsics.checkNotNullExpressionValue(set, (String)"getEntriesByName(...)");
            Iterable iterable = set;
            Collection destination$iv = new HashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                ClassDb.ClassEntry classEntry = (ClassDb.ClassEntry)element$iv;
                boolean bl = false;
                Set<ClassDb.ClassEntry> set2 = $classDatabase.getDescendantClasses(classEntry.getClassId());
                Intrinsics.checkNotNullExpressionValue(set2, (String)"getDescendantClasses(...)");
                Iterable list$iv = set2;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            return (HashSet)var2_2;
        }

        private static final HashSet<ClassDb.ClassEntry> makeLeakTest$lambda$2(Lazy<? extends HashSet<ClassDb.ClassEntry>> $allActivitySubclasses$delegate) {
            Lazy<? extends HashSet<ClassDb.ClassEntry>> lazy = $allActivitySubclasses$delegate;
            return (HashSet)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        private static final HashSet makeLeakTest$lambda$5(ClassDb $classDatabase) {
            void var2_3;
            void $this$flatMapTo$iv;
            void $this$flatMapTo$iv$iv;
            Object $this$flatMap$iv = FRAGMENT_CLASS_NAMES;
            boolean $i$f$flatMap = false;
            String[] stringArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void className = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl = false;
                Set<ClassDb.ClassEntry> set = $classDatabase.getEntriesByName((String)className);
                Intrinsics.checkNotNullExpressionValue(set, (String)"getEntriesByName(...)");
                Iterable list$iv$iv = set;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            Collection destination$iv = new HashSet();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                ClassDb.ClassEntry classEntry = (ClassDb.ClassEntry)element$iv;
                boolean bl = false;
                Set<ClassDb.ClassEntry> set = $classDatabase.getDescendantClasses(classEntry.getClassId());
                Intrinsics.checkNotNullExpressionValue(set, (String)"getDescendantClasses(...)");
                Iterable list$iv = set;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            return (HashSet)var2_3;
        }

        private static final HashSet<ClassDb.ClassEntry> makeLeakTest$lambda$6(Lazy<? extends HashSet<ClassDb.ClassEntry>> $allFragmentSubclasses$delegate) {
            Lazy<? extends HashSet<ClassDb.ClassEntry>> lazy = $allFragmentSubclasses$delegate;
            return (HashSet)lazy.getValue();
        }

        private static final boolean makeLeakTest$lambda$7(Lazy $allActivitySubclasses$delegate, Lazy $allFragmentSubclasses$delegate, InstanceObject it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return com.android.tools.profilers.memory.adapters.instancefilters.ActivityFragmentLeakInstanceFilter$Companion.makeLeakTest$lambda$2((Lazy<? extends HashSet<ClassDb.ClassEntry>>)$allActivitySubclasses$delegate).contains(it.getClassEntry()) && Companion.isPotentialActivityLeak(it) || com.android.tools.profilers.memory.adapters.instancefilters.ActivityFragmentLeakInstanceFilter$Companion.makeLeakTest$lambda$6((Lazy<? extends HashSet<ClassDb.ClassEntry>>)$allFragmentSubclasses$delegate).contains(it.getClassEntry()) && Companion.isPotentialFragmentLeak(it);
        }

        private static final boolean isPotentialActivityLeak$lambda$8(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)ActivityFragmentLeakInstanceFilter.FINISHED_FIELD_NAME, (Object)it) || Intrinsics.areEqual((Object)ActivityFragmentLeakInstanceFilter.DESTROYED_FIELD_NAME, (Object)it);
        }

        private static final boolean isPotentialActivityLeak$lambda$9(Object it) {
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.Boolean");
            return (Boolean)it;
        }

        private static final boolean isPotentialFragmentLeak$lambda$10(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)ActivityFragmentLeakInstanceFilter.FRAGFMENT_MANAGER_FIELD_NAME, (Object)it);
        }

        private static final boolean isPotentialFragmentLeak$lambda$11(Object it) {
            return it == null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

