/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.profilers.memory.adapters.ArrayObject;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ&\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0002J\"\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/profilers/memory/BitmapDuplicationAnalyzer;", "", "<init>", "()V", "duplicateBitmapInstances", "", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "analyze", "", "instances", "", "getDuplicateInstances", "", "getBitmapInfo", "Lcom/android/tools/profilers/memory/BitmapDuplicationAnalyzer$BitmapInfo;", "instance", "ptrToBufferMap", "", "", "", "buildPtrToBufferMap", "getByteArrayFromInstanceObject", "getNestedInstanceObject", "parentInstance", "fieldName", "", "Companion", "BitmapInfo", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nBitmapDuplicationAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapDuplicationAnalyzer.kt\ncom/android/tools/profilers/memory/BitmapDuplicationAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1869#2,2:173\n774#2:175\n865#2,2:176\n1803#2,3:178\n295#2,2:181\n*S KotlinDebug\n*F\n+ 1 BitmapDuplicationAnalyzer.kt\ncom/android/tools/profilers/memory/BitmapDuplicationAnalyzer\n*L\n85#1:173,2\n123#1:175\n123#1:176,2\n124#1:178,3\n168#1:181,2\n*E\n"})
public final class BitmapDuplicationAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<InstanceObject> duplicateBitmapInstances = new LinkedHashSet();
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String BITMAP_CLASS_NAME = "android.graphics.Bitmap";
    @NotNull
    public static final String BITMAP_DUMP_DATA_CLASS_NAME = "android.graphics.Bitmap$DumpData";

    public final void analyze(@NotNull Iterable<? extends InstanceObject> instances) {
        boolean bl;
        Intrinsics.checkNotNullParameter(instances, (String)"instances");
        this.duplicateBitmapInstances.clear();
        Map<Long, byte[]> ptrToBufferMap = this.buildPtrToBufferMap(instances);
        if (ptrToBufferMap.isEmpty()) {
            LOG.debug("Could not build pointer-to-buffer map. Skipping duplicate bitmap analysis.");
            return;
        }
        Map bitmapsByInfo = new LinkedHashMap();
        for (InstanceObject instanceObject : instances) {
            BitmapInfo info;
            if (!Intrinsics.areEqual((Object)instanceObject.getClassEntry().getClassName(), (Object)BITMAP_CLASS_NAME) || instanceObject.getDepth() == Integer.MAX_VALUE) continue;
            if (this.getBitmapInfo(instanceObject, ptrToBufferMap) == null) continue;
            bl = false;
            bitmapsByInfo.computeIfAbsent(info, arg_0 -> BitmapDuplicationAnalyzer.analyze$lambda$2$lambda$1(BitmapDuplicationAnalyzer::analyze$lambda$2$lambda$0, arg_0)).add(instanceObject);
        }
        Iterable $this$forEach$iv = bitmapsByInfo.values();
        boolean bl2 = false;
        for (Object element$iv : $this$forEach$iv) {
            List instanceList = (List)element$iv;
            bl = false;
            if (instanceList.size() <= 1) continue;
            this.duplicateBitmapInstances.addAll(instanceList);
        }
    }

    @NotNull
    public final Set<InstanceObject> getDuplicateInstances() {
        return this.duplicateBitmapInstances;
    }

    private final BitmapInfo getBitmapInfo(InstanceObject instance, Map<Long, byte[]> ptrToBufferMap) {
        Integer width = null;
        Integer height = null;
        Long nativePtr = null;
        for (FieldObject field : instance.getFields()) {
            switch (field.getFieldName()) {
                case "mWidth": {
                    Object object = field.getValue();
                    width = object instanceof Integer ? (Integer)object : null;
                    break;
                }
                case "mHeight": {
                    Object object = field.getValue();
                    height = object instanceof Integer ? (Integer)object : null;
                    break;
                }
                case "mNativePtr": {
                    Object object = field.getValue();
                    nativePtr = object instanceof Long ? (Long)object : null;
                }
            }
        }
        if (width == null || height == null || nativePtr == null) {
            return null;
        }
        byte[] byArray = ptrToBufferMap.get(nativePtr);
        if (byArray == null) {
            return null;
        }
        byte[] buffer = byArray;
        return new BitmapInfo(height, width, Arrays.hashCode(buffer));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Long, byte[]> buildPtrToBufferMap(Iterable<? extends InstanceObject> instances) {
        void $this$fold$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = instances;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            InstanceObject it = (InstanceObject)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getClassEntry().getClassName(), (Object)BITMAP_DUMP_DATA_CLASS_NAME) && it.getDepth() != Integer.MAX_VALUE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Map initial$iv = new LinkedHashMap();
        boolean $i$f$fold = false;
        Map accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Map map;
            void dumpDataInstance;
            Object element$iv$iv;
            element$iv$iv = (InstanceObject)element$iv;
            Map acc = accumulator$iv;
            boolean bl = false;
            InstanceObject buffersInstance = this.getNestedInstanceObject((InstanceObject)dumpDataInstance, "buffers");
            InstanceObject nativesInstance = this.getNestedInstanceObject((InstanceObject)dumpDataInstance, "natives");
            if (buffersInstance == null || nativesInstance == null) {
                map = acc;
            } else {
                List<FieldObject> nativesFields;
                List<FieldObject> buffersFields;
                Intrinsics.checkNotNullExpressionValue(buffersInstance.getFields(), (String)"getFields(...)");
                Intrinsics.checkNotNullExpressionValue(nativesInstance.getFields(), (String)"getFields(...)");
                if (buffersFields.size() != nativesFields.size()) {
                    Locale locale = Locale.US;
                    String string = "Mismatch in size between 'buffers' (%d) and 'natives' (%d) fields. Cannot process.";
                    Object[] objectArray = new Object[]{buffersFields.size(), nativesFields.size()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    LOG.warn(string2);
                    map = acc;
                } else {
                    int n = ((Collection)nativesFields).size();
                    for (int i = 0; i < n; ++i) {
                        byte[] byteArray;
                        ValueObject bufferInstance;
                        FieldObject fieldObject = (FieldObject)CollectionsKt.getOrNull(nativesFields, (int)i);
                        Object object = fieldObject != null ? fieldObject.getValue() : null;
                        Long l = object instanceof Long ? (Long)object : null;
                        if (l == null) {
                            continue;
                        }
                        long nativePtr = l;
                        ValueObject valueObject = (FieldObject)CollectionsKt.getOrNull(buffersFields, (int)i);
                        if (valueObject == null) continue;
                        if ((valueObject = valueObject.getAsInstance()) == null || this.getByteArrayFromInstanceObject((InstanceObject)(bufferInstance = valueObject)) == null) continue;
                        acc.put(nativePtr, byteArray);
                    }
                    map = acc;
                }
            }
            accumulator$iv = map;
        }
        return accumulator$iv;
    }

    private final byte[] getByteArrayFromInstanceObject(InstanceObject instance) {
        ArrayObject arrayObject = instance.getArrayObject();
        if (arrayObject == null) {
            BitmapDuplicationAnalyzer $this$getByteArrayFromInstanceObject_u24lambda_u246 = this;
            boolean bl = false;
            LOG.warn("Buffer instance does not contain an ArrayObject.");
            return null;
        }
        ArrayObject arrayObject2 = arrayObject;
        if (arrayObject2.getArrayElementType() != ValueObject.ValueType.BYTE) {
            LOG.warn("ArrayObject element type is not BYTE. Found: " + arrayObject2.getArrayElementType());
            return null;
        }
        return arrayObject2.getAsByteArray();
    }

    private final InstanceObject getNestedInstanceObject(InstanceObject parentInstance, String fieldName) {
        Object v1;
        block1: {
            List<FieldObject> list = parentInstance.getFields();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getFields(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FieldObject field = (FieldObject)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)fieldName, (Object)field.getFieldName()) && field.getValue() instanceof InstanceObject)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        FieldObject fieldObject = v1;
        return fieldObject != null ? fieldObject.getAsInstance() : null;
    }

    private static final List analyze$lambda$2$lambda$0(BitmapInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List analyze$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(BitmapDuplicationAnalyzer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/profilers/memory/BitmapDuplicationAnalyzer$BitmapInfo;", "", "height", "", "width", "bufferHash", "<init>", "(III)V", "getHeight", "()I", "getWidth", "getBufferHash", "compareTo", "other", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "", "intellij.android.profilers"})
    private static final class BitmapInfo
    implements Comparable<BitmapInfo> {
        private final int height;
        private final int width;
        private final int bufferHash;

        public BitmapInfo(int height, int width, int bufferHash) {
            this.height = height;
            this.width = width;
            this.bufferHash = bufferHash;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getBufferHash() {
            return this.bufferHash;
        }

        @Override
        public int compareTo(@NotNull BitmapInfo other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int areaCompare = Intrinsics.compare((int)(other.width * other.height), (int)(this.width * this.height));
            if (areaCompare != 0) {
                return areaCompare;
            }
            return Intrinsics.compare((int)other.bufferHash, (int)this.bufferHash);
        }

        public final int component1() {
            return this.height;
        }

        public final int component2() {
            return this.width;
        }

        public final int component3() {
            return this.bufferHash;
        }

        @NotNull
        public final BitmapInfo copy(int height, int width, int bufferHash) {
            return new BitmapInfo(height, width, bufferHash);
        }

        public static /* synthetic */ BitmapInfo copy$default(BitmapInfo bitmapInfo, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = bitmapInfo.height;
            }
            if ((n4 & 2) != 0) {
                n2 = bitmapInfo.width;
            }
            if ((n4 & 4) != 0) {
                n3 = bitmapInfo.bufferHash;
            }
            return bitmapInfo.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "BitmapInfo(height=" + this.height + ", width=" + this.width + ", bufferHash=" + this.bufferHash + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.height);
            result = result * 31 + Integer.hashCode(this.width);
            result = result * 31 + Integer.hashCode(this.bufferHash);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BitmapInfo)) {
                return false;
            }
            BitmapInfo bitmapInfo = (BitmapInfo)other;
            if (this.height != bitmapInfo.height) {
                return false;
            }
            if (this.width != bitmapInfo.width) {
                return false;
            }
            return this.bufferHash == bitmapInfo.bufferHash;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/profilers/memory/BitmapDuplicationAnalyzer$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "BITMAP_CLASS_NAME", "", "BITMAP_DUMP_DATA_CLASS_NAME", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

