/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.leakcanary;

import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.leakcanary.SharkHostAnalyzer;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import shark.HeapAnalysis;
import shark.HeapAnalysisSuccess;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u000eJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/profilers/leakcanary/LeakCanaryHeapDumper;", "", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isHeapDumpInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "onHostAnalysisFinished", "Lkotlin/Function1;", "Lshark/HeapAnalysis;", "", "getOnHostAnalysisFinished", "()Lkotlin/jvm/functions/Function1;", "setOnHostAnalysisFinished", "(Lkotlin/jvm/functions/Function1;)V", "triggerAndAnalyze", "sendHeapDumpCommand", "", "waitForHeapDumpStatus", "Lcom/android/tools/profiler/proto/Memory$HeapDumpInfo;", "commandId", "waitForHeapDumpCompletion", "heapDumpInfo", "downloadHeapDump", "Ljava/io/File;", "analyzeAndHandleResult", "hprofFile", "intellij.android.profilers"})
public final class LeakCanaryHeapDumper {
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AtomicBoolean isHeapDumpInProgress;
    public Function1<? super HeapAnalysis, Unit> onHostAnalysisFinished;

    public LeakCanaryHeapDumper(@NotNull StudioProfilers profilers) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        this.profilers = profilers;
        Logger logger = Logger.getInstance(LeakCanaryHeapDumper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.isHeapDumpInProgress = new AtomicBoolean(false);
    }

    @NotNull
    public final Function1<HeapAnalysis, Unit> getOnHostAnalysisFinished() {
        Function1<? super HeapAnalysis, Unit> function1 = this.onHostAnalysisFinished;
        if (function1 != null) {
            return function1;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"onHostAnalysisFinished");
        return null;
    }

    public final void setOnHostAnalysisFinished(@NotNull Function1<? super HeapAnalysis, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onHostAnalysisFinished = function1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void triggerAndAnalyze() {
        if (!this.isHeapDumpInProgress.compareAndSet(false, true)) {
            this.logger.info("Host analysis is already in progress. Ignoring trigger.");
            return;
        }
        try {
            int commandId = this.sendHeapDumpCommand();
            Memory.HeapDumpInfo heapDumpInfo = this.waitForHeapDumpStatus(commandId);
            this.waitForHeapDumpCompletion(heapDumpInfo);
            File hprofFile = this.downloadHeapDump(heapDumpInfo);
            this.analyzeAndHandleResult(hprofFile);
        }
        catch (Exception e) {
            this.logger.error("Host analysis process failed.", (Throwable)e);
        }
        finally {
            this.isHeapDumpInProgress.set(false);
        }
    }

    private final int sendHeapDumpCommand() {
        this.logger.info("Host analysis triggered. Initiating heap dump.");
        Commands.Command dumpCommand = Commands.Command.newBuilder().setStreamId(this.profilers.getSession().getStreamId()).setPid(this.profilers.getSession().getPid()).setSessionId(this.profilers.getSession().getSessionId()).setType(Commands.Command.CommandType.HEAP_DUMP).build();
        Transport.ExecuteResponse response = this.profilers.getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(dumpCommand).build());
        return response.getCommandId();
    }

    private final Memory.HeapDumpInfo waitForHeapDumpStatus(int commandId) {
        CompletableFuture future = new CompletableFuture();
        TransportEventListener statusListener = new TransportEventListener(Common.Event.Kind.MEMORY_HEAP_DUMP_STATUS, this.profilers.getIdeServices().getPoolExecutor(), arg_0 -> LeakCanaryHeapDumper.waitForHeapDumpStatus$lambda$0(commandId, arg_0), () -> LeakCanaryHeapDumper.waitForHeapDumpStatus$lambda$1(this), () -> LeakCanaryHeapDumper.waitForHeapDumpStatus$lambda$2(this), null, null, null, arg_0 -> LeakCanaryHeapDumper.waitForHeapDumpStatus$lambda$3(this, future, arg_0), 224, null);
        this.profilers.getTransportPoller().registerListener(statusListener);
        Object t = future.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (Memory.HeapDumpInfo)t;
    }

    private final void waitForHeapDumpCompletion(Memory.HeapDumpInfo heapDumpInfo) {
        CompletableFuture future = new CompletableFuture();
        TransportEventListener completionListener = new TransportEventListener(Common.Event.Kind.MEMORY_HEAP_DUMP, this.profilers.getIdeServices().getPoolExecutor(), null, () -> LeakCanaryHeapDumper.waitForHeapDumpCompletion$lambda$4(this), () -> LeakCanaryHeapDumper.waitForHeapDumpCompletion$lambda$5(this), null, () -> LeakCanaryHeapDumper.waitForHeapDumpCompletion$lambda$6(heapDumpInfo), null, arg_0 -> LeakCanaryHeapDumper.waitForHeapDumpCompletion$lambda$7(heapDumpInfo, this, future, arg_0), 164, null);
        this.profilers.getTransportPoller().registerListener(completionListener);
        future.get();
    }

    private final File downloadHeapDump(Memory.HeapDumpInfo heapDumpInfo) {
        File hprofFile;
        Transport.BytesRequest bytesRequest = Transport.BytesRequest.newBuilder().setStreamId(this.profilers.getSession().getStreamId()).setId(String.valueOf(heapDumpInfo.getStartTime())).build();
        Transport.FileResponse fileResponse = this.profilers.getClient().getTransportClient().getFile(bytesRequest);
        String string = fileResponse.getFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilePath(...)");
        File file = hprofFile = ((CharSequence)string).length() == 0 ? null : new File(fileResponse.getFilePath());
        if (hprofFile == null || !hprofFile.exists()) {
            throw new RuntimeException("Hprof file not found on device despite completion signal. Expected path: " + fileResponse.getFilePath());
        }
        return hprofFile;
    }

    private final void analyzeAndHandleResult(File hprofFile) {
        this.logger.info("Hprof file downloaded to: " + hprofFile.getPath() + ". Starting analysis.");
        HeapAnalysis analysisResult = new SharkHostAnalyzer().analyze(hprofFile);
        if (!(analysisResult instanceof HeapAnalysisSuccess)) {
            throw new RuntimeException("Heap analysis failed for " + hprofFile.getPath());
        }
        this.profilers.getIdeServices().getMainExecutor().execute(() -> LeakCanaryHeapDumper.analyzeAndHandleResult$lambda$8(this, analysisResult));
    }

    private static final boolean waitForHeapDumpStatus$lambda$0(int $commandId, Common.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return event.getCommandId() == $commandId;
    }

    private static final long waitForHeapDumpStatus$lambda$1(LeakCanaryHeapDumper this$0) {
        return this$0.profilers.getSession().getStreamId();
    }

    private static final int waitForHeapDumpStatus$lambda$2(LeakCanaryHeapDumper this$0) {
        return this$0.profilers.getSession().getPid();
    }

    private static final boolean waitForHeapDumpStatus$lambda$3(LeakCanaryHeapDumper this$0, CompletableFuture $future, Common.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Memory.HeapDumpStatus status = event.getMemoryHeapdumpStatus().getStatus();
        if (status.getStatus() == Memory.HeapDumpStatus.Status.SUCCESS) {
            this$0.logger.info("Heap dump process started on device. Waiting for completion signal.");
            v0 = $future.complete(Memory.HeapDumpInfo.newBuilder().setStartTime(status.getStartTime()).build());
        } else {
            v0 = $future.completeExceptionally(new RuntimeException("Heap dump failed to start on device. Status: " + status.getStatus()));
        }
        return true;
    }

    private static final long waitForHeapDumpCompletion$lambda$4(LeakCanaryHeapDumper this$0) {
        return this$0.profilers.getSession().getStreamId();
    }

    private static final int waitForHeapDumpCompletion$lambda$5(LeakCanaryHeapDumper this$0) {
        return this$0.profilers.getSession().getPid();
    }

    private static final long waitForHeapDumpCompletion$lambda$6(Memory.HeapDumpInfo $heapDumpInfo) {
        return $heapDumpInfo.getStartTime();
    }

    private static final boolean waitForHeapDumpCompletion$lambda$7(Memory.HeapDumpInfo $heapDumpInfo, LeakCanaryHeapDumper this$0, CompletableFuture $future, Common.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.getIsEnded()) {
            return false;
        }
        if (event.getMemoryHeapdump().getInfo().getStartTime() != $heapDumpInfo.getStartTime()) {
            return false;
        }
        if (event.getMemoryHeapdump().getInfo().getSuccess()) {
            this$0.logger.info("Detected heap dump completion event for id " + $heapDumpInfo.getStartTime() + ".");
            v0 = $future.complete(null);
        } else {
            v0 = $future.completeExceptionally(new RuntimeException("Heap dump failed on device for id " + $heapDumpInfo.getStartTime() + "."));
        }
        return true;
    }

    private static final void analyzeAndHandleResult$lambda$8(LeakCanaryHeapDumper this$0, HeapAnalysis $analysisResult) {
        this$0.getOnHostAnalysisFinished().invoke((Object)$analysisResult);
    }
}

