/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.cpu.systemtrace.CounterModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00070\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J.\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u00110\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007H\u0002J<\u0010\u0013\u001a\u00020\u00142\u001e\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u00110\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\rH\u0002J@\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00070\u00052\u001e\u0010\u0019\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00070\u0005H\u0007J\u001a\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\u001b\u001a\u00020\u000b\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/profilers/cpu/systemtrace/CounterDataUtils;", "", "<init>", "()V", "aggregateCounters", "Ljava/util/SortedMap;", "", "", "Lcom/android/tools/adtui/model/SeriesData;", "", "counters", "Lcom/android/tools/profilers/cpu/systemtrace/CounterModel;", "groupingMap", "", "normalizeStartTime", "", "convertCountersToAggregatableFormat", "Ljava/util/TreeMap;", "", "removeDataBeforeNormalizedStartTime", "", "groupToAggregatedData", "", "groupNameToMaxMinTs", "convertSeriesDataToDeltaSeries", "countersData", "convertCounterToSeriesData", "counter", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nSystemTraceModelAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemTraceModelAdapter.kt\ncom/android/tools/profilers/cpu/systemtrace/CounterDataUtils\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,382:1\n536#2:383\n521#2,6:384\n463#2:392\n413#2:393\n216#3,2:390\n126#3:404\n153#3,3:405\n1252#4,4:394\n1193#4,2:398\n1267#4,4:400\n*S KotlinDebug\n*F\n+ 1 SystemTraceModelAdapter.kt\ncom/android/tools/profilers/cpu/systemtrace/CounterDataUtils\n*L\n197#1:383\n197#1:384,6\n259#1:392\n259#1:393\n197#1:390,2\n323#1:404\n323#1:405,3\n259#1:394,4\n275#1:398,2\n275#1:400,4\n*E\n"})
public final class CounterDataUtils {
    @NotNull
    public static final CounterDataUtils INSTANCE = new CounterDataUtils();

    private CounterDataUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final SortedMap<String, List<SeriesData<Long>>> aggregateCounters(@NotNull List<CounterModel> counters, @NotNull Map<String, String> groupingMap, boolean normalizeStartTime) {
        void $this$mapValuesTo$iv$iv;
        Object existingSortedMap;
        void $this$forEach$iv;
        Object $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(counters, (String)"counters");
        Intrinsics.checkNotNullParameter(groupingMap, (String)"groupingMap");
        Map aggregatableCounters = INSTANCE.convertCountersToAggregatableFormat(counters);
        Map groupToAggregatedData = new LinkedHashMap();
        Map groupNameToNormalizedStartTime = new LinkedHashMap();
        Map $this$filter$iv = aggregatableCounters;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!groupingMap.containsKey(it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            String groupName;
            Map.Entry element$iv;
            Map.Entry it = element$iv = $this$filterTo$iv$iv.next();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)groupingMap.get(it.getKey()));
            TreeMap newCounterData = (TreeMap)it.getValue();
            if (groupToAggregatedData.containsKey(groupName)) {
                Object v = groupToAggregatedData.get(groupName);
                Intrinsics.checkNotNull(v);
                TreeMap existingMap = (TreeMap)v;
                existingSortedMap = MapsKt.toSortedMap((Map)existingMap);
                Long minTs = (Long)newCounterData.firstKey();
                long l = ((Number)groupNameToNormalizedStartTime.getOrDefault(groupName, Long.MIN_VALUE)).longValue();
                Intrinsics.checkNotNull((Object)minTs);
                groupNameToNormalizedStartTime.put(groupName, Long.max(l, minTs));
                existingSortedMap.putAll((Map)it.getValue());
                TreeMap newSortedMap = new TreeMap();
                for (Long ts : existingSortedMap.keySet()) {
                    boolean inCurrentGroup = ((Map)existingMap).containsKey(ts);
                    boolean inNewCounter = ((Map)newCounterData).containsKey(ts);
                    if (inCurrentGroup && inNewCounter) {
                        Map map2 = newSortedMap;
                        Object v2 = existingMap.get(ts);
                        Intrinsics.checkNotNull(v2);
                        double d = ((Number)v2).doubleValue();
                        Object v3 = newCounterData.get(ts);
                        Intrinsics.checkNotNull(v3);
                        map2.put(ts, d + ((Number)v3).doubleValue());
                        continue;
                    }
                    if (inCurrentGroup) {
                        Map.Entry pastCurrentCounterVal = newCounterData.floorEntry(ts);
                        Map map3 = newSortedMap;
                        Map.Entry entry2 = pastCurrentCounterVal;
                        double d = entry2 != null ? (Double)entry2.getValue() : Double.valueOf(0.0);
                        Object v4 = existingMap.get(ts);
                        Intrinsics.checkNotNull(v4);
                        map3.put(ts, d + ((Number)v4).doubleValue());
                        continue;
                    }
                    if (!inNewCounter) continue;
                    Map.Entry pastCurrentGroupVal = existingMap.floorEntry(ts);
                    Map map4 = newSortedMap;
                    Map.Entry entry3 = pastCurrentGroupVal;
                    double d = entry3 != null ? (Double)entry3.getValue() : Double.valueOf(0.0);
                    Object v5 = newCounterData.get(ts);
                    Intrinsics.checkNotNull(v5);
                    map4.put(ts, d + ((Number)v5).doubleValue());
                }
                groupToAggregatedData.put(groupName, newSortedMap);
                continue;
            }
            Long minTs = (Long)((TreeMap)it.getValue()).firstKey();
            long l = ((Number)groupNameToNormalizedStartTime.getOrDefault(groupName, Long.MIN_VALUE)).longValue();
            Intrinsics.checkNotNull((Object)minTs);
            groupNameToNormalizedStartTime.put(groupName, Long.max(l, minTs));
            groupToAggregatedData.put(groupName, it.getValue());
        }
        if (normalizeStartTime) {
            INSTANCE.removeDataBeforeNormalizedStartTime(groupToAggregatedData, groupNameToNormalizedStartTime);
        }
        Map $this$mapValues$iv = groupToAggregatedData;
        boolean $i$f$mapValues = false;
        $this$filterTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            existingSortedMap = (Map.Entry)element$iv$iv$iv;
            Map map5 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry4 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map6 = map5;
            boolean bl2 = false;
            CounterModel counterModel = new CounterModel((String)it.getKey(), (SortedMap)it.getValue());
            List<SeriesData<Long>> list = INSTANCE.convertCounterToSeriesData(counterModel);
            map6.put(k, list);
        }
        return MapsKt.toSortedMap((Map)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, TreeMap<Long, Double>> convertCountersToAggregatableFormat(List<CounterModel> counters) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = counters;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            CounterModel it = (CounterModel)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), new TreeMap<Long, Double>(it.getValuesByTimestampUs()));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private final void removeDataBeforeNormalizedStartTime(Map<String, TreeMap<Long, Double>> groupToAggregatedData, Map<String, Long> groupNameToMaxMinTs) {
        Set<String> groupNames = groupToAggregatedData.keySet();
        for (String groupName : groupNames) {
            if (!groupToAggregatedData.containsKey(groupName)) continue;
            Long l = groupNameToMaxMinTs.get(groupName);
            Intrinsics.checkNotNull((Object)l);
            long maxMinTs = ((Number)l).longValue();
            TreeMap<Long, Double> treeMap = groupToAggregatedData.get(groupName);
            Intrinsics.checkNotNull(treeMap);
            Long l2 = maxMinTs;
            TreeMap<Long, Double> treeMap2 = groupToAggregatedData.get(groupName);
            Intrinsics.checkNotNull(treeMap2);
            groupToAggregatedData.put(groupName, new TreeMap<Long, Double>(treeMap.subMap(l2, ((Number)treeMap2.lastKey()).longValue() + 1L)));
        }
    }

    @JvmStatic
    @NotNull
    public static final SortedMap<String, List<SeriesData<Long>>> convertSeriesDataToDeltaSeries(@NotNull SortedMap<String, List<SeriesData<Long>>> countersData) {
        Intrinsics.checkNotNullParameter(countersData, (String)"countersData");
        SortedMap groupToDeltaSeries = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        for (Map.Entry entry2 : ((Map)countersData).entrySet()) {
            String groupName = (String)entry2.getKey();
            List data = (List)entry2.getValue();
            List deltaData = new ArrayList();
            int n = data.size() - 1;
            for (int i = 0; i < n; ++i) {
                SeriesData a = (SeriesData)data.get(i);
                SeriesData b = (SeriesData)data.get(i + 1);
                deltaData.add(new SeriesData(b.x, (Object)(((Number)b.value).longValue() - ((Number)a.value).longValue())));
            }
            ((Map)groupToDeltaSeries).put(groupName, deltaData);
        }
        return groupToDeltaSeries;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SeriesData<Long>> convertCounterToSeriesData(@NotNull CounterModel counter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        Map $this$map$iv = counter.getValuesByTimestampUs();
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            collection.add(new SeriesData(((Number)k).longValue(), (Object)((long)((Number)it.getValue()).doubleValue())));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }
}

