/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.DefaultDurationData;
import com.android.tools.adtui.model.DurationData;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.model.legend.EventLegend;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ChartTooltipViewBase;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.CaptureNode;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

class CpuTraceEventTooltipView
extends ChartTooltipViewBase<CaptureNode> {
    @NotNull
    private final TraceEventTooltipLegends myLegends = new TraceEventTooltipLegends();
    @NotNull
    private final Color myRunningColor;
    @NotNull
    private final Color myIdleColor;

    protected CpuTraceEventTooltipView(@NotNull HTreeChart<CaptureNode> chart, @NotNull JComponent tooltipRoot, @NotNull Color runningColor, @NotNull Color idleColor) {
        super(chart, tooltipRoot);
        this.myRunningColor = runningColor;
        this.myIdleColor = idleColor;
    }

    @Override
    public void showTooltip(@NotNull CaptureNode node) {
        long totalDuration = node.getDuration();
        long threadDuration = Math.min(totalDuration, Math.max(0L, node.getEndThread() - node.getStartThread()));
        long idleDuration = totalDuration - threadDuration;
        this.getTooltipContainer().removeAll();
        JLabel nameLabel = new JLabel(node.getData().getFullName());
        nameLabel.setFont(TooltipView.TOOLTIP_BODY_FONT);
        nameLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        this.myLegends.getRunningDurationLegend().setPickData((DurationData)new DefaultDurationData(threadDuration));
        this.myLegends.getIdleDurationLegend().setPickData((DurationData)new DefaultDurationData(idleDuration));
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)this.myLegends).setOrientation(LegendComponent.Orientation.VERTICAL).build();
        legend.setForeground(ProfilerColors.TOOLTIP_TEXT);
        legend.configure(this.myLegends.getRunningDurationLegend(), new LegendConfig(LegendConfig.IconType.BOX, this.myRunningColor));
        legend.configure(this.myLegends.getIdleDurationLegend(), new LegendConfig(LegendConfig.IconType.BOX, this.myIdleColor));
        JLabel totalLabel = new JLabel(String.format("Total: %s", TimeFormatter.getSingleUnitDurationString((long)totalDuration)));
        this.getTooltipContainer().add((Component)nameLabel, new TabularLayout.Constraint(0, 0));
        this.getTooltipContainer().add((Component)legend, new TabularLayout.Constraint(1, 0));
        this.getTooltipContainer().add((Component)AdtUiUtils.createHorizontalSeparator(), new TabularLayout.Constraint(2, 0));
        this.getTooltipContainer().add((Component)totalLabel, new TabularLayout.Constraint(3, 0));
    }

    private static class TraceEventTooltipLegends
    extends LegendComponentModel {
        @NotNull
        private final EventLegend<DefaultDurationData> myRunningDurationLegend = new EventLegend("Running", e -> TimeFormatter.getSingleUnitDurationString((long)e.getDurationUs()));
        @NotNull
        private final EventLegend<DefaultDurationData> myIdleDurationLegend = new EventLegend("Idle", e -> TimeFormatter.getSingleUnitDurationString((long)e.getDurationUs()));

        TraceEventTooltipLegends() {
            this.add((Legend)this.myRunningDurationLegend);
            this.add((Legend)this.myIdleDurationLegend);
        }

        @NotNull
        EventLegend<DefaultDurationData> getRunningDurationLegend() {
            return this.myRunningDurationLegend;
        }

        @NotNull
        EventLegend<DefaultDurationData> getIdleDurationLegend() {
            return this.myIdleDurationLegend;
        }
    }
}

