/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadTrackModel;
import com.android.tools.profilers.cpu.ThreadState;
import com.android.tools.profilers.cpu.analysis.CaptureNodeDetailTable;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.CpuThreadAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.CpuThreadStateTable;
import com.android.tools.profilers.cpu.analysis.SummaryDetailsViewBase;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002R\u0013\u0010\b\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u000e\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0013\u0010\u0010\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadSummaryDetailsView;", "Lcom/android/tools/profilers/cpu/analysis/SummaryDetailsViewBase;", "Lcom/android/tools/profilers/cpu/analysis/CpuThreadAnalysisSummaryTabModel;", "parentView", "Lcom/android/tools/profilers/StudioProfilersView;", "tabModel", "<init>", "(Lcom/android/tools/profilers/StudioProfilersView;Lcom/android/tools/profilers/cpu/analysis/CpuThreadAnalysisSummaryTabModel;)V", "timeRangeLabel", "Ljavax/swing/JLabel;", "getTimeRangeLabel", "()Ljavax/swing/JLabel;", "durationLabel", "getDurationLabel", "dataTypeLabel", "getDataTypeLabel", "threadIdLabel", "getThreadIdLabel", "nodesTablePanel", "Ljavax/swing/JPanel;", "onSelectionRangeChanged", "", "populateNodesTable", "Companion", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCpuThreadSummaryDetailsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuThreadSummaryDetailsView.kt\ncom/android/tools/profilers/cpu/analysis/CpuThreadSummaryDetailsView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1#2:106\n1#2:117\n1617#3,9:107\n1869#3:116\n1870#3:118\n1626#3:119\n*S KotlinDebug\n*F\n+ 1 CpuThreadSummaryDetailsView.kt\ncom/android/tools/profilers/cpu/analysis/CpuThreadSummaryDetailsView\n*L\n61#1:117\n61#1:107,9\n61#1:116\n61#1:118\n61#1:119\n*E\n"})
public final class CpuThreadSummaryDetailsView
extends SummaryDetailsViewBase<CpuThreadAnalysisSummaryTabModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JLabel timeRangeLabel;
    @NotNull
    private final JLabel durationLabel;
    @NotNull
    private final JLabel dataTypeLabel;
    @NotNull
    private final JLabel threadIdLabel;
    @NotNull
    private final JPanel nodesTablePanel;
    public static final int $stable = 8;
    private static final int NUMBER_OF_TABLE_NODES = 10;

    /*
     * WARNING - void declaration
     */
    public CpuThreadSummaryDetailsView(@NotNull StudioProfilersView parentView, @NotNull CpuThreadAnalysisSummaryTabModel tabModel) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parentView, (String)"parentView");
        Intrinsics.checkNotNullParameter((Object)tabModel, (String)"tabModel");
        super(parentView, (CpuAnalysisSummaryTabModel)tabModel);
        this.timeRangeLabel = new JLabel();
        this.durationLabel = new JLabel();
        this.dataTypeLabel = new JLabel(tabModel.getLabel());
        this.threadIdLabel = new JLabel();
        this.nodesTablePanel = new JPanel(new BorderLayout());
        this.addRowToCommonSection("Time Range", this.timeRangeLabel);
        this.addRowToCommonSection("Duration", this.durationLabel);
        this.addRowToCommonSection("Data Type", this.dataTypeLabel);
        if (tabModel.getDataSeries().size() == 1) {
            void $this$_init__u24lambda_u240;
            JLabel jLabel;
            JLabel jLabel2 = jLabel = this.threadIdLabel;
            String string = "ID";
            CpuThreadSummaryDetailsView cpuThreadSummaryDetailsView = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.setText(String.valueOf(((CpuThreadTrackModel)tabModel.getDataSeries().get(0)).getThreadInfo().getId()));
            Unit unit = Unit.INSTANCE;
            cpuThreadSummaryDetailsView.addRowToCommonSection(string, jLabel);
        }
        tabModel.getSelectionRange().addDependency(this.getObserver()).onChange((Enum)Range.Aspect.RANGE, () -> CpuThreadSummaryDetailsView._init_$lambda$1(this));
        this.onSelectionRangeChanged();
        List list = tabModel.getDataSeries();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSeries(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable bl = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DataSeries<ThreadState> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            CpuThreadTrackModel it = (CpuThreadTrackModel)element$iv$iv;
            boolean bl3 = false;
            if (it.getThreadStateSeries() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List threadStateSeriesList = (List)destination$iv$iv;
        boolean bl5 = false;
        if (!((Collection)threadStateSeriesList).isEmpty()) {
            StudioProfilers studioProfilers = parentView.getStudioProfilers();
            Range range = tabModel.getSelectionRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getSelectionRange(...)");
            this.addSection(new CpuThreadStateTable(studioProfilers, threadStateSeriesList, range, null, 8, null).getComponent());
        }
        this.addSection(this.nodesTablePanel);
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getTimeRangeLabel() {
        return this.timeRangeLabel;
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getDurationLabel() {
        return this.durationLabel;
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getDataTypeLabel() {
        return this.dataTypeLabel;
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getThreadIdLabel() {
        return this.threadIdLabel;
    }

    private final void onSelectionRangeChanged() {
        Range range = ((CpuThreadAnalysisSummaryTabModel)this.getTabModel()).getSelectionRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getSelectionRange(...)");
        Range selectionRange = range;
        Range range2 = ((CpuThreadAnalysisSummaryTabModel)this.getTabModel()).getCaptureRange();
        Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"getCaptureRange(...)");
        Range captureRange = range2;
        this.timeRangeLabel.setText(SummaryDetailsViewBase.Companion.formatTimeRangeAsString$default(SummaryDetailsViewBase.Companion, selectionRange, (long)captureRange.getMin(), '\u0000', 4, null));
        this.durationLabel.setText(TimeFormatter.getSingleUnitDurationString((long)((long)selectionRange.getLength())));
        this.populateNodesTable();
    }

    private final void populateNodesTable() {
        this.getProfilersView().getStudioProfilers().getIdeServices().getPoolExecutor().execute(() -> CpuThreadSummaryDetailsView.populateNodesTable$lambda$6(this));
    }

    private static final void _init_$lambda$1(CpuThreadSummaryDetailsView this$0) {
        this$0.onSelectionRangeChanged();
    }

    private static final void populateNodesTable$lambda$6$lambda$5(CpuThreadSummaryDetailsView this$0, List $nodesInRange) {
        this$0.nodesTablePanel.removeAll();
        if (!((Collection)$nodesInRange).isEmpty()) {
            HideablePanel hideablePanel;
            Range range = ((CpuThreadAnalysisSummaryTabModel)this$0.getTabModel()).getCaptureRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getCaptureRange(...)");
            CaptureNodeDetailTable nodesTable = new CaptureNodeDetailTable($nodesInRange, range, this$0.getProfilersView().getStudioProfilers().getStage().getTimeline().getViewRange(), 0, 8, null);
            String sizeText = $nodesInRange.size() == 10 ? "top 10" : String.valueOf($nodesInRange.size());
            Border border = JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)((Color)StudioColorsKt.getBorder()), (int)1), (Border)((Border)JBUI.Borders.empty((int)8, (int)0, (int)0, (int)0)), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)border, (String)"merge(...)");
            Border contentBorder = border;
            HideablePanel $this$populateNodesTable_u24lambda_u246_u24lambda_u245_u24lambda_u244 = hideablePanel = new HideablePanel.Builder("Longest running events (" + sizeText + ")", nodesTable.getComponent()).setPanelBorder((Border)JBUI.Borders.empty()).setContentBorder(contentBorder).build();
            boolean bl = false;
            $this$populateNodesTable_u24lambda_u246_u24lambda_u245_u24lambda_u244.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
            HideablePanel hideablePanel2 = hideablePanel;
            Intrinsics.checkNotNullExpressionValue((Object)hideablePanel2, (String)"apply(...)");
            HideablePanel hideablePanel3 = hideablePanel2;
            this$0.nodesTablePanel.add((Component)hideablePanel3);
        }
        this$0.nodesTablePanel.revalidate();
        this$0.nodesTablePanel.repaint();
    }

    private static final void populateNodesTable$lambda$6(CpuThreadSummaryDetailsView this$0) {
        List<CaptureNode> list = ((CpuThreadAnalysisSummaryTabModel)this$0.getTabModel()).getTopNodesInSelectionRange(10);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTopNodesInSelectionRange(...)");
        List<CaptureNode> nodesInRange = list;
        this$0.getProfilersView().getStudioProfilers().getIdeServices().getMainExecutor().execute(() -> CpuThreadSummaryDetailsView.populateNodesTable$lambda$6$lambda$5(this$0, nodesInRange));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuThreadSummaryDetailsView$Companion;", "", "<init>", "()V", "NUMBER_OF_TABLE_NODES", "", "intellij.android.profilers.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

