/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.perfetto.proto.TraceProcessor;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.analysis.FrameEventRow;
import com.android.tools.profilers.cpu.analysis.FrameEventTableColumn;
import com.android.tools.profilers.cpu.analysis.PaginatedTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR'\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisFramesTabModel;", "Lcom/android/tools/profilers/cpu/analysis/CpuAnalysisTabModel;", "Lcom/android/tools/profilers/cpu/CpuCapture;", "captureRange", "Lcom/android/tools/adtui/model/Range;", "<init>", "(Lcom/android/tools/adtui/model/Range;)V", "getCaptureRange", "()Lcom/android/tools/adtui/model/Range;", "tableModels", "", "Lcom/android/tools/profilers/cpu/analysis/PaginatedTableModel;", "Lcom/android/tools/profilers/cpu/analysis/FrameEventRow;", "getTableModels", "()Ljava/util/List;", "tableModels$delegate", "Lkotlin/Lazy;", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nCpuAnalysisFramesTabModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuAnalysisFramesTabModel.kt\ncom/android/tools/profilers/cpu/analysis/CpuAnalysisFramesTabModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 TableModelUtils.kt\ncom/android/tools/profilers/cpu/analysis/TableModelUtilsKt\n*L\n1#1,87:1\n1374#2:88\n1460#2,5:89\n1563#2:94\n1634#2,2:95\n1869#2:97\n1869#2:98\n1870#2:106\n1870#2:107\n1636#2:116\n382#3,7:99\n1#4:108\n25#5,6:109\n48#5:115\n*S KotlinDebug\n*F\n+ 1 CpuAnalysisFramesTabModel.kt\ncom/android/tools/profilers/cpu/analysis/CpuAnalysisFramesTabModel\n*L\n30#1:88\n30#1:89,5\n32#1:94\n32#1:95,2\n34#1:97\n35#1:98\n35#1:106\n34#1:107\n32#1:116\n36#1:99,7\n55#1:109,6\n55#1:115\n*E\n"})
public final class CpuAnalysisFramesTabModel
extends CpuAnalysisTabModel<CpuCapture> {
    @NotNull
    private final Range captureRange;
    @NotNull
    private final Lazy tableModels$delegate;

    public CpuAnalysisFramesTabModel(@NotNull Range captureRange) {
        Intrinsics.checkNotNullParameter((Object)captureRange, (String)"captureRange");
        super(CpuAnalysisTabModel.Type.FRAMES);
        this.captureRange = captureRange;
        this.tableModels$delegate = LazyKt.lazy(() -> CpuAnalysisFramesTabModel.tableModels_delegate$lambda$9(this));
    }

    @NotNull
    public final Range getCaptureRange() {
        return this.captureRange;
    }

    @NotNull
    public final List<PaginatedTableModel<FrameEventRow>> getTableModels() {
        Lazy lazy = this.tableModels$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final List tableModels_delegate$lambda$9(CpuAnalysisFramesTabModel this$0) {
        void $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        List list = this$0.getDataSeries();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSeries(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CpuCapture it = (CpuCapture)element$iv$iv;
            boolean bl = false;
            Object object = it.getSystemTraceData();
            if (object == null || (object = object.getAndroidFrameLayers()) == null) {
                object = CollectionsKt.emptyList();
            }
            list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List layers = (List)destination$iv$iv;
        Iterable $this$map$iv = layers;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void name$iv;
            void $this$asTableModel_u24default$iv;
            void layer;
            Object object;
            list$iv$iv = (TraceProcessor.AndroidFrameEventsResult.Layer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object it = object = (Map)new LinkedHashMap();
            boolean bl2 = false;
            List list2 = layer.getPhaseList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPhaseList(...)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TraceProcessor.AndroidFrameEventsResult.Phase phase = (TraceProcessor.AndroidFrameEventsResult.Phase)element$iv;
                boolean bl3 = false;
                List list3 = phase.getFrameEventList();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getFrameEventList(...)");
                Iterable $this$forEach$iv2 = list3;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Object object2;
                    void $this$getOrPut$iv;
                    TraceProcessor.AndroidFrameEventsResult.FrameEvent frameEvent = (TraceProcessor.AndroidFrameEventsResult.FrameEvent)element$iv2;
                    boolean bl4 = false;
                    Map map = it;
                    Integer key$iv = frameEvent.getFrameNumber();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl5 = false;
                        FrameEventRow answer$iv = new FrameEventRow(frameEvent.getFrameNumber(), (long)this$0.captureRange.getMin(), (long)this$0.captureRange.getMax(), 0L, 0L, 0L, 56, null);
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    FrameEventRow frameEventRow = (FrameEventRow)object2;
                    long timestampUs = TimeUnit.NANOSECONDS.toMicros(frameEvent.getTimestampNanoseconds());
                    long durationUs = TimeUnit.NANOSECONDS.toMicros(frameEvent.getDurationNanoseconds());
                    String string = phase.getPhaseName();
                    if (string == null) continue;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 66049: {
                            if (string.equals("App")) {
                                n = 1;
                            }
                            break;
                        }
                        case 828944778: {
                            if (string.equals("Composition")) {
                                n = 2;
                            }
                            break;
                        }
                        case 70796: {
                            if (string.equals("GPU")) {
                                n = 3;
                            }
                            break;
                        }
                        case -958549854: {
                            if (string.equals("Display")) {
                                n = 4;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            frameEventRow.setStartTimeUs(timestampUs);
                            frameEventRow.setAppDurationUs(durationUs);
                            break;
                        }
                        case 3: {
                            frameEventRow.setGpuDurationUs(durationUs);
                            break;
                        }
                        case 2: {
                            frameEventRow.setCompositionDurationUs(durationUs);
                            break;
                        }
                        case 4: {
                            frameEventRow.setEndTimeUs(timestampUs);
                        }
                    }
                }
            }
            Map frameNumberToRow = object;
            object = CollectionsKt.toMutableList(frameNumberToRow.values());
            String it2 = layer.getLayerName();
            boolean bl6 = false;
            Intrinsics.checkNotNull((Object)it2);
            String string = it2.substring(StringsKt.lastIndexOf$default((CharSequence)it2, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            it = string;
            int pageSize$iv = 25;
            boolean $i$f$asTableModel = false;
            collection.add((PaginatedTableModel)new PaginatedTableModel<FrameEventRow>(pageSize$iv, (List)$this$asTableModel_u24default$iv, (String)name$iv){
                final /* synthetic */ List $this_asTableModel;
                final /* synthetic */ String $name;
                {
                    this.$this_asTableModel = $receiver;
                    this.$name = $name;
                    super($pageSize);
                }

                public List<FrameEventRow> getRows() {
                    return this.$this_asTableModel;
                }

                public int getDataSize() {
                    return this.getRows().size();
                }

                protected Comparable<?> getDataValueAt(int dataIndex, int columnIndex) {
                    FrameEventTableColumn p0 = FrameEventTableColumn.values()[columnIndex];
                    boolean bl = false;
                    return (Comparable)p0.getGetValueFrom().invoke((Object)this.getRows().get(dataIndex));
                }

                public int getColumnCount() {
                    return FrameEventTableColumn.values().length;
                }

                public Class<?> getColumnClass(int columnIndex) {
                    FrameEventTableColumn p0 = FrameEventTableColumn.values()[columnIndex];
                    boolean bl = false;
                    return p0.getType();
                }

                public String getColumnName(int column) {
                    FrameEventTableColumn p0 = FrameEventTableColumn.values()[column];
                    boolean bl = false;
                    return p0.getDisplayName();
                }

                public String toString() {
                    return this.$name;
                }

                /*
                 * WARNING - void declaration
                 */
                public void sortData(List<? extends RowSorter.SortKey> sortKeys) {
                    Intrinsics.checkNotNullParameter(sortKeys, (String)"sortKeys");
                    if (!((Collection)sortKeys).isEmpty()) {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = sortKeys;
                        List<FrameEventRow> list = this.getRows();
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Object destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void key;
                            RowSorter.SortKey sortKey = (RowSorter.SortKey)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            FrameEventTableColumn p0 = FrameEventTableColumn.values()[key.getColumn()];
                            boolean bl2 = false;
                            Function1<FrameEventRow, Comparable<?>> function1 = p0.getGetValueFrom();
                            Comparator<T> cmp = new Comparator(function1){
                                final /* synthetic */ Function1 $selector;
                                {
                                    this.$selector = $selector;
                                }

                                public final int compare(T a, T b) {
                                    Function1 function1 = this.$selector;
                                    return ComparisonsKt.compareValues((Comparable)((Comparable)function1.invoke(a)), (Comparable)((Comparable)function1.invoke(b)));
                                }
                            };
                            collection.add(key.getSortOrder() == SortOrder.ASCENDING ? cmp : cmp.reversed());
                        }
                        Iterable $this$reduce$iv = (List)destination$iv$iv;
                        boolean $i$f$reduce = false;
                        Iterator<T> iterator$iv = $this$reduce$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            throw new UnsupportedOperationException("Empty collection can't be reduced.");
                        }
                        Object accumulator$iv = iterator$iv.next();
                        while (iterator$iv.hasNext()) {
                            void p1;
                            destination$iv$iv = (Comparator)iterator$iv.next();
                            Comparator p0 = (Comparator)accumulator$iv;
                            boolean bl = false;
                            accumulator$iv = ComparisonsKt.then((Comparator)p0, (Comparator)p1);
                        }
                        CollectionsKt.sortWith(list, (Comparator)((Comparator)((Object)iterable)));
                    }
                }
            });
        }
        return (List)destination$iv$iv;
    }
}

