/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.profilers.LiveDataModel;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageCpuUsageTooltip;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.android.tools.profilers.cpu.adapters.CpuDataProvider;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class LiveCpuUsageModel
extends LiveDataModel {
    private final List<Updatable> myUpdatable;
    private final StudioProfilers myProfilers;
    private TooltipModel myCpuUsageTooltip;
    private final CpuDataProvider myCpuDataProvider;
    private final Stage myStage;

    public LiveCpuUsageModel(@NotNull StudioProfilers profilers, @NotNull Stage stage) {
        super(profilers);
        this.myProfilers = profilers;
        this.myStage = stage;
        this.myCpuDataProvider = new CpuDataProvider(profilers, profilers.getTimeline());
        this.myUpdatable = ImmutableList.of((Object)((Object)this.myCpuDataProvider.getCpuUsage()));
        this.myCpuUsageTooltip = new CpuProfilerStageCpuUsageTooltip(this.myCpuDataProvider.getLegends(), this.myCpuDataProvider.getRangeSelectionModel(), this.myCpuDataProvider.getTraceDurations());
    }

    @VisibleForTesting
    protected LiveCpuUsageModel(@NotNull StudioProfilers profilers, @NotNull CpuDataProvider cpuDataProvider, @NotNull Stage stage) {
        super(profilers);
        this.myStage = stage;
        this.myProfilers = profilers;
        this.myCpuDataProvider = cpuDataProvider;
        this.myUpdatable = ImmutableList.of((Object)((Object)this.myCpuDataProvider.getCpuUsage()));
        this.myCpuUsageTooltip = new CpuProfilerStageCpuUsageTooltip(this.myCpuDataProvider.getLegends(), this.myCpuDataProvider.getRangeSelectionModel(), this.myCpuDataProvider.getTraceDurations());
    }

    public Stage getStage() {
        return this.myStage;
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myCpuDataProvider.getAspect();
    }

    public void setAndSelectCapture(long traceId) {
    }

    public int getSelectedThread() {
        return this.myCpuDataProvider.getSelectedThread();
    }

    public void setSelectedThread(int id) {
        this.myCpuDataProvider.setSelectedThread(id);
    }

    @NotNull
    public RangeSelectionModel getRangeSelectionModel() {
        return this.myCpuDataProvider.getRangeSelectionModel();
    }

    public StudioProfilers getStudioProfilers() {
        return this.myProfilers;
    }

    public UpdatableManager getUpdatableManager() {
        return this.myCpuDataProvider.getUpdatableManager();
    }

    @NotNull
    public CpuThreadsModel getThreadStates() {
        return this.myCpuDataProvider.getThreadStates();
    }

    public AxisComponentModel getCpuUsageAxis() {
        return this.myCpuDataProvider.getCpuUsageAxis();
    }

    public AxisComponentModel getThreadCountAxis() {
        return this.myCpuDataProvider.getThreadCountAxis();
    }

    public AxisComponentModel getTimeAxisGuide() {
        return this.myCpuDataProvider.getTimeAxisGuide();
    }

    public DetailedCpuUsage getCpuUsage() {
        return this.myCpuDataProvider.getCpuUsage();
    }

    public CpuProfilerStage.CpuStageLegends getLegends() {
        return this.myCpuDataProvider.getLegends();
    }

    public DurationDataModel<CpuTraceInfo> getTraceDurations() {
        return this.myCpuDataProvider.getTraceDurations();
    }

    @Override
    public void enter() {
        this.myUpdatable.forEach(updatable -> this.myProfilers.getUpdater().register(updatable));
    }

    @Override
    public String getName() {
        return "LIVE_CPU";
    }

    @Override
    public TooltipModel getTooltip() {
        return this.myCpuUsageTooltip;
    }

    @Override
    public void exit() {
        this.myUpdatable.forEach(updatable -> this.myProfilers.getUpdater().unregister(updatable));
    }
}

