/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParserUtil;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerNotifications;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.MainProcessSelector;
import com.android.tools.profilers.cpu.ProcessSelectorDialogAbortedException;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.TracePreProcessor;
import com.android.tools.profilers.cpu.art.ArtTraceParser;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.config.UnspecifiedConfiguration;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.SystemTraceNodeModel;
import com.android.tools.profilers.cpu.simpleperf.SimpleperfTraceParser;
import com.android.tools.profilers.cpu.systemtrace.AtraceParser;
import com.android.tools.profilers.perfetto.PerfettoParser;
import com.android.tools.profilers.tasks.TaskEventTrackerUtils;
import com.android.tools.profilers.tasks.TaskFinishedState;
import com.android.tools.profilers.tasks.TaskProcessingFailedMetadata;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.CpuCaptureMetadata;
import com.google.wireless.android.sdk.stats.CpuImportTraceMetadata;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCaptureParser {
    @VisibleForTesting
    static final int MAX_SUPPORTED_TRACE_SIZE = 0x6400000;
    private final Map<Long, CompletableFuture<CpuCapture>> myCaptures;
    @NotNull
    private final IdeProfilerServices myServices;
    @NotNull
    private final StudioProfilers myProfilers;
    private final AspectModel<CpuProfilerAspect> myAspect = new AspectModel();
    private boolean myIsParsing;
    private long myParsingStartTimeMs;
    private final Map<Long, CpuCaptureMetadata> myCaptureMetadataMap = new HashMap<Long, CpuCaptureMetadata>();
    private static final Set<String> myPreviouslyLoadedCaptures = new HashSet<String>();
    private static final Logger LOGGER = Logger.getInstance(CpuCaptureParser.class);

    public CpuCaptureParser(@NotNull StudioProfilers profilers) {
        this.myProfilers = profilers;
        this.myServices = profilers.getIdeServices();
        this.myCaptures = new HashMap<Long, CompletableFuture<CpuCapture>>();
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myAspect;
    }

    @VisibleForTesting
    static void clearPreviouslyLoadedCaptures() {
        myPreviouslyLoadedCaptures.clear();
    }

    @Nullable
    public CompletableFuture<CpuCapture> getCapture(long traceId) {
        return this.myCaptures.get(traceId);
    }

    void trackCaptureMetadata(long traceId, @NotNull CpuCaptureMetadata metadata) {
        this.myCaptureMetadataMap.put(traceId, metadata);
    }

    public void abortParsing() {
        this.myCaptures.forEach((id, capture) -> {
            boolean isCaptureCancelled = capture.cancel(true);
            if (!isCaptureCancelled) {
                LOGGER.warn(String.format("Parsing of capture %d was not properly cancelled.", id));
            }
        });
    }

    public boolean isParsing() {
        return this.myIsParsing;
    }

    public long getParsingElapsedTimeMs() {
        return System.currentTimeMillis() - this.myParsingStartTimeMs;
    }

    private void updateParsingStateWhenDone() {
        this.myIsParsing = false;
        this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_PARSING);
    }

    @VisibleForTesting
    public void updateParsingStateWhenStarting() {
        this.myParsingStartTimeMs = System.currentTimeMillis();
        this.myIsParsing = true;
        this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_PARSING);
    }

    @NotNull
    public CompletableFuture<CpuCapture> parse(@NotNull File traceFile, long traceId, @NotNull ProfilingConfiguration.TraceType preferredProfilerType, int processIdHint, String processNameHint, @NotNull Consumer<TaskFinishedState> trackTaskFinished) {
        if (this.myCaptures.containsKey(traceId)) {
            return this.myCaptures.get(traceId);
        }
        boolean isImportedTrace = processIdHint == 0;
        CompletionStage cpuCapture = ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(new TraceFileValidationAction(traceFile), this.myServices.getPoolExecutor()).thenRunAsync(new ParsingStartAction(traceFile), this.myServices.getMainExecutor())).thenApplyAsync((Function)new ProcessTraceAction(traceFile, traceId, preferredProfilerType, processIdHint, processNameHint, this.myServices), this.myServices.getPoolExecutor())).whenCompleteAsync((BiConsumer)new TraceResultHandler(traceFile, traceId, isImportedTrace, trackTaskFinished), this.myServices.getMainExecutor());
        this.myCaptures.put(traceId, (CompletableFuture<CpuCapture>)cpuCapture);
        return cpuCapture;
    }

    @NotNull
    public static com.google.wireless.android.sdk.stats.CpuCaptureMetadata getCpuCaptureMetadata(@NotNull CpuCaptureMetadata metadata) {
        CpuCaptureMetadata.Builder result = com.google.wireless.android.sdk.stats.CpuCaptureMetadata.newBuilder().setCaptureStatus(metadata.getStatus() != null ? CpuCaptureMetadata.CaptureStatus.valueOf((String)metadata.getStatus().name()) : CpuCaptureMetadata.CaptureStatus.UNKNOWN_STATUS).setCaptureDurationMs(metadata.getCaptureDurationMs()).setParsingTimeMs(metadata.getParsingTimeMs()).setRecordDurationMs(metadata.getRecordDurationMs()).setStoppingTimeMs(metadata.getStoppingTimeMs()).setHasComposeTracingNodes(Boolean.TRUE.equals(metadata.getHasComposeTracingNodes())).setTraceFileSizeBytes(metadata.getTraceFileSizeBytes()).setArtStopTimeoutSec(metadata.getArtStopTimeoutSec());
        if (metadata.getCpuProfilerEntryPoint() != null) {
            result.setCpuProfilerEntryPoint(CpuCaptureMetadata.CpuProfilerEntryPoint.valueOf((String)metadata.getCpuProfilerEntryPoint().name()));
        }
        return result.build();
    }

    private static final class TraceFileValidationAction
    implements Runnable {
        @NotNull
        private final File traceFile;

        private TraceFileValidationAction(@NotNull File traceFile) {
            this.traceFile = traceFile;
        }

        @Override
        public void run() {
            if (!this.traceFile.exists() || this.traceFile.isDirectory()) {
                throw new InvalidPathParsingFailureException(this.traceFile.getAbsolutePath());
            }
            if (this.traceFile.length() == (long)TracePreProcessor.FAILURE.size()) {
                try (FileInputStream is = new FileInputStream(this.traceFile);){
                    ByteString fileContent = ByteString.readFrom((InputStream)is);
                    if (TracePreProcessor.FAILURE.equals((Object)fileContent)) {
                        throw new PreProcessorFailureException();
                    }
                }
                catch (IOException e) {
                    throw new ReadErrorParsingFailureException(this.traceFile.getAbsolutePath(), e);
                }
            }
        }
    }

    private final class ParsingStartAction
    implements Runnable {
        @NotNull
        private final File traceFile;

        private ParsingStartAction(File traceFile) {
            this.traceFile = traceFile;
        }

        @Override
        public void run() {
            CpuCaptureParser.this.updateParsingStateWhenStarting();
            long traceLengthBytes = this.traceFile.length();
            if (this.traceFile.length() > 0x6400000L) {
                Runnable yesCallback = () -> {};
                Runnable noCallback = () -> {
                    throw new CancellationException(String.format("Parsing of a long (%d bytes) trace file was aborted by the user.", traceLengthBytes));
                };
                this.openParseLargeTracesDialog(yesCallback, noCallback);
            }
        }

        private void openParseLargeTracesDialog(Runnable yesCallback, Runnable noCallback) {
            CpuCaptureParser.this.myServices.openYesNoDialog("The trace file generated is large, and Android Studio may become unresponsive while it parses the data. Do you want to continue?\n\nWarning: If you select \"No\", Android Studio discards the trace data and you will need to capture a new method trace.", "Trace File Too Large", yesCallback, noCallback);
        }
    }

    @VisibleForTesting
    static final class ProcessTraceAction
    implements Function<Void, CpuCapture> {
        @NotNull
        private final File traceFile;
        private final long traceId;
        @NotNull
        private final ProfilingConfiguration.TraceType preferredProfilerType;
        private final int processIdHint;
        @NotNull
        private final String processNameHint;
        @NotNull
        private final IdeProfilerServices services;
        private static final Supplier<TraceParser> ART_PARSER_SUPPLIER = () -> new ArtTraceParser();
        private static final Supplier<TraceParser> SIMPLEPERF_PARSER_SUPPLIER = () -> new SimpleperfTraceParser();
        private final Supplier<TraceParser> ATRACE_PARSER_SUPPLIER = () -> new AtraceParser(this.getMainProcessSelector());
        private final Supplier<TraceParser> PERFETTO_PARSER_SUPPLIER = () -> new PerfettoParser(this.getMainProcessSelector(), this.getProfilerServices());

        @VisibleForTesting
        ProcessTraceAction(@NotNull File traceFile, long traceId, @NotNull ProfilingConfiguration.TraceType preferredProfilerType, int processIdHint, @Nullable String processNameHint, @NotNull IdeProfilerServices services) {
            this.traceFile = traceFile;
            this.traceId = traceId;
            this.preferredProfilerType = preferredProfilerType;
            this.processIdHint = processIdHint;
            this.processNameHint = processNameHint != null ? processNameHint : "";
            this.services = services;
        }

        @Override
        public CpuCapture apply(Void aVoid) {
            return this.parseToCapture(this.traceFile, this.traceId, this.preferredProfilerType);
        }

        private CpuCapture parseToCapture(@NotNull File traceFile, long traceId, @NotNull ProfilingConfiguration.TraceType profilerType) {
            ProfilingConfiguration.TraceType traceType = CpuCaptureParserUtil.getFileTraceType(traceFile, profilerType);
            if (traceType == null) {
                throw new UnknownParserParsingFailureException(traceFile.getAbsolutePath());
            }
            return this.parseWith(traceType, traceFile, traceId);
        }

        @NotNull
        private MainProcessSelector getMainProcessSelector() {
            return new MainProcessSelector(this.processNameHint, this.processIdHint, this.services);
        }

        @NotNull
        private IdeProfilerServices getProfilerServices() {
            return this.services;
        }

        private CpuCapture parseWith(@NotNull ProfilingConfiguration.TraceType type, @NotNull File traceFile, long traceId) {
            Supplier<TraceParser> parserSupplier = this.getParserSupplier(type);
            TraceParser parser = parserSupplier.get();
            try {
                return parser.parse(traceFile, traceId);
            }
            catch (ProcessSelectorDialogAbortedException e) {
                throw new CancellationException("User aborted process choice dialog.");
            }
            catch (Throwable e) {
                throw new ParsingFailureException(String.format("Trace file '%s' failed to be parsed as %s.", new Object[]{traceFile.getAbsolutePath(), type}), e);
            }
        }

        @VisibleForTesting
        Supplier<TraceParser> getParserSupplier(@NotNull ProfilingConfiguration.TraceType type) {
            return switch (type) {
                case ProfilingConfiguration.TraceType.ART -> ART_PARSER_SUPPLIER;
                case ProfilingConfiguration.TraceType.SIMPLEPERF -> SIMPLEPERF_PARSER_SUPPLIER;
                case ProfilingConfiguration.TraceType.ATRACE -> this.ATRACE_PARSER_SUPPLIER;
                case ProfilingConfiguration.TraceType.PERFETTO -> this.PERFETTO_PARSER_SUPPLIER;
                default -> null;
            };
        }
    }

    private final class TraceResultHandler
    implements BiConsumer<CpuCapture, Throwable> {
        @NotNull
        private final File traceFile;
        private final long traceId;
        private final boolean isImportedTrace;
        private final Consumer<TaskFinishedState> trackTaskFinished;

        private TraceResultHandler(File traceFile, long traceId, @NotNull boolean isImportedTrace, Consumer<TaskFinishedState> trackTaskFinished) {
            this.traceFile = traceFile;
            this.traceId = traceId;
            this.isImportedTrace = isImportedTrace;
            this.trackTaskFinished = trackTaskFinished;
        }

        @Override
        public void accept(CpuCapture capture, Throwable throwable) {
            CpuCaptureParser.this.updateParsingStateWhenDone();
            CpuCaptureMetadata metadata = CpuCaptureParser.this.myCaptureMetadataMap.computeIfAbsent(this.traceId, id -> new CpuCaptureMetadata(new UnspecifiedConfiguration("Unnamed")));
            metadata.setTraceFileSizeBytes((int)this.traceFile.length());
            if (metadata.getProfilingConfiguration().getTraceType() == ProfilingConfiguration.TraceType.ART) {
                metadata.setArtStopTimeoutSec(CpuProfilerStage.CPU_ART_STOP_TIMEOUT_SEC);
            }
            if (capture != null) {
                metadata.setStatus(CpuCaptureMetadata.CaptureStatus.SUCCESS);
                metadata.setParsingTimeMs(Math.max(1L, System.currentTimeMillis() - CpuCaptureParser.this.myParsingStartTimeMs));
                metadata.setCaptureDurationMs(TimeUnit.MICROSECONDS.toMillis(capture.getDurationUs()));
                metadata.setRecordDurationMs(this.calculateRecordDurationMs(capture));
                metadata.setHasComposeTracingNodes(this.checkHasComposeTracingNodes(capture));
            } else if (throwable != null) {
                LOGGER.warn("Unable to parse capture: " + throwable.getMessage(), throwable.getCause());
                if (throwable.getCause() instanceof CancellationException) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING);
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_ABORTED);
                    this.trackTaskFinished.accept(TaskFinishedState.USER_CANCELLED);
                } else if (throwable.getCause() instanceof PreProcessorFailureException) {
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PREPROCESS_FAILURE);
                    if (!CpuCaptureParser.this.myServices.getFeatureConfig().isTaskBasedUxEnabled()) {
                        return;
                    }
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILURE);
                } else if (throwable.getCause() instanceof InvalidPathParsingFailureException) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_PATH_INVALID);
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_FAILURE);
                } else if (throwable.getCause() instanceof ReadErrorParsingFailureException) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_READ_ERROR);
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_FAILURE);
                } else if (throwable.getCause() instanceof UnknownParserParsingFailureException) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_PARSER_UNKNOWN);
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_FAILURE);
                } else if (throwable.getCause() instanceof FileHeaderParsingFailureException) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_FILE_HEADER_ERROR);
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_FAILURE);
                } else if (throwable.getCause() instanceof ParsingFailureException) {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_PARSER_ERROR);
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_FAILURE);
                } else {
                    metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_CAUSE_UNKNOWN);
                    CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_FAILURE);
                }
            } else {
                LOGGER.warn("Unable to parse capture: no throwable.");
                metadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_CAUSE_UNKNOWN);
                CpuCaptureParser.this.myServices.showNotification(CpuProfilerNotifications.PARSING_FAILURE);
            }
            if (!myPreviouslyLoadedCaptures.contains(this.traceFile.getAbsolutePath())) {
                myPreviouslyLoadedCaptures.add(this.traceFile.getAbsolutePath());
                CpuCaptureParser.this.myServices.getFeatureTracker().trackCaptureTrace(metadata);
                if (this.isImportedTrace) {
                    boolean isSuccess;
                    ProfilingConfiguration.TraceType type = capture != null ? capture.getType() : metadata.getProfilingConfiguration().getTraceType();
                    boolean bl = isSuccess = capture != null;
                    if (CpuCaptureParser.this.myServices.getFeatureConfig().isTaskBasedUxEnabled()) {
                        if (!isSuccess) {
                            TaskEventTrackerUtils.trackProcessingTaskFailed(CpuCaptureParser.this.myProfilers, CpuCaptureParser.this.myProfilers.getSessionsManager().isSessionAlive(), new TaskProcessingFailedMetadata(metadata));
                        }
                    } else {
                        CpuCaptureParser.this.myServices.getFeatureTracker().trackImportTrace(this.createCpuImportTraceMetadata(type, isSuccess, metadata.getHasComposeTracingNodes()));
                    }
                }
                CpuCaptureParser.this.myCaptureMetadataMap.remove(this.traceId);
            }
        }

        private long calculateRecordDurationMs(CpuCapture capture) {
            Range maxDataRange = new Range();
            for (CaptureNode node : capture.getCaptureNodes()) {
                maxDataRange.expand((double)node.getStartGlobal(), (double)node.getEndGlobal());
            }
            return TimeUnit.MICROSECONDS.toMillis((long)maxDataRange.getLength());
        }

        @NotNull
        private Boolean checkHasComposeTracingNodes(CpuCapture capture) {
            Pattern pattern = Pattern.compile("^(.*) \\((.*\\.(kt|java)):(-?\\d+)\\)$");
            ArrayDeque<CaptureNode> queue = new ArrayDeque<CaptureNode>();
            HashSet<CaptureNode> seen = new HashSet<CaptureNode>();
            for (CaptureNode node : capture.getCaptureNodes()) {
                if (!seen.add(node)) continue;
                queue.add(node);
            }
            while (!queue.isEmpty()) {
                CaptureNode node = (CaptureNode)queue.removeFirst();
                CaptureNodeModel data = node.getData();
                if (data instanceof SystemTraceNodeModel && pattern.matcher(data.getFullName()).find()) {
                    return true;
                }
                for (CaptureNode child : node.childrenList) {
                    if (!seen.add(child)) continue;
                    queue.addLast(child);
                }
            }
            return false;
        }

        private CpuImportTraceMetadata createCpuImportTraceMetadata(@NotNull ProfilingConfiguration.TraceType profilerType, boolean isSuccess, @Nullable Boolean hasComposeTracingNodes) {
            CpuImportTraceMetadata.Builder metadata = CpuImportTraceMetadata.newBuilder();
            metadata.setImportStatus(isSuccess ? CpuImportTraceMetadata.ImportStatus.IMPORT_TRACE_SUCCESS : CpuImportTraceMetadata.ImportStatus.IMPORT_TRACE_FAILURE);
            metadata.setTechnology(this.technologyForProfilerType(profilerType));
            if (hasComposeTracingNodes != null) {
                metadata.setHasComposeTracingNodes(hasComposeTracingNodes.booleanValue());
            }
            return metadata.build();
        }

        private CpuImportTraceMetadata.Technology technologyForProfilerType(@NotNull ProfilingConfiguration.TraceType profilerType) {
            switch (profilerType) {
                case ART: {
                    return CpuImportTraceMetadata.Technology.ART_TECHNOLOGY;
                }
                case SIMPLEPERF: {
                    return CpuImportTraceMetadata.Technology.SIMPLEPERF_TECHNOLOGY;
                }
                case ATRACE: {
                    return CpuImportTraceMetadata.Technology.ATRACE_TECHNOLOGY;
                }
                case PERFETTO: {
                    return CpuImportTraceMetadata.Technology.PERFETTO_TECHNOLOGY;
                }
            }
            return CpuImportTraceMetadata.Technology.UNKNOWN_TECHNOLOGY;
        }
    }

    public static class FileHeaderParsingFailureException
    extends ParsingFailureException {
        public FileHeaderParsingFailureException(@NotNull String traceFilePath, @NotNull ProfilingConfiguration.TraceType type) {
            super(String.format("Trace file '%s' expected to be of type %s but failed header verification.", new Object[]{traceFilePath, type}));
        }

        public FileHeaderParsingFailureException(@NotNull String traceFilePath, @NotNull ProfilingConfiguration.TraceType type, @NotNull Throwable cause) {
            super(String.format("Trace file '%s' expected to be of type %s but failed header verification.", new Object[]{traceFilePath, type}), cause);
        }
    }

    public static class UnknownParserParsingFailureException
    extends ParsingFailureException {
        private UnknownParserParsingFailureException(@NotNull String traceFilePath) {
            super(String.format("Trace not parsed. Couldn't identify the correct parser for '%s'.", traceFilePath));
        }
    }

    public static class ReadErrorParsingFailureException
    extends ParsingFailureException {
        private ReadErrorParsingFailureException(@NotNull String traceFilePath, @NotNull IOException readError) {
            super(String.format("Trace not parsed. Unable to read file: '%s'.", traceFilePath), readError);
        }
    }

    public static class InvalidPathParsingFailureException
    extends ParsingFailureException {
        private InvalidPathParsingFailureException(@NotNull String traceFilePath) {
            super(String.format("Trace not parsed. Path doesn't exist or points to a directory: '%s'.", traceFilePath));
        }
    }

    public static class PreProcessorFailureException
    extends ParsingFailureException {
        private PreProcessorFailureException() {
        }
    }

    public static class ParsingFailureException
    extends RuntimeException {
        private ParsingFailureException() {
        }

        protected ParsingFailureException(@NotNull String string) {
            super(string);
        }

        protected ParsingFailureException(@NotNull String string, @NotNull Throwable cause) {
            super(string, cause);
        }
    }
}

