/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameEvent;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameEventTooltip;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0019\u001a\u00020\u0003H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00108\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00108\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001b\u0010\u0015\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00108\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u001b\u0010\u0017\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00108\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/profilers/cpu/AndroidFrameEventTooltipView;", "Lcom/android/tools/adtui/TooltipView;", "parent", "Ljavax/swing/JComponent;", "tooltip", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameEventTooltip;", "<init>", "(Ljavax/swing/JComponent;Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameEventTooltip;)V", "getTooltip", "()Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameEventTooltip;", "labelContainer", "Ljavax/swing/JPanel;", "getLabelContainer", "()Ljavax/swing/JPanel;", "frameNumberLabel", "Ljavax/swing/JLabel;", "Lorg/jetbrains/annotations/NotNull;", "getFrameNumberLabel", "()Ljavax/swing/JLabel;", "startTimeLabel", "getStartTimeLabel", "durationLabel", "getDurationLabel", "helpTextLabel", "getHelpTextLabel", "createTooltip", "updateView", "", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAndroidFrameEventTooltipView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidFrameEventTooltipView.kt\ncom/android/tools/profilers/cpu/AndroidFrameEventTooltipView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class AndroidFrameEventTooltipView
extends TooltipView {
    @NotNull
    private final AndroidFrameEventTooltip tooltip;
    @VisibleForTesting
    @NotNull
    private final JPanel labelContainer;
    @VisibleForTesting
    @NotNull
    private final JLabel frameNumberLabel;
    @VisibleForTesting
    @NotNull
    private final JLabel startTimeLabel;
    @VisibleForTesting
    @NotNull
    private final JLabel durationLabel;
    @VisibleForTesting
    @NotNull
    private final JLabel helpTextLabel;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public AndroidFrameEventTooltipView(@NotNull JComponent parent, @NotNull AndroidFrameEventTooltip tooltip) {
        JPanel jPanel;
        void $this$helpTextLabel_u24lambda_u240;
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)((Object)tooltip), (String)"tooltip");
        super(tooltip.getTimeline());
        this.tooltip = tooltip;
        this.labelContainer = new JPanel((LayoutManager)new TabularLayout("*").setVGap(12));
        JLabel jLabel2 = TooltipView.createTooltipLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel2, (String)"createTooltipLabel(...)");
        this.frameNumberLabel = jLabel2;
        JLabel jLabel3 = TooltipView.createTooltipLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel3, (String)"createTooltipLabel(...)");
        this.startTimeLabel = jLabel3;
        JLabel jLabel4 = TooltipView.createTooltipLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel4, (String)"createTooltipLabel(...)");
        this.durationLabel = jLabel4;
        JLabel jLabel5 = jLabel = TooltipView.createTooltipLabel();
        AndroidFrameEventTooltipView androidFrameEventTooltipView = this;
        boolean bl = false;
        $this$helpTextLabel_u24lambda_u240.setText(this.tooltip.getAndroidFramePhase().getTooltipText());
        JLabel jLabel6 = jLabel;
        Intrinsics.checkNotNullExpressionValue((Object)jLabel6, (String)"apply(...)");
        androidFrameEventTooltipView.helpTextLabel = jLabel6;
        JPanel $this$_init__u24lambda_u244 = jPanel = this.labelContainer;
        boolean bl2 = false;
        $this$_init__u24lambda_u244.add((Component)this.frameNumberLabel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        $this$_init__u24lambda_u244.add((Component)this.startTimeLabel, new TabularLayout.Constraint(1, 0, 0, 4, null));
        $this$_init__u24lambda_u244.add((Component)this.durationLabel, new TabularLayout.Constraint(2, 0, 0, 4, null));
        $this$_init__u24lambda_u244.add((Component)this.helpTextLabel, new TabularLayout.Constraint(3, 0, 0, 4, null));
        this.tooltip.addDependency((AspectObserver)this).onChange((Enum)AndroidFrameEventTooltip.Aspect.VALUE_CHANGED, this::updateView);
        this.updateView();
    }

    @NotNull
    public final AndroidFrameEventTooltip getTooltip() {
        return this.tooltip;
    }

    @NotNull
    public final JPanel getLabelContainer() {
        return this.labelContainer;
    }

    @NotNull
    public final JLabel getFrameNumberLabel() {
        return this.frameNumberLabel;
    }

    @NotNull
    public final JLabel getStartTimeLabel() {
        return this.startTimeLabel;
    }

    @NotNull
    public final JLabel getDurationLabel() {
        return this.durationLabel;
    }

    @NotNull
    public final JLabel getHelpTextLabel() {
        return this.helpTextLabel;
    }

    @NotNull
    protected JComponent createTooltip() {
        return this.labelContainer;
    }

    private final void updateView() {
        AndroidFrameEvent activeEvent = this.tooltip.getActiveFrameEvent();
        if (activeEvent instanceof AndroidFrameEvent.Data) {
            JLabel jLabel;
            JLabel $this$updateView_u24lambda_u241 = jLabel = this.frameNumberLabel;
            boolean bl = false;
            $this$updateView_u24lambda_u241.setVisible(true);
            $this$updateView_u24lambda_u241.setText("Frame number: " + ((AndroidFrameEvent.Data)activeEvent).getFrameNumber());
            JLabel $this$updateView_u24lambda_u242 = jLabel = this.startTimeLabel;
            boolean bl2 = false;
            $this$updateView_u24lambda_u242.setVisible(true);
            $this$updateView_u24lambda_u242.setText("Start time: " + TimeFormatter.getSemiSimplifiedClockString((long)(((AndroidFrameEvent.Data)activeEvent).getTimestampUs() - (long)this.getTimeline().getDataRange().getMin())));
            JLabel $this$updateView_u24lambda_u243 = jLabel = this.durationLabel;
            boolean bl3 = false;
            $this$updateView_u24lambda_u243.setVisible(true);
            $this$updateView_u24lambda_u243.setText("Duration: " + TimeFormatter.getSingleUnitDurationString((long)((AndroidFrameEvent.Data)activeEvent).getDurationUs()));
            this.helpTextLabel.setVisible(true);
        } else {
            this.frameNumberLabel.setVisible(false);
            this.startTimeLabel.setVisible(false);
            this.durationLabel.setVisible(false);
            this.helpTextLabel.setVisible(false);
        }
    }
}

