/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.database.EventsTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EventProfiler;
import com.android.tools.profiler.proto.EventServiceGrpc;
import org.jetbrains.annotations.NotNull;

public class EventDataPoller
extends PollRunner {
    private long myDataRequestStartTimestampNs = Long.MIN_VALUE;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final EventsTable myEventsTable;
    @NotNull
    private final EventServiceGrpc.EventServiceBlockingStub myEventPollingService;

    public EventDataPoller(@NotNull Common.Session session, @NotNull EventsTable eventTable, @NotNull EventServiceGrpc.EventServiceBlockingStub pollingService) {
        super(POLLING_DELAY_NS);
        this.myEventsTable = eventTable;
        this.myEventPollingService = pollingService;
        this.mySession = session;
    }

    @Override
    public void poll() throws StatusRuntimeException {
        EventProfiler.EventDataRequest.Builder dataRequestBuilder = EventProfiler.EventDataRequest.newBuilder().setSession(this.mySession).setStartTimestamp(this.myDataRequestStartTimestampNs).setEndTimestamp(Long.MAX_VALUE);
        EventProfiler.ActivityDataResponse activityResponse = this.myEventPollingService.getActivityData(dataRequestBuilder.build());
        for (EventProfiler.ActivityData data : activityResponse.getDataList()) {
            long id = data.getHash();
            EventProfiler.ActivityData cached_data = this.myEventsTable.findActivityDataOrNull(this.mySession, id);
            if (cached_data != null) {
                EventProfiler.ActivityData.Builder builder = cached_data.toBuilder();
                for (EventProfiler.ActivityStateData state : data.getStateChangesList()) {
                    if (!cached_data.getStateChangesList().contains(state)) {
                        builder.addStateChanges(state);
                    }
                    if (state.getTimestamp() <= this.myDataRequestStartTimestampNs) continue;
                    this.myDataRequestStartTimestampNs = state.getTimestamp();
                }
                this.myEventsTable.insertOrReplace(id, this.mySession, builder.build());
                continue;
            }
            this.myEventsTable.insertOrReplace(id, this.mySession, data);
            for (EventProfiler.ActivityStateData state : data.getStateChangesList()) {
                if (state.getTimestamp() <= this.myDataRequestStartTimestampNs) continue;
                this.myDataRequestStartTimestampNs = state.getTimestamp();
            }
        }
        EventProfiler.SystemDataResponse systemResponse = this.myEventPollingService.getSystemData(dataRequestBuilder.build());
        for (EventProfiler.SystemData data : systemResponse.getDataList()) {
            long id = data.getEventId();
            this.myEventsTable.insertOrReplace(id, this.mySession, data);
        }
    }
}

