/*
 * Decompiled with CFR 0.152.
 */
package aida.io.opencensus.trace;

import aida.io.opencensus.common.Scope;
import aida.io.opencensus.internal.Utils;
import aida.io.opencensus.trace.BlankSpan;
import aida.io.opencensus.trace.CurrentSpanUtils;
import aida.io.opencensus.trace.Sampler;
import aida.io.opencensus.trace.Span;
import aida.io.opencensus.trace.SpanContext;
import com.google.errorprone.annotations.MustBeClosed;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public abstract class SpanBuilder {
    public abstract SpanBuilder setSampler(Sampler var1);

    public abstract SpanBuilder setParentLinks(List<Span> var1);

    public abstract SpanBuilder setRecordEvents(boolean var1);

    public SpanBuilder setSpanKind(@Nullable Span.Kind spanKind) {
        return this;
    }

    public abstract Span startSpan();

    @MustBeClosed
    public final Scope startScopedSpan() {
        return CurrentSpanUtils.withSpan(this.startSpan(), true);
    }

    public final void startSpanAndRun(Runnable runnable) {
        Span span = this.startSpan();
        CurrentSpanUtils.withSpan(span, true, runnable).run();
    }

    public final <V> V startSpanAndCall(Callable<V> callable) throws Exception {
        Span span = this.startSpan();
        return CurrentSpanUtils.withSpan(span, true, callable).call();
    }

    static final class NoopSpanBuilder
    extends SpanBuilder {
        static NoopSpanBuilder createWithParent(String spanName, @Nullable Span parent) {
            return new NoopSpanBuilder(spanName);
        }

        static NoopSpanBuilder createWithRemoteParent(String spanName, @Nullable SpanContext remoteParentSpanContext) {
            return new NoopSpanBuilder(spanName);
        }

        @Override
        public Span startSpan() {
            return BlankSpan.INSTANCE;
        }

        @Override
        public SpanBuilder setSampler(@Nullable Sampler sampler) {
            return this;
        }

        @Override
        public SpanBuilder setParentLinks(List<Span> parentLinks) {
            return this;
        }

        @Override
        public SpanBuilder setRecordEvents(boolean recordEvents) {
            return this;
        }

        @Override
        public SpanBuilder setSpanKind(@Nullable Span.Kind spanKind) {
            return this;
        }

        private NoopSpanBuilder(String name) {
            Utils.checkNotNull(name, "name");
        }
    }
}

