/*
 * Decompiled with CFR 0.152.
 */
package aida.io.grpc.netty;

import aida.io.grpc.Internal;
import aida.io.grpc.internal.ClientTransportFactory;
import aida.io.grpc.internal.SharedResourcePool;
import aida.io.grpc.internal.TransportTracer;
import aida.io.grpc.netty.InternalProtocolNegotiator;
import aida.io.grpc.netty.NettyChannelBuilder;
import aida.io.grpc.netty.ProtocolNegotiator;
import aida.io.grpc.netty.Utils;
import aida.io.netty.channel.socket.nio.NioSocketChannel;
import com.google.common.annotations.VisibleForTesting;
import java.net.InetSocketAddress;

@Internal
public final class InternalNettyChannelBuilder {
    public static void disableCheckAuthority(NettyChannelBuilder builder) {
        builder.disableCheckAuthority();
    }

    public static void enableCheckAuthority(NettyChannelBuilder builder) {
        builder.enableCheckAuthority();
    }

    public static void setProtocolNegotiatorFactory(NettyChannelBuilder builder, final ProtocolNegotiatorFactory protocolNegotiator) {
        builder.protocolNegotiatorFactory(new ProtocolNegotiator.ClientFactory(){

            @Override
            public ProtocolNegotiator newNegotiator() {
                return protocolNegotiator.buildProtocolNegotiator();
            }

            @Override
            public int getDefaultPort() {
                return 443;
            }
        });
    }

    public static void setProtocolNegotiatorFactory(NettyChannelBuilder builder, InternalProtocolNegotiator.ClientFactory protocolNegotiator) {
        builder.protocolNegotiatorFactory(protocolNegotiator);
    }

    public static void setStatsEnabled(NettyChannelBuilder builder, boolean value) {
        builder.setStatsEnabled(value);
    }

    public static void setTracingEnabled(NettyChannelBuilder builder, boolean value) {
        builder.setTracingEnabled(value);
    }

    public static void setStatsRecordStartedRpcs(NettyChannelBuilder builder, boolean value) {
        builder.setStatsRecordStartedRpcs(value);
    }

    public static void setStatsRecordFinishedRpcs(NettyChannelBuilder builder, boolean value) {
        builder.setStatsRecordFinishedRpcs(value);
    }

    public static void setStatsRecordRealTimeMetrics(NettyChannelBuilder builder, boolean value) {
        builder.setStatsRecordRealTimeMetrics(value);
    }

    public static void setStatsRecordRetryMetrics(NettyChannelBuilder builder, boolean value) {
        builder.setStatsRecordRetryMetrics(value);
    }

    public static void useNioTransport(NettyChannelBuilder builder) {
        builder.channelType(NioSocketChannel.class, InetSocketAddress.class);
        builder.eventLoopGroupPool(SharedResourcePool.forResource(Utils.NIO_WORKER_EVENT_LOOP_GROUP));
    }

    public static ClientTransportFactory buildTransportFactory(NettyChannelBuilder builder) {
        return builder.buildTransportFactory();
    }

    @VisibleForTesting
    public static void setTransportTracerFactory(NettyChannelBuilder builder, TransportTracer.Factory factory) {
        builder.setTransportTracerFactory(factory);
    }

    private InternalNettyChannelBuilder() {
    }

    public static interface ProtocolNegotiatorFactory {
        public InternalProtocolNegotiator.ProtocolNegotiator buildProtocolNegotiator();
    }
}

