/*
 * Decompiled with CFR 0.152.
 */
package aida.io.grpc.internal;

import aida.io.grpc.Attributes;
import aida.io.grpc.CallCredentials;
import aida.io.grpc.CallOptions;
import aida.io.grpc.ChannelCredentials;
import aida.io.grpc.ChannelLogger;
import aida.io.grpc.ClientStreamTracer;
import aida.io.grpc.CompositeCallCredentials;
import aida.io.grpc.InternalMayRequireSpecificExecutor;
import aida.io.grpc.Metadata;
import aida.io.grpc.MethodDescriptor;
import aida.io.grpc.SecurityLevel;
import aida.io.grpc.Status;
import aida.io.grpc.internal.ClientStream;
import aida.io.grpc.internal.ClientTransportFactory;
import aida.io.grpc.internal.ConnectionClientTransport;
import aida.io.grpc.internal.FailingClientStream;
import aida.io.grpc.internal.ForwardingConnectionClientTransport;
import aida.io.grpc.internal.GrpcAttributes;
import aida.io.grpc.internal.MetadataApplierImpl;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

final class CallCredentialsApplyingTransportFactory
implements ClientTransportFactory {
    private final ClientTransportFactory delegate;
    private final CallCredentials channelCallCredentials;
    private final Executor appExecutor;

    CallCredentialsApplyingTransportFactory(ClientTransportFactory delegate, CallCredentials channelCallCredentials, Executor appExecutor) {
        this.delegate = (ClientTransportFactory)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.channelCallCredentials = channelCallCredentials;
        this.appExecutor = (Executor)Preconditions.checkNotNull((Object)appExecutor, (Object)"appExecutor");
    }

    @Override
    public ConnectionClientTransport newClientTransport(SocketAddress serverAddress, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
        return new CallCredentialsApplyingTransport(this.delegate.newClientTransport(serverAddress, options, channelLogger), options.getAuthority());
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.delegate.getScheduledExecutorService();
    }

    @Override
    public ClientTransportFactory.SwapChannelCredentialsResult swapChannelCredentials(ChannelCredentials channelCreds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Collection<Class<? extends SocketAddress>> getSupportedSocketAddressTypes() {
        return this.delegate.getSupportedSocketAddressTypes();
    }

    private class CallCredentialsApplyingTransport
    extends ForwardingConnectionClientTransport {
        private final ConnectionClientTransport delegate;
        private final String authority;
        private final AtomicInteger pendingApplier = new AtomicInteger(-2147483647);
        private volatile Status shutdownStatus;
        @GuardedBy(value="this")
        private Status savedShutdownStatus;
        @GuardedBy(value="this")
        private Status savedShutdownNowStatus;
        private final MetadataApplierImpl.MetadataApplierListener applierListener = new MetadataApplierImpl.MetadataApplierListener(){

            @Override
            public void onComplete() {
                if (CallCredentialsApplyingTransport.this.pendingApplier.decrementAndGet() == 0) {
                    CallCredentialsApplyingTransport.this.maybeShutdown();
                }
            }
        };

        CallCredentialsApplyingTransport(ConnectionClientTransport delegate, String authority) {
            this.delegate = (ConnectionClientTransport)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
            this.authority = (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
        }

        @Override
        protected ConnectionClientTransport delegate() {
            return this.delegate;
        }

        @Override
        public ClientStream newStream(final MethodDescriptor<?, ?> method, Metadata headers, final CallOptions callOptions, ClientStreamTracer[] tracers) {
            CallCredentials creds = callOptions.getCredentials();
            if (creds == null) {
                creds = CallCredentialsApplyingTransportFactory.this.channelCallCredentials;
            } else if (CallCredentialsApplyingTransportFactory.this.channelCallCredentials != null) {
                creds = new CompositeCallCredentials(CallCredentialsApplyingTransportFactory.this.channelCallCredentials, creds);
            }
            if (creds != null) {
                MetadataApplierImpl applier = new MetadataApplierImpl(this.delegate, method, headers, callOptions, this.applierListener, tracers);
                if (this.pendingApplier.incrementAndGet() > 0) {
                    this.applierListener.onComplete();
                    return new FailingClientStream(this.shutdownStatus, tracers);
                }
                CallCredentials.RequestInfo requestInfo = new CallCredentials.RequestInfo(){

                    @Override
                    public MethodDescriptor<?, ?> getMethodDescriptor() {
                        return method;
                    }

                    @Override
                    public CallOptions getCallOptions() {
                        return callOptions;
                    }

                    @Override
                    public SecurityLevel getSecurityLevel() {
                        return (SecurityLevel)((Object)MoreObjects.firstNonNull((Object)((Object)CallCredentialsApplyingTransport.this.delegate.getAttributes().get(GrpcAttributes.ATTR_SECURITY_LEVEL)), (Object)((Object)SecurityLevel.NONE)));
                    }

                    @Override
                    public String getAuthority() {
                        return (String)MoreObjects.firstNonNull((Object)callOptions.getAuthority(), (Object)CallCredentialsApplyingTransport.this.authority);
                    }

                    @Override
                    public Attributes getTransportAttrs() {
                        return CallCredentialsApplyingTransport.this.delegate.getAttributes();
                    }
                };
                try {
                    Executor executor = creds instanceof InternalMayRequireSpecificExecutor && ((InternalMayRequireSpecificExecutor)((Object)creds)).isSpecificExecutorRequired() && callOptions.getExecutor() != null ? callOptions.getExecutor() : CallCredentialsApplyingTransportFactory.this.appExecutor;
                    creds.applyRequestMetadata(requestInfo, executor, applier);
                }
                catch (Throwable t) {
                    applier.fail(Status.UNAUTHENTICATED.withDescription("Credentials should use fail() instead of throwing exceptions").withCause(t));
                }
                return applier.returnStream();
            }
            if (this.pendingApplier.get() >= 0) {
                return new FailingClientStream(this.shutdownStatus, tracers);
            }
            return this.delegate.newStream(method, headers, callOptions, tracers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown(Status status) {
            Preconditions.checkNotNull((Object)status, (Object)"status");
            CallCredentialsApplyingTransport callCredentialsApplyingTransport = this;
            synchronized (callCredentialsApplyingTransport) {
                if (this.pendingApplier.get() >= 0) {
                    return;
                }
                this.shutdownStatus = status;
                this.pendingApplier.addAndGet(Integer.MAX_VALUE);
                if (this.pendingApplier.get() != 0) {
                    this.savedShutdownStatus = status;
                    return;
                }
            }
            super.shutdown(status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdownNow(Status status) {
            Preconditions.checkNotNull((Object)status, (Object)"status");
            CallCredentialsApplyingTransport callCredentialsApplyingTransport = this;
            synchronized (callCredentialsApplyingTransport) {
                if (this.pendingApplier.get() < 0) {
                    this.shutdownStatus = status;
                    this.pendingApplier.addAndGet(Integer.MAX_VALUE);
                } else if (this.savedShutdownNowStatus != null) {
                    return;
                }
                if (this.pendingApplier.get() != 0) {
                    this.savedShutdownNowStatus = status;
                    return;
                }
            }
            super.shutdownNow(status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeShutdown() {
            Status maybeShutdownNow;
            Status maybeShutdown;
            CallCredentialsApplyingTransport callCredentialsApplyingTransport = this;
            synchronized (callCredentialsApplyingTransport) {
                if (this.pendingApplier.get() != 0) {
                    return;
                }
                maybeShutdown = this.savedShutdownStatus;
                maybeShutdownNow = this.savedShutdownNowStatus;
                this.savedShutdownStatus = null;
                this.savedShutdownNowStatus = null;
            }
            if (maybeShutdown != null) {
                super.shutdown(maybeShutdown);
            }
            if (maybeShutdownNow != null) {
                super.shutdownNow(maybeShutdownNow);
            }
        }
    }
}

