/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.manifest.parser;

import com.android.tools.manifest.parser.XmlNode;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceFile;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlEndElementChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlStartElementChunk;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Stack;

public class BinaryXmlParser {
    public static XmlNode parse(InputStream inputStream2) throws IOException {
        BinaryResourceFile file = BinaryResourceFile.fromInputStream(inputStream2);
        List<Chunk> chunks = file.getChunks();
        Stack<XmlNode> nodes = new Stack<XmlNode>();
        if (chunks.isEmpty()) {
            throw new IllegalArgumentException("Invalid Binary XML, no chunks found");
        }
        if (!(chunks.get(0) instanceof XmlChunk)) {
            throw new IllegalArgumentException("Invalid Binary XML, chunk[0] != XmlChunk");
        }
        XmlChunk xmlChunk = (XmlChunk)chunks.get(0);
        XmlNode node = new XmlNode();
        nodes.push(node);
        for (Chunk chunk : xmlChunk.getChunks().values()) {
            if (chunk instanceof XmlStartElementChunk) {
                XmlStartElementChunk c = (XmlStartElementChunk)chunk;
                XmlNode child = new XmlNode(c, c.getName());
                node.children().add(child);
                nodes.push(node);
                node = child;
                continue;
            }
            if (!(chunk instanceof XmlEndElementChunk)) continue;
            node = (XmlNode)nodes.pop();
        }
        if (node.children().isEmpty()) {
            throw new IllegalStateException("Cannot parse binary XML without root node");
        }
        return node.children().get(0);
    }
}

