/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.model.DefaultLintModelSourceProvider;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelSourceProvider;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\"\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0011H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0011H\u0004J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u0011H\u0004J\b\u0010\u001e\u001a\u00020\u0011H\u0004J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0011H\u0004J\b\u0010\"\u001a\u00020 H\u0004J\b\u0010#\u001a\u00020 H\u0004J\u0010\u0010$\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0011H\u0004J\u0012\u0010%\u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00020\u0011H\u0004J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0011H\u0004J\b\u0010'\u001a\u00020\u0011H\u0004J\u001e\u0010(\u001a\u0004\u0018\u00010\u00052\u0006\u0010)\u001a\u00020\u00112\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u0005H\u0004J\u0012\u0010+\u001a\u0004\u0018\u00010\u00052\u0006\u0010)\u001a\u00020\u0011H\u0004J\u001c\u0010,\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00112\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u0005H\u0004J\u0018\u0010-\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u0019H\u0004J \u0010/\u001a\b\u0012\u0004\u0012\u00020\u0011002\u0006\u0010!\u001a\u00020\u00112\b\b\u0002\u00101\u001a\u00020\u0011H\u0004J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u0005002\u0006\u0010!\u001a\u00020\u0011H\u0004J\u0012\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u00020\u0011H\u0004J\u0016\u00106\u001a\b\u0012\u0004\u0012\u000204002\u0006\u00105\u001a\u00020\u0011H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00067"}, d2={"Lcom/android/tools/lint/model/LintModelReader;", "", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "root", "Ljava/io/File;", "reader", "Ljava/io/Reader;", "<init>", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;Ljava/io/File;Ljava/io/Reader;)V", "getAdapter", "()Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "getRoot", "()Ljava/io/File;", "setRoot", "(Ljava/io/File;)V", "path", "", "getPath", "()Ljava/lang/String;", "parser", "Lorg/kxml2/io/KXmlParser;", "getParser", "()Lorg/kxml2/io/KXmlParser;", "isNumber", "", "toApiVersion", "Lcom/android/sdklib/AndroidVersion;", "toMavenCoordinate", "Lcom/android/tools/lint/model/LintModelMavenName;", "getLocation", "expectTag", "", "name", "unexpectedTag", "missingData", "finishTag", "getOptionalAttribute", "getRequiredAttribute", "getName", "getOptionalFile", "attribute", "relativeTo", "getOptionalOutputFile", "getRequiredFile", "getOptionalBoolean", "default", "getStrings", "", "separator", "getFiles", "readSourceProvider", "Lcom/android/tools/lint/model/LintModelSourceProvider;", "tag", "readSourceProviders", "android.sdktools.lint-model"})
@SourceDebugExtension(value={"SMAP\nLintModelSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintModelSerialization.kt\ncom/android/tools/lint/model/LintModelReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,2005:1\n1563#2:2006\n1634#2,3:2007\n*S KotlinDebug\n*F\n+ 1 LintModelSerialization.kt\ncom/android/tools/lint/model/LintModelReader\n*L\n1166#1:2006\n1166#1:2007,3\n*E\n"})
abstract class LintModelReader {
    @NotNull
    private final LintModelSerialization.LintModelSerializationAdapter adapter;
    @Nullable
    private File root;
    @NotNull
    private final KXmlParser parser;

    public LintModelReader(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter, @Nullable File root2, @NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.adapter = adapter;
        this.root = root2;
        this.parser = new KXmlParser();
        this.parser.setInput(reader);
    }

    @NotNull
    protected final LintModelSerialization.LintModelSerializationAdapter getAdapter() {
        return this.adapter;
    }

    @Nullable
    protected final File getRoot() {
        return this.root;
    }

    protected final void setRoot(@Nullable File file) {
        this.root = file;
    }

    @NotNull
    protected abstract String getPath();

    @NotNull
    protected final KXmlParser getParser() {
        return this.parser;
    }

    private final boolean isNumber(String $this$isNumber) {
        return Character.isDigit(StringsKt.first((CharSequence)$this$isNumber));
    }

    @NotNull
    protected final AndroidVersion toApiVersion(@NotNull String $this$toApiVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$toApiVersion, (String)"<this>");
        if (!this.isNumber($this$toApiVersion)) {
            File file = this.adapter.getPathVariables().get("ANDROID_HOME");
            if (file != null) {
                int levelBegin;
                int levelEnd;
                String descriptor;
                int begin;
                File home = file;
                boolean bl = false;
                File descriptorFile = new File(home, "platforms" + File.separator + "android-" + $this$toApiVersion + File.separator + "package.xml");
                if (descriptorFile.isFile() && (begin = StringsKt.indexOf$default((CharSequence)(descriptor = FilesKt.readText$default((File)descriptorFile, null, (int)1, null)), (String)"<api-level>", (int)0, (boolean)false, (int)6, null)) != -1 && (levelEnd = StringsKt.indexOf$default((CharSequence)descriptor, (String)"</api-level>", (int)(levelBegin = StringsKt.indexOf$default((CharSequence)descriptor, (char)'>', (int)begin, (boolean)false, (int)4, null) + 1), (boolean)false, (int)4, null)) != -1) {
                    try {
                        String string2 = descriptor.substring(levelBegin, levelEnd);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        AndroidVersion numericVersion = AndroidVersion.fromString((String)((Object)StringsKt.trim((CharSequence)string2)).toString());
                        return new AndroidVersion(numericVersion.getApiLevel(), numericVersion.getApiMinorLevel(), $this$toApiVersion, null, true);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                }
            }
            String buildCode = SdkVersionInfo.getBuildCode((int)36);
            if (buildCode != null) {
                int delta = Character.toUpperCase(StringsKt.first((CharSequence)$this$toApiVersion)) - Character.toUpperCase(StringsKt.first((CharSequence)buildCode));
                boolean bl = 0 <= delta ? delta < 5 : false;
                if (bl) {
                    return new AndroidVersion(36 + delta - 1, $this$toApiVersion);
                }
            }
        }
        AndroidVersion androidVersion = AndroidVersion.fromString((String)$this$toApiVersion);
        Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"fromString(...)");
        return androidVersion;
    }

    @Nullable
    protected final LintModelMavenName toMavenCoordinate(@NotNull String $this$toMavenCoordinate) {
        Intrinsics.checkNotNullParameter((Object)$this$toMavenCoordinate, (String)"<this>");
        return LintModelMavenName.Companion.parse($this$toMavenCoordinate);
    }

    @NotNull
    protected final String getLocation() {
        return this.getPath() + ":" + this.parser.getLineNumber();
    }

    protected final void expectTag(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!Intrinsics.areEqual((Object)name, (Object)this.parser.getName())) {
            throw new IllegalStateException(("Unexpected tag `<" + this.parser.getName() + ">` at " + this.getLocation() + "; expected `<" + name + ">`").toString());
        }
    }

    protected final void unexpectedTag() {
        throw new IllegalStateException(("Unexpected tag `<" + this.parser.getName() + ">` at " + this.getLocation()).toString());
    }

    protected final void missingData() {
        throw new IllegalStateException(("Missing data at " + this.getLocation()).toString());
    }

    protected final void finishTag(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        block4: while (this.parser.next() != 1) {
            int eventType = this.parser.getEventType();
            switch (eventType) {
                case 2: {
                    this.unexpectedTag();
                    continue block4;
                }
                case 3: {
                    this.expectTag(name);
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
    }

    @Nullable
    protected final String getOptionalAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.parser.getAttributeValue(null, name);
    }

    @NotNull
    protected final String getRequiredAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string2 = this.parser.getAttributeValue(null, name);
        if (string2 == null) {
            throw new IllegalStateException(("Expected `" + name + "` attribute in <" + this.parser.getName() + "> tag at " + this.getLocation()).toString());
        }
        return string2;
    }

    @NotNull
    protected final String getName() {
        return this.getRequiredAttribute("name");
    }

    @Nullable
    protected final File getOptionalFile(@NotNull String attribute, @Nullable File relativeTo) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String string2 = this.getOptionalAttribute(attribute);
        if (string2 == null) {
            return null;
        }
        String path = string2;
        return this.adapter.fromPathString(path, relativeTo);
    }

    public static /* synthetic */ File getOptionalFile$default(LintModelReader lintModelReader, String string2, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getOptionalFile");
        }
        if ((n & 2) != 0) {
            file = lintModelReader.root;
        }
        return lintModelReader.getOptionalFile(string2, file);
    }

    @Nullable
    protected final File getOptionalOutputFile(@NotNull String attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String string2 = this.getOptionalAttribute(attribute);
        if (string2 == null) {
            return null;
        }
        String path = string2;
        File relativeTo = Intrinsics.areEqual((Object)path, (Object)"stderr") || Intrinsics.areEqual((Object)path, (Object)"stdout") ? null : this.root;
        return this.adapter.fromPathString(path, relativeTo);
    }

    @NotNull
    protected final File getRequiredFile(@NotNull String attribute, @Nullable File relativeTo) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String path = this.getRequiredAttribute(attribute);
        return this.adapter.fromPathString(path, relativeTo);
    }

    public static /* synthetic */ File getRequiredFile$default(LintModelReader lintModelReader, String string2, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRequiredFile");
        }
        if ((n & 2) != 0) {
            file = lintModelReader.root;
        }
        return lintModelReader.getRequiredFile(string2, file);
    }

    protected final boolean getOptionalBoolean(@NotNull String attribute, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String string2 = this.getOptionalAttribute(attribute);
        if (string2 == null) {
            return bl;
        }
        String value = string2;
        return Intrinsics.areEqual((Object)value, (Object)"true");
    }

    @NotNull
    protected final List<String> getStrings(@NotNull String name, @NotNull String separator) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Object object = this.getOptionalAttribute(name);
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{separator}), (boolean)false, (int)0, (int)6, null)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static /* synthetic */ List getStrings$default(LintModelReader lintModelReader, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getStrings");
        }
        if ((n & 2) != 0) {
            string3 = ",";
        }
        return lintModelReader.getStrings(string2, string3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    protected final List<File> getFiles(@NotNull String name) {
        void $this$mapTo$iv$iv;
        List list2;
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                object = this.getOptionalAttribute(name);
                if (object == null) break block5;
                CharSequence charSequence = (CharSequence)object;
                String[] stringArray = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
                object = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if (object != null) break block6;
            }
            list2 = CollectionsKt.emptyList();
            return list2;
        }
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (true) {
            void path;
            if (!iterator.hasNext()) {
                list2 = (List)destination$iv$iv;
                return list2;
            }
            Object item$iv$iv = iterator.next();
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = new File((String)path);
            collection.add(this.root != null && !file.isAbsolute() ? new File(this.root, (String)path) : file);
        }
    }

    @NotNull
    protected final LintModelSourceProvider readSourceProvider(@NotNull String tag) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.expectTag(tag);
        Collection collection2 = this.getFiles("manifests");
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = CollectionsKt.listOfNotNull((Object)LintModelReader.getOptionalFile$default(this, "manifest", null, 2, null));
        } else {
            collection = collection2;
        }
        List manifestFiles = (List)collection;
        List<File> javaDirectories = this.getFiles("javaDirectories");
        List<File> resDirectories = this.getFiles("resDirectories");
        List<File> assetsDirectories = this.getFiles("assetsDirectories");
        boolean androidTestOnly = this.getOptionalBoolean("androidTest", false);
        boolean unitTestOnly = this.getOptionalBoolean("unitTest", false);
        boolean debugOnly = this.getOptionalBoolean("debugOnly", false);
        boolean testFixture = this.getOptionalBoolean("testFixture", false);
        this.finishTag(tag);
        return new DefaultLintModelSourceProvider(manifestFiles, (Collection<? extends File>)javaDirectories, (Collection<? extends File>)resDirectories, (Collection<? extends File>)assetsDirectories, debugOnly, unitTestOnly, androidTestOnly, testFixture);
    }

    public static /* synthetic */ LintModelSourceProvider readSourceProvider$default(LintModelReader lintModelReader, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readSourceProvider");
        }
        if ((n & 1) != 0) {
            string2 = "sourceProvider";
        }
        return lintModelReader.readSourceProvider(string2);
    }

    @NotNull
    protected final List<LintModelSourceProvider> readSourceProviders(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.expectTag(tag);
        List sourceProviders = new ArrayList();
        block4: while (this.parser.next() != 1) {
            int eventType = this.parser.getEventType();
            switch (eventType) {
                case 2: {
                    if (Intrinsics.areEqual((Object)this.parser.getName(), (Object)"sourceProvider")) {
                        sourceProviders.add(LintModelReader.readSourceProvider$default(this, null, 1, null));
                        continue block4;
                    }
                    this.unexpectedTag();
                    continue block4;
                }
                case 3: {
                    this.expectTag(tag);
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return sourceProviders;
    }
}

