/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.tools.lint.model.DefaultLintModelAndroidLibrary;
import com.android.tools.lint.model.DefaultLintModelJavaLibrary;
import com.android.tools.lint.model.DefaultLintModelLibraryResolver;
import com.android.tools.lint.model.DefaultLintModelModuleLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelReader;
import com.android.tools.lint.model.LintModelSerialization;
import java.io.File;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u0015\u001a\u00020\u0005J\b\u0010\u0016\u001a\u00020\u0011H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/model/LintModelLibrariesReader;", "Lcom/android/tools/lint/model/LintModelReader;", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "libraryResolver", "Lcom/android/tools/lint/model/DefaultLintModelLibraryResolver;", "root", "Ljava/io/File;", "variantName", "", "artifactName", "reader", "Ljava/io/Reader;", "<init>", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;Lcom/android/tools/lint/model/DefaultLintModelLibraryResolver;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Ljava/io/Reader;)V", "libraryResolverMap", "", "Lcom/android/tools/lint/model/LintModelLibrary;", "path", "getPath", "()Ljava/lang/String;", "readLibraries", "readLibrary", "android.sdktools.lint-model"})
final class LintModelLibrariesReader
extends LintModelReader {
    @NotNull
    private final String variantName;
    @NotNull
    private final String artifactName;
    @NotNull
    private final Map<String, LintModelLibrary> libraryResolverMap;
    @NotNull
    private final DefaultLintModelLibraryResolver libraryResolver;

    public LintModelLibrariesReader(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter, @Nullable DefaultLintModelLibraryResolver libraryResolver, @Nullable File root2, @NotNull String variantName, @NotNull String artifactName, @NotNull Reader reader) {
        DefaultLintModelLibraryResolver defaultLintModelLibraryResolver;
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        super(adapter, root2, reader);
        this.variantName = variantName;
        this.artifactName = artifactName;
        DefaultLintModelLibraryResolver defaultLintModelLibraryResolver2 = libraryResolver;
        Map map2 = defaultLintModelLibraryResolver2 != null ? defaultLintModelLibraryResolver2.getLibraryMap() : null;
        Map<Object, Object> map3 = TypeIntrinsics.isMutableMap(map2) ? map2 : null;
        if (map3 == null) {
            map3 = this.libraryResolverMap = (Map)new LinkedHashMap();
        }
        if ((defaultLintModelLibraryResolver = libraryResolver) == null) {
            defaultLintModelLibraryResolver = new DefaultLintModelLibraryResolver(this.libraryResolverMap);
        }
        this.libraryResolver = defaultLintModelLibraryResolver;
    }

    public /* synthetic */ LintModelLibrariesReader(LintModelSerialization.LintModelSerializationAdapter lintModelSerializationAdapter, DefaultLintModelLibraryResolver defaultLintModelLibraryResolver, File file, String string2, String string3, Reader reader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            defaultLintModelLibraryResolver = null;
        }
        if ((n & 0x20) != 0) {
            reader = lintModelSerializationAdapter.getReader(LintModelSerialization.TargetFile.LIBRARY_TABLE, string2, string3);
        }
        this(lintModelSerializationAdapter, defaultLintModelLibraryResolver, file, string2, string3, reader);
    }

    @Override
    @NotNull
    protected String getPath() {
        Object object = this.getAdapter().file(LintModelSerialization.TargetFile.DEPENDENCIES, this.variantName, this.artifactName);
        if (object == null || (object = ((File)object).getPath()) == null) {
            object = "<unknown>";
        }
        return object;
    }

    @NotNull
    public final DefaultLintModelLibraryResolver readLibraries() {
        this.getParser().nextTag();
        this.expectTag("libraries");
        block4: while (this.getParser().next() != 1) {
            int eventType = this.getParser().getEventType();
            switch (eventType) {
                case 2: {
                    if (Intrinsics.areEqual((Object)this.getParser().getName(), (Object)"library")) {
                        LintModelLibrary library2 = this.readLibrary();
                        this.libraryResolverMap.put(library2.getIdentifier(), library2);
                        continue block4;
                    }
                    this.unexpectedTag();
                    continue block4;
                }
                case 3: {
                    this.expectTag("libraries");
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return this.libraryResolver;
    }

    private final LintModelLibrary readLibrary() {
        LintModelLibrary lintModelLibrary;
        this.expectTag("library");
        boolean android = false;
        String identifier = this.getName();
        List<File> jars = this.getFiles("jars");
        String project = this.getOptionalAttribute("project");
        String string2 = this.getOptionalAttribute("resolved");
        LintModelMavenName resolved = string2 != null ? this.toMavenCoordinate(string2) : null;
        boolean provided = this.getOptionalBoolean("provided", false);
        File partialResultsDir = LintModelReader.getOptionalFile$default(this, "partialResultsDir", null, 2, null);
        File manifestFile = null;
        File resFolder = null;
        File assetsFolder = null;
        File lintJar = null;
        File publicResources = null;
        File symbolFile = null;
        File externalAnnotations = null;
        File proguardRules = null;
        File folder = LintModelReader.getOptionalFile$default(this, "folder", null, 2, null);
        if (folder != null) {
            android = true;
            resFolder = this.getRequiredFile("resFolder", folder);
            assetsFolder = this.getRequiredFile("assetsFolder", folder);
            lintJar = this.getRequiredFile("lintJar", folder);
            publicResources = this.getRequiredFile("publicResources", folder);
            symbolFile = this.getRequiredFile("symbolFile", folder);
            manifestFile = this.getRequiredFile("manifest", folder);
            externalAnnotations = this.getRequiredFile("externalAnnotations", folder);
            proguardRules = this.getRequiredFile("proguardRules", folder);
        }
        this.finishTag("library");
        if (project != null) {
            lintModelLibrary = new DefaultLintModelModuleLibrary(identifier, project, lintJar, provided);
        } else if (android) {
            File file = manifestFile;
            Intrinsics.checkNotNull(file);
            File file2 = folder;
            Intrinsics.checkNotNull((Object)file2);
            File file3 = resFolder;
            Intrinsics.checkNotNull((Object)file3);
            File file4 = assetsFolder;
            Intrinsics.checkNotNull((Object)file4);
            File file5 = publicResources;
            Intrinsics.checkNotNull((Object)file5);
            File file6 = symbolFile;
            Intrinsics.checkNotNull((Object)file6);
            File file7 = externalAnnotations;
            Intrinsics.checkNotNull(file7);
            File file8 = proguardRules;
            Intrinsics.checkNotNull(file8);
            LintModelMavenName lintModelMavenName = resolved;
            Intrinsics.checkNotNull((Object)lintModelMavenName);
            lintModelLibrary = new DefaultLintModelAndroidLibrary(identifier, jars, file, file2, file3, file4, lintJar, file5, file6, file7, file8, provided, lintModelMavenName, partialResultsDir);
        } else {
            LintModelMavenName lintModelMavenName = resolved;
            Intrinsics.checkNotNull((Object)lintModelMavenName);
            LintModelMavenName lintModelMavenName2 = lintModelMavenName;
            lintModelLibrary = new DefaultLintModelJavaLibrary(identifier, jars, lintModelMavenName2, provided, partialResultsDir);
        }
        return lintModelLibrary;
    }
}

