/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api.interprocedural;

import com.android.tools.lint.detector.api.interprocedural.CallGraph;
import com.android.tools.lint.detector.api.interprocedural.CallGraphKt;
import com.android.tools.lint.detector.api.interprocedural.CallTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\t\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/detector/api/interprocedural/MutableCallGraph;", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraph;", "<init>", "()V", "nodeMap", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/uast/UElement;", "Lcom/android/tools/lint/detector/api/interprocedural/MutableCallGraph$MutableNode;", "Lkotlin/collections/LinkedHashMap;", "nodes", "", "Lkotlin/jvm/internal/EnhancedNullability;", "getNodes", "()Ljava/util/Collection;", "getNode", "element", "toString", "", "MutableNode", "android.sdktools.lint-api"})
@SourceDebugExtension(value={"SMAP\nCallGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallGraph.kt\ncom/android/tools/lint/detector/api/interprocedural/MutableCallGraph\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,468:1\n382#2,7:469\n*S KotlinDebug\n*F\n+ 1 CallGraph.kt\ncom/android/tools/lint/detector/api/interprocedural/MutableCallGraph\n*L\n152#1:469,7\n*E\n"})
public final class MutableCallGraph
implements CallGraph {
    @NotNull
    private final LinkedHashMap<UElement, MutableNode> nodeMap = new LinkedHashMap();

    @NotNull
    public Collection<MutableNode> getNodes() {
        Collection<MutableNode> collection = this.nodeMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNode getNode(@NotNull UElement element) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Map map2 = this.nodeMap;
        UElement key$iv = element;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            CallTarget callTarget;
            boolean bl = false;
            UElement uElement = element;
            if (uElement instanceof UMethod) {
                callTarget = new CallTarget.Method((UMethod)element);
            } else if (uElement instanceof ULambdaExpression) {
                callTarget = new CallTarget.Lambda((ULambdaExpression)element);
            } else if (uElement instanceof UClass) {
                callTarget = new CallTarget.DefaultCtor((UClass)element);
            } else {
                throw new Error("Unexpected UElement type " + element.getClass());
            }
            CallTarget caller = callTarget;
            MutableNode answer$iv = new MutableNode(caller, null, 2, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (MutableNode)object;
    }

    @NotNull
    public String toString() {
        int numEdges = SequencesKt.sumOfInt((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.getNodes()), MutableCallGraph::toString$lambda$1));
        return "Call graph: " + this.nodeMap.size() + " nodes, " + numEdges + " edges";
    }

    @Override
    @NotNull
    public String dump(@NotNull Function1<? super CallGraph.Edge, Boolean> filter2) {
        return CallGraph.super.dump(filter2);
    }

    @Override
    public void outputToDotFile(@NotNull String file, @NotNull Function1<? super CallGraph.Edge, Boolean> filter2) {
        CallGraph.super.outputToDotFile(file, filter2);
    }

    private static final int toString$lambda$1(MutableNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getEdges().size();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/detector/api/interprocedural/MutableCallGraph$MutableNode;", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Node;", "target", "Lcom/android/tools/lint/detector/api/interprocedural/CallTarget;", "edges", "", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Edge;", "<init>", "(Lcom/android/tools/lint/detector/api/interprocedural/CallTarget;Ljava/util/Collection;)V", "getTarget", "()Lcom/android/tools/lint/detector/api/interprocedural/CallTarget;", "getEdges", "()Ljava/util/Collection;", "toString", "", "android.sdktools.lint-api"})
    public static final class MutableNode
    implements CallGraph.Node {
        @NotNull
        private final CallTarget target;
        @NotNull
        private final Collection<CallGraph.Edge> edges;

        public MutableNode(@NotNull CallTarget target2, @NotNull Collection<CallGraph.Edge> edges) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            Intrinsics.checkNotNullParameter(edges, (String)"edges");
            this.target = target2;
            this.edges = edges;
        }

        public /* synthetic */ MutableNode(CallTarget callTarget, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                collection = new ArrayList();
            }
            this(callTarget, collection);
        }

        @Override
        @NotNull
        public CallTarget getTarget() {
            return this.target;
        }

        @Override
        @NotNull
        public Collection<CallGraph.Edge> getEdges() {
            return this.edges;
        }

        @NotNull
        public String toString() {
            return CallGraphKt.getShortName(this);
        }

        @Override
        @NotNull
        public Collection<CallGraph.Edge> getLikelyEdges() {
            return CallGraph.Node.super.getLikelyEdges();
        }
    }
}

