/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.detector.api.BooleanOption;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.FileOption;
import com.android.tools.lint.detector.api.FloatOption;
import com.android.tools.lint.detector.api.IntOption;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.StringOption;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 !2\u00020\u0001:\u0001!B%\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\fH&J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u000eH&J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0003H&J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0015\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u001f\u001a\u00020 H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u0082\u0001\u0005\"#$%&\u00a8\u0006'"}, d2={"Lcom/android/tools/lint/detector/api/Option;", "", "name", "", "description", "explanation", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getValue", "configuration", "Lcom/android/tools/lint/client/api/Configuration;", "context", "Lcom/android/tools/lint/detector/api/Context;", "defaultAsString", "rangeAsString", "getDescription", "format", "Lcom/android/tools/lint/detector/api/TextFormat;", "getExplanation", "describe", "includeExample", "", "toString", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "getIssue", "()Lcom/android/tools/lint/detector/api/Issue;", "setIssue", "(Lcom/android/tools/lint/detector/api/Issue;)V", "ensureRegistered", "", "Companion", "Lcom/android/tools/lint/detector/api/BooleanOption;", "Lcom/android/tools/lint/detector/api/FileOption;", "Lcom/android/tools/lint/detector/api/FloatOption;", "Lcom/android/tools/lint/detector/api/IntOption;", "Lcom/android/tools/lint/detector/api/StringOption;", "android.sdktools.lint-api"})
public abstract sealed class Option
permits BooleanOption, FileOption, FloatOption, IntOption, StringOption {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @Nullable
    private final String explanation;
    public Issue issue;

    private Option(String name, String description, String explanation) {
        this.name = name;
        this.description = description;
        this.explanation = explanation;
    }

    public /* synthetic */ Option(String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string4 = null;
        }
        this(string2, string3, string4, null);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public abstract Object getValue(@NotNull Configuration var1);

    @Nullable
    public abstract Object getValue(@NotNull Context var1);

    @Nullable
    public abstract String defaultAsString();

    @Nullable
    public String rangeAsString() {
        return null;
    }

    @NotNull
    public final String getDescription(@NotNull TextFormat format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        String trimmed = StringsKt.trimIndent((String)this.description);
        return TextFormat.RAW.convertTo(trimmed, format);
    }

    public static /* synthetic */ String getDescription$default(Option option, TextFormat textFormat, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDescription");
        }
        if ((n & 1) != 0) {
            textFormat = TextFormat.RAW;
        }
        return option.getDescription(textFormat);
    }

    @Nullable
    public final String getExplanation(@NotNull TextFormat format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        if (this.explanation == null) {
            return null;
        }
        String trimmed = StringsKt.trimIndent((String)this.explanation);
        String message = StringsKt.replace$default((String)trimmed, (String)"\\\n", (String)"", (boolean)false, (int)4, null);
        return TextFormat.RAW.convertTo(message, format);
    }

    public static /* synthetic */ String getExplanation$default(Option option, TextFormat textFormat, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getExplanation");
        }
        if ((n & 1) != 0) {
            textFormat = TextFormat.RAW;
        }
        return option.getExplanation(textFormat);
    }

    @NotNull
    public final String describe(@NotNull TextFormat format, boolean includeExample) {
        String explanation;
        String string2;
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        StringBuilder sb = new StringBuilder();
        sb.append("**").append(this.name).append("**");
        String defaultValue = this.defaultAsString();
        if (defaultValue != null) {
            String esc = this instanceof FileOption ? "`" : "";
            sb.append(" (default is ").append(esc).append(defaultValue).append(esc).append(")");
        }
        sb.append(":");
        String desc = Option.getDescription$default(this, null, 1, null);
        int maxLineWidth = 72;
        StringBuilder stringBuilder = desc.length() + sb.length() > maxLineWidth ? sb.append("\n") : sb.append(" ");
        sb.append(desc).append(".\n");
        String range = this.rangeAsString();
        if (range != null) {
            sb.append(range).append(".\n");
        }
        if ((string2 = Option.getExplanation$default(this, null, 1, null)) == null) {
            string2 = "";
        }
        if (!StringsKt.isBlank((CharSequence)(explanation = string2))) {
            sb.append("\n");
            if (format == TextFormat.TEXT) {
                v2 = sb.append(SdkUtils.wrap((String)explanation, (int)maxLineWidth, (String)""));
            } else {
                sb.append(explanation);
                v2 = sb.append("\n");
            }
        }
        if (includeExample) {
            sb.append("\n");
            sb.append("To configure this option, use a `lint.xml` file with an <option> like this:\n\n");
            String string3 = this.getIssue().getId();
            String string4 = defaultValue;
            if (string4 == null) {
                string4 = "some string";
            }
            sb.append(StringsKt.trimIndent((String)("\n                ```xml\n                <lint>\n                    <issue id=\"" + string3 + "\">\n                        <option name=\"" + this.name + "\" value=\"" + string4 + "\" />\n                    </issue>\n                </lint>\n                ```\n                ")));
        }
        String string5 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        return TextFormat.RAW.convertTo(string5, format);
    }

    public static /* synthetic */ String describe$default(Option option, TextFormat textFormat, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: describe");
        }
        if ((n & 1) != 0) {
            textFormat = TextFormat.RAW;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return option.describe(textFormat, bl);
    }

    @NotNull
    public String toString() {
        return Option.describe$default(this, TextFormat.TEXT, false, 2, null);
    }

    @NotNull
    public final Issue getIssue() {
        Issue issue = this.issue;
        if (issue != null) {
            return issue;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"issue");
        return null;
    }

    public final void setIssue(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"<set-?>");
        this.issue = issue;
    }

    protected final void ensureRegistered() {
        if (this.issue == null) {
            throw new IllegalStateException(("Option " + this.name + " has not been registered with an associated `Issue`; see `Issue.options()`").toString());
        }
    }

    public /* synthetic */ Option(String name, String description, String explanation, DefaultConstructorMarker $constructor_marker) {
        this(name, description, explanation);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/detector/api/Option$Companion;", "", "<init>", "()V", "describe", "", "options", "", "Lcom/android/tools/lint/detector/api/Option;", "format", "Lcom/android/tools/lint/detector/api/TextFormat;", "includeExample", "", "android.sdktools.lint-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String describe(@NotNull List<? extends Option> options, @NotNull TextFormat format, boolean includeExample) {
            Intrinsics.checkNotNullParameter(options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            if (!((Collection)options).isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Available options:\n");
                for (Option option : options) {
                    sb.append('\n').append(option.describe(TextFormat.RAW, includeExample)).append('\n');
                }
                String string2 = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                return TextFormat.RAW.convertTo(string2, format);
            }
            return "";
        }

        public static /* synthetic */ String describe$default(Companion companion, List list2, TextFormat textFormat, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                textFormat = TextFormat.RAW;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.describe(list2, textFormat, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

