/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.XmlUtils;
import com.intellij.openapi.util.TextRange;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 O2\u00020\u0001:\u0004NOPQB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J$\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J4\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010\u001b\u001a\u00020\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001d2\u0006\u0010\u0015\u001a\u00020\u0016J*\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001d2\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010 \u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J$\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001d2\u0006\u0010\u0015\u001a\u00020\u0016J8\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001d2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\t0&H\u0014J&\u0010!\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001dH&J>\u0010!\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d2 \b\u0002\u0010(\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u001d\u0012\u0004\u0012\u00020\t0&J,\u0010)\u001a\u00020\t2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020+0\u00112\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020+H\u0016J$\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001dH\u0002J\u0016\u0010/\u001a\u00020\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020$0\u001dH\u0002J>\u00100\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u00101\u001a\u00020\u0005H\u0002J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001dH\u0002J2\u00103\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u000107H\u0002J\u0018\u00108\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u000209H\u0002J*\u0010:\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020<2\b\u00106\u001a\u0004\u0018\u000107H\u0002J0\u0010=\u001a\u00020+2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\r2\u0006\u0010B\u001a\u00020\rH\u0002J2\u0010C\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010D\u001a\u00020E2\b\u00106\u001a\u0004\u0018\u000107H\u0014J.\u0010F\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020+0G2\b\u0010H\u001a\u0004\u0018\u00010\r2\u0006\u0010I\u001a\u00020\r2\u0006\u0010J\u001a\u00020\u0005H\u0002J(\u0010K\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020E2\u0006\u0010L\u001a\u00020\rH\u0014J$\u0010M\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/android/tools/lint/client/api/LintFixPerformer;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "requireAutoFixable", "", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;Z)V", "log", "", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "message", "", "getFileData", "Lcom/android/tools/lint/client/api/LintFixPerformer$PendingEditFile;", "fileMap", "", "Ljava/io/File;", "file", "registerFix", "fileProvider", "Lcom/android/tools/lint/client/api/LintFixPerformer$FileProvider;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "lintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "fix", "incidents", "", "registerFixes", "fixes", "cleanup", "applyEdits", "fileData", "edits", "Lcom/android/tools/lint/client/api/LintFixPerformer$PendingEdit;", "applier", "Lkotlin/Function2;", "files", "performEdits", "printStatistics", "editMap", "", "appliedEditCount", "editedFileCount", "findApplicableFixes", "findConflicts", "addEdits", "isTopLevel", "sortAttributes", "addAnnotation", "annotateFix", "Lcom/android/tools/lint/detector/api/LintFix$AnnotateFix;", "fixLocation", "Lcom/android/tools/lint/detector/api/Location;", "addCreateFile", "Lcom/android/tools/lint/detector/api/LintFix$CreateFileFix;", "addSetAttribute", "setFix", "Lcom/android/tools/lint/detector/api/LintFix$SetAttribute;", "findAttributeInsertionOffset", "xml", "element", "Lorg/w3c/dom/Element;", "namespacePrefix", "attributeName", "addReplaceString", "replaceFix", "Lcom/android/tools/lint/detector/api/LintFix$ReplaceString;", "getSelectionDeltas", "Lkotlin/Pair;", "selectPattern", "source", "optional", "customizeReplaceString", "replacement", "computeEdits", "FileProvider", "Companion", "PendingEditFile", "PendingEdit", "android.sdktools.lint-api"})
@SourceDebugExtension(value={"SMAP\nLintFixPerformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintFixPerformer.kt\ncom/android/tools/lint/client/api/LintFixPerformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1471:1\n774#2:1472\n865#2,2:1473\n1788#2,4:1475\n808#2,11:1479\n1011#2,2:1490\n774#2:1492\n865#2,2:1493\n1011#2,2:1495\n1#3:1497\n*S KotlinDebug\n*F\n+ 1 LintFixPerformer.kt\ncom/android/tools/lint/client/api/LintFixPerformer\n*L\n124#1:1472\n124#1:1473,2\n378#1:1475,4\n409#1:1479,11\n410#1:1490,2\n414#1:1492\n414#1:1493,2\n631#1:1495,2\n*E\n"})
public abstract class LintFixPerformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LintClient client;
    private final boolean requireAutoFixable;

    public LintFixPerformer(@NotNull LintClient client, boolean requireAutoFixable) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.requireAutoFixable = requireAutoFixable;
    }

    public /* synthetic */ LintFixPerformer(LintClient lintClient, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(lintClient, bl);
    }

    public abstract void log(@NotNull Severity var1, @NotNull String var2);

    private final PendingEditFile getFileData(Map<File, PendingEditFile> fileMap, File file) {
        PendingEditFile pendingEditFile = fileMap.get(file);
        if (pendingEditFile == null) {
            LintFixPerformer $this$getFileData_u24lambda_u240 = this;
            boolean bl = false;
            PendingEditFile fileData = new PendingEditFile(file);
            fileMap.put(file, fileData);
            pendingEditFile = fileData;
        }
        return pendingEditFile;
    }

    private final void registerFix(FileProvider fileProvider, Map<File, PendingEditFile> fileMap, Incident incident, LintFix lintFix) {
        if (LintFixPerformer.addEdits$default(this, fileProvider, fileMap, incident, lintFix, false, 16, null)) {
            incident.setWasAutoFixed(true);
        }
    }

    public final boolean fix(@NotNull List<Incident> incidents, @NotNull FileProvider fileProvider) {
        Intrinsics.checkNotNullParameter(incidents, (String)"incidents");
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        List<PendingEditFile> files = this.findApplicableFixes(fileProvider, incidents);
        return LintFixPerformer.applyEdits$default(this, fileProvider, files, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PendingEditFile> registerFixes(@NotNull Incident incident, @NotNull List<? extends LintFix> fixes, @NotNull FileProvider fileProvider) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        Map fileMap = new LinkedHashMap();
        for (LintFix lintFix : fixes) {
            if (!Companion.canAutoFix(lintFix, this.requireAutoFixable)) continue;
            this.registerFix(fileProvider, fileMap, incident, lintFix);
        }
        Iterable iterable = fileMap.values();
        boolean $i$f$filter = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PendingEditFile it = (PendingEditFile)element$iv$iv;
            boolean bl = false;
            if (!(!it.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List files = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        for (PendingEditFile file : files) {
            this.cleanup(fileProvider, file);
        }
        return files;
    }

    private final void cleanup(FileProvider fileProvider, PendingEditFile file) {
        List it = file.getEdits();
        boolean bl = false;
        List edits = it.size() > 1 ? SequencesKt.toMutableList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.sortedDescending((Sequence)CollectionsKt.asSequence((Iterable)it)))) : it;
        String source = fileProvider.getFileContents(file);
        int length = source.length();
        int n = ((Collection)edits).size();
        for (int i = 0; i < n; ++i) {
            int k;
            PendingEdit prev;
            PendingEdit next;
            PendingEdit edit2 = (PendingEdit)edits.get(i);
            if (!edit2.isDelete()) continue;
            int prevLineStart = -1;
            int nextLineEnd = -1;
            PendingEdit pendingEdit = next = i < edits.size() - 1 ? (PendingEdit)edits.get(i + 1) : null;
            int n2 = pendingEdit != null ? pendingEdit.getStartOffset() : length;
            int max = Math.min(length, n2);
            block9: for (int j = edit2.getEndOffset(); j < max; ++j) {
                char c = source.charAt(j);
                switch (c) {
                    case ' ': {
                        continue block9;
                    }
                    case '\n': 
                    case '\r': {
                        nextLineEnd = j;
                        break block9;
                    }
                    default: {
                        break block9;
                    }
                }
            }
            PendingEdit pendingEdit2 = prev = i > 0 ? (PendingEdit)edits.get(i - 1) : null;
            int min = pendingEdit2 != null ? pendingEdit2.getEndOffset() : 0;
            block10: for (k = edit2.getStartOffset(); k > min; --k) {
                char c = source.charAt(k - 1);
                switch (c) {
                    case ' ': {
                        continue block10;
                    }
                    case '\n': {
                        prevLineStart = k;
                        break block10;
                    }
                    default: {
                        break block10;
                    }
                }
            }
            if (prevLineStart != -1 && nextLineEnd != -1) {
                file.getEdits().add(new PendingEdit(edit2.getFix(), edit2.getEndOffset(), ++nextLineEnd, "", 0, 0, 0, 112, null));
                if (prevLineStart >= edit2.getStartOffset()) continue;
                file.getEdits().add(new PendingEdit(edit2.getFix(), prevLineStart, edit2.getStartOffset(), "", 0, 0, 0, 112, null));
                continue;
            }
            if (nextLineEnd == -1 || nextLineEnd <= edit2.getEndOffset() && k >= edit2.getStartOffset()) continue;
            if (nextLineEnd > edit2.getEndOffset()) {
                file.getEdits().add(new PendingEdit(edit2.getFix(), edit2.getEndOffset(), nextLineEnd, "", 0, 0, 0, 112, null));
            }
            if (k >= edit2.getStartOffset()) continue;
            file.getEdits().add(new PendingEdit(edit2.getFix(), k, edit2.getStartOffset(), "", 0, 0, 0, 112, null));
        }
    }

    public final boolean fix(@NotNull Incident incident, @NotNull List<? extends LintFix> fixes, @NotNull FileProvider fileProvider) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        List<PendingEditFile> fileMap = this.registerFixes(incident, fixes, fileProvider);
        return LintFixPerformer.applyEdits$default(this, fileProvider, fileMap, null, 4, null);
    }

    protected void applyEdits(@NotNull PendingEditFile fileData, @NotNull List<PendingEdit> edits, @NotNull Function2<? super PendingEditFile, ? super PendingEdit, Unit> applier) {
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Intrinsics.checkNotNullParameter(edits, (String)"edits");
        Intrinsics.checkNotNullParameter(applier, (String)"applier");
        for (PendingEdit edit2 : edits) {
            applier.invoke((Object)fileData, (Object)edit2);
        }
    }

    public abstract void applyEdits(@NotNull FileProvider var1, @NotNull PendingEditFile var2, @NotNull List<PendingEdit> var3);

    public final boolean applyEdits(@NotNull FileProvider fileProvider, @NotNull List<PendingEditFile> files, @NotNull Function2<? super PendingEditFile, ? super List<PendingEdit>, Unit> performEdits) {
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(performEdits, (String)"performEdits");
        int appliedEditCount = 0;
        int editedFileCount = 0;
        Map editMap = new LinkedHashMap();
        for (PendingEditFile fileData : files) {
            if (fileData.getCreateBytes() != null) {
                byte[] byArray = fileData.getCreateBytes();
                Intrinsics.checkNotNull((Object)byArray);
                fileProvider.createBinaryFile(fileData, byArray);
                ++editedFileCount;
                continue;
            }
            if (fileData.getDelete()) {
                fileProvider.deleteFile(fileData);
                ++editedFileCount;
                continue;
            }
            List edits = SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.sorted((Sequence)CollectionsKt.asSequence((Iterable)fileData.getEdits()))));
            if (this.findConflicts(edits)) continue;
            performEdits.invoke((Object)fileData, (Object)edits);
            for (PendingEdit edit2 : edits) {
                ++appliedEditCount;
                String key = edit2.fixName();
                Integer n = (Integer)editMap.get(key);
                int count = n != null ? n : 0;
                editMap.put(key, count + 1);
            }
            ++editedFileCount;
        }
        if (editedFileCount > 0) {
            this.printStatistics(editMap, appliedEditCount, editedFileCount);
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean applyEdits$default(LintFixPerformer lintFixPerformer, FileProvider fileProvider, List list2, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: applyEdits");
        }
        if ((n & 4) != 0) {
            function2 = (arg_0, arg_1) -> LintFixPerformer.applyEdits$lambda$3(lintFixPerformer, fileProvider, arg_0, arg_1);
        }
        return lintFixPerformer.applyEdits(fileProvider, list2, (Function2<? super PendingEditFile, ? super List<PendingEdit>, Unit>)function2);
    }

    public void printStatistics(@NotNull Map<String, Integer> editMap, int appliedEditCount, int editedFileCount) {
        Intrinsics.checkNotNullParameter(editMap, (String)"editMap");
    }

    private final List<PendingEditFile> findApplicableFixes(FileProvider fileProvider, List<Incident> incidents) {
        Map fileMap = new LinkedHashMap();
        for (Incident incident : incidents) {
            LintFix data;
            if (incident.getFix() == null) continue;
            if (data instanceof LintFix.LintFixGroup) {
                if (((LintFix.LintFixGroup)data).getType() != LintFix.GroupType.COMPOSITE) continue;
                boolean all2 = true;
                for (LintFix sub : ((LintFix.LintFixGroup)data).getFixes()) {
                    if (Companion.canAutoFix(sub, this.requireAutoFixable)) continue;
                    all2 = false;
                    break;
                }
                if (!all2) continue;
                for (LintFix sub : ((LintFix.LintFixGroup)data).getFixes()) {
                    this.registerFix(fileProvider, fileMap, incident, sub);
                }
                continue;
            }
            if (!Companion.canAutoFix(data, this.requireAutoFixable)) continue;
            this.registerFix(fileProvider, fileMap, incident, data);
        }
        return CollectionsKt.toList((Iterable)fileMap.values());
    }

    private final boolean findConflicts(List<PendingEdit> fixes) {
        if (fixes.isEmpty()) {
            return false;
        }
        PendingEdit prev = fixes.get(fixes.size() - 1);
        for (int index2 = fixes.size() - 2; -1 < index2; --index2) {
            PendingEdit fix2 = fixes.get(index2);
            if (fix2.getStartOffset() < prev.getEndOffset()) {
                this.log(Severity.WARNING, "Overlapping edits in quickfixes; skipping. Involved fixes: " + prev.getFix().getDisplayName() + " in [" + prev.getStartOffset() + "-" + prev.getEndOffset() + "] and " + fix2.getFix().getDisplayName() + " in [" + fix2.getStartOffset() + "-" + fix2.getEndOffset() + "]");
                return true;
            }
            prev = fix2;
        }
        return false;
    }

    private final boolean addEdits(FileProvider fileProvider, Map<File, PendingEditFile> fileMap, Incident incident, LintFix lintFix, boolean isTopLevel) {
        boolean bl;
        if (lintFix instanceof LintFix.LintFixGroup && ((LintFix.LintFixGroup)lintFix).getType() == LintFix.GroupType.COMPOSITE) {
            int attributeFixes;
            boolean all2 = true;
            List<LintFix> fixes = ((LintFix.LintFixGroup)lintFix).getFixes();
            Iterable $this$count$iv = fixes;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v0 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    LintFix it = (LintFix)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof LintFix.SetAttribute) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v0 = attributeFixes = count$iv;
            }
            if (attributeFixes > 1) {
                fixes = this.sortAttributes(fixes);
            }
            for (LintFix nested : fixes) {
                if (this.addEdits(fileProvider, fileMap, incident, nested, false)) continue;
                all2 = false;
            }
            return all2;
        }
        Location location = Companion.getLocation(incident, lintFix);
        PendingEditFile file = this.getFileData(fileMap, location.getFile());
        LintFix lintFix2 = lintFix;
        if (lintFix2 instanceof LintFix.ReplaceString) {
            bl = this.addReplaceString(fileProvider, file, incident, (LintFix.ReplaceString)lintFix, location);
        } else if (lintFix2 instanceof LintFix.SetAttribute) {
            bl = this.addSetAttribute(fileProvider, file, (LintFix.SetAttribute)lintFix, location);
        } else if (lintFix2 instanceof LintFix.AnnotateFix) {
            bl = this.addAnnotation(fileProvider, file, incident, (LintFix.AnnotateFix)lintFix, location);
        } else if (lintFix2 instanceof LintFix.CreateFileFix) {
            if (isTopLevel || ((LintFix.CreateFileFix)lintFix).getSelectPattern() != null) {
                file.setOpen(true);
            }
            bl = this.addCreateFile(file, (LintFix.CreateFileFix)lintFix);
        } else {
            bl = false;
        }
        return bl;
    }

    static /* synthetic */ boolean addEdits$default(LintFixPerformer lintFixPerformer, FileProvider fileProvider, Map map2, Incident incident, LintFix lintFix, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addEdits");
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return lintFixPerformer.addEdits(fileProvider, map2, incident, lintFix, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LintFix> sortAttributes(List<? extends LintFix> fixes) {
        void $this$filterTo$iv$iv;
        List reordered;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = fixes;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LintFix.SetAttribute)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List $this$sortBy$iv = reordered = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    LintFix.SetAttribute it = (LintFix.SetAttribute)a;
                    boolean bl = false;
                    String string2 = LintFixPerformer.Companion.suggestNamespacePrefix(it.getNamespace());
                    if (string2 == null) {
                        string2 = "app";
                    }
                    String prefix = string2;
                    Comparable comparable = Integer.valueOf(-com.android.tools.lint.client.api.LintFixPerformer$Companion.access$rankAttributeNames(LintFixPerformer.Companion, prefix, it.getAttribute()));
                    it = (LintFix.SetAttribute)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    String string3 = LintFixPerformer.Companion.suggestNamespacePrefix(it.getNamespace());
                    if (string3 == null) {
                        string3 = "app";
                    }
                    prefix = string3;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(-com.android.tools.lint.client.api.LintFixPerformer$Companion.access$rankAttributeNames(LintFixPerformer.Companion, prefix, it.getAttribute())));
                }
            });
        }
        Iterable $this$filter$iv = fixes;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LintFix it = (LintFix)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof LintFix.SetAttribute))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)reordered);
    }

    private final boolean addAnnotation(FileProvider fileProvider, PendingEditFile file, Incident incident, LintFix.AnnotateFix annotateFix, Location fixLocation) {
        Location location = annotateFix.getRange();
        if (location == null) {
            location = fixLocation;
        }
        LintFix.ReplaceString replaceFix = Companion.createAnnotationFix(annotateFix, location, fileProvider.getFileContents(file));
        return this.addReplaceString(fileProvider, file, incident, replaceFix, fixLocation);
    }

    private final boolean addCreateFile(PendingEditFile file, LintFix.CreateFileFix fix2) {
        if (fix2.getDelete()) {
            file.setDelete(true);
        } else {
            String text = fix2.getText();
            if (text != null) {
                file.setCreateText(true);
                file.setReformat(fix2.getReformat());
                Pair<Integer, Integer> pair2 = this.getSelectionDeltas(fix2.getSelectPattern(), text, false);
                int selectStart = ((Number)pair2.component1()).intValue();
                int selectEnd = ((Number)pair2.component2()).intValue();
                file.getEdits().add(new PendingEdit(fix2, 0, 0, text, selectStart, selectEnd, 0, 64, null));
            } else {
                file.setCreateBytes(fix2.getBinary());
            }
        }
        return true;
    }

    private final boolean addSetAttribute(FileProvider fileProvider, PendingEditFile file, LintFix.SetAttribute setFix, Location fixLocation) {
        int insertOffset;
        Attr attr;
        Location location = setFix.getRange();
        if (location == null && (location = fixLocation) == null) {
            return false;
        }
        Location location2 = location;
        Position position = location2.getStart();
        if (position == null) {
            return false;
        }
        Position start2 = position;
        String contents = fileProvider.getFileContents(file);
        Document document = this.client.getXmlDocument(file.getFile(), contents);
        if (document == null && (document = fileProvider.getXmlDocument(file)) == null) {
            return false;
        }
        Document document2 = document;
        Node node = this.client.getXmlParser().findNodeAt(document2, start2.getOffset());
        if (node == null) {
            throw new IllegalStateException(("No node found at offset " + start2.getOffset()).toString());
        }
        Node node2 = node;
        if (node2.getNodeType() == 2) {
            node2 = ((Attr)node2).getOwnerElement();
        } else if (node2.getNodeType() != 1) {
            node2 = node2.getParentNode();
        }
        if (node2 == null || node2.getNodeType() != 1) {
            throw new IllegalArgumentException("Didn't find element at offset " + start2.getOffset() + " (line " + start2.getLine() + "1, column " + start2.getColumn() + "1) in " + file.getFile().getPath() + ":\n" + contents);
        }
        Element element = (Element)node2;
        String value = setFix.getValue();
        String namespace = setFix.getNamespace();
        Object attributeName = setFix.getAttribute();
        Attr attr2 = attr = namespace != null ? element.getAttributeNodeNS(namespace, (String)attributeName) : element.getAttributeNode((String)attributeName);
        if (value == null) {
            if (attr != null) {
                int startOffset = this.client.getXmlParser().getNodeStartOffset(this.client, file.getFile(), attr);
                int endOffset = this.client.getXmlParser().getNodeEndOffset(this.client, file.getFile(), attr);
                int padding = contents.charAt(endOffset) == ' ' ? 1 : 0;
                file.getEdits().add(new PendingEdit(setFix, startOffset, endOffset + padding, "", 0, 0, 0, 112, null));
                return true;
            }
            return false;
        }
        if (attr != null) {
            int startOffset = this.client.getXmlParser().getNodeStartOffset(this.client, file.getFile(), attr);
            int endOffset = this.client.getXmlParser().getNodeEndOffset(this.client, file.getFile(), attr);
            if (setFix.getPoint() == null && Intrinsics.areEqual((Object)attr.getValue(), (Object)value)) {
                return false;
            }
            Integer n = setFix.getPoint();
            int point = n != null ? n : 0;
            Integer n2 = setFix.getMark();
            int mark = n2 != null ? n2 : point;
            String prefix = attr.getName() + "=\"";
            String replacement = prefix + XmlUtils.toXmlAttributeValue((String)value) + "\"";
            file.getEdits().add(new PendingEdit(setFix, startOffset, endOffset, replacement, setFix.getPoint() == null ? -1 : prefix.length() + Math.min(point, mark), setFix.getPoint() == null ? -1 : prefix.length() + Math.max(point, mark), 0, 64, null));
            return true;
        }
        Object prefix = null;
        boolean insertNamespaceDeclaration = false;
        if (namespace != null && (prefix = document2.lookupPrefix(namespace)) == null) {
            insertNamespaceDeclaration = true;
            String string2 = Companion.suggestNamespacePrefix(namespace);
            if (string2 == null) {
                string2 = "ns";
            }
            String base = string2;
            Element root2 = document2.getDocumentElement();
            int index2 = 1;
            while (root2.hasAttribute("xmlns:" + (String)(prefix = base + (index2 == 1 ? "" : String.valueOf(index2))))) {
                ++index2;
            }
        }
        if (insertNamespaceDeclaration && prefix != null) {
            String namespaceAttribute = "xmlns:" + (String)prefix;
            File file2 = file.getFile();
            Element element2 = document2.getDocumentElement();
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"getDocumentElement(...)");
            int rootInsertOffset = this.findAttributeInsertionOffset(file2, contents, element2, "xmlns", (String)prefix);
            String padLeft = !CharsKt.isWhitespace((char)contents.charAt(rootInsertOffset - 1)) ? " " : "";
            String padRight = contents.charAt(rootInsertOffset) != '>' ? " " : "";
            file.getEdits().add(new PendingEdit(setFix, rootInsertOffset, rootInsertOffset, padLeft + namespaceAttribute + "=\"" + namespace + "\"" + padRight, 0, 0, 0, 112, null));
        }
        if (namespace != null) {
            attributeName = (String)prefix + ":" + (String)attributeName;
        }
        File file3 = file.getFile();
        Object object = prefix;
        if (object == null) {
            object = "";
        }
        String padLeft = !CharsKt.isWhitespace((char)contents.charAt((insertOffset = this.findAttributeInsertionOffset(file3, contents, element, (String)object, setFix.getAttribute())) - 1)) ? " " : "";
        String padRight = contents.charAt(insertOffset) != '>' ? " " : "";
        String leftPart = padLeft + (String)attributeName + "=\"";
        String valuePart = XmlUtils.toXmlAttributeValue((String)value);
        Integer n = setFix.getPoint();
        int point = n != null ? n : 0;
        Integer n3 = setFix.getMark();
        int mark = n3 != null ? n3 : point;
        String rightPart = "\"" + padRight;
        file.getEdits().add(new PendingEdit(setFix, insertOffset, insertOffset, leftPart + valuePart + rightPart, setFix.getPoint() == null ? -1 : leftPart.length() + Math.min(point, mark), setFix.getPoint() == null ? -1 : leftPart.length() + Math.max(point, mark), 0, 64, null));
        file.setReformat(true);
        return true;
    }

    private final int findAttributeInsertionOffset(File file, String xml, Element element, String namespacePrefix, String attributeName) {
        int tagEnd;
        NamedNodeMap attributes = element.getAttributes();
        List attributeList = new ArrayList();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Node attribute;
            Intrinsics.checkNotNullExpressionValue((Object)attributes.item(i), (String)"item(...)");
            int offset = this.client.getXmlParser().getNodeStartOffset(this.client, file, attribute);
            attributeList.add(new Pair((Object)offset, (Object)((Attr)attribute)));
        }
        List $this$sortBy$iv = attributeList;
        boolean $i$f$sortBy2 = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getFirst();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getFirst()));
                }
            });
        }
        for (Pair $i$f$sortBy2 : attributeList) {
            String string2;
            String name;
            int offset = ((Number)$i$f$sortBy2.component1()).intValue();
            Attr attribute = (Attr)$i$f$sortBy2.component2();
            String string3 = attribute.getLocalName();
            if (string3 == null) {
                string3 = name = attribute.getNodeName();
            }
            if ((string2 = attribute.getPrefix()) == null) {
                string2 = "";
            }
            Intrinsics.checkNotNull((Object)name);
            int delta = Companion.compareAttributeNames(namespacePrefix, attributeName, string2, name);
            if (delta >= 0) continue;
            return offset;
        }
        if (!((Collection)attributeList).isEmpty()) {
            int i = this.client.getXmlParser().getNodeEndOffset(this.client, file, (Node)((Pair)CollectionsKt.last((List)attributeList)).getSecond());
            if (xml.charAt(i) == ' ') {
                return i + 1;
            }
            return i;
        }
        int startOffset = this.client.getXmlParser().getNodeStartOffset(this.client, file, element);
        for (int offset = tagEnd = startOffset + element.getTagName().length(); offset < xml.length(); ++offset) {
            char c = xml.charAt(offset);
            if (!Character.isWhitespace(c) && c != '>' && c != '/') continue;
            return c == ' ' ? offset + 1 : offset;
        }
        return xml.length();
    }

    protected boolean addReplaceString(@NotNull FileProvider fileProvider, @NotNull PendingEditFile file, @NotNull Incident incident, @NotNull LintFix.ReplaceString replaceFix, @Nullable Location fixLocation) {
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)replaceFix, (String)"replaceFix");
        String contents = fileProvider.getFileContents(file);
        String oldPattern = replaceFix.getOldPattern();
        String oldString = replaceFix.getOldString();
        Location location = replaceFix.getRange();
        if (location == null && (location = fixLocation) == null) {
            return false;
        }
        Location location2 = location;
        Position position = location2.getStart();
        if (position == null) {
            return false;
        }
        Position start2 = position;
        Position position2 = location2.getEnd();
        if (position2 == null) {
            return false;
        }
        Position end2 = position2;
        CharSequence charSequence = oldString;
        int adjustedEnd = (!(charSequence == null || charSequence.length() == 0) || !((charSequence = (CharSequence)oldPattern) == null || charSequence.length() == 0)) && end2.getOffset() == start2.getOffset() ? contents.length() : end2.getOffset();
        int adjustedStart = start2.getOffset();
        boolean found = false;
        while (adjustedStart <= adjustedEnd) {
            Intrinsics.checkNotNullExpressionValue((Object)contents.substring(adjustedStart, adjustedEnd), (String)"substring(...)");
            int startOffset = 0;
            int endOffset = 0;
            String replacement = replaceFix.getReplacement();
            int continueOffset = 0;
            if (oldString == null && oldPattern == null) {
                startOffset = adjustedStart;
                endOffset = adjustedEnd;
                boolean allSpace = true;
                String string2 = replacement;
                int n = string2.length();
                for (int i = 0; i < n; ++i) {
                    char element = string2.charAt(i);
                    if (Character.isWhitespace(element)) continue;
                    allSpace = false;
                    break;
                }
                if (allSpace) {
                    int lineEnd;
                    char c;
                    int lineBegin;
                    for (lineBegin = startOffset; lineBegin > 0 && (c = contents.charAt(lineBegin - 1)) != '\n'; --lineBegin) {
                        if (Character.isWhitespace(c)) continue;
                        allSpace = false;
                        break;
                    }
                    for (lineEnd = endOffset; lineEnd < contents.length(); ++lineEnd) {
                        char c2 = contents.charAt(lineEnd);
                        if (c2 == '\n') break;
                        if (Character.isWhitespace(c2)) continue;
                        allSpace = false;
                        break;
                    }
                    if (allSpace) {
                        startOffset = lineBegin;
                        endOffset = lineEnd;
                    }
                }
                continueOffset = adjustedEnd + 1;
            } else if (oldString != null) {
                int index2 = StringsKt.indexOf$default((CharSequence)locationRange, (String)oldString, (int)0, (boolean)false, (int)6, null);
                if (index2 != -1) {
                    startOffset = adjustedStart + index2;
                    continueOffset = endOffset = adjustedStart + index2 + oldString.length();
                } else if (Intrinsics.areEqual((Object)oldString, (Object)"_lint_insert_begin_")) {
                    endOffset = startOffset = adjustedStart;
                    continueOffset = adjustedEnd + 1;
                } else if (Intrinsics.areEqual((Object)oldString, (Object)"_lint_insert_end_")) {
                    endOffset = startOffset = adjustedEnd;
                    continueOffset = adjustedEnd + 1;
                } else {
                    if (replaceFix.getOptional() || replaceFix.getGlobally() && found) break;
                    throw new IllegalArgumentException("Did not find \"" + oldString + "\" in \"" + locationRange + "\" in " + LintClient.getDisplayPath$default(this.client, file.getFile(), null, null, 6, null) + " as suggested in the quickfix.\n\nConsider calling ReplaceStringBuilder#range() to set a larger range to\nsearch than the default highlight range.\n\n(This fix is associated with the issue id `" + incident.getIssue().getId() + "`,\nreported via " + incident.getIssue().getImplementation().getDetectorClass().getName() + ".)");
                }
                found = true;
            } else {
                boolean index2;
                boolean bl = index2 = oldPattern != null;
                if (_Assertions.ENABLED && !index2) {
                    String lineBegin = "Assertion failed";
                    throw new AssertionError((Object)lineBegin);
                }
                String string3 = oldPattern;
                Intrinsics.checkNotNull((Object)string3);
                Pattern pattern = Companion.createFixPattern(string3, replaceFix.getPatternFlags());
                Matcher matcher = pattern.matcher(locationRange);
                if (!matcher.find()) {
                    if (replaceFix.getOptional() || replaceFix.getGlobally() && found) break;
                    throw new IllegalArgumentException("Did not match pattern \"" + oldPattern + "\" in \"" + locationRange + "\" in " + LintClient.getDisplayPath$default(this.client, file.getFile(), null, null, 6, null) + " as suggested in the quickfix.\n\n(This fix is associated with the issue id `" + incident.getIssue().getId() + "`,\nreported via " + incident.getIssue().getImplementation().getDetectorClass().getName() + ".)");
                }
                endOffset = startOffset = adjustedStart;
                continueOffset = startOffset + matcher.end();
                if (matcher.groupCount() > 0) {
                    startOffset += matcher.start(1);
                    endOffset += matcher.end(1);
                } else {
                    startOffset += matcher.start();
                    endOffset += matcher.end();
                }
                Intrinsics.checkNotNull((Object)matcher);
                replacement = replaceFix.expandBackReferences(matcher);
                found = true;
            }
            replacement = this.customizeReplaceString(fileProvider, file, replaceFix, replacement);
            Pair<Integer, Integer> pair2 = this.getSelectionDeltas(replaceFix.getSelectPattern(), replacement, replaceFix.getOptional());
            int selectStart = ((Number)pair2.component1()).intValue();
            int selectEnd = ((Number)pair2.component2()).intValue();
            PendingEdit edit2 = new PendingEdit(replaceFix, startOffset, endOffset, replacement, selectStart, selectEnd, replaceFix.getSortPriority());
            file.getEdits().add(edit2);
            if (!replaceFix.getGlobally()) break;
            adjustedStart = continueOffset;
        }
        if (!((Collection)replaceFix.getImports()).isEmpty()) {
            List list2 = file.getImports();
            if (list2 == null) {
                List endOffset;
                List it = endOffset = (List)new ArrayList();
                boolean bl = false;
                file.setImports(it);
                list2 = endOffset;
            }
            List list3 = list2;
            for (String string4 : replaceFix.getImports()) {
                if (list3.contains(string4)) continue;
                list3.add(string4);
            }
        }
        if (replaceFix.getShortenNames()) {
            file.setShortenReferences(true);
        }
        if (replaceFix.getReformat()) {
            file.setReformat(true);
        }
        return true;
    }

    private final Pair<Integer, Integer> getSelectionDeltas(String selectPattern, String source, boolean optional) {
        if (selectPattern != null) {
            Pattern pattern = com.android.tools.lint.client.api.LintFixPerformer$Companion.createFixPattern$default(Companion, selectPattern, 0, 2, null);
            Matcher matcher = pattern.matcher(source);
            if (matcher.find(0)) {
                if (matcher.groupCount() > 0) {
                    return new Pair((Object)matcher.start(1), (Object)matcher.end(1));
                }
                return new Pair((Object)matcher.start(), (Object)matcher.end());
            }
            if (!optional && LintClient.Companion.isUnitTest()) {
                throw new IllegalArgumentException("Didn't find selection pattern " + selectPattern + "in " + source);
            }
            return new Pair((Object)-1, (Object)-1);
        }
        return new Pair((Object)-1, (Object)-1);
    }

    @NotNull
    protected String customizeReplaceString(@NotNull FileProvider fileProvider, @NotNull PendingEditFile file, @NotNull LintFix.ReplaceString replaceFix, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)replaceFix, (String)"replaceFix");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        return replacement;
    }

    @NotNull
    public final List<PendingEditFile> computeEdits(@NotNull Incident incident, @NotNull LintFix lintFix, @NotNull FileProvider fileProvider) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)lintFix, (String)"lintFix");
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        Map fileMap = new LinkedHashMap();
        this.registerFix(fileProvider, fileMap, incident, lintFix);
        return CollectionsKt.toList((Iterable)fileMap.values());
    }

    private static final Unit applyEdits$lambda$3(LintFixPerformer this$0, FileProvider $fileProvider, PendingEditFile fileData, List edits) {
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Intrinsics.checkNotNullParameter((Object)edits, (String)"edits");
        this$0.applyEdits($fileProvider, fileData, edits);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000fJ\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007J&\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0007J\"\u0010!\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u000b2\b\u0010%\u001a\u0004\u0018\u00010\u0007J*\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\t2\b\b\u0002\u0010*\u001a\u00020\u00112\b\b\u0002\u0010+\u001a\u00020\u0011J\u0016\u0010,\u001a\u00020\t2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\t\u00a8\u0006-"}, d2={"Lcom/android/tools/lint/client/api/LintFixPerformer$Companion;", "", "<init>", "()V", "createFixPattern", "Ljava/util/regex/Pattern;", "pattern", "", "flags", "", "getLocation", "Lcom/android/tools/lint/detector/api/Location;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "isEditingFix", "", "canAutoFix", "lintFix", "requireAutoFixable", "suggestNamespacePrefix", "uri", "compareAttributeNames", "prefix1", "n1", "prefix2", "n2", "rankAttributeNames", "prefix", "name", "implicitlyImported", "pkg", "createAnnotationFix", "Lcom/android/tools/lint/detector/api/LintFix$ReplaceString;", "Lcom/android/tools/lint/detector/api/LintFix$AnnotateFix;", "location", "contents", "skipCommentsAndWhitespace", "source", "", "start", "allowCommentNesting", "stopAtNewline", "skipAnnotation", "android.sdktools.lint-api"})
    @SourceDebugExtension(value={"SMAP\nLintFixPerformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintFixPerformer.kt\ncom/android/tools/lint/client/api/LintFixPerformer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1471:1\n1#2:1472\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern createFixPattern(@NotNull String pattern, int flags) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Pattern pattern2 = Pattern.compile(pattern, flags);
            Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
            return pattern2;
        }

        public static /* synthetic */ Pattern createFixPattern$default(Companion companion, String string2, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.createFixPattern(string2, n);
        }

        @NotNull
        public final Location getLocation(@NotNull Incident incident, @Nullable LintFix fix2) {
            Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
            Object object = fix2;
            if (object == null || (object = ((LintFix)object).getRange()) == null) {
                object = incident.getLocation();
            }
            return object;
        }

        public static /* synthetic */ Location getLocation$default(Companion companion, Incident incident, LintFix lintFix, int n, Object object) {
            if ((n & 2) != 0) {
                lintFix = incident.getFix();
            }
            return companion.getLocation(incident, lintFix);
        }

        public final boolean isEditingFix(@NotNull LintFix fix2) {
            Intrinsics.checkNotNullParameter((Object)fix2, (String)"fix");
            return fix2 instanceof LintFix.ReplaceString || fix2 instanceof LintFix.AnnotateFix || fix2 instanceof LintFix.SetAttribute || fix2 instanceof LintFix.CreateFileFix;
        }

        public final boolean canAutoFix(@NotNull LintFix lintFix) {
            Intrinsics.checkNotNullParameter((Object)lintFix, (String)"lintFix");
            return this.canAutoFix(lintFix, true);
        }

        public final boolean canAutoFix(@NotNull LintFix lintFix, boolean requireAutoFixable) {
            Intrinsics.checkNotNullParameter((Object)lintFix, (String)"lintFix");
            if (!(requireAutoFixable || lintFix instanceof LintFix.LintFixGroup && ((LintFix.LintFixGroup)lintFix).getType() == LintFix.GroupType.ALTERNATIVES)) {
                return true;
            }
            if (lintFix instanceof LintFix.LintFixGroup) {
                switch (WhenMappings.$EnumSwitchMapping$0[((LintFix.LintFixGroup)lintFix).getType().ordinal()]) {
                    case 1: {
                        return false;
                    }
                    case 2: {
                        for (LintFix nested : ((LintFix.LintFixGroup)lintFix).getFixes()) {
                            if (this.canAutoFix(nested, requireAutoFixable)) continue;
                            return false;
                        }
                        return true;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            if (!lintFix.robot) {
                return false;
            }
            return lintFix.independent;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final String suggestNamespacePrefix(@Nullable String uri) {
            String string2;
            String string3 = string2 = uri;
            if (string3 == null) return "";
            switch (string3.hashCode()) {
                case -1168752206: {
                    if (string2.equals("http://schemas.android.com/apk/res/android")) return "android";
                    break;
                }
                case 1224167186: {
                    if (string2.equals("http://schemas.android.com/apk/distribution")) return "dist";
                    break;
                }
                case -1988678336: {
                    if (string2.equals("http://schemas.android.com/tools")) return "tools";
                    break;
                }
                case -621665718: {
                    if (string2.equals("http://schemas.android.com/apk/res-auto")) return "app";
                    break;
                }
                case -1500319236: {
                    if (string2.equals("urn:oasis:names:tc:xliff:document:1.2")) return "xliff";
                    break;
                }
                case 766553631: {
                    if (string2.equals("http://schemas.android.com/aapt")) return "aapt";
                    break;
                }
            }
            if (!StringsKt.startsWith$default((String)uri, (String)"http://schemas.android.com/apk/res/", (boolean)false, (int)2, null)) return null;
            return "app";
        }

        public final int compareAttributeNames(@NotNull String prefix1, @NotNull String n1, @NotNull String prefix2, @NotNull String n2) {
            Intrinsics.checkNotNullParameter((Object)prefix1, (String)"prefix1");
            Intrinsics.checkNotNullParameter((Object)n1, (String)"n1");
            Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix2");
            Intrinsics.checkNotNullParameter((Object)n2, (String)"n2");
            int rank1 = this.rankAttributeNames(prefix1, n1);
            int rank2 = this.rankAttributeNames(prefix2, n2);
            int delta = rank1 - rank2;
            if (delta != 0) {
                return delta;
            }
            return n1.compareTo(n2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final int rankAttributeNames(String prefix, String name) {
            switch (prefix) {
                case "xmlns": {
                    return 0;
                }
                case "tools": {
                    return 100;
                }
                case "": {
                    switch (name.hashCode()) {
                        case -1109722326: {
                            if (name.equals("layout")) return 20;
                            return 90;
                        }
                        case -807062458: {
                            if (name.equals("package")) return 20;
                            return 90;
                        }
                        case 94842723: {
                            if (name.equals("color")) return 95;
                            return 90;
                        }
                        case 109780401: {
                            if (!name.equals("style")) return 90;
                            return 20;
                        }
                    }
                    return 90;
                }
                case "aapt": {
                    return 7;
                }
                case "android": {
                    if (Intrinsics.areEqual((Object)name, (Object)"id")) return 10;
                    if (Intrinsics.areEqual((Object)name, (Object)"name")) {
                        return 10;
                    }
                    if (!StringsKt.startsWith$default((String)name, (String)"layout_", (boolean)false, (int)2, null)) return 40;
                    if (Intrinsics.areEqual((Object)name, (Object)"layout_width")) {
                        return 30;
                    }
                    if (!Intrinsics.areEqual((Object)name, (Object)"layout_height")) return 34;
                    return 32;
                }
                case "dist": {
                    return 45;
                }
                case "app": {
                    return 50;
                }
                default: {
                    return 60;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean implicitlyImported(@NotNull String pkg) {
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            String string2 = pkg;
            switch (string2.hashCode()) {
                case -1423119331: {
                    if (string2.equals("kotlin.comparisons")) return true;
                    return false;
                }
                case 838499368: {
                    if (string2.equals("kotlin.collections")) return true;
                    return false;
                }
                case -888658374: {
                    if (string2.equals("java.lang")) return true;
                    return false;
                }
                case -1177193165: {
                    if (string2.equals("kotlin.io")) return true;
                    return false;
                }
                case -86810587: {
                    if (string2.equals("kotlin.sequences")) return true;
                    return false;
                }
                case -1125574399: {
                    if (string2.equals("kotlin")) return true;
                    return false;
                }
                case 1235978339: {
                    if (string2.equals("kotlin.ranges")) return true;
                    return false;
                }
                case 213317180: {
                    if (string2.equals("kotlin.annotation")) return true;
                    return false;
                }
                case -1705910790: {
                    if (string2.equals("kotlin.text")) return true;
                    return false;
                }
                case -1706123307: {
                    if (string2.equals("kotlin.math")) return true;
                    return false;
                }
                case -2133248460: {
                    if (!string2.equals("kotlin.jvm")) return false;
                    return true;
                }
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final LintFix.ReplaceString createAnnotationFix(@NotNull LintFix.AnnotateFix fix, @Nullable Location location, @Nullable String contents) {
            block18: {
                Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
                replaceFixBuilder = LintFix.Companion.create().replace().shortenNames().reformat(true);
                range = location;
                it = fix.getAnnotation();
                $i$a$-let-LintFixPerformer$Companion$createAnnotationFix$annotation$1 = false;
                index = StringsKt.indexOf$default((CharSequence)it, (char)'(', (int)1, (boolean)false, (int)4, null);
                $i$a$-let-LintFixPerformer$Companion$createAnnotationFix$annotation$1$argStart$1 = false;
                argStart = index == -1 ? it.length() : index;
                packageEnd = StringsKt.lastIndexOf$default((CharSequence)it, (char)'.', (int)argStart, (boolean)false, (int)4, null);
                if (packageEnd == -1) ** GOTO lbl-1000
                v0 = it.substring(1, packageEnd);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"substring(...)");
                if (LintFixPerformer.Companion.implicitlyImported(v0)) {
                    v1 = it.substring(packageEnd + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                    v2 = "@" + v1;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = it.substring(1, argStart);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"substring(...)");
                    fqn = v3;
                    if (contents != null && StringsKt.contains$default((CharSequence)contents, (CharSequence)fqn, (boolean)false, (int)2, null) && (StringsKt.contains$default((CharSequence)contents, (CharSequence)("import " + fqn + "\n"), (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)contents, (CharSequence)("import " + fqn + ";"), (boolean)false, (int)2, null))) {
                        v4 = it.substring(packageEnd + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"substring(...)");
                        v2 = "@" + v4;
                    } else {
                        v2 = it;
                    }
                }
                annotation = v2;
                oldText = "_lint_insert_begin_";
                v5 = range;
                if ((v5 != null ? v5.getStart() : null) == null || contents == null) break block18;
                start = range.getStart();
                startOffset = start.getOffset();
                v6 = range.getFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getPath(...)");
                if (StringsKt.endsWith$default((String)v6, (String)".kt", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v7 = range.getFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getPath(...)");
                if (StringsKt.endsWith$default((String)v7, (String)".kts", (boolean)false, (int)2, null)) lbl-1000:
                // 2 sources

                {
                    v8 = true;
                } else {
                    v8 = false;
                }
                isKotlin = v8;
                offset = com.android.tools.lint.client.api.LintFixPerformer$Companion.skipCommentsAndWhitespace$default(this, contents, startOffset, isKotlin, false, 8, null);
                if (fix.getReplace()) {
                    symbolEnd = StringsKt.substringBefore$default((String)annotation, (char)'(', null, (int)2, null);
                    current = offset;
                    while (current < contents.length() && contents.charAt(current) == '@') {
                        if (StringsKt.startsWith$default((String)contents, (String)symbolEnd, (int)current, (boolean)false, (int)4, null) && current + symbolEnd.length() < contents.length() && !Character.isJavaIdentifierPart(contents.charAt(current + symbolEnd.length()))) {
                            offset = current;
                            annotationEnd = this.skipAnnotation(contents, current);
                            v9 = contents.substring(current, annotationEnd);
                            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"substring(...)");
                            oldText = v9;
                            break;
                        }
                        current = this.skipAnnotation(contents, current);
                        current = com.android.tools.lint.client.api.LintFixPerformer$Companion.skipCommentsAndWhitespace$default(this, contents, current, false, false, 12, null);
                    }
                }
                if (StringsKt.startsWith$default((String)annotation, (String)"@file:", (boolean)false, (int)2, null)) {
                    offset = 0;
                }
                if (offset != startOffset) {
                    v10 = range.getEnd();
                    range = Location.Companion.create(range.getFile(), new DefaultPosition(-1, -1, offset), new DefaultPosition(-1, -1, Math.max(v10 != null ? v10.getOffset() : -1, startOffset)));
                }
            }
            replacement = annotation;
            if (Intrinsics.areEqual((Object)oldText, (Object)"_lint_insert_begin_")) {
                replacement = (String)replacement + "\n";
                if (range != null && contents != null && range.getStart() != null) {
                    start = range.getStart();
                    for (lineBegin = startOffset = start.getOffset(); lineBegin > 0 && Character.isWhitespace(c = contents.charAt(lineBegin - 1)); --lineBegin) {
                        if (c != '\n' && lineBegin != 1) continue;
                        if (startOffset <= lineBegin) break;
                        v11 = contents.substring(lineBegin, startOffset);
                        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"substring(...)");
                        indent = v11;
                        separator = "\n" + indent;
                        replacement = StringsKt.contains$default((CharSequence)annotation, (CharSequence)"\n", (boolean)false, (int)2, null) != false ? CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)annotation), (CharSequence)separator, null, null, (int)0, null, null, (int)62, null) + separator : annotation + separator;
                        break;
                    }
                }
            }
            replaceFixBuilder.text(oldText).with((String)replacement);
            if (range == null) ** GOTO lbl-1000
            v12 = range.getEnd();
            if ((v12 != null ? Integer.valueOf(v12.getOffset()) : null) == null) ** GOTO lbl-1000
            v13 = range.getStart();
            if ((v13 != null ? Integer.valueOf(v13.getOffset()) : null) != null && range.getEnd().getOffset() >= range.getStart().getOffset()) {
                replaceFixBuilder.range(range);
            } else if (LintClient.Companion.isUnitTest()) {
                throw new IllegalStateException(StringsKt.trimIndent((String)("\n            Invalid location " + range + " computed for Lint fix " + fix.getDisplayName() + "} during tests.\n            This can happen if the location for the fix was not correctly specified.\n            ")).toString());
            }
            if (fix.getSelectPattern() != null) {
                replaceFixBuilder.select(fix.getSelectPattern());
            }
            v14 = replaceFixBuilder.build();
            Intrinsics.checkNotNull((Object)v14, (String)"null cannot be cast to non-null type com.android.tools.lint.detector.api.LintFix.ReplaceString");
            return (LintFix.ReplaceString)v14;
        }

        public final int skipCommentsAndWhitespace(@NotNull CharSequence source, int start2, boolean allowCommentNesting, boolean stopAtNewline) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            int index2 = start2;
            int length = source.length();
            block0: while (index2 < length) {
                char c;
                if (CharsKt.isWhitespace((char)(c = source.charAt(index2++)))) {
                    if (c != '\n' || !stopAtNewline) continue;
                    return index2;
                }
                if (c == '/' && index2 < length) {
                    if (source.charAt(index2) == '/') {
                        if ((index2 = StringsKt.indexOf$default((CharSequence)source, (char)'\n', (int)index2, (boolean)false, (int)4, null) + 1) != 0) continue;
                        return length;
                    }
                    if (source.charAt(index2) == '*') {
                        ++index2;
                        int nesting = 1;
                        while (index2 < length) {
                            char d = source.charAt(index2++);
                            if (allowCommentNesting && d == '/' && index2 < length && source.charAt(index2) == '*') {
                                ++index2;
                                ++nesting;
                                continue;
                            }
                            if (d != '*' || index2 >= length || source.charAt(index2) != '/') continue;
                            ++index2;
                            if (--nesting != 0) continue;
                            continue block0;
                        }
                        continue;
                    }
                    return index2 - 1;
                }
                return index2 - 1;
            }
            return index2;
        }

        public static /* synthetic */ int skipCommentsAndWhitespace$default(Companion companion, CharSequence charSequence, int n, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl = true;
            }
            if ((n2 & 8) != 0) {
                bl2 = false;
            }
            return companion.skipCommentsAndWhitespace(charSequence, n, bl, bl2);
        }

        public final int skipAnnotation(@NotNull CharSequence source, int start2) {
            int offset;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            int length = source.length();
            boolean bl2 = bl = source.charAt(start2) == '@';
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            int balance = 0;
            for (offset = start2 + 1; offset < length && (Character.isJavaIdentifierPart(source.charAt(offset)) || source.charAt(offset) == ':'); ++offset) {
            }
            int next = com.android.tools.lint.client.api.LintFixPerformer$Companion.skipCommentsAndWhitespace$default(this, source, offset, false, false, 12, null);
            if (next == length || source.charAt(next) != '(') {
                return offset;
            }
            offset = next;
            block7: while (offset < length) {
                char d = source.charAt(offset++);
                switch (d) {
                    case '(': 
                    case '{': {
                        ++balance;
                        continue block7;
                    }
                    case ')': 
                    case '}': {
                        if (--balance != 0) continue block7;
                        break block7;
                    }
                    case '\"': 
                    case '\'': {
                        while (offset < length) {
                            char e;
                            if ((e = source.charAt(offset++)) == '\\') {
                                ++offset;
                                continue;
                            }
                            if (e != d) continue;
                            continue block7;
                        }
                        continue block7;
                    }
                    case '/': {
                        int after = com.android.tools.lint.client.api.LintFixPerformer$Companion.skipCommentsAndWhitespace$default(this, source, offset - 1, false, false, 12, null);
                        if (after <= offset) continue block7;
                        offset = after;
                    }
                    default: {
                        continue block7;
                    }
                }
            }
            return offset;
        }

        public static final /* synthetic */ int access$rankAttributeNames(Companion $this, String prefix, String name) {
            return $this.rankAttributeNames(prefix, name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LintFix.GroupType.values().length];
                try {
                    nArray[LintFix.GroupType.ALTERNATIVES.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LintFix.GroupType.COMPOSITE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH&J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H&\u00a8\u0006\u000e\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/lint/client/api/LintFixPerformer$FileProvider;", "", "getFileContents", "", "file", "Lcom/android/tools/lint/client/api/LintFixPerformer$PendingEditFile;", "getXmlDocument", "Lorg/w3c/dom/Document;", "createBinaryFile", "", "fileData", "contents", "", "deleteFile", "android.sdktools.lint-api"})
    public static interface FileProvider {
        @NotNull
        public String getFileContents(@NotNull PendingEditFile var1);

        @Nullable
        public Document getXmlDocument(@NotNull PendingEditFile var1);

        public void createBinaryFile(@NotNull PendingEditFile var1, @NotNull byte[] var2);

        public void deleteFile(@NotNull PendingEditFile var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\u0011\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020\bJ\b\u0010 \u001a\u00020\bH\u0016J\u0010\u0010 \u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\bJ\u0013\u0010\"\u001a\u00020\u001c2\b\u0010\u0018\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/lint/client/api/LintFixPerformer$PendingEdit;", "", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "startOffset", "", "endOffset", "replacement", "", "selectStart", "selectEnd", "sortPriority", "<init>", "(Lcom/android/tools/lint/detector/api/LintFix;IILjava/lang/String;III)V", "getFix", "()Lcom/android/tools/lint/detector/api/LintFix;", "getStartOffset", "()I", "getEndOffset", "getReplacement", "()Ljava/lang/String;", "getSelectStart", "getSelectEnd", "compareTo", "other", "apply", "contents", "isInsert", "", "isDelete", "isReplace", "fixName", "toString", "source", "equals", "", "hashCode", "android.sdktools.lint-api"})
    public static final class PendingEdit
    implements Comparable<PendingEdit> {
        @NotNull
        private final LintFix fix;
        private final int startOffset;
        private final int endOffset;
        @NotNull
        private final String replacement;
        private final int selectStart;
        private final int selectEnd;
        private final int sortPriority;

        public PendingEdit(@NotNull LintFix fix2, int startOffset, int endOffset, @NotNull String replacement, int selectStart, int selectEnd, int sortPriority) {
            Intrinsics.checkNotNullParameter((Object)fix2, (String)"fix");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            this.fix = fix2;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.replacement = replacement;
            this.selectStart = selectStart;
            this.selectEnd = selectEnd;
            this.sortPriority = sortPriority;
        }

        public /* synthetic */ PendingEdit(LintFix lintFix, int n, int n2, String string2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n6 & 0x10) != 0) {
                n3 = -1;
            }
            if ((n6 & 0x20) != 0) {
                n4 = -1;
            }
            if ((n6 & 0x40) != 0) {
                n5 = -1;
            }
            this(lintFix, n, n2, string2, n3, n4, n5);
        }

        @NotNull
        public final LintFix getFix() {
            return this.fix;
        }

        public final int getStartOffset() {
            return this.startOffset;
        }

        public final int getEndOffset() {
            return this.endOffset;
        }

        @NotNull
        public final String getReplacement() {
            return this.replacement;
        }

        public final int getSelectStart() {
            return this.selectStart;
        }

        public final int getSelectEnd() {
            return this.selectEnd;
        }

        @Override
        public int compareTo(@NotNull PendingEdit other) {
            int d2;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int delta = other.startOffset - this.startOffset;
            if (delta != 0) {
                return delta;
            }
            int d1 = this.isReplace() ? 0 : 1;
            int deleteDelta = d1 - (d2 = other.isReplace() ? 0 : 1);
            if (deleteDelta != 0) {
                return deleteDelta;
            }
            int sortDelta = other.sortPriority - this.sortPriority;
            if (sortDelta != 0) {
                return sortDelta;
            }
            return other.endOffset - this.endOffset;
        }

        @NotNull
        public final String apply(@NotNull String contents) {
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            String string2 = new StringBuilder(contents).replace(this.startOffset, this.endOffset, this.replacement).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        public final boolean isInsert() {
            return this.endOffset == this.startOffset;
        }

        public final boolean isDelete() {
            return ((CharSequence)this.replacement).length() == 0;
        }

        public final boolean isReplace() {
            return this.endOffset > this.startOffset;
        }

        @NotNull
        public final String fixName() {
            String string2 = this.fix.getFamilyName();
            if (string2 == null) {
                String string3 = this.fix.getDisplayName();
                if (string3 == null) {
                    String string4 = this.fix.getClass().getSimpleName();
                    string3 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getSimpleName(...)");
                }
                return string3;
            }
            return string2;
        }

        @NotNull
        public String toString() {
            return this.toString(null);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final String toString(@Nullable String source) {
            block5: {
                block6: {
                    block4: {
                        if (!this.isDelete()) break block4;
                        if (source == null) ** GOTO lbl-1000
                        v0 = source.substring(this.startOffset, this.endOffset);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"substring(...)");
                        var2_2 = v0;
                        if (var2_2 != null) {
                            v1 = var2_2;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = this.endOffset - this.startOffset + " characters";
                        }
                        v2 = "At " + this.startOffset + ", delete \"" + (String)v1 + "\"";
                        break block5;
                    }
                    if (!this.isInsert()) break block6;
                    v2 = "At " + this.startOffset + ", insert \"" + this.replacement + "\"";
                    break block5;
                }
                if (source == null) ** GOTO lbl-1000
                v3 = source.substring(this.startOffset, this.endOffset);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"substring(...)");
                var2_3 = v3;
                if (var2_3 != null) {
                    v4 = var2_3;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = this.endOffset - this.startOffset + " characters";
                }
                v2 = "At " + this.startOffset + ", change \"" + (String)v4 + "\" to \"" + this.replacement + "\"";
            }
            return v2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.android.tools.lint.client.api.LintFixPerformer.PendingEdit");
            PendingEdit cfr_ignored_0 = (PendingEdit)other;
            if (this.startOffset != ((PendingEdit)other).startOffset) {
                return false;
            }
            if (this.endOffset != ((PendingEdit)other).endOffset) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.replacement, (Object)((PendingEdit)other).replacement)) {
                return false;
            }
            if (this.selectStart != ((PendingEdit)other).selectStart) {
                return false;
            }
            return this.selectEnd == ((PendingEdit)other).selectEnd;
        }

        public int hashCode() {
            int result2 = this.startOffset;
            result2 = 31 * result2 + this.endOffset;
            result2 = 31 * result2 + this.replacement.hashCode();
            result2 = 31 * result2 + Integer.hashCode(this.selectStart);
            result2 = 31 * result2 + Integer.hashCode(this.selectEnd);
            return result2;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010*\u001a\u00020\u0013J\u0006\u0010+\u001a\u00020,R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u001a\u0010\u001e\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0015\"\u0004\b \u0010\u0017R\u001a\u0010!\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0015\"\u0004\b#\u0010\u0017R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006-"}, d2={"Lcom/android/tools/lint/client/api/LintFixPerformer$PendingEditFile;", "", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "edits", "", "Lcom/android/tools/lint/client/api/LintFixPerformer$PendingEdit;", "getEdits", "()Ljava/util/List;", "imports", "", "getImports", "setImports", "(Ljava/util/List;)V", "shortenReferences", "", "getShortenReferences", "()Z", "setShortenReferences", "(Z)V", "reformat", "getReformat", "setReformat", "open", "getOpen", "setOpen", "delete", "getDelete", "setDelete", "createText", "getCreateText", "setCreateText", "createBytes", "", "getCreateBytes", "()[B", "setCreateBytes", "([B)V", "isEmpty", "affectedRange", "Lcom/intellij/openapi/util/TextRange;", "android.sdktools.lint-api"})
    @SourceDebugExtension(value={"SMAP\nLintFixPerformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintFixPerformer.kt\ncom/android/tools/lint/client/api/LintFixPerformer$PendingEditFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1471:1\n1#2:1472\n*E\n"})
    public static final class PendingEditFile {
        @NotNull
        private final File file;
        @NotNull
        private final List<PendingEdit> edits;
        @Nullable
        private List<String> imports;
        private boolean shortenReferences;
        private boolean reformat;
        private boolean open;
        private boolean delete;
        private boolean createText;
        @Nullable
        private byte[] createBytes;

        public PendingEditFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.edits = new ArrayList();
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final List<PendingEdit> getEdits() {
            return this.edits;
        }

        @Nullable
        public final List<String> getImports() {
            return this.imports;
        }

        public final void setImports(@Nullable List<String> list2) {
            this.imports = list2;
        }

        public final boolean getShortenReferences() {
            return this.shortenReferences;
        }

        public final void setShortenReferences(boolean bl) {
            this.shortenReferences = bl;
        }

        public final boolean getReformat() {
            return this.reformat;
        }

        public final void setReformat(boolean bl) {
            this.reformat = bl;
        }

        public final boolean getOpen() {
            return this.open;
        }

        public final void setOpen(boolean bl) {
            this.open = bl;
        }

        public final boolean getDelete() {
            return this.delete;
        }

        public final void setDelete(boolean bl) {
            this.delete = bl;
        }

        public final boolean getCreateText() {
            return this.createText;
        }

        public final void setCreateText(boolean bl) {
            this.createText = bl;
        }

        @Nullable
        public final byte[] getCreateBytes() {
            return this.createBytes;
        }

        public final void setCreateBytes(@Nullable byte[] byArray) {
            this.createBytes = byArray;
        }

        public final boolean isEmpty() {
            return this.edits.isEmpty() && !this.createText && this.createBytes == null && !this.delete;
        }

        @NotNull
        public final TextRange affectedRange() {
            int n;
            if (this.edits.isEmpty()) {
                TextRange textRange = TextRange.EMPTY_RANGE;
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
                return textRange;
            }
            Iterator iterator = ((Iterable)this.edits).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            PendingEdit it22 = (PendingEdit)iterator.next();
            boolean bl = false;
            int it22 = it22.getStartOffset();
            while (iterator.hasNext()) {
                PendingEdit it32 = (PendingEdit)iterator.next();
                $i$a$-minOf-LintFixPerformer$PendingEditFile$affectedRange$1 = false;
                int it32 = it32.getStartOffset();
                if (it22 <= it32) continue;
                it22 = it32;
            }
            Iterable iterable = this.edits;
            int n2 = it22;
            iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            PendingEdit it = (PendingEdit)iterator.next();
            boolean bl2 = false;
            int n3 = it.getEndOffset();
            while (iterator.hasNext()) {
                PendingEdit it3 = (PendingEdit)iterator.next();
                $i$a$-maxOf-LintFixPerformer$PendingEditFile$affectedRange$2 = false;
                int n4 = it3.getEndOffset();
                if (n3 >= n4) continue;
                n3 = n4;
            }
            int n5 = n = n3;
            int n6 = n2;
            return new TextRange(n6, n5);
        }
    }
}

